/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigSanityCheck;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.ObservableConfiguration;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.NamespaceConfiguration;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.conf.ZooConfigurationFactory;

public class ServerConfigurationFactory
extends ServerConfiguration {
    private static final Map<String, Map<TableId, TableConfiguration>> tableConfigs = new HashMap<String, Map<TableId, TableConfiguration>>(1);
    private static final Map<String, Map<NamespaceId, NamespaceConfiguration>> namespaceConfigs = new HashMap<String, Map<NamespaceId, NamespaceConfiguration>>(1);
    private static final Map<String, Map<TableId, NamespaceConfiguration>> tableParentConfigs = new HashMap<String, Map<TableId, NamespaceConfiguration>>(1);
    private final ServerContext context;
    private final SiteConfiguration siteConfig;
    private final String instanceID;
    private ZooCacheFactory zcf = new ZooCacheFactory();
    private DefaultConfiguration defaultConfig = null;
    private AccumuloConfiguration systemConfig = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addInstanceToCaches(String iid) {
        Map<String, Map<Object, ObservableConfiguration>> map = tableConfigs;
        synchronized (map) {
            tableConfigs.computeIfAbsent(iid, k -> new HashMap());
        }
        map = namespaceConfigs;
        synchronized (map) {
            namespaceConfigs.computeIfAbsent(iid, k -> new HashMap());
        }
        map = tableParentConfigs;
        synchronized (map) {
            tableParentConfigs.computeIfAbsent(iid, k -> new HashMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean removeCachedTableConfiguration(String instanceId, TableId tableId) {
        Map<String, Map<TableId, TableConfiguration>> map = tableConfigs;
        synchronized (map) {
            return tableConfigs.get(instanceId).remove(tableId) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean removeCachedNamespaceConfiguration(String instanceId, NamespaceId namespaceId) {
        Map<String, Map<NamespaceId, NamespaceConfiguration>> map = namespaceConfigs;
        synchronized (map) {
            return namespaceConfigs.get(instanceId).remove(namespaceId) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCachedConfigurations() {
        Map<String, Map<Object, ObservableConfiguration>> map = tableConfigs;
        synchronized (map) {
            tableConfigs.clear();
        }
        map = namespaceConfigs;
        synchronized (map) {
            namespaceConfigs.clear();
        }
        map = tableParentConfigs;
        synchronized (map) {
            tableParentConfigs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void expireAllTableObservers() {
        Map<String, Map<TableId, TableConfiguration>> map = tableConfigs;
        synchronized (map) {
            for (Map<TableId, TableConfiguration> instanceMap : tableConfigs.values()) {
                for (TableConfiguration c : instanceMap.values()) {
                    c.expireAllObservers();
                }
            }
        }
    }

    public ServerConfigurationFactory(ServerContext context, SiteConfiguration siteConfig) {
        this.context = context;
        this.siteConfig = siteConfig;
        this.instanceID = context.getInstanceID();
        ServerConfigurationFactory.addInstanceToCaches(this.instanceID);
    }

    public ServerContext getServerContext() {
        return this.context;
    }

    void setZooCacheFactory(ZooCacheFactory zcf) {
        this.zcf = zcf;
    }

    public SiteConfiguration getSiteConfiguration() {
        return this.siteConfig;
    }

    public synchronized DefaultConfiguration getDefaultConfiguration() {
        if (this.defaultConfig == null) {
            this.defaultConfig = DefaultConfiguration.getInstance();
        }
        return this.defaultConfig;
    }

    @Override
    public synchronized AccumuloConfiguration getSystemConfiguration() {
        if (this.systemConfig == null) {
            this.systemConfig = new ZooConfigurationFactory().getInstance(this.context, this.zcf, (AccumuloConfiguration)this.getSiteConfiguration());
        }
        return this.systemConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableConfiguration getTableConfiguration(TableId tableId) {
        TableConfiguration conf;
        Map<String, Map<TableId, TableConfiguration>> map = tableConfigs;
        synchronized (map) {
            conf = tableConfigs.get(this.instanceID).get(tableId);
        }
        if (conf == null && Tables.exists((ClientContext)this.context, (TableId)tableId)) {
            conf = new TableConfiguration(this.context, tableId, this.getNamespaceConfigurationForTable(tableId));
            ConfigSanityCheck.validate((Iterable)((Object)conf));
            map = tableConfigs;
            synchronized (map) {
                Map<TableId, TableConfiguration> configs = tableConfigs.get(this.instanceID);
                TableConfiguration existingConf = configs.get(tableId);
                if (existingConf == null) {
                    configs.put(tableId, conf);
                } else {
                    conf = existingConf;
                }
            }
        }
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamespaceConfiguration getNamespaceConfigurationForTable(TableId tableId) {
        NamespaceConfiguration conf;
        Map<String, Map<TableId, NamespaceConfiguration>> map = tableParentConfigs;
        synchronized (map) {
            conf = tableParentConfigs.get(this.instanceID).get(tableId);
        }
        if (conf == null) {
            NamespaceId namespaceId;
            try {
                namespaceId = Tables.getNamespaceId((ClientContext)this.context, (TableId)tableId);
            }
            catch (TableNotFoundException e) {
                throw new RuntimeException(e);
            }
            conf = new NamespaceConfiguration(namespaceId, this.context, this.getSystemConfiguration());
            ConfigSanityCheck.validate((Iterable)((Object)conf));
            Map<String, Map<TableId, NamespaceConfiguration>> map2 = tableParentConfigs;
            synchronized (map2) {
                tableParentConfigs.get(this.instanceID).put(tableId, conf);
            }
        }
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamespaceConfiguration getNamespaceConfiguration(NamespaceId namespaceId) {
        NamespaceConfiguration conf;
        Map<String, Map<NamespaceId, NamespaceConfiguration>> map = namespaceConfigs;
        synchronized (map) {
            conf = namespaceConfigs.get(this.instanceID).get(namespaceId);
        }
        if (conf == null) {
            conf = new NamespaceConfiguration(namespaceId, this.context, this.getSystemConfiguration());
            conf.setZooCacheFactory(this.zcf);
            ConfigSanityCheck.validate((Iterable)((Object)conf));
            map = namespaceConfigs;
            synchronized (map) {
                namespaceConfigs.get(this.instanceID).put(namespaceId, conf);
            }
        }
        return conf;
    }
}

