/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationObserver;
import org.apache.accumulo.core.conf.ObservableConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.NamespaceConfWatcher;
import org.apache.accumulo.server.conf.ZooCachePropertyAccessor;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceConfiguration
extends ObservableConfiguration {
    private static final Logger log = LoggerFactory.getLogger(NamespaceConfiguration.class);
    private static final Map<ZooCachePropertyAccessor.PropCacheKey, ZooCache> propCaches = new HashMap<ZooCachePropertyAccessor.PropCacheKey, ZooCache>();
    private final AccumuloConfiguration parent;
    private final AtomicReference<ZooCachePropertyAccessor> propCacheAccessor = new AtomicReference();
    protected NamespaceId namespaceId = null;
    protected ServerContext context;
    private ZooCacheFactory zcf = new ZooCacheFactory();
    private final String path;

    public NamespaceConfiguration(NamespaceId namespaceId, ServerContext context, AccumuloConfiguration parent) {
        this.context = context;
        this.parent = parent;
        this.namespaceId = namespaceId;
        this.path = context.getZooKeeperRoot() + "/namespaces" + "/" + namespaceId + "/conf";
    }

    public AccumuloConfiguration getParentConfiguration() {
        return this.parent;
    }

    void setZooCacheFactory(ZooCacheFactory zcf) {
        this.zcf = zcf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZooCache getZooCache() {
        Map<ZooCachePropertyAccessor.PropCacheKey, ZooCache> map = propCaches;
        synchronized (map) {
            ZooCachePropertyAccessor.PropCacheKey key = new ZooCachePropertyAccessor.PropCacheKey(this.context.getInstanceID(), this.namespaceId.canonical());
            ZooCache propCache = propCaches.get(key);
            if (propCache == null) {
                propCache = this.zcf.getZooCache(this.context.getZooKeepers(), this.context.getZooKeepersSessionTimeOut(), (Watcher)new NamespaceConfWatcher(this.context));
                propCaches.put(key, propCache);
            }
            return propCache;
        }
    }

    private ZooCachePropertyAccessor getPropCacheAccessor() {
        ZooCachePropertyAccessor zcpa = this.propCacheAccessor.get();
        if (zcpa != null) {
            return zcpa;
        }
        return this.propCacheAccessor.updateAndGet(pca -> pca == null ? new ZooCachePropertyAccessor(this.getZooCache()) : pca);
    }

    private String getPath() {
        return this.path;
    }

    public boolean isPropertySet(Property prop, boolean cacheAndWatch) {
        if (!cacheAndWatch) {
            throw new UnsupportedOperationException("Namespace configuration only supports checking if a property is set in cache.");
        }
        if (this.getPropCacheAccessor().isPropertySet(prop, this.getPath())) {
            return true;
        }
        return this.parent.isPropertySet(prop, cacheAndWatch);
    }

    public String get(Property property) {
        String key = property.getKey();
        Object getParent = !this.namespaceId.equals((Object)Namespace.ACCUMULO.id()) || !NamespaceConfiguration.isIteratorOrConstraint(key) ? this.parent : null;
        return this.getPropCacheAccessor().get(property, this.getPath(), (AccumuloConfiguration)getParent);
    }

    public void getProperties(Map<String, String> props, Predicate<String> filter) {
        Predicate<String> parentFilter = filter;
        if (this.getNamespaceId().equals((Object)Namespace.ACCUMULO.id())) {
            parentFilter = key -> NamespaceConfiguration.isIteratorOrConstraint(key) ? false : filter.test((String)key);
        }
        this.getPropCacheAccessor().getProperties(props, this.getPath(), filter, this.parent, parentFilter);
    }

    protected NamespaceId getNamespaceId() {
        return this.namespaceId;
    }

    public void addObserver(ConfigurationObserver co) {
        if (this.namespaceId == null) {
            String err = "Attempt to add observer for non-namespace configuration";
            log.error(err);
            throw new RuntimeException(err);
        }
        this.iterator();
        super.addObserver(co);
    }

    public void removeObserver(ConfigurationObserver co) {
        if (this.namespaceId == null) {
            String err = "Attempt to remove observer for non-namespace configuration";
            log.error(err);
            throw new RuntimeException(err);
        }
        super.removeObserver(co);
    }

    static boolean isIteratorOrConstraint(String key) {
        return key.startsWith(Property.TABLE_ITERATOR_PREFIX.getKey()) || key.startsWith(Property.TABLE_CONSTRAINT_PREFIX.getKey());
    }

    public synchronized void invalidateCache() {
        ZooCachePropertyAccessor pca = this.propCacheAccessor.get();
        if (pca != null) {
            pca.invalidateCache();
        }
    }

    public long getUpdateCount() {
        return this.parent.getUpdateCount() + this.getPropCacheAccessor().getZooCache().getUpdateCount();
    }
}

