/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.hadoopImpl.mapreduce.lib;

import java.io.IOException;
import java.util.Properties;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.admin.DelegationTokenConfig;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.DelegationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapReduceClientOpts
extends ClientOpts {
    private static final Logger log = LoggerFactory.getLogger(MapReduceClientOpts.class);

    public Properties getClientProps() {
        Properties props = super.getClientProps();
        AuthenticationToken authToken = ClientProperty.getAuthenticationToken((Properties)props);
        if (authToken instanceof KerberosToken) {
            log.info("Received KerberosToken, fetching DelegationToken for MapReduce");
            KerberosToken krbToken = (KerberosToken)authToken;
            try {
                UserGroupInformation user = UserGroupInformation.getCurrentUser();
                if (!user.hasKerberosCredentials()) {
                    throw new IllegalStateException("Expected current user to have Kerberos credentials");
                }
                String newPrincipal = user.getUserName();
                log.info("Obtaining delegation token for {}", (Object)newPrincipal);
                try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(props).as((CharSequence)newPrincipal, (AuthenticationToken)krbToken).build();){
                    if (!client.securityOperations().hasSystemPermission(client.whoami(), SystemPermission.OBTAIN_DELEGATION_TOKEN)) {
                        log.error("{} doesn't have the {} SystemPermission neccesary to obtain a delegation token. MapReduce tasks cannot automatically use the client's credentials on remote servers. Delegation tokens provide a means to run MapReduce without distributing the user's credentials.", (Object)user.getUserName(), (Object)SystemPermission.OBTAIN_DELEGATION_TOKEN.name());
                        throw new IllegalStateException(client.whoami() + " does not have permission to obtain a delegation token");
                    }
                    DelegationToken token = client.securityOperations().getDelegationToken(new DelegationTokenConfig());
                    props.setProperty(ClientProperty.AUTH_PRINCIPAL.getKey(), newPrincipal);
                    ClientProperty.setAuthenticationToken((Properties)props, (AuthenticationToken)token);
                }
            }
            catch (IOException | AccumuloException | AccumuloSecurityException e) {
                String msg = "Failed to acquire DelegationToken for use with MapReduce";
                log.error("Failed to acquire DelegationToken for use with MapReduce", e);
                throw new RuntimeException("Failed to acquire DelegationToken for use with MapReduce", e);
            }
        }
        return props;
    }
}

