/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.hadoop.mapreduce.partition;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Scanner;
import java.util.TreeSet;
import org.apache.accumulo.core.clientImpl.mapreduce.lib.DistributedCacheHelper;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Partitioner;

public class RangePartitioner
extends Partitioner<Text, Writable>
implements Configurable {
    private static final String PREFIX = RangePartitioner.class.getName();
    private static final String CUTFILE_KEY = PREFIX + ".cutFile";
    private static final String NUM_SUBBINS = PREFIX + ".subBins";
    private Configuration conf;
    private int _numSubBins = 0;
    private Text[] cutPointArray = null;

    public int getPartition(Text key, Writable value, int numPartitions) {
        try {
            return this.findPartition(key, this.getCutPoints(), this.getNumSubBins());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    int findPartition(Text key, Text[] array, int numSubBins) {
        int index = Arrays.binarySearch(array, key);
        int n = index = index < 0 ? (index + 1) * -1 : index;
        if (numSubBins < 2) {
            return index;
        }
        return (key.toString().hashCode() & Integer.MAX_VALUE) % numSubBins + index * numSubBins;
    }

    private synchronized int getNumSubBins() {
        if (this._numSubBins < 1) {
            this._numSubBins = Math.max(1, this.getConf().getInt(NUM_SUBBINS, 1));
        }
        return this._numSubBins;
    }

    private synchronized Text[] getCutPoints() throws IOException {
        if (this.cutPointArray == null) {
            String cutFileName = this.conf.get(CUTFILE_KEY);
            TreeSet<Text> cutPoints = new TreeSet<Text>();
            try (InputStream inputStream = DistributedCacheHelper.openCachedFile((String)cutFileName, (String)CUTFILE_KEY, (Configuration)this.conf);
                 Scanner in = new Scanner(inputStream, StandardCharsets.UTF_8.name());){
                while (in.hasNextLine()) {
                    cutPoints.add(new Text(Base64.getDecoder().decode(in.nextLine())));
                }
            }
            this.cutPointArray = cutPoints.toArray(new Text[cutPoints.size()]);
            if (this.cutPointArray == null) {
                throw new IOException("Cutpoint array not properly created from file" + cutFileName);
            }
        }
        return this.cutPointArray;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public static void setSplitFile(Job job, String file) {
        DistributedCacheHelper.addCacheFile((Job)job, (String)file, (String)CUTFILE_KEY);
        job.getConfiguration().set(CUTFILE_KEY, file);
    }

    public static void setNumSubBins(Job job, int num) {
        job.getConfiguration().setInt(NUM_SUBBINS, num);
    }
}

