/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.tablet;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.tserver.InMemoryMap;
import org.apache.accumulo.tserver.tablet.CommitSession;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TabletMemory
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(TabletMemory.class);
    private final Tablet tablet;
    private InMemoryMap memTable;
    private InMemoryMap otherMemTable;
    private InMemoryMap deletingMemTable;
    private long nextSeq = 1L;
    private CommitSession commitSession;
    private ServerContext context;

    TabletMemory(Tablet tablet) {
        this.tablet = tablet;
        this.context = tablet.getContext();
        this.memTable = new InMemoryMap((AccumuloConfiguration)tablet.getTableConfiguration(), this.context, tablet.getExtent().getTableId());
        this.commitSession = new CommitSession(tablet, this.nextSeq, this.memTable);
        this.nextSeq += 2L;
    }

    public InMemoryMap getMemTable() {
        return this.memTable;
    }

    public InMemoryMap getMinCMemTable() {
        return this.otherMemTable;
    }

    public CommitSession prepareForMinC() {
        if (this.otherMemTable != null) {
            throw new IllegalStateException();
        }
        if (this.deletingMemTable != null) {
            throw new IllegalStateException();
        }
        if (this.commitSession == null) {
            throw new IllegalStateException();
        }
        this.otherMemTable = this.memTable;
        this.memTable = new InMemoryMap((AccumuloConfiguration)this.tablet.getTableConfiguration(), this.context, this.tablet.getExtent().getTableId());
        CommitSession oldCommitSession = this.commitSession;
        this.commitSession = new CommitSession(this.tablet, this.nextSeq, this.memTable);
        this.nextSeq += 2L;
        this.tablet.updateMemoryUsageStats(this.memTable.estimatedSizeInBytes(), this.otherMemTable.estimatedSizeInBytes());
        return oldCommitSession;
    }

    public void finishedMinC() {
        if (this.otherMemTable == null) {
            throw new IllegalStateException();
        }
        if (this.deletingMemTable != null) {
            throw new IllegalStateException();
        }
        if (this.commitSession == null) {
            throw new IllegalStateException();
        }
        this.deletingMemTable = this.otherMemTable;
        this.otherMemTable = null;
        this.tablet.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeMinC() {
        if (this.commitSession == null) {
            throw new IllegalStateException();
        }
        try {
            this.deletingMemTable.delete(15000L);
        }
        finally {
            Tablet tablet = this.tablet;
            synchronized (tablet) {
                if (this.otherMemTable != null) {
                    throw new IllegalStateException();
                }
                if (this.deletingMemTable == null) {
                    throw new IllegalStateException();
                }
                this.deletingMemTable = null;
                this.tablet.updateMemoryUsageStats(this.memTable.estimatedSizeInBytes(), 0L);
            }
        }
    }

    public boolean memoryReservedForMinC() {
        return this.otherMemTable != null || this.deletingMemTable != null;
    }

    public void waitForMinC() {
        while (this.otherMemTable != null || this.deletingMemTable != null) {
            try {
                this.tablet.wait(50L);
            }
            catch (InterruptedException e) {
                log.warn("{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public void mutate(CommitSession cm, List<Mutation> mutations, int count) {
        cm.mutate(mutations, count);
    }

    public void updateMemoryUsageStats() {
        long other = 0L;
        if (this.otherMemTable != null) {
            other = this.otherMemTable.estimatedSizeInBytes();
        } else if (this.deletingMemTable != null) {
            other = this.deletingMemTable.estimatedSizeInBytes();
        }
        this.tablet.updateMemoryUsageStats(this.memTable.estimatedSizeInBytes(), other);
    }

    public List<InMemoryMap.MemoryIterator> getIterators(SamplerConfigurationImpl samplerConfig) {
        ArrayList<InMemoryMap.MemoryIterator> toReturn = new ArrayList<InMemoryMap.MemoryIterator>(2);
        toReturn.add(this.memTable.skvIterator(samplerConfig));
        if (this.otherMemTable != null) {
            toReturn.add(this.otherMemTable.skvIterator(samplerConfig));
        }
        return toReturn;
    }

    public void returnIterators(List<InMemoryMap.MemoryIterator> iters) {
        for (InMemoryMap.MemoryIterator iter : iters) {
            iter.close();
        }
    }

    public long getNumEntries() {
        if (this.otherMemTable != null) {
            return this.memTable.getNumEntries() + this.otherMemTable.getNumEntries();
        }
        return this.memTable.getNumEntries();
    }

    public CommitSession getCommitSession() {
        return this.commitSession;
    }

    @Override
    public void close() {
        this.commitSession = null;
    }
}

