/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.session;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.IterInfo;
import org.apache.accumulo.core.dataImpl.thrift.MultiScanResult;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.spi.scan.ScanInfo;
import org.apache.accumulo.tserver.scan.ScanTask;
import org.apache.accumulo.tserver.session.ScanSession;

public class MultiScanSession
extends ScanSession {
    public final KeyExtent threadPoolExtent;
    public final Map<KeyExtent, List<Range>> queries;
    public final SamplerConfiguration samplerConfig;
    public final long batchTimeOut;
    public final String context;
    public int numRanges;
    public int numTablets;
    public int numEntries;
    public long totalLookupTime;
    public volatile ScanTask<MultiScanResult> lookupTask;

    public MultiScanSession(TCredentials credentials, KeyExtent threadPoolExtent, Map<KeyExtent, List<Range>> queries, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, Authorizations authorizations, SamplerConfiguration samplerConfig, long batchTimeOut, String context, Map<String, String> executionHints) {
        super(credentials, new HashSet<Column>(), ssiList, ssio, authorizations, executionHints);
        this.queries = queries;
        this.threadPoolExtent = threadPoolExtent;
        this.samplerConfig = samplerConfig;
        this.batchTimeOut = batchTimeOut;
        this.context = context;
    }

    public ScanInfo.Type getScanType() {
        return ScanInfo.Type.MULTI;
    }

    public TableId getTableId() {
        return this.threadPoolExtent.getTableId();
    }

    @Override
    public boolean cleanup() {
        if (this.lookupTask != null) {
            this.lookupTask.cancel(true);
        }
        return true;
    }
}

