/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.scan;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.clientImpl.Translator;
import org.apache.accumulo.core.clientImpl.Translators;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.MultiScanResult;
import org.apache.accumulo.core.dataImpl.thrift.TKey;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TKeyValue;
import org.apache.accumulo.core.iterators.IterationInterruptedException;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.accumulo.tserver.scan.ScanRunState;
import org.apache.accumulo.tserver.scan.ScanTask;
import org.apache.accumulo.tserver.session.MultiScanSession;
import org.apache.accumulo.tserver.tablet.KVEntry;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupTask
extends ScanTask<MultiScanResult> {
    private static final Logger log = LoggerFactory.getLogger(LookupTask.class);
    private final long scanID;

    public LookupTask(TabletServer server, long scanID) {
        super(server);
        this.scanID = scanID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MultiScanSession session = (MultiScanSession)this.server.getSession(this.scanID);
        String oldThreadName = Thread.currentThread().getName();
        try {
            if (this.isCancelled() || session == null) {
                return;
            }
            TableConfiguration acuTableConf = this.server.getTableConfiguration(session.threadPoolExtent);
            long maxResultsSize = acuTableConf.getAsBytes(Property.TABLE_SCAN_MAXMEM);
            this.runState.set(ScanRunState.RUNNING);
            Thread.currentThread().setName("Client: " + session.client + " User: " + session.getUser() + " Start: " + session.startTime + " Table: ");
            long bytesAdded = 0L;
            long maxScanTime = 4000L;
            long startTime = System.currentTimeMillis();
            ArrayList<KVEntry> results = new ArrayList<KVEntry>();
            HashMap<KeyExtent, List<Range>> failures = new HashMap<KeyExtent, List<Range>>();
            ArrayList<KeyExtent> fullScans = new ArrayList<KeyExtent>();
            KeyExtent partScan = null;
            Key partNextKey = null;
            boolean partNextKeyInclusive = false;
            Iterator<Map.Entry<KeyExtent, List<Range>>> iter = session.queries.entrySet().iterator();
            while (iter.hasNext() && bytesAdded < maxResultsSize && System.currentTimeMillis() - startTime < maxScanTime) {
                Tablet.LookupResult lookupResult;
                Map.Entry<KeyExtent, List<Range>> entry = iter.next();
                iter.remove();
                Tablet tablet = this.server.getOnlineTablet(entry.getKey());
                if (tablet == null) {
                    failures.put(entry.getKey(), entry.getValue());
                    continue;
                }
                Thread.currentThread().setName("Client: " + session.client + " User: " + session.getUser() + " Start: " + session.startTime + " Tablet: " + entry.getKey());
                try {
                    if (this.isCancelled()) {
                        this.interruptFlag.set(true);
                    }
                    lookupResult = tablet.lookup(entry.getValue(), session.columnSet, session.auths, results, maxResultsSize - bytesAdded, session.ssiList, session.ssio, this.interruptFlag, session.samplerConfig, session.batchTimeOut, session.context);
                    this.interruptFlag.set(false);
                }
                catch (IOException e) {
                    log.warn("lookup failed for tablet " + entry.getKey(), (Throwable)e);
                    throw new RuntimeException(e);
                }
                bytesAdded += lookupResult.bytesAdded;
                if (lookupResult.unfinishedRanges.size() > 0) {
                    if (lookupResult.closed) {
                        failures.put(entry.getKey(), lookupResult.unfinishedRanges);
                        continue;
                    }
                    session.queries.put(entry.getKey(), lookupResult.unfinishedRanges);
                    partScan = entry.getKey();
                    partNextKey = lookupResult.unfinishedRanges.get(0).getStartKey();
                    partNextKeyInclusive = lookupResult.unfinishedRanges.get(0).isStartKeyInclusive();
                    continue;
                }
                fullScans.add(entry.getKey());
            }
            long finishTime = System.currentTimeMillis();
            session.totalLookupTime += finishTime - startTime;
            session.numEntries += results.size();
            ArrayList<TKeyValue> retResults = new ArrayList<TKeyValue>();
            for (KVEntry entry : results) {
                retResults.add(new TKeyValue(((Key)entry.getKey()).toThrift(), ByteBuffer.wrap(((Value)entry.getValue()).get())));
            }
            Map retFailures = Translator.translate(failures, (Translator)Translators.KET, (Translator)new Translator.ListTranslator(Translators.RT));
            List retFullScans = Translator.translate(fullScans, (Translator)Translators.KET);
            TKeyExtent retPartScan = null;
            TKey retPartNextKey = null;
            if (partScan != null) {
                retPartScan = partScan.toThrift();
                retPartNextKey = partNextKey.toThrift();
            }
            this.addResult(new MultiScanResult(retResults, retFailures, retFullScans, retPartScan, retPartNextKey, partNextKeyInclusive, session.queries.size() != 0));
        }
        catch (IterationInterruptedException iie) {
            if (!this.isCancelled()) {
                log.warn("Iteration interrupted, when scan not cancelled", (Throwable)iie);
                this.addResult((Object)iie);
            }
        }
        catch (SampleNotPresentException e) {
            this.addResult((Object)e);
        }
        catch (Throwable e) {
            log.warn("exception while doing multi-scan ", e);
            this.addResult(e);
        }
        finally {
            Thread.currentThread().setName(oldThreadName);
            this.runState.set(ScanRunState.FINISHED);
        }
    }
}

