/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tracer;

import com.beust.jcommander.Parameter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.tracer.TraceFormatter;
import org.apache.accumulo.tracer.thrift.RemoteSpan;

public class TraceTableStats {
    public static void main(String[] args) throws Exception {
        TraceTableStats stats = new TraceTableStats();
        Opts opts = new Opts();
        opts.parseArgs(TraceTableStats.class.getName(), args, new Object[0]);
        stats.count(opts);
    }

    public void count(Opts opts) throws TableNotFoundException {
        TreeMap<String, SpanTypeCount> counts = new TreeMap<String, SpanTypeCount>();
        SpanTypeCount hdfs = new SpanTypeCount();
        hdfs.type = "HDFS";
        SpanTypeCount accumulo = new SpanTypeCount();
        accumulo.type = "Accumulo";
        long numSpans = 0L;
        double maxSpanLength = 0.0;
        double maxSpanLengthMS = 0.0;
        try (AccumuloClient client = (AccumuloClient)Accumulo.newClient().from(opts.getClientProps()).build();){
            Scanner scanner = client.createScanner(opts.tableName, Authorizations.EMPTY);
            scanner.setRange(new Range(null, true, (CharSequence)"idx:", false));
            for (Map.Entry entry : scanner) {
                ++numSpans;
                RemoteSpan span2 = TraceFormatter.getRemoteSpan(entry);
                String id = span2.getSvc() + ":" + span2.getDescription().replaceAll("[0-9][0-9][0-9]+", "");
                SpanTypeCount stc = (SpanTypeCount)counts.get(id);
                if (stc == null) {
                    stc = new SpanTypeCount();
                    counts.put(id, stc);
                    stc.type = span2.description.startsWith("org.apache.hadoop") || span2.svc.equals("NameNode") || span2.svc.equals("DataNode") || span2.description.contains("DFSOutputStream") || span2.description.contains("DFSInputStream") || span2.description.contains("BlockReader") ? hdfs.type : accumulo.type;
                }
                TraceTableStats.increment(stc, span2);
                if (stc.type.equals(hdfs.type)) {
                    TraceTableStats.increment(hdfs, span2);
                } else {
                    TraceTableStats.increment(accumulo, span2);
                }
                maxSpanLength = Math.max(maxSpanLength, Math.log10(span2.stop - span2.start));
                maxSpanLengthMS = Math.max(maxSpanLengthMS, (double)(span2.stop - span2.start));
            }
        }
        System.out.println();
        System.out.println("log10 max span length " + maxSpanLength + " " + maxSpanLengthMS);
        System.out.println("Total spans " + numSpans);
        System.out.println("Percentage Accumulo nonzero of total " + accumulo.nonzeroCount + "/" + numSpans + " = " + (double)accumulo.nonzeroCount * 1.0 / (double)numSpans);
        System.out.println(hdfs + ", total " + (hdfs.nonzeroCount + hdfs.zeroCount));
        System.out.println(accumulo + ", total " + (accumulo.nonzeroCount + accumulo.zeroCount));
        System.out.println();
        System.out.println("source:desc={stats}");
        for (Map.Entry c : counts.entrySet()) {
            System.out.println(c);
        }
    }

    private static void increment(SpanTypeCount stc, RemoteSpan span2) {
        stc.traceIds.add(span2.getTraceId());
        if (span2.stop == span2.start) {
            ++stc.zeroCount;
            TraceTableStats.incrementIndex(stc.log10SpanLength, 0);
        } else {
            ++stc.nonzeroCount;
            long ms = span2.stop - span2.start;
            if (ms <= 10L) {
                TraceTableStats.incrementIndex(stc.log10SpanLength, 1);
            } else if (ms <= 100L) {
                TraceTableStats.incrementIndex(stc.log10SpanLength, 2);
            } else if (ms <= 1000L) {
                TraceTableStats.incrementIndex(stc.log10SpanLength, 3);
            } else if (ms <= 10000L) {
                TraceTableStats.incrementIndex(stc.log10SpanLength, 4);
            } else if (ms <= 100000L) {
                TraceTableStats.incrementIndex(stc.log10SpanLength, 5);
            } else if (ms <= 1000000L) {
                TraceTableStats.incrementIndex(stc.log10SpanLength, 6);
            } else {
                throw new IllegalArgumentException("unexpected span length " + ms);
            }
        }
    }

    private static void incrementIndex(ArrayList<Long> hist, int i) {
        hist.set(i, hist.get(i) + 1L);
    }

    static class SpanTypeCount {
        String type;
        long nonzeroCount = 0L;
        long zeroCount = 0L;
        ArrayList<Long> log10SpanLength = new ArrayList();
        Set<Long> traceIds = new HashSet<Long>();

        public SpanTypeCount() {
            for (int i = 0; i < 7; ++i) {
                this.log10SpanLength.add(0L);
            }
        }

        public String toString() {
            return "{type='" + this.type + '\'' + ", nonzeroCount=" + this.nonzeroCount + ", zeroCount=" + this.zeroCount + ", numTraces=" + this.traceIds.size() + ", log10SpanLength=" + this.log10SpanLength + '}';
        }
    }

    static class Opts
    extends ClientOpts {
        @Parameter(names={"--table"}, description="table to use")
        String tableName = "trace";

        Opts() {
        }
    }
}

