/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.commands.OptUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.LoggerFactory;

public abstract class ShellPluginConfigurationCommand
extends Shell.Command {
    private Option removePluginOption;
    private Option pluginClassOption;
    private Option listPluginOption;
    private String pluginType;
    private Property tableProp;
    private String classOpt;

    ShellPluginConfigurationCommand(String typeName, Property tableProp, String classOpt) {
        this.pluginType = typeName;
        this.tableProp = tableProp;
        this.classOpt = classOpt;
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        String tableName = OptUtil.getTableOpt(cl, shellState);
        if (cl.hasOption(this.removePluginOption.getOpt())) {
            this.removePlugin(cl, shellState, tableName);
            shellState.getReader().println((CharSequence)("Removed " + this.pluginType + " on " + tableName));
        } else if (cl.hasOption(this.listPluginOption.getOpt())) {
            for (Map.Entry ent : shellState.getAccumuloClient().tableOperations().getProperties(tableName)) {
                if (!((String)ent.getKey()).startsWith(this.tableProp.toString())) continue;
                shellState.getReader().println((CharSequence)((String)ent.getKey() + ": " + (String)ent.getValue()));
            }
        } else {
            String className = cl.getOptionValue(this.pluginClassOption.getOpt());
            this.setPlugin(cl, shellState, tableName, className);
        }
        return 0;
    }

    protected void setPlugin(CommandLine cl, Shell shellState, String tableName, String className) throws AccumuloException, AccumuloSecurityException {
        shellState.getAccumuloClient().tableOperations().setProperty(tableName, this.tableProp.toString(), className);
    }

    protected void removePlugin(CommandLine cl, Shell shellState, String tableName) throws AccumuloException, AccumuloSecurityException {
        shellState.getAccumuloClient().tableOperations().removeProperty(tableName, this.tableProp.toString());
    }

    public static <T> Class<? extends T> getPluginClass(String tableName, Shell shellState, Class<T> clazz, Property pluginProp) {
        Iterator props;
        try {
            props = shellState.getAccumuloClient().tableOperations().getProperties(tableName).iterator();
        }
        catch (AccumuloException | TableNotFoundException e) {
            return null;
        }
        while (props.hasNext()) {
            Class<T> pluginClazz;
            Map.Entry ent = (Map.Entry)props.next();
            if (!((String)ent.getKey()).equals(pluginProp.toString())) continue;
            Object[] args = new String[2];
            try {
                Options o = new Options();
                o.addOption(OptUtil.tableOpt());
                args[0] = "-t";
                args[1] = tableName;
                CommandLine cl = new DefaultParser().parse(o, (String[])args);
                pluginClazz = shellState.getClassLoader(cl, shellState).loadClass((String)ent.getValue()).asSubclass(clazz);
            }
            catch (ClassNotFoundException e) {
                LoggerFactory.getLogger(ShellPluginConfigurationCommand.class).error("Class not found {}", (Object)e.getMessage());
                return null;
            }
            catch (ParseException e) {
                LoggerFactory.getLogger(ShellPluginConfigurationCommand.class).error("Error parsing table: {} {}", (Object)Arrays.toString(args), (Object)e.getMessage());
                return null;
            }
            catch (TableNotFoundException e) {
                LoggerFactory.getLogger(ShellPluginConfigurationCommand.class).error("Table not found: {} {}", (Object)tableName, (Object)e.getMessage());
                return null;
            }
            catch (Exception e) {
                LoggerFactory.getLogger(ShellPluginConfigurationCommand.class).error("Error: {}", (Object)e.getMessage());
                return null;
            }
            return pluginClazz;
        }
        return null;
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        OptionGroup actionGroup = new OptionGroup();
        this.pluginClassOption = new Option(this.classOpt, this.pluginType, true, "fully qualified name of the " + this.pluginType + " class to use");
        this.pluginClassOption.setArgName("className");
        this.removePluginOption = new Option("r", "remove", false, "remove the current " + this.pluginType + "");
        this.listPluginOption = new Option("l", "list", false, "display the current " + this.pluginType + "");
        actionGroup.addOption(this.pluginClassOption);
        actionGroup.addOption(this.removePluginOption);
        actionGroup.addOption(this.listPluginOption);
        actionGroup.setRequired(true);
        o.addOptionGroup(actionGroup);
        o.addOption(OptUtil.tableOpt("table to set the " + this.pluginType + " on"));
        return o;
    }

    @Override
    public int numArgs() {
        return 0;
    }
}

