/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.ShellCommandException;
import org.apache.accumulo.shell.commands.SetIterCommand;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class SetShellIterCommand
extends SetIterCommand {
    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, IOException, ShellCommandException {
        return super.execute(fullCommand, cl, shellState);
    }

    @Override
    protected void setTableProperties(CommandLine cl, Shell shellState, int priority, Map<String, String> options, String classname, String name) throws AccumuloException, AccumuloSecurityException, ShellCommandException, TableNotFoundException {
        String profile = cl.getOptionValue(this.profileOpt.getOpt());
        options.values().removeIf(v -> v == null || v.isEmpty());
        List<IteratorSetting> tableScanIterators = shellState.iteratorProfiles.get(profile);
        if (tableScanIterators == null) {
            tableScanIterators = new ArrayList<IteratorSetting>();
            shellState.iteratorProfiles.put(profile, tableScanIterators);
        }
        IteratorSetting setting = new IteratorSetting(priority, name, classname);
        setting.addOptions(options);
        tableScanIterators.removeIf(iteratorSetting -> iteratorSetting.getName().equals(name));
        tableScanIterators.add(setting);
    }

    @Override
    public String description() {
        return "adds an iterator to a profile for this shell session";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.setBaseOptions(o);
        this.setProfileOptions(o);
        return o;
    }

    private void setProfileOptions(Options o) {
        this.profileOpt = new Option("pn", "profile", true, "iterator profile name");
        this.profileOpt.setRequired(true);
        this.profileOpt.setArgName("profile");
        o.addOption(this.profileOpt);
    }
}

