/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.IOException;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.shell.Shell;
import org.apache.commons.cli.CommandLine;

public class ImportDirectoryCommand
extends Shell.Command {
    @Override
    public String description() {
        return "bulk imports an entire directory of data files to the current table. The boolean argument determines if accumulo sets the time. Passing 3 arguments will use the old bulk import.  The new bulk import only takes 2 arguments: <directory> true|false";
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws IOException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
        shellState.checkTableState();
        String[] args = cl.getArgs();
        String dir = args[0];
        if (args.length == 2) {
            boolean setTime = Boolean.parseBoolean(cl.getArgs()[1]);
            shellState.getAccumuloClient().tableOperations().importDirectory(dir).to(shellState.getTableName()).tableTime(setTime).load();
        } else {
            if (args.length == 3) {
                Shell.log.warn("Deprecated since 2.0.0. New bulk import technique does not take a failure directory as an argument.");
                String failureDir = args[1];
                boolean setTime = Boolean.parseBoolean(cl.getArgs()[2]);
                shellState.getAccumuloClient().tableOperations().importDirectory(shellState.getTableName(), dir, failureDir, setTime);
                return 0;
            }
            shellState.printException(new IllegalArgumentException(String.format("Expected 2 or 3 arguments. There %s %d.", args.length == 1 ? "was" : "were", args.length)));
            this.printHelp(shellState);
        }
        return 0;
    }

    @Override
    public int numArgs() {
        return -1;
    }

    @Override
    public String usage() {
        return this.getName() + " <directory> [failureDirectory] true|false";
    }
}

