/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.shell.Shell;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;

public class GetAuthsCommand
extends Shell.Command {
    private Option userOpt;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, IOException {
        String user = cl.getOptionValue(this.userOpt.getOpt(), shellState.getAccumuloClient().whoami());
        Authorizations auths = shellState.getAccumuloClient().securityOperations().getUserAuthorizations(user);
        List<String> set = this.sortAuthorizations(auths);
        shellState.getReader().println((CharSequence)StringUtils.join(set, (char)','));
        return 0;
    }

    protected List<String> sortAuthorizations(Authorizations auths) {
        ArrayList<String> list = new ArrayList<String>();
        for (byte[] auth : auths) {
            list.add(new String(auth));
        }
        Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
        return list;
    }

    @Override
    public String description() {
        return "displays the maximum scan authorizations for a user";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.userOpt = new Option("u", "user", true, "user to operate on");
        this.userOpt.setArgName("user");
        o.addOption(this.userOpt);
        return o;
    }

    @Override
    public int numArgs() {
        return 0;
    }
}

