/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.NamespaceExistsException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.shell.Shell;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class CreateNamespaceCommand
extends Shell.Command {
    private Option createNamespaceOptCopyConfig;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException, IOException, ClassNotFoundException, NamespaceExistsException, NamespaceNotFoundException {
        if (this.createNamespaceOptCopyConfig == null) {
            this.getOptions();
        }
        String namespace = cl.getArgs()[0];
        shellState.getAccumuloClient().namespaceOperations().create(namespace);
        Iterable configuration = null;
        if (cl.hasOption(this.createNamespaceOptCopyConfig.getOpt())) {
            String copy = cl.getOptionValue(this.createNamespaceOptCopyConfig.getOpt());
            if (shellState.getAccumuloClient().namespaceOperations().exists(namespace)) {
                configuration = shellState.getAccumuloClient().namespaceOperations().getProperties(copy);
            }
        }
        if (configuration != null) {
            for (Map.Entry entry : configuration) {
                if (!Property.isValidTablePropertyKey((String)((String)entry.getKey()))) continue;
                shellState.getAccumuloClient().namespaceOperations().setProperty(namespace, (String)entry.getKey(), (String)entry.getValue());
            }
        }
        return 0;
    }

    @Override
    public String description() {
        return "creates a new namespace";
    }

    @Override
    public String usage() {
        return this.getName() + " <namespaceName>";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.createNamespaceOptCopyConfig = new Option("cc", "copy-config", true, "namespace to copy configuration from");
        this.createNamespaceOptCopyConfig.setArgName("namespace");
        OptionGroup ogp = new OptionGroup();
        ogp.addOption(this.createNamespaceOptCopyConfig);
        o.addOptionGroup(ogp);
        return o;
    }

    @Override
    public int numArgs() {
        return 1;
    }
}

