/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.hadoop.io.Text;

public class ShellUtil {
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="app is run in same security context as user providing the filename")
    public static List<Text> scanFile(String filename, boolean decode) throws FileNotFoundException {
        ArrayList<Text> result = new ArrayList<Text>();
        try (Scanner file = new Scanner(new File(filename), StandardCharsets.UTF_8.name());){
            while (file.hasNextLine()) {
                String line = file.nextLine();
                if (line.isEmpty()) continue;
                result.add(decode ? new Text(Base64.getDecoder().decode(line)) : new Text(line));
            }
        }
        return result;
    }

    public static Map<String, String> parseMapOpt(CommandLine cl, Option opt) {
        if (cl.hasOption(opt.getLongOpt())) {
            String[] keyVals;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (String keyVal : keyVals = cl.getOptionValue(opt.getLongOpt()).split(",")) {
                String[] sa = keyVal.split("=");
                builder.put((Object)sa[0], (Object)sa[1]);
            }
            return builder.build();
        }
        return Collections.emptyMap();
    }
}

