/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.tableImport;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.accumulo.core.clientImpl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.master.tableOps.tableImport.ImportSetupPermissions;
import org.apache.accumulo.master.tableOps.tableImport.ImportedTableInfo;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportTable
extends MasterRepo {
    private static final Logger log = LoggerFactory.getLogger(ImportTable.class);
    private static final long serialVersionUID = 1L;
    private ImportedTableInfo tableInfo = new ImportedTableInfo();

    public ImportTable(String user, String tableName, String exportDir, NamespaceId namespaceId) {
        this.tableInfo.tableName = tableName;
        this.tableInfo.user = user;
        this.tableInfo.exportDir = exportDir;
        this.tableInfo.namespaceId = namespaceId;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return Utils.reserveHdfsDirectory(environment, new Path(this.tableInfo.exportDir).toString(), tid) + Utils.reserveNamespace(environment, this.tableInfo.namespaceId, tid, false, true, TableOperation.IMPORT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long tid, Master env) throws Exception {
        this.checkVersions(env);
        Utils.getIdLock().lock();
        try {
            this.tableInfo.tableId = Utils.getNextId(this.tableInfo.tableName, env.getContext(), TableId::of);
            ImportSetupPermissions importSetupPermissions = new ImportSetupPermissions(this.tableInfo);
            return importSetupPermissions;
        }
        finally {
            Utils.getIdLock().unlock();
        }
    }

    @SuppressFBWarnings(value={"OS_OPEN_STREAM"}, justification="closing intermediate readers would close the ZipInputStream")
    public void checkVersions(Master env) throws AcceptableThriftTableOperationException {
        Path path = new Path(this.tableInfo.exportDir, "exportMetadata.zip");
        Integer exportVersion = null;
        Integer dataVersion = null;
        try (ZipInputStream zis = new ZipInputStream((InputStream)env.getFileSystem().open(path));){
            ZipEntry zipEntry;
            while ((zipEntry = zis.getNextEntry()) != null) {
                if (!zipEntry.getName().equals("accumulo_export_info.txt")) continue;
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)zis, StandardCharsets.UTF_8));
                String line = null;
                while ((line = in.readLine()) != null) {
                    String[] sa = line.split(":", 2);
                    if (sa[0].equals("exportVersion")) {
                        exportVersion = Integer.parseInt(sa[1]);
                        continue;
                    }
                    if (!sa[0].equals("srcDataVersion")) continue;
                    dataVersion = Integer.parseInt(sa[1]);
                }
                break;
            }
        }
        catch (IOException ioe) {
            log.warn("{}", (Object)ioe.getMessage(), (Object)ioe);
            throw new AcceptableThriftTableOperationException(null, this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "Failed to read export metadata " + ioe.getMessage());
        }
        if (exportVersion == null || exportVersion > 1) {
            throw new AcceptableThriftTableOperationException(null, this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "Incompatible export version " + exportVersion);
        }
        if (dataVersion == null || dataVersion > 9) {
            throw new AcceptableThriftTableOperationException(null, this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "Incompatible data version " + dataVersion);
        }
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
        Utils.unreserveHdfsDirectory(env, new Path(this.tableInfo.exportDir).toString(), tid);
        Utils.unreserveNamespace(env, this.tableInfo.namespaceId, tid, false);
    }
}

