/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.dirlist;

import com.beust.jcommander.Parameter;
import java.util.Map;
import java.util.TreeMap;
import org.apache.accumulo.core.cli.ClientOnRequiredTable;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.RegExFilter;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.examples.simple.dirlist.Ingest;
import org.apache.hadoop.io.Text;

public class QueryUtil {
    private Connector conn = null;
    private String tableName;
    private Authorizations auths;
    public static final Text DIR_COLF = new Text("dir");
    public static final Text FORWARD_PREFIX = new Text("f");
    public static final Text REVERSE_PREFIX = new Text("r");
    public static final Text INDEX_COLF = new Text("i");
    public static final Text COUNTS_COLQ = new Text("counts");

    public QueryUtil(Opts opts) throws AccumuloException, AccumuloSecurityException {
        this.conn = opts.getConnector();
        this.tableName = opts.getTableName();
        this.auths = opts.auths;
    }

    public static int getDepth(String path) {
        int numSlashes = 0;
        int index = -1;
        while ((index = path.indexOf("/", index + 1)) >= 0) {
            ++numSlashes;
        }
        return numSlashes;
    }

    public static Text getRow(String path) {
        Text row = new Text(String.format("%03d", QueryUtil.getDepth(path)));
        row.append(path.getBytes(), 0, path.length());
        return row;
    }

    public static Text getForwardIndex(String path) {
        String part = path.substring(path.lastIndexOf("/") + 1);
        if (part.length() == 0) {
            return null;
        }
        Text row = new Text(FORWARD_PREFIX);
        row.append(part.getBytes(), 0, part.length());
        return row;
    }

    public static Text getReverseIndex(String path) {
        String part = path.substring(path.lastIndexOf("/") + 1);
        if (part.length() == 0) {
            return null;
        }
        byte[] rev = new byte[part.length()];
        int i = part.length() - 1;
        for (byte b : part.getBytes()) {
            rev[i--] = b;
        }
        Text row = new Text(REVERSE_PREFIX);
        row.append(rev, 0, rev.length);
        return row;
    }

    public static String getType(Text colf) {
        if (colf.equals((Object)DIR_COLF)) {
            return colf.toString() + ":";
        }
        return Long.toString((Long)Ingest.encoder.decode(colf.getBytes())) + ":";
    }

    public Map<String, String> getData(String path) throws TableNotFoundException {
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        Scanner scanner = this.conn.createScanner(this.tableName, this.auths);
        scanner.setRange(new Range(QueryUtil.getRow(path)));
        TreeMap<String, String> data = new TreeMap<String, String>();
        for (Map.Entry e : scanner) {
            String type = QueryUtil.getType(((Key)e.getKey()).getColumnFamily());
            data.put("fullname", ((Key)e.getKey()).getRow().toString().substring(3));
            data.put(type + ((Key)e.getKey()).getColumnQualifier().toString() + ":" + ((Key)e.getKey()).getColumnVisibility().toString(), new String(((Value)e.getValue()).get()));
        }
        return data;
    }

    public Map<String, Map<String, String>> getDirList(String path) throws TableNotFoundException {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        TreeMap<String, Map<String, String>> fim = new TreeMap<String, Map<String, String>>();
        Scanner scanner = this.conn.createScanner(this.tableName, this.auths);
        scanner.setRange(Range.prefix((Text)QueryUtil.getRow(path)));
        for (Map.Entry e : scanner) {
            String name = ((Key)e.getKey()).getRow().toString();
            name = name.substring(name.lastIndexOf("/") + 1);
            String type = QueryUtil.getType(((Key)e.getKey()).getColumnFamily());
            if (!fim.containsKey(name)) {
                fim.put(name, new TreeMap());
                ((Map)fim.get(name)).put("fullname", ((Key)e.getKey()).getRow().toString().substring(3));
            }
            ((Map)fim.get(name)).put(type + ((Key)e.getKey()).getColumnQualifier().toString() + ":" + ((Key)e.getKey()).getColumnVisibility().toString(), new String(((Value)e.getValue()).get()));
        }
        return fim;
    }

    public Iterable<Map.Entry<Key, Value>> exactTermSearch(String term) throws Exception {
        System.out.println("executing exactTermSearch for " + term);
        Scanner scanner = this.conn.createScanner(this.tableName, this.auths);
        scanner.setRange(new Range(QueryUtil.getForwardIndex(term)));
        return scanner;
    }

    public Iterable<Map.Entry<Key, Value>> singleRestrictedWildCardSearch(String exp) throws Exception {
        if (exp.indexOf("/") >= 0) {
            throw new Exception("this method only works with unqualified names");
        }
        Scanner scanner = this.conn.createScanner(this.tableName, this.auths);
        if (exp.startsWith("*")) {
            System.out.println("executing beginning wildcard search for " + exp);
            exp = exp.substring(1);
            scanner.setRange(Range.prefix((Text)QueryUtil.getReverseIndex(exp)));
        } else if (exp.endsWith("*")) {
            System.out.println("executing ending wildcard search for " + exp);
            exp = exp.substring(0, exp.length() - 1);
            scanner.setRange(Range.prefix((Text)QueryUtil.getForwardIndex(exp)));
        } else {
            if (exp.indexOf("*") >= 0) {
                throw new Exception("this method only works for beginning or ending wild cards");
            }
            return this.exactTermSearch(exp);
        }
        return scanner;
    }

    public Iterable<Map.Entry<Key, Value>> singleWildCardSearch(String exp) throws Exception {
        int starIndex = exp.indexOf("*");
        if (exp.indexOf("*", starIndex + 1) >= 0) {
            throw new Exception("only one wild card for search");
        }
        if (starIndex < 0) {
            return this.exactTermSearch(exp);
        }
        if (starIndex == 0 || starIndex == exp.length() - 1) {
            return this.singleRestrictedWildCardSearch(exp);
        }
        String firstPart = exp.substring(0, starIndex);
        String lastPart = exp.substring(starIndex + 1);
        String regexString = ".*/" + exp.replace("*", "[^/]*");
        Scanner scanner = this.conn.createScanner(this.tableName, this.auths);
        if (firstPart.length() >= lastPart.length()) {
            System.out.println("executing middle wildcard search for " + regexString + " from entries starting with " + firstPart);
            scanner.setRange(Range.prefix((Text)QueryUtil.getForwardIndex(firstPart)));
        } else {
            System.out.println("executing middle wildcard search for " + regexString + " from entries ending with " + lastPart);
            scanner.setRange(Range.prefix((Text)QueryUtil.getReverseIndex(lastPart)));
        }
        IteratorSetting regex = new IteratorSetting(50, "regex", RegExFilter.class);
        RegExFilter.setRegexs((IteratorSetting)regex, null, null, (String)regexString, null, (boolean)false);
        scanner.addScanIterator(regex);
        return scanner;
    }

    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(QueryUtil.class.getName(), args, new Object[0]);
        QueryUtil q = new QueryUtil(opts);
        if (opts.search) {
            for (Map.Entry<Key, Value> e : q.singleWildCardSearch(opts.path)) {
                System.out.println(e.getKey().getColumnQualifier());
            }
        } else {
            for (Map.Entry<String, Map<String, String>> e : q.getDirList(opts.path).entrySet()) {
                System.out.println(e);
            }
        }
    }

    public static class Opts
    extends ClientOnRequiredTable {
        @Parameter(names={"--path"}, description="the directory to list")
        String path = "/";
        @Parameter(names={"--search"}, description="find a file or directory with the given name")
        boolean search = false;
    }
}

