/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.replication;

import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.replication.AccumuloReplicationReplayer;
import org.apache.accumulo.core.replication.thrift.KeyValues;
import org.apache.accumulo.core.replication.thrift.RemoteReplicationErrorCode;
import org.apache.accumulo.core.replication.thrift.RemoteReplicationException;
import org.apache.accumulo.core.replication.thrift.ReplicationServicer;
import org.apache.accumulo.core.replication.thrift.WalEdits;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationServicerHandler
implements ReplicationServicer.Iface {
    private static final Logger log = LoggerFactory.getLogger(ReplicationServicerHandler.class);
    private TabletServer tabletServer;

    public ReplicationServicerHandler(TabletServer tabletServer) {
        this.tabletServer = tabletServer;
    }

    public long replicateLog(String tableId, WalEdits data, TCredentials tcreds) throws RemoteReplicationException, TException {
        long entriesReplicated;
        AccumuloReplicationReplayer replayer;
        Class<AccumuloReplicationReplayer> clz;
        String tableName;
        log.debug("Got replication request to tableID {} with {} edits", (Object)tableId, (Object)data.getEditsSize());
        this.tabletServer.getSecurityOperation().authenticateUser(this.tabletServer.rpcCreds(), tcreds);
        try {
            tableName = Tables.getTableName((Instance)this.tabletServer.getInstance(), (String)tableId);
        }
        catch (TableNotFoundException e) {
            log.error("Could not find table with id {}", (Object)tableId);
            throw new RemoteReplicationException(RemoteReplicationErrorCode.TABLE_DOES_NOT_EXIST, "Table with id " + tableId + " does not exist");
        }
        AccumuloConfiguration conf = this.tabletServer.getConfiguration();
        Map replicationHandlers = conf.getAllPropertiesWithPrefix(Property.TSERV_REPLICATION_REPLAYERS);
        String propertyForHandlerTable = Property.TSERV_REPLICATION_REPLAYERS.getKey() + tableId;
        String handlerClassForTable = (String)replicationHandlers.get(propertyForHandlerTable);
        if (null == handlerClassForTable) {
            if (!replicationHandlers.isEmpty()) {
                log.debug("Could not find replication replayer for {}", (Object)tableId);
            }
            handlerClassForTable = conf.get(Property.TSERV_REPLICATION_DEFAULT_HANDLER);
        }
        log.debug("Using {} replication replayer for table {}", (Object)handlerClassForTable, (Object)tableId);
        try {
            Class<?> untypedClz = Class.forName(handlerClassForTable);
            clz = untypedClz.asSubclass(AccumuloReplicationReplayer.class);
        }
        catch (ClassNotFoundException e) {
            log.error("Could not instantiate replayer class {}", (Object)handlerClassForTable, (Object)e);
            throw new RemoteReplicationException(RemoteReplicationErrorCode.CANNOT_INSTANTIATE_REPLAYER, "Could not instantiate replayer class " + handlerClassForTable);
        }
        try {
            replayer = clz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e1) {
            log.error("Could not instantiate replayer class {}", (Object)clz.getName());
            throw new RemoteReplicationException(RemoteReplicationErrorCode.CANNOT_INSTANTIATE_REPLAYER, "Could not instantiate replayer class" + clz.getName());
        }
        try {
            entriesReplicated = replayer.replicateLog((ClientContext)this.tabletServer, tableName, data);
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            log.error("Could not get connection", e);
            throw new RemoteReplicationException(RemoteReplicationErrorCode.CANNOT_AUTHENTICATE, "Cannot get connector as " + this.tabletServer.getCredentials().getPrincipal());
        }
        log.debug("Replicated {} mutations to {}", (Object)entriesReplicated, (Object)tableName);
        return entriesReplicated;
    }

    public long replicateKeyValues(String tableId, KeyValues data, TCredentials creds) throws RemoteReplicationException, TException {
        throw new UnsupportedOperationException();
    }
}

