/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.commands.OptUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class ListIterCommand
extends Shell.Command {
    private Option nameOpt;
    private Option allScopesOpt;
    private Map<IteratorUtil.IteratorScope, Option> scopeOpts;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        Map iterators;
        boolean tables = cl.hasOption(OptUtil.tableOpt().getOpt()) || !shellState.getTableName().isEmpty();
        boolean namespaces = cl.hasOption(OptUtil.namespaceOpt().getOpt());
        if (namespaces) {
            iterators = shellState.getConnector().namespaceOperations().listIterators(OptUtil.getNamespaceOpt(cl, shellState));
        } else if (tables) {
            iterators = shellState.getConnector().tableOperations().listIterators(OptUtil.getTableOpt(cl, shellState));
        } else {
            throw new IllegalArgumentException("No table or namespace specified");
        }
        if (cl.hasOption(this.nameOpt.getOpt())) {
            String name = cl.getOptionValue(this.nameOpt.getOpt());
            if (!iterators.containsKey(name)) {
                Shell.log.warn((Object)"no iterators found that match your criteria");
                return 0;
            }
            EnumSet scopes = (EnumSet)iterators.get(name);
            iterators.clear();
            iterators.put(name, scopes);
        }
        boolean allScopes = cl.hasOption(this.allScopesOpt.getOpt());
        HashSet<IteratorUtil.IteratorScope> desiredScopes = new HashSet<IteratorUtil.IteratorScope>();
        for (IteratorUtil.IteratorScope scope : IteratorUtil.IteratorScope.values()) {
            if (!allScopes && !cl.hasOption(this.scopeOpts.get(scope).getOpt())) continue;
            desiredScopes.add(scope);
        }
        if (desiredScopes.isEmpty()) {
            throw new IllegalArgumentException("You must select at least one scope to configure");
        }
        StringBuilder sb = new StringBuilder("-\n");
        for (Map.Entry entry : iterators.entrySet()) {
            String name = (String)entry.getKey();
            EnumSet scopes = (EnumSet)entry.getValue();
            for (IteratorUtil.IteratorScope scope : scopes) {
                IteratorSetting setting;
                if (!desiredScopes.contains(scope)) continue;
                if (namespaces) {
                    setting = shellState.getConnector().namespaceOperations().getIteratorSetting(OptUtil.getNamespaceOpt(cl, shellState), name, scope);
                } else if (tables) {
                    setting = shellState.getConnector().tableOperations().getIteratorSetting(OptUtil.getTableOpt(cl, shellState), name, scope);
                } else {
                    throw new IllegalArgumentException("No table or namespace specified");
                }
                sb.append("-    Iterator ").append(setting.getName()).append(", ").append(scope).append(" scope options:\n");
                sb.append("-        ").append("iteratorPriority").append(" = ").append(setting.getPriority()).append("\n");
                sb.append("-        ").append("iteratorClassName").append(" = ").append(setting.getIteratorClass()).append("\n");
                for (Map.Entry optEntry : setting.getOptions().entrySet()) {
                    sb.append("-        ").append((String)optEntry.getKey()).append(" = ").append((String)optEntry.getValue()).append("\n");
                }
            }
        }
        sb.append("-");
        shellState.getReader().println((CharSequence)sb.toString());
        return 0;
    }

    @Override
    public String description() {
        return "lists table-specific or namespace-specific iterators configured in this shell session";
    }

    @Override
    public int numArgs() {
        return 0;
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.nameOpt = new Option("n", "name", true, "iterator to list");
        this.nameOpt.setArgName("itername");
        this.allScopesOpt = new Option("all", "all-scopes", false, "list from all scopes");
        o.addOption(this.allScopesOpt);
        this.scopeOpts = new EnumMap<IteratorUtil.IteratorScope, Option>(IteratorUtil.IteratorScope.class);
        this.scopeOpts.put(IteratorUtil.IteratorScope.minc, new Option(IteratorUtil.IteratorScope.minc.name(), "minor-compaction", false, "list iterator for minor compaction scope"));
        this.scopeOpts.put(IteratorUtil.IteratorScope.majc, new Option(IteratorUtil.IteratorScope.majc.name(), "major-compaction", false, "list iterator for major compaction scope"));
        this.scopeOpts.put(IteratorUtil.IteratorScope.scan, new Option(IteratorUtil.IteratorScope.scan.name(), "scan-time", false, "list iterator for scan scope"));
        OptionGroup grp = new OptionGroup();
        grp.addOption(OptUtil.tableOpt("table to list the configured iterators on"));
        grp.addOption(OptUtil.namespaceOpt("namespace to list the configured iterators on"));
        o.addOptionGroup(grp);
        o.addOption(this.nameOpt);
        for (Option opt : this.scopeOpts.values()) {
            o.addOption(opt);
        }
        return o;
    }
}

