/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.multitable;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;

public class BulkImport
extends Test {
    public static final int LOTS = 100000;
    public static final int COLS = 10;
    public static final List<IteratorSetting.Column> COLNAMES = new ArrayList<IteratorSetting.Column>();
    public static final Text CHECK_COLUMN_FAMILY = new Text("cf");
    public static final Text MARKER_CF;
    static final AtomicLong counter;
    private static final Value ONE;

    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        List tables = (List)state.get("tableList");
        if (tables.isEmpty()) {
            this.log.debug((Object)"No tables to ingest into");
            return;
        }
        Random rand = new Random();
        String tableName = (String)tables.get(rand.nextInt(tables.size()));
        String uuid = UUID.randomUUID().toString();
        Path dir = new Path("/tmp", "bulk_" + uuid);
        Path fail = new Path(dir.toString() + "_fail");
        DefaultConfiguration defaultConfiguration = AccumuloConfiguration.getDefaultConfiguration();
        FileSystem fs = (FileSystem)state.get("fs");
        fs.mkdirs(fail);
        int parts = rand.nextInt(10) + 1;
        TreeSet<String> rows = new TreeSet<String>();
        for (int i = 0; i < 100000; ++i) {
            rows.add(uuid + String.format("__%05d", i));
        }
        String markerColumnQualifier = String.format("%07d", counter.incrementAndGet());
        this.log.debug((Object)("Preparing bulk import to " + tableName + " start: " + (String)rows.first() + " last: " + (String)rows.last() + " marker: " + markerColumnQualifier));
        for (int i = 0; i < parts; ++i) {
            String fileName = dir + "/" + String.format("part_%d.", i) + "rf";
            FileSKVWriter f = ((FileOperations.OpenWriterOperationBuilder)FileOperations.getInstance().newWriterBuilder().forFile(fileName, fs, fs.getConf()).withTableConfiguration((AccumuloConfiguration)defaultConfiguration)).build();
            f.startDefaultLocalityGroup();
            for (String r : rows) {
                Text row = new Text(r);
                for (IteratorSetting.Column col : COLNAMES) {
                    f.append(new Key(row, col.getColumnFamily(), col.getColumnQualifier()), ONE);
                }
                f.append(new Key(row, MARKER_CF, new Text(markerColumnQualifier)), ONE);
            }
            f.close();
        }
        env.getConnector().tableOperations().importDirectory(tableName, dir.toString(), fail.toString(), true);
        fs.delete(dir, true);
        FileStatus[] failures = fs.listStatus(fail);
        if (failures != null && failures.length > 0) {
            state.set("bulkImportSuccess", "false");
            throw new Exception(failures.length + " failure files found importing files from " + dir);
        }
        fs.delete(fail, true);
        this.log.debug((Object)("Finished bulk import to " + tableName + " start: " + (String)rows.first() + " last: " + (String)rows.last() + " marker " + markerColumnQualifier));
    }

    static {
        for (int i = 0; i < 10; ++i) {
            COLNAMES.add(new IteratorSetting.Column(CHECK_COLUMN_FAMILY, new Text(String.format("%03d", i))));
        }
        MARKER_CF = new Text("marker");
        counter = new AtomicLong();
        ONE = new Value("1".getBytes());
    }
}

