/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.performance.metadata;

import com.google.common.collect.Iterators;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.Stat;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataBatchScanTest {
    private static final Logger log = LoggerFactory.getLogger(MetadataBatchScanTest.class);

    public static void main(String[] args) throws Exception {
        Mutation mut;
        BatchWriter bw;
        ClientOpts opts = new ClientOpts();
        opts.parseArgs(MetadataBatchScanTest.class.getName(), args, new Object[0]);
        ZooKeeperInstance inst = new ZooKeeperInstance(ClientConfiguration.create().withInstance("acu14").withZkHosts("localhost"));
        final Connector connector = inst.getConnector(opts.getPrincipal(), opts.getToken());
        TreeSet<Long> splits = new TreeSet<Long>();
        Random r = new Random(42L);
        while (splits.size() < 99999) {
            splits.add((r.nextLong() & Long.MAX_VALUE) % 1000000000000L);
        }
        String tid = "8";
        Text per = null;
        ArrayList<KeyExtent> extents = new ArrayList<KeyExtent>();
        for (Long l : splits) {
            Text er = new Text(String.format("%012d", l));
            KeyExtent ke = new KeyExtent(tid, er, per);
            per = er;
            extents.add(ke);
        }
        extents.add(new KeyExtent(tid, null, per));
        if (args[0].equals("write")) {
            bw = connector.createBatchWriter("accumulo.metadata", new BatchWriterConfig());
            for (KeyExtent extent : extents) {
                mut = extent.getPrevRowUpdateMutation();
                new TServerInstance(HostAndPort.fromParts((String)"192.168.1.100", (int)4567), "DEADBEEF").putLocation(mut);
                bw.addMutation(mut);
            }
            bw.close();
        } else if (args[0].equals("writeFiles")) {
            bw = connector.createBatchWriter("accumulo.metadata", new BatchWriterConfig());
            for (KeyExtent extent : extents) {
                mut = new Mutation(extent.getMetadataEntry());
                String dir = "/t-" + UUID.randomUUID();
                MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(mut, new Value(dir.getBytes(StandardCharsets.UTF_8)));
                for (int i = 0; i < 5; ++i) {
                    mut.put(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, new Text(dir + "/00000_0000" + i + ".map"), new DataFileValue(10000L, 1000000L).encodeAsValue());
                }
                bw.addMutation(mut);
            }
            bw.close();
        } else if (args[0].equals("scan")) {
            int i;
            int numThreads = Integer.parseInt(args[1]);
            final int n = Integer.parseInt(args[2]);
            int numLookups = Integer.parseInt(args[3]);
            HashSet<Integer> indexes = new HashSet<Integer>();
            while (indexes.size() < numLookups) {
                indexes.add(r.nextInt(extents.size()));
            }
            final ArrayList<Range> ranges = new ArrayList<Range>();
            for (Integer i2 : indexes) {
                ranges.add(((KeyExtent)extents.get(i2)).toMetadataRange());
            }
            Thread[] threads = new Thread[numThreads];
            for (int i3 = 0; i3 < threads.length; ++i3) {
                threads[i3] = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            System.out.println(MetadataBatchScanTest.runScanTest(connector, n, ranges));
                        }
                        catch (Exception e) {
                            log.error("Exception while running scan test.", (Throwable)e);
                        }
                    }
                });
            }
            long t1 = System.currentTimeMillis();
            for (i = 0; i < threads.length; ++i) {
                threads[i].start();
            }
            for (i = 0; i < threads.length; ++i) {
                threads[i].join();
            }
            long t2 = System.currentTimeMillis();
            System.out.printf("tt : %6.2f%n", (double)(t2 - t1) / 1000.0);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private static ScanStats runScanTest(Connector connector, int numLoop, List<Range> ranges) throws Exception {
        Scanner scanner = null;
        BatchScanner bs = connector.createBatchScanner("accumulo.metadata", Authorizations.EMPTY, 1);
        bs.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
        MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch((ScannerBase)bs);
        bs.setRanges(ranges);
        ScanStats stats = new ScanStats();
        for (int i = 0; i < numLoop; ++i) {
            ScanStat ss = MetadataBatchScanTest.scan(bs, ranges, scanner);
            stats.merge(ss);
        }
        return stats;
    }

    private static ScanStat scan(BatchScanner bs, List<Range> ranges, Scanner scanner) {
        ScanStat ss = new ScanStat();
        long t1 = System.currentTimeMillis();
        int count = Iterators.size((Iterator)bs.iterator());
        bs.close();
        long t2 = System.currentTimeMillis();
        ss.delta1 = t2 - t1;
        ss.count1 = count;
        count = 0;
        t1 = System.currentTimeMillis();
        t2 = System.currentTimeMillis();
        ss.delta2 = t2 - t1;
        ss.count2 = count;
        return ss;
    }

    private static class ScanStats {
        Stat delta1 = new Stat();
        Stat delta2 = new Stat();
        Stat count1 = new Stat();
        Stat count2 = new Stat();

        private ScanStats() {
        }

        void merge(ScanStat ss) {
            this.delta1.addStat(ss.delta1);
            this.delta2.addStat(ss.delta2);
            this.count1.addStat((long)ss.count1);
            this.count2.addStat((long)ss.count2);
        }

        public String toString() {
            return "[" + this.delta1 + "] [" + this.delta2 + "]";
        }
    }

    private static class ScanStat {
        long delta1;
        long delta2;
        int count1;
        int count2;

        private ScanStat() {
        }
    }
}

