/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterables;
import java.util.Map;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloITBase;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.MiniClusterHarness;
import org.apache.accumulo.harness.TestingKdc;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.categories.MiniClusterOnlyTests;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiniClusterOnlyTests.class})
public class KerberosRenewalIT
extends AccumuloITBase {
    private static final Logger log = LoggerFactory.getLogger(KerberosRenewalIT.class);
    private static TestingKdc kdc;
    private static String krbEnabledForITs;
    private static ClusterUser rootUser;
    private static final long TICKET_LIFETIME = 360000L;
    private static final long TICKET_TEST_LIFETIME = 480000L;
    private static final long TEST_DURATION = 540000L;
    private MiniAccumuloClusterImpl mac;

    @BeforeClass
    public static void startKdc() throws Exception {
        kdc = new TestingKdc(TestingKdc.computeKdcDir(), TestingKdc.computeKeytabDir(), 360000L);
        kdc.start();
        krbEnabledForITs = System.getProperty("org.apache.accumulo.test.functional.useKrbForIT");
        if (null == krbEnabledForITs || !Boolean.parseBoolean(krbEnabledForITs)) {
            System.setProperty("org.apache.accumulo.test.functional.useKrbForIT", "true");
        }
        rootUser = kdc.getRootUser();
    }

    @AfterClass
    public static void stopKdc() throws Exception {
        if (null != kdc) {
            kdc.stop();
        }
        if (null != krbEnabledForITs) {
            System.setProperty("org.apache.accumulo.test.functional.useKrbForIT", krbEnabledForITs);
        }
    }

    @Override
    public int defaultTimeoutSeconds() {
        return 540;
    }

    @Before
    public void startMac() throws Exception {
        MiniClusterHarness harness = new MiniClusterHarness();
        this.mac = harness.create(this, (AuthenticationToken)new PasswordToken((CharSequence)"unused"), kdc, new MiniClusterConfigurationCallback(){

            @Override
            public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
                Map site = cfg.getSiteConfig();
                site.put(Property.INSTANCE_ZK_TIMEOUT.getKey(), "15s");
                site.put(Property.GENERAL_KERBEROS_RENEWAL_PERIOD.getKey(), "5s");
                cfg.setSiteConfig(site);
            }
        });
        this.mac.getConfig().setNumTservers(1);
        this.mac.start();
        Configuration conf = new Configuration(false);
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    @After
    public void stopMac() throws Exception {
        if (null != this.mac) {
            this.mac.stop();
        }
    }

    @Test(timeout=540000L)
    public void testReadAndWriteThroughTicketLifetime() throws Exception {
        long now;
        UserGroupInformation.loginUserFromKeytab((String)rootUser.getPrincipal(), (String)rootUser.getKeytab().getAbsolutePath());
        log.info("Logged in as {}", (Object)rootUser.getPrincipal());
        Connector conn = this.mac.getConnector(rootUser.getPrincipal(), (AuthenticationToken)new KerberosToken());
        log.info("Created connector as {}", (Object)rootUser.getPrincipal());
        Assert.assertEquals((Object)rootUser.getPrincipal(), (Object)conn.whoami());
        long last = System.currentTimeMillis();
        for (long duration = 0L; duration < 480000L; duration += now - last) {
            this.createReadWriteDrop(conn);
            Thread.sleep(5000L);
            now = System.currentTimeMillis();
            last = now;
        }
    }

    private void createReadWriteDrop(Connector conn) throws TableNotFoundException, AccumuloSecurityException, AccumuloException, TableExistsException {
        String table = this.testName.getMethodName() + "_table";
        conn.tableOperations().create(table);
        BatchWriter bw = conn.createBatchWriter(table, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"a");
        m.put((CharSequence)"b", (CharSequence)"c", (CharSequence)"d");
        bw.addMutation(m);
        bw.close();
        conn.tableOperations().compact(table, new CompactionConfig().setFlush(true).setWait(true));
        Scanner s = conn.createScanner(table, Authorizations.EMPTY);
        Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
        Assert.assertEquals((String)"Did not find the expected key", (long)0L, (long)new Key((CharSequence)"a", (CharSequence)"b", (CharSequence)"c").compareTo((Key)entry.getKey(), PartialKey.ROW_COLFAM_COLQUAL));
        Assert.assertEquals((Object)"d", (Object)((Value)entry.getValue()).toString());
        conn.tableOperations().delete(table);
    }

    static {
        krbEnabledForITs = null;
    }
}

