/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.junit.Assert;
import org.junit.Test;

public class KeyValueEqualityIT
extends AccumuloClusterHarness {
    @Override
    public int defaultTimeoutSeconds() {
        return 60;
    }

    @Test
    public void testEquality() throws Exception {
        Connector conn = this.getConnector();
        BatchWriterConfig config = new BatchWriterConfig();
        String[] tables = this.getUniqueNames(2);
        String table1 = tables[0];
        String table2 = tables[1];
        TableOperations tops = conn.tableOperations();
        tops.create(table1);
        tops.create(table2);
        BatchWriter bw1 = conn.createBatchWriter(table1, config);
        BatchWriter bw2 = conn.createBatchWriter(table2, config);
        for (int row = 0; row < 100; ++row) {
            Mutation m = new Mutation((CharSequence)Integer.toString(row));
            for (int col = 0; col < 10; ++col) {
                m.put((CharSequence)Integer.toString(col), (CharSequence)"", System.currentTimeMillis(), (CharSequence)Integer.toString(col * 2));
            }
            bw1.addMutation(m);
            bw2.addMutation(m);
        }
        bw1.close();
        bw2.close();
        Iterator t1 = conn.createScanner(table1, Authorizations.EMPTY).iterator();
        Iterator t2 = conn.createScanner(table2, Authorizations.EMPTY).iterator();
        while (t1.hasNext() && t2.hasNext()) {
            Map.Entry e1 = (Map.Entry)t1.next();
            Map.Entry e2 = (Map.Entry)t2.next();
            Assert.assertEquals((Object)e1, (Object)e2);
            Assert.assertEquals((long)e1.hashCode(), (long)e2.hashCode());
        }
        Assert.assertFalse((String)"table1 had more data to read", (boolean)t1.hasNext());
        Assert.assertFalse((String)"table2 had more data to read", (boolean)t2.hasNext());
    }
}

