/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationObserver;
import org.apache.accumulo.core.conf.ObservableConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.NamespaceConfWatcher;
import org.apache.accumulo.server.conf.ZooCachePropertyAccessor;
import org.apache.zookeeper.Watcher;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceConfiguration
extends ObservableConfiguration {
    private static final Logger log = LoggerFactory.getLogger(NamespaceConfiguration.class);
    private static final Map<ZooCachePropertyAccessor.PropCacheKey, ZooCache> propCaches = new HashMap<ZooCachePropertyAccessor.PropCacheKey, ZooCache>();
    private final AccumuloConfiguration parent;
    private ZooCachePropertyAccessor propCacheAccessor = null;
    protected String namespaceId = null;
    protected Instance inst = null;
    private ZooCacheFactory zcf = new ZooCacheFactory();
    private final String path;

    public NamespaceConfiguration(String namespaceId, AccumuloConfiguration parent) {
        this(namespaceId, HdfsZooInstance.getInstance(), parent);
    }

    public NamespaceConfiguration(String namespaceId, Instance inst, AccumuloConfiguration parent) {
        this.inst = inst;
        this.parent = parent;
        this.namespaceId = namespaceId;
        this.path = ZooUtil.getRoot((String)inst.getInstanceID()) + "/namespaces" + "/" + namespaceId + "/conf";
    }

    public AccumuloConfiguration getParentConfiguration() {
        return this.parent;
    }

    void setZooCacheFactory(ZooCacheFactory zcf) {
        this.zcf = zcf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ZooCachePropertyAccessor getPropCacheAccessor() {
        if (this.propCacheAccessor == null) {
            Map<ZooCachePropertyAccessor.PropCacheKey, ZooCache> map = propCaches;
            synchronized (map) {
                ZooCachePropertyAccessor.PropCacheKey key = new ZooCachePropertyAccessor.PropCacheKey(this.inst.getInstanceID(), this.namespaceId);
                ZooCache propCache = propCaches.get(key);
                if (propCache == null) {
                    propCache = this.zcf.getZooCache(this.inst.getZooKeepers(), this.inst.getZooKeepersSessionTimeOut(), (Watcher)new NamespaceConfWatcher(this.inst));
                    propCaches.put(key, propCache);
                }
                this.propCacheAccessor = new ZooCachePropertyAccessor(propCache);
            }
        }
        return this.propCacheAccessor;
    }

    private String getPath() {
        return this.path;
    }

    public String get(Property property) {
        String key = property.getKey();
        Object getParent = !this.namespaceId.equals("+accumulo") || !NamespaceConfiguration.isIteratorOrConstraint(key) ? this.parent : null;
        return this.getPropCacheAccessor().get(property, this.getPath(), (AccumuloConfiguration)getParent);
    }

    @SuppressModernizer
    public void getProperties(Map<String, String> props, Predicate<String> filter) {
        SystemNamespaceFilter parentFilter = filter;
        if (this.getNamespaceId().equals("+accumulo")) {
            parentFilter = new SystemNamespaceFilter(filter);
        }
        this.getPropCacheAccessor().getProperties(props, this.getPath(), filter, this.parent, parentFilter);
    }

    protected String getNamespaceId() {
        return this.namespaceId;
    }

    public void addObserver(ConfigurationObserver co) {
        if (this.namespaceId == null) {
            String err = "Attempt to add observer for non-namespace configuration";
            log.error(err);
            throw new RuntimeException(err);
        }
        this.iterator();
        super.addObserver(co);
    }

    public void removeObserver(ConfigurationObserver co) {
        if (this.namespaceId == null) {
            String err = "Attempt to remove observer for non-namespace configuration";
            log.error(err);
            throw new RuntimeException(err);
        }
        super.removeObserver(co);
    }

    static boolean isIteratorOrConstraint(String key) {
        return key.startsWith(Property.TABLE_ITERATOR_PREFIX.getKey()) || key.startsWith(Property.TABLE_CONSTRAINT_PREFIX.getKey());
    }

    public synchronized void invalidateCache() {
        if (null != this.propCacheAccessor) {
            this.propCacheAccessor.invalidateCache();
        }
    }

    public long getUpdateCount() {
        return this.parent.getUpdateCount() + this.getPropCacheAccessor().getZooCache().getUpdateCount();
    }

    @SuppressModernizer
    private class SystemNamespaceFilter
    implements Predicate<String> {
        private Predicate<String> userFilter;

        SystemNamespaceFilter(Predicate<String> userFilter) {
            this.userFilter = userFilter;
        }

        public boolean apply(String key) {
            if (NamespaceConfiguration.isIteratorOrConstraint(key)) {
                return false;
            }
            return this.userFilter.apply((Object)key);
        }
    }
}

