/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication.merkle;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.test.replication.merkle.RangeSerialization;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MerkleTreeNode {
    private static final Logger log = LoggerFactory.getLogger(MerkleTreeNode.class);
    private Range range;
    private int level;
    private List<Range> children;
    private byte[] hash;

    public MerkleTreeNode(Range range, int level, List<Range> children, byte[] hash) {
        this.range = range;
        this.level = level;
        this.children = children;
        this.hash = hash;
    }

    public MerkleTreeNode(Key k, Value v) {
        this.range = RangeSerialization.toRange(k);
        this.level = 0;
        this.children = Collections.emptyList();
        this.hash = v.get();
    }

    public MerkleTreeNode(List<MerkleTreeNode> children, String digestAlgorithm) throws NoSuchAlgorithmException {
        this.level = 0;
        this.children = new ArrayList<Range>(children.size());
        MessageDigest digest = MessageDigest.getInstance(digestAlgorithm);
        Range childrenRange = null;
        for (MerkleTreeNode child : children) {
            this.children.add(child.getRange());
            this.level = Math.max(child.getLevel(), this.level);
            digest.update(child.getHash());
            if (null == childrenRange) {
                childrenRange = child.getRange();
                continue;
            }
            List overlappingRanges = Range.mergeOverlapping(Arrays.asList(childrenRange, child.getRange()));
            if (1 != overlappingRanges.size()) {
                log.error("Tried to merge non-contiguous ranges: {} {}", (Object)childrenRange, (Object)child.getRange());
                throw new IllegalArgumentException("Ranges must be contiguous: " + childrenRange + ", " + child.getRange());
            }
            childrenRange = (Range)overlappingRanges.get(0);
        }
        ++this.level;
        this.hash = digest.digest();
        this.range = childrenRange;
    }

    public Range getRange() {
        return this.range;
    }

    public int getLevel() {
        return this.level;
    }

    public List<Range> getChildren() {
        return this.children;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("range=").append(this.range).append(" level=").append(this.level).append(" hash=").append(Hex.encodeHexString((byte[])this.hash)).append(" children=").append(this.children);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof MerkleTreeNode) {
            MerkleTreeNode other = (MerkleTreeNode)o;
            return this.range.equals(other.getRange()) && this.level == other.getLevel() && this.children.equals(other.getChildren()) && Arrays.equals(this.hash, other.getHash());
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder(1395, 39532);
        return hcb.append((Object)this.range).append(this.level).append(this.children).append(this.hash).toHashCode();
    }
}

