/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import com.google.protobuf.GeneratedMessage;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.impl.ReplicationOperationsImpl;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.MasterClientServiceHandler;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore(value="Replication ITs are not stable and not currently maintained")
public class ReplicationOperationsImplIT
extends ConfigurableMacBase {
    private static final Logger log = LoggerFactory.getLogger(ReplicationOperationsImplIT.class);
    private Instance inst;
    private Connector conn;

    @Before
    public void configureInstance() throws Exception {
        this.conn = this.getConnector();
        this.inst = this.conn.getInstance();
        ReplicationTable.setOnline((Connector)this.conn);
        this.conn.securityOperations().grantTablePermission(this.conn.whoami(), "accumulo.metadata", TablePermission.WRITE);
        this.conn.securityOperations().grantTablePermission(this.conn.whoami(), "accumulo.replication", TablePermission.READ);
        this.conn.securityOperations().grantTablePermission(this.conn.whoami(), "accumulo.replication", TablePermission.WRITE);
    }

    private ReplicationOperationsImpl getReplicationOperations() throws Exception {
        Master master = (Master)EasyMock.createMock(Master.class);
        EasyMock.expect((Object)master.getConnector()).andReturn((Object)this.conn).anyTimes();
        EasyMock.expect((Object)master.getInstance()).andReturn((Object)this.inst).anyTimes();
        EasyMock.replay((Object[])new Object[]{master});
        final MasterClientServiceHandler mcsh = new MasterClientServiceHandler(master){

            protected String getTableId(Instance inst, String tableName) throws ThriftTableOperationException {
                try {
                    return (String)ReplicationOperationsImplIT.this.conn.tableOperations().tableIdMap().get(tableName);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        ClientContext context = new ClientContext(this.inst, new Credentials("root", (AuthenticationToken)new PasswordToken((CharSequence)"testRootPassword1")), this.getClientConfig());
        return new ReplicationOperationsImpl(context){

            protected boolean getMasterDrain(TInfo tinfo, TCredentials rpcCreds, String tableName, Set<String> wals) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
                try {
                    return mcsh.drainReplicationTable(tinfo, rpcCreds, tableName, wals);
                }
                catch (TException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @Test
    public void waitsUntilEntriesAreReplicated() throws Exception {
        this.conn.tableOperations().create("foo");
        String tableId = (String)this.conn.tableOperations().tableIdMap().get("foo");
        String file1 = "/accumulo/wals/tserver+port/" + UUID.randomUUID();
        String file2 = "/accumulo/wals/tserver+port/" + UUID.randomUUID();
        Replication.Status stat = Replication.Status.newBuilder().setBegin(0L).setEnd(10000L).setInfiniteEnd(false).setClosed(false).build();
        BatchWriter bw = ReplicationTable.getBatchWriter((Connector)this.conn);
        Mutation m = new Mutation((CharSequence)file1);
        ReplicationSchema.StatusSection.add((Mutation)m, (String)tableId, (Value)ProtobufUtil.toValue((GeneratedMessage)stat));
        bw.addMutation(m);
        m = new Mutation((CharSequence)file2);
        ReplicationSchema.StatusSection.add((Mutation)m, (String)tableId, (Value)ProtobufUtil.toValue((GeneratedMessage)stat));
        bw.addMutation(m);
        bw.close();
        bw = this.conn.createBatchWriter("accumulo.metadata", new BatchWriterConfig());
        m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + file1));
        m.put(MetadataSchema.ReplicationSection.COLF, new Text(tableId), ProtobufUtil.toValue((GeneratedMessage)stat));
        bw.addMutation(m);
        m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + file2));
        m.put(MetadataSchema.ReplicationSection.COLF, new Text(tableId), ProtobufUtil.toValue((GeneratedMessage)stat));
        bw.close();
        final AtomicBoolean done = new AtomicBoolean(false);
        final AtomicBoolean exception = new AtomicBoolean(false);
        final ReplicationOperationsImpl roi = this.getReplicationOperations();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    roi.drain("foo");
                }
                catch (Exception e) {
                    log.error("Got error", (Throwable)e);
                    exception.set(true);
                }
                done.set(true);
            }
        });
        t.start();
        Assert.assertFalse((boolean)done.get());
        bw = this.conn.createBatchWriter("accumulo.metadata", new BatchWriterConfig());
        m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + file1));
        m.putDelete(MetadataSchema.ReplicationSection.COLF, new Text(tableId));
        bw.addMutation(m);
        bw.flush();
        Assert.assertFalse((boolean)done.get());
        m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + file2));
        m.putDelete(MetadataSchema.ReplicationSection.COLF, new Text(tableId));
        bw.addMutation(m);
        bw.flush();
        bw.close();
        Assert.assertFalse((boolean)done.get());
        bw = ReplicationTable.getBatchWriter((Connector)this.conn);
        m = new Mutation((CharSequence)file1);
        m.putDelete(ReplicationSchema.StatusSection.NAME, new Text(tableId));
        bw.addMutation(m);
        bw.flush();
        Assert.assertFalse((boolean)done.get());
        m = new Mutation((CharSequence)file2);
        m.putDelete(ReplicationSchema.StatusSection.NAME, new Text(tableId));
        bw.addMutation(m);
        bw.flush();
        try {
            t.join(5000L);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"ReplicationOperations.drain did not complete");
        }
        Assert.assertTrue((String)"Drain never finished", (boolean)done.get());
        Assert.assertFalse((String)"Saw unexpectetd exception", (boolean)exception.get());
    }

    @Test
    public void unrelatedReplicationRecordsDontBlockDrain() throws Exception {
        this.conn.tableOperations().create("foo");
        this.conn.tableOperations().create("bar");
        String tableId1 = (String)this.conn.tableOperations().tableIdMap().get("foo");
        String tableId2 = (String)this.conn.tableOperations().tableIdMap().get("bar");
        String file1 = "/accumulo/wals/tserver+port/" + UUID.randomUUID();
        String file2 = "/accumulo/wals/tserver+port/" + UUID.randomUUID();
        Replication.Status stat = Replication.Status.newBuilder().setBegin(0L).setEnd(10000L).setInfiniteEnd(false).setClosed(false).build();
        BatchWriter bw = ReplicationTable.getBatchWriter((Connector)this.conn);
        Mutation m = new Mutation((CharSequence)file1);
        ReplicationSchema.StatusSection.add((Mutation)m, (String)tableId1, (Value)ProtobufUtil.toValue((GeneratedMessage)stat));
        bw.addMutation(m);
        m = new Mutation((CharSequence)file2);
        ReplicationSchema.StatusSection.add((Mutation)m, (String)tableId2, (Value)ProtobufUtil.toValue((GeneratedMessage)stat));
        bw.addMutation(m);
        bw.close();
        bw = this.conn.createBatchWriter("accumulo.metadata", new BatchWriterConfig());
        m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + file1));
        m.put(MetadataSchema.ReplicationSection.COLF, new Text(tableId1), ProtobufUtil.toValue((GeneratedMessage)stat));
        bw.addMutation(m);
        m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + file2));
        m.put(MetadataSchema.ReplicationSection.COLF, new Text(tableId2), ProtobufUtil.toValue((GeneratedMessage)stat));
        bw.close();
        final AtomicBoolean done = new AtomicBoolean(false);
        final AtomicBoolean exception = new AtomicBoolean(false);
        final ReplicationOperationsImpl roi = this.getReplicationOperations();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    roi.drain("foo");
                }
                catch (Exception e) {
                    log.error("Got error", (Throwable)e);
                    exception.set(true);
                }
                done.set(true);
            }
        });
        t.start();
        Assert.assertFalse((boolean)done.get());
        bw = this.conn.createBatchWriter("accumulo.metadata", new BatchWriterConfig());
        m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + file1));
        m.putDelete(MetadataSchema.ReplicationSection.COLF, new Text(tableId1));
        bw.addMutation(m);
        bw.flush();
        Assert.assertFalse((boolean)done.get());
        bw = ReplicationTable.getBatchWriter((Connector)this.conn);
        m = new Mutation((CharSequence)file1);
        m.putDelete(ReplicationSchema.StatusSection.NAME, new Text(tableId1));
        bw.addMutation(m);
        bw.flush();
        try {
            t.join(5000L);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"ReplicationOperations.drain did not complete");
        }
        Assert.assertTrue((String)"Drain never completed", (boolean)done.get());
        Assert.assertFalse((String)"Saw unexpected exception", (boolean)exception.get());
    }

    @Test
    public void inprogressReplicationRecordsBlockExecution() throws Exception {
        this.conn.tableOperations().create("foo");
        String tableId1 = (String)this.conn.tableOperations().tableIdMap().get("foo");
        String file1 = "/accumulo/wals/tserver+port/" + UUID.randomUUID();
        Replication.Status stat = Replication.Status.newBuilder().setBegin(0L).setEnd(10000L).setInfiniteEnd(false).setClosed(false).build();
        BatchWriter bw = ReplicationTable.getBatchWriter((Connector)this.conn);
        Mutation m = new Mutation((CharSequence)file1);
        ReplicationSchema.StatusSection.add((Mutation)m, (String)tableId1, (Value)ProtobufUtil.toValue((GeneratedMessage)stat));
        bw.addMutation(m);
        bw.close();
        LogEntry logEntry = new LogEntry(new KeyExtent(tableId1, null, null), System.currentTimeMillis(), "tserver", file1);
        bw = this.conn.createBatchWriter("accumulo.metadata", new BatchWriterConfig());
        m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + file1));
        m.put(MetadataSchema.ReplicationSection.COLF, new Text(tableId1), ProtobufUtil.toValue((GeneratedMessage)stat));
        bw.addMutation(m);
        m = new Mutation(logEntry.getRow());
        m.put(logEntry.getColumnFamily(), logEntry.getColumnQualifier(), logEntry.getValue());
        bw.addMutation(m);
        bw.close();
        final AtomicBoolean done = new AtomicBoolean(false);
        final AtomicBoolean exception = new AtomicBoolean(false);
        final ReplicationOperationsImpl roi = this.getReplicationOperations();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    roi.drain("foo");
                }
                catch (Exception e) {
                    log.error("Got error", (Throwable)e);
                    exception.set(true);
                }
                done.set(true);
            }
        });
        t.start();
        Assert.assertFalse((boolean)done.get());
        Replication.Status newStatus = Replication.Status.newBuilder().setBegin(1000L).setEnd(2000L).setInfiniteEnd(false).setClosed(true).build();
        bw = this.conn.createBatchWriter("accumulo.metadata", new BatchWriterConfig());
        m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + file1));
        m.put(MetadataSchema.ReplicationSection.COLF, new Text(tableId1), ProtobufUtil.toValue((GeneratedMessage)newStatus));
        bw.addMutation(m);
        bw.flush();
        Assert.assertFalse((boolean)done.get());
        bw = ReplicationTable.getBatchWriter((Connector)this.conn);
        m = new Mutation((CharSequence)file1);
        m.put(ReplicationSchema.StatusSection.NAME, new Text(tableId1), ProtobufUtil.toValue((GeneratedMessage)newStatus));
        bw.addMutation(m);
        bw.flush();
        try {
            t.join(5000L);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"ReplicationOperations.drain did not complete");
        }
        Assert.assertFalse((String)"Drain somehow finished", (boolean)done.get());
        Assert.assertFalse((String)"Saw unexpected exception", (boolean)exception.get());
    }

    @Test
    public void laterCreatedLogsDontBlockExecution() throws Exception {
        this.conn.tableOperations().create("foo");
        String tableId1 = (String)this.conn.tableOperations().tableIdMap().get("foo");
        String file1 = "/accumulo/wals/tserver+port/" + UUID.randomUUID();
        Replication.Status stat = Replication.Status.newBuilder().setBegin(0L).setEnd(10000L).setInfiniteEnd(false).setClosed(false).build();
        BatchWriter bw = ReplicationTable.getBatchWriter((Connector)this.conn);
        Mutation m = new Mutation((CharSequence)file1);
        ReplicationSchema.StatusSection.add((Mutation)m, (String)tableId1, (Value)ProtobufUtil.toValue((GeneratedMessage)stat));
        bw.addMutation(m);
        bw.close();
        bw = this.conn.createBatchWriter("accumulo.metadata", new BatchWriterConfig());
        m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + file1));
        m.put(MetadataSchema.ReplicationSection.COLF, new Text(tableId1), ProtobufUtil.toValue((GeneratedMessage)stat));
        bw.addMutation(m);
        bw.close();
        log.info("Reading metadata first time");
        try (Scanner s = this.conn.createScanner("accumulo.metadata", Authorizations.EMPTY);){
            for (Map.Entry e : s) {
                log.info("{}", e.getKey());
            }
        }
        final AtomicBoolean done = new AtomicBoolean(false);
        final AtomicBoolean exception = new AtomicBoolean(false);
        final ReplicationOperationsImpl roi = this.getReplicationOperations();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    roi.drain("foo");
                }
                catch (Exception e) {
                    log.error("Got error", (Throwable)e);
                    exception.set(true);
                }
                done.set(true);
            }
        });
        t.start();
        Thread.sleep(2000L);
        bw = this.conn.createBatchWriter("accumulo.metadata", new BatchWriterConfig());
        m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + "/accumulo/wals/tserver+port/" + UUID.randomUUID()));
        m.put(MetadataSchema.ReplicationSection.COLF, new Text(tableId1), ProtobufUtil.toValue((GeneratedMessage)stat));
        bw.addMutation(m);
        m = new Mutation((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + file1));
        m.putDelete(MetadataSchema.ReplicationSection.COLF, new Text(tableId1));
        bw.addMutation(m);
        bw.close();
        log.info("Reading metadata second time");
        try (Scanner s = this.conn.createScanner("accumulo.metadata", Authorizations.EMPTY);){
            for (Map.Entry e : s) {
                log.info("{}", e.getKey());
            }
        }
        bw = ReplicationTable.getBatchWriter((Connector)this.conn);
        m = new Mutation((CharSequence)file1);
        m.putDelete(ReplicationSchema.StatusSection.NAME, new Text(tableId1));
        bw.addMutation(m);
        bw.close();
        try {
            t.join(5000L);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"ReplicationOperations.drain did not complete");
        }
        Assert.assertTrue((String)"Drain didn't finish", (boolean)done.get());
    }
}

