/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.proxy;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.proxy.Proxy;
import org.apache.accumulo.proxy.thrift.AccumuloException;
import org.apache.accumulo.proxy.thrift.IteratorScope;
import org.apache.accumulo.proxy.thrift.IteratorSetting;
import org.apache.accumulo.test.proxy.TestProxyClient;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class TestProxyNamespaceOperations {
    protected static TServer proxy;
    protected static TestProxyClient tpc;
    protected static ByteBuffer userpass;
    protected static final int port = 10198;
    protected static final String testnamespace = "testns";

    @BeforeClass
    public static void setup() throws Exception {
        Properties prop = new Properties();
        prop.setProperty("useMockInstance", "true");
        prop.put("tokenClass", PasswordToken.class.getName());
        proxy = Proxy.createProxyServer((HostAndPort)HostAndPort.fromParts((String)"localhost", (int)10198), (TProtocolFactory)new TCompactProtocol.Factory(), (Properties)prop).server;
        while (!proxy.isServing()) {
            Thread.sleep(500L);
        }
        tpc = new TestProxyClient("localhost", 10198);
        userpass = tpc.proxy().login("root", Collections.singletonMap("password", ""));
    }

    @AfterClass
    public static void tearDown() throws InterruptedException {
        proxy.stop();
    }

    @Before
    public void makeTestNamespace() throws Exception {
        tpc.proxy().createNamespace(userpass, testnamespace);
    }

    @After
    public void deleteTestNamespace() throws Exception {
        tpc.proxy().deleteNamespace(userpass, testnamespace);
    }

    @Test
    public void createExistsDelete() throws TException {
        tpc.proxy().createNamespace(userpass, "testns2");
        Assert.assertTrue((boolean)tpc.proxy().namespaceExists(userpass, "testns2"));
        tpc.proxy().deleteNamespace(userpass, "testns2");
        Assert.assertFalse((boolean)tpc.proxy().namespaceExists(userpass, "testns2"));
    }

    @Test
    public void listRename() throws TException {
        Assert.assertFalse((boolean)tpc.proxy().namespaceExists(userpass, "testns2"));
        tpc.proxy().renameNamespace(userpass, testnamespace, "testns2");
        Assert.assertTrue((boolean)tpc.proxy().namespaceExists(userpass, "testns2"));
        tpc.proxy().renameNamespace(userpass, "testns2", testnamespace);
        Assert.assertTrue((boolean)tpc.proxy().listNamespaces(userpass).contains(testnamespace));
        Assert.assertFalse((boolean)tpc.proxy().listNamespaces(userpass).contains("testns2"));
    }

    @Test
    public void systemDefault() throws TException {
        Assert.assertEquals((Object)tpc.proxy().systemNamespace(), (Object)"accumulo");
        Assert.assertEquals((Object)tpc.proxy().defaultNamespace(), (Object)"");
    }

    @Test
    public void namespaceProperties() throws TException {
        tpc.proxy().setNamespaceProperty(userpass, testnamespace, "test.property1", "wharrrgarbl");
        Assert.assertEquals(tpc.proxy().getNamespaceProperties(userpass, testnamespace).get("test.property1"), (Object)"wharrrgarbl");
        tpc.proxy().removeNamespaceProperty(userpass, testnamespace, "test.property1");
        Assert.assertNull(tpc.proxy().getNamespaceProperties(userpass, testnamespace).get("test.property1"));
    }

    @Ignore(value="MockInstance doesn't return expected results for this function.")
    @Test
    public void namespaceIds() throws TException {
        Assert.assertTrue((boolean)tpc.proxy().namespaceIdMap(userpass).containsKey("accumulo"));
        Assert.assertEquals(tpc.proxy().namespaceIdMap(userpass).get("accumulo"), (Object)"+accumulo");
    }

    @Test
    public void namespaceIterators() throws TException {
        IteratorSetting setting = new IteratorSetting(40, "DebugTheThings", "org.apache.accumulo.core.iterators.DebugIterator", new HashMap());
        HashSet<IteratorScope> scopes = new HashSet<IteratorScope>();
        scopes.add(IteratorScope.SCAN);
        tpc.proxy().attachNamespaceIterator(userpass, testnamespace, setting, scopes);
        Assert.assertEquals((Object)setting, (Object)tpc.proxy().getNamespaceIteratorSetting(userpass, testnamespace, "DebugTheThings", IteratorScope.SCAN));
        Assert.assertTrue((boolean)tpc.proxy().listNamespaceIterators(userpass, testnamespace).containsKey("DebugTheThings"));
        HashSet<IteratorScope> scopes2 = new HashSet<IteratorScope>();
        scopes2.add(IteratorScope.MINC);
        tpc.proxy().checkNamespaceIteratorConflicts(userpass, testnamespace, setting, scopes2);
        tpc.proxy().removeNamespaceIterator(userpass, testnamespace, "DebugTheThings", scopes);
        Assert.assertFalse((boolean)tpc.proxy().listNamespaceIterators(userpass, testnamespace).containsKey("DebugTheThings"));
    }

    @Test(expected=AccumuloException.class)
    public void namespaceIteratorConflict() throws TException {
        IteratorSetting setting = new IteratorSetting(40, "DebugTheThings", "org.apache.accumulo.core.iterators.DebugIterator", new HashMap());
        HashSet<IteratorScope> scopes = new HashSet<IteratorScope>();
        scopes.add(IteratorScope.SCAN);
        tpc.proxy().attachNamespaceIterator(userpass, testnamespace, setting, scopes);
        tpc.proxy().checkNamespaceIteratorConflicts(userpass, testnamespace, setting, scopes);
    }

    @Test
    public void namespaceConstraints() throws TException {
        int constraintId = tpc.proxy().addNamespaceConstraint(userpass, testnamespace, "org.apache.accumulo.examples.simple.constraints.MaxMutationSize");
        Assert.assertTrue((boolean)tpc.proxy().listNamespaceConstraints(userpass, testnamespace).containsKey("org.apache.accumulo.examples.simple.constraints.MaxMutationSize"));
        Assert.assertEquals((long)constraintId, (long)((Integer)tpc.proxy().listNamespaceConstraints(userpass, testnamespace).get("org.apache.accumulo.examples.simple.constraints.MaxMutationSize")).intValue());
        tpc.proxy().removeNamespaceConstraint(userpass, testnamespace, constraintId);
        Assert.assertFalse((boolean)tpc.proxy().listNamespaceConstraints(userpass, testnamespace).containsKey("org.apache.accumulo.examples.simple.constraints.MaxMutationSize"));
    }

    @Test
    public void classLoad() throws TException {
        Assert.assertTrue((boolean)tpc.proxy().testNamespaceClassLoad(userpass, testnamespace, "org.apache.accumulo.core.iterators.user.VersioningIterator", "org.apache.accumulo.core.iterators.SortedKeyValueIterator"));
        Assert.assertFalse((boolean)tpc.proxy().testNamespaceClassLoad(userpass, testnamespace, "org.apache.accumulo.core.iterators.user.VersioningIterator", "dummy"));
    }
}

