/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.accumulo.cluster.ClusterControl;
import org.apache.accumulo.cluster.standalone.StandaloneAccumuloCluster;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.rfile.PrintInfo;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.MonitorUtil;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.TestMultiTableIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.accumulo.test.categories.StandaloneCapableClusterTests;
import org.apache.accumulo.test.categories.SunnyDayTests;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={StandaloneCapableClusterTests.class, SunnyDayTests.class})
public class ReadWriteIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(ReadWriteIT.class);
    static final int ROWS = 100000;
    static final int COLS = 1;
    static final String COLF = "colf";

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 360;
    }

    @Test(expected=RuntimeException.class)
    public void invalidInstanceName() throws Exception {
        Connector conn = this.getConnector();
        new ZooKeeperInstance("fake_instance_name", conn.getInstance().getZooKeepers());
    }

    @Test
    public void sunnyDay() throws Exception {
        byte[] masterLockData;
        log.debug("Starting Monitor");
        cluster.getClusterControl().startAllServers(ServerType.MONITOR);
        Connector connector = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        ReadWriteIT.ingest(connector, ReadWriteIT.getCluster().getClientConfig(), ReadWriteIT.getAdminPrincipal(), 100000, 1, 50, 0, tableName);
        ReadWriteIT.verify(connector, ReadWriteIT.getCluster().getClientConfig(), ReadWriteIT.getAdminPrincipal(), 100000, 1, 50, 0, tableName);
        String monitorLocation = null;
        while (null == monitorLocation) {
            monitorLocation = MonitorUtil.getLocation((Instance)this.getConnector().getInstance());
            if (null != monitorLocation) continue;
            log.debug("Could not fetch monitor HTTP address from zookeeper");
            Thread.sleep(2000L);
        }
        String scheme = "http://";
        if (ReadWriteIT.getCluster() instanceof StandaloneAccumuloCluster) {
            StandaloneAccumuloCluster standaloneCluster = (StandaloneAccumuloCluster)ReadWriteIT.getCluster();
            File accumuloSite = new File(standaloneCluster.getServerAccumuloConfDir(), "accumulo-site.xml");
            if (accumuloSite.isFile()) {
                Configuration conf = new Configuration(false);
                conf.addResource(new Path(accumuloSite.toURI()));
                String monitorSslKeystore = conf.get(Property.MONITOR_SSL_KEYSTORE.getKey());
                if (null != monitorSslKeystore) {
                    log.info("Setting scheme to HTTPS since monitor ssl keystore configuration was observed in {}", (Object)accumuloSite);
                    scheme = "https://";
                    SSLContext ctx = SSLContext.getInstance("SSL");
                    TrustManager[] tm = new TrustManager[]{new TestTrustManager()};
                    ctx.init(new KeyManager[0], tm, new SecureRandom());
                    SSLContext.setDefault(ctx);
                    HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
                    HttpsURLConnection.setDefaultHostnameVerifier(new TestHostnameVerifier());
                }
            } else {
                log.info("{} is not a normal file, not checking for monitor running with SSL", (Object)accumuloSite);
            }
        }
        URL url = new URL(scheme + monitorLocation);
        log.debug("Fetching web page " + url);
        String result = FunctionalTestUtils.readAll(url.openStream());
        Assert.assertTrue((result.length() > 100 ? 1 : 0) != 0);
        log.debug("Stopping accumulo cluster");
        ClusterControl control = cluster.getClusterControl();
        control.adminStopAll();
        ZooReader zreader = new ZooReader(connector.getInstance().getZooKeepers(), connector.getInstance().getZooKeepersSessionTimeOut());
        ZooCache zcache = new ZooCache(zreader, null);
        do {
            if (null == (masterLockData = ZooLock.getLockData((ZooCache)zcache, (String)(ZooUtil.getRoot((Instance)connector.getInstance()) + "/masters/lock"), null))) continue;
            log.info("Master lock is still held");
            Thread.sleep(1000L);
        } while (null != masterLockData);
        control.stopAllServers(ServerType.GARBAGE_COLLECTOR);
        control.stopAllServers(ServerType.MONITOR);
        control.stopAllServers(ServerType.TRACER);
        log.debug("success!");
        cluster.start();
    }

    public static void ingest(Connector connector, ClientConfiguration clientConfig, String principal, int rows, int cols, int width, int offset, String tableName) throws Exception {
        ReadWriteIT.ingest(connector, clientConfig, principal, rows, cols, width, offset, COLF, tableName);
    }

    public static void ingest(Connector connector, ClientConfiguration clientConfig, String principal, int rows, int cols, int width, int offset, String colf, String tableName) throws Exception {
        TestIngest.Opts opts = new TestIngest.Opts();
        opts.rows = rows;
        opts.cols = cols;
        opts.dataSize = width;
        opts.startRow = offset;
        opts.columnFamily = colf;
        opts.createTable = true;
        opts.setTableName(tableName);
        if (clientConfig.hasSasl()) {
            opts.updateKerberosCredentials(clientConfig);
        } else {
            opts.setPrincipal(principal);
        }
        TestIngest.ingest(connector, opts, new BatchWriterOpts());
    }

    public static void verify(Connector connector, ClientConfiguration clientConfig, String principal, int rows, int cols, int width, int offset, String tableName) throws Exception {
        ReadWriteIT.verify(connector, clientConfig, principal, rows, cols, width, offset, COLF, tableName);
    }

    private static void verify(Connector connector, ClientConfiguration clientConfig, String principal, int rows, int cols, int width, int offset, String colf, String tableName) throws Exception {
        ScannerOpts scannerOpts = new ScannerOpts();
        VerifyIngest.Opts opts = new VerifyIngest.Opts();
        opts.rows = rows;
        opts.cols = cols;
        opts.dataSize = width;
        opts.startRow = offset;
        opts.columnFamily = colf;
        opts.setTableName(tableName);
        if (clientConfig.hasSasl()) {
            opts.updateKerberosCredentials(clientConfig);
        } else {
            opts.setPrincipal(principal);
        }
        VerifyIngest.verifyIngest(connector, opts, scannerOpts);
    }

    public static String[] args(String ... args) {
        return args;
    }

    @Test
    public void multiTableTest() throws Exception {
        final String instance = cluster.getInstanceName();
        final String keepers = cluster.getZooKeepers();
        final ClusterControl control = cluster.getClusterControl();
        final String prefix = this.getClass().getSimpleName() + "_" + this.testName.getMethodName();
        ExecutorService svc = Executors.newFixedThreadPool(2);
        Future<Integer> p1 = svc.submit(new Callable<Integer>(){

            @Override
            public Integer call() {
                try {
                    ClientConfiguration clientConf = cluster.getClientConfig();
                    if (clientConf.hasSasl()) {
                        String principal = AccumuloClusterHarness.getAdminPrincipal();
                        AuthenticationToken token = AccumuloClusterHarness.getAdminToken();
                        Assert.assertTrue((String)("Expected KerberosToken, but was " + token.getClass()), (boolean)(token instanceof KerberosToken));
                        KerberosToken kt = (KerberosToken)token;
                        Assert.assertNotNull((String)"Expected keytab in token", (Object)kt.getKeytab());
                        return control.exec(TestMultiTableIngest.class, ReadWriteIT.args("--count", Integer.toString(100000), "-i", instance, "-z", keepers, "--tablePrefix", prefix, "--keytab", kt.getKeytab().getAbsolutePath(), "-u", principal));
                    }
                    return control.exec(TestMultiTableIngest.class, ReadWriteIT.args("--count", Integer.toString(100000), "-u", AccumuloClusterHarness.getAdminPrincipal(), "-i", instance, "-z", keepers, "-p", new String(((PasswordToken)AccumuloClusterHarness.getAdminToken()).getPassword(), StandardCharsets.UTF_8), "--tablePrefix", prefix));
                }
                catch (IOException e) {
                    log.error("Error running MultiTableIngest", (Throwable)e);
                    return -1;
                }
            }
        });
        Future<Integer> p2 = svc.submit(new Callable<Integer>(){

            @Override
            public Integer call() {
                try {
                    ClientConfiguration clientConf = cluster.getClientConfig();
                    if (clientConf.hasSasl()) {
                        String principal = AccumuloClusterHarness.getAdminPrincipal();
                        AuthenticationToken token = AccumuloClusterHarness.getAdminToken();
                        Assert.assertTrue((String)("Expected KerberosToken, but was " + token.getClass()), (boolean)(token instanceof KerberosToken));
                        KerberosToken kt = (KerberosToken)token;
                        Assert.assertNotNull((String)"Expected keytab in token", (Object)kt.getKeytab());
                        return control.exec(TestMultiTableIngest.class, ReadWriteIT.args("--count", Integer.toString(100000), "--readonly", "-i", instance, "-z", keepers, "--tablePrefix", prefix, "--keytab", kt.getKeytab().getAbsolutePath(), "-u", principal));
                    }
                    return control.exec(TestMultiTableIngest.class, ReadWriteIT.args("--count", Integer.toString(100000), "--readonly", "-u", AccumuloClusterHarness.getAdminPrincipal(), "-i", instance, "-z", keepers, "-p", new String(((PasswordToken)AccumuloClusterHarness.getAdminToken()).getPassword(), StandardCharsets.UTF_8), "--tablePrefix", prefix));
                }
                catch (IOException e) {
                    log.error("Error running MultiTableIngest", (Throwable)e);
                    return -1;
                }
            }
        });
        svc.shutdown();
        while (!svc.isTerminated()) {
            svc.awaitTermination(15L, TimeUnit.SECONDS);
        }
        Assert.assertEquals((long)0L, (long)p1.get().intValue());
        Assert.assertEquals((long)0L, (long)p2.get().intValue());
    }

    @Test
    public void largeTest() throws Exception {
        Connector connector = this.getConnector();
        String table = this.getUniqueNames(1)[0];
        ReadWriteIT.ingest(connector, ReadWriteIT.getCluster().getClientConfig(), ReadWriteIT.getAdminPrincipal(), 2, 1, 500000, 0, table);
        ReadWriteIT.verify(connector, ReadWriteIT.getCluster().getClientConfig(), ReadWriteIT.getAdminPrincipal(), 2, 1, 500000, 0, table);
    }

    @Test
    public void interleaved() throws Exception {
        Connector connector = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        ReadWriteIT.interleaveTest(connector, tableName);
    }

    static void interleaveTest(final Connector connector, final String tableName) throws Exception {
        int i;
        final AtomicBoolean fail = new AtomicBoolean(false);
        int CHUNKSIZE = 10000;
        ReadWriteIT.ingest(connector, ReadWriteIT.getCluster().getClientConfig(), ReadWriteIT.getAdminPrincipal(), 10000, 1, 50, 0, tableName);
        for (i = 0; i < 100000; i += 10000) {
            final int start = i;
            Thread verify = new Thread(){

                @Override
                public void run() {
                    try {
                        ReadWriteIT.verify(connector, AccumuloClusterHarness.getCluster().getClientConfig(), AccumuloClusterHarness.getAdminPrincipal(), 10000, 1, 50, start, tableName);
                    }
                    catch (Exception ex) {
                        fail.set(true);
                    }
                }
            };
            verify.start();
            ReadWriteIT.ingest(connector, ReadWriteIT.getCluster().getClientConfig(), ReadWriteIT.getAdminPrincipal(), 10000, 1, 50, i + 10000, tableName);
            verify.join();
            Assert.assertFalse((boolean)fail.get());
        }
        ReadWriteIT.verify(connector, ReadWriteIT.getCluster().getClientConfig(), ReadWriteIT.getAdminPrincipal(), 10000, 1, 50, i, tableName);
    }

    public static Text t(String s) {
        return new Text(s);
    }

    public static Mutation m(String row, String cf, String cq, String value) {
        Mutation m = new Mutation(ReadWriteIT.t(row));
        m.put(ReadWriteIT.t(cf), ReadWriteIT.t(cq), new Value(value.getBytes()));
        return m;
    }

    @Test
    public void localityGroupPerf() throws Exception {
        Connector connector = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        connector.tableOperations().create(tableName);
        connector.tableOperations().setProperty(tableName, "table.group.g1", COLF);
        connector.tableOperations().setProperty(tableName, "table.groups.enabled", "g1");
        ReadWriteIT.ingest(connector, ReadWriteIT.getCluster().getClientConfig(), ReadWriteIT.getAdminPrincipal(), 2000, 1, 50, 0, tableName);
        connector.tableOperations().compact(tableName, null, null, true, true);
        BatchWriter bw = connector.createBatchWriter(tableName, new BatchWriterConfig());
        bw.addMutation(ReadWriteIT.m("zzzzzzzzzzz", "colf2", "cq", "value"));
        bw.close();
        long now = System.currentTimeMillis();
        Scanner scanner = connector.createScanner(tableName, Authorizations.EMPTY);
        scanner.fetchColumnFamily(new Text(COLF));
        Iterators.size((Iterator)scanner.iterator());
        long diff = System.currentTimeMillis() - now;
        now = System.currentTimeMillis();
        scanner = connector.createScanner(tableName, Authorizations.EMPTY);
        scanner.fetchColumnFamily(new Text("colf2"));
        Iterators.size((Iterator)scanner.iterator());
        bw.close();
        long diff2 = System.currentTimeMillis() - now;
        Assert.assertTrue((diff2 < diff ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sunnyLG() throws Exception {
        Connector connector = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        connector.tableOperations().create(tableName);
        TreeMap<String, Set<Text>> groups = new TreeMap<String, Set<Text>>();
        groups.put("g1", Collections.singleton(ReadWriteIT.t(COLF)));
        connector.tableOperations().setLocalityGroups(tableName, groups);
        ReadWriteIT.ingest(connector, ReadWriteIT.getCluster().getClientConfig(), ReadWriteIT.getAdminPrincipal(), 2000, 1, 50, 0, tableName);
        ReadWriteIT.verify(connector, ReadWriteIT.getCluster().getClientConfig(), ReadWriteIT.getAdminPrincipal(), 2000, 1, 50, 0, tableName);
        connector.tableOperations().flush(tableName, null, null, true);
        try (BatchScanner bscanner = connector.createBatchScanner("accumulo.metadata", Authorizations.EMPTY, 1);){
            String tableId = (String)connector.tableOperations().tableIdMap().get(tableName);
            bscanner.setRanges(Collections.singletonList(new Range(new Text(tableId + ";"), new Text(tableId + "<"))));
            bscanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            boolean foundFile = false;
            for (Map.Entry entry : bscanner) {
                foundFile = true;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream newOut = new PrintStream(baos);
                PrintStream oldOut = System.out;
                try {
                    System.setOut(newOut);
                    ArrayList<String> args = new ArrayList<String>();
                    args.add(((Key)entry.getKey()).getColumnQualifier().toString());
                    if (AccumuloClusterHarness.ClusterType.STANDALONE == ReadWriteIT.getClusterType() && cluster.getClientConfig().hasSasl()) {
                        args.add("--config");
                        StandaloneAccumuloCluster sac = (StandaloneAccumuloCluster)cluster;
                        String hadoopConfDir = sac.getHadoopConfDir();
                        args.add(new Path(hadoopConfDir, "core-site.xml").toString());
                        args.add(new Path(hadoopConfDir, "hdfs-site.xml").toString());
                    }
                    log.info("Invoking PrintInfo with " + args);
                    PrintInfo.main((String[])args.toArray(new String[args.size()]));
                    newOut.flush();
                    String stdout = baos.toString();
                    Assert.assertTrue((boolean)stdout.contains("Locality group           : g1"));
                    Assert.assertTrue((boolean)stdout.contains("families        : [colf]"));
                }
                finally {
                    newOut.close();
                    System.setOut(oldOut);
                }
            }
            Assert.assertTrue((boolean)foundFile);
        }
    }

    @Test
    public void localityGroupChange() throws Exception {
        Connector connector = this.getConnector();
        String table = this.getUniqueNames(1)[0];
        TableOperations to = connector.tableOperations();
        to.create(table);
        String[] config = new String[]{"lg1:colf", null, "lg1:colf,xyz", "lg1:colf,xyz;lg2:c1,c2"};
        int i = 0;
        for (String cfg : config) {
            to.setLocalityGroups(table, this.getGroups(cfg));
            ReadWriteIT.ingest(connector, ReadWriteIT.getCluster().getClientConfig(), ReadWriteIT.getAdminPrincipal(), 100000 * (i + 1), 1, 50, 100000 * i, table);
            to.flush(table, null, null, true);
            ReadWriteIT.verify(connector, ReadWriteIT.getCluster().getClientConfig(), ReadWriteIT.getAdminPrincipal(), 0, 1, 50, 100000 * (i + 1), table);
            ++i;
        }
        to.delete(table);
        to.create(table);
        config = new String[]{"lg1:colf", null, "lg1:colf,xyz", "lg1:colf;lg2:colf"};
        i = 1;
        for (String cfg : config) {
            ReadWriteIT.ingest(connector, ReadWriteIT.getCluster().getClientConfig(), ReadWriteIT.getAdminPrincipal(), 100000 * i, 1, 50, 0, table);
            ReadWriteIT.ingest(connector, ReadWriteIT.getCluster().getClientConfig(), ReadWriteIT.getAdminPrincipal(), 100000 * i, 1, 50, 0, "xyz", table);
            to.setLocalityGroups(table, this.getGroups(cfg));
            to.flush(table, null, null, true);
            ReadWriteIT.verify(connector, ReadWriteIT.getCluster().getClientConfig(), ReadWriteIT.getAdminPrincipal(), 100000 * i, 1, 50, 0, table);
            ReadWriteIT.verify(connector, ReadWriteIT.getCluster().getClientConfig(), ReadWriteIT.getAdminPrincipal(), 100000 * i, 1, 50, 0, "xyz", table);
            ++i;
        }
    }

    private Map<String, Set<Text>> getGroups(String cfg) {
        TreeMap<String, Set<Text>> groups = new TreeMap<String, Set<Text>>();
        if (cfg != null) {
            for (String group : cfg.split(";")) {
                String[] parts = group.split(":");
                HashSet<Text> cols = new HashSet<Text>();
                for (String col : parts[1].split(",")) {
                    cols.add(ReadWriteIT.t(col));
                }
                groups.put(parts[1], cols);
            }
        }
        return groups;
    }

    private static class TestHostnameVerifier
    implements HostnameVerifier {
        private TestHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class TestTrustManager
    implements X509TrustManager {
        private TestTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

