/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.continuous;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class ContinuousOpts {
    @Parameter(names={"--min"}, description="lowest random row number to use")
    long min = 0L;
    @Parameter(names={"--max"}, description="maximum random row number to use")
    long max = Long.MAX_VALUE;
    @Parameter(names={"--debugLog"}, description="file to write debugging output", converter=DebugConverter.class)
    String debugLog = null;
    @Parameter(names={"--num"}, description="the number of entries to ingest")
    long num = Long.MAX_VALUE;
    @Parameter(names={"--maxColF"}, description="maximum column family value to use", converter=ShortConverter.class)
    short maxColF = Short.MAX_VALUE;
    @Parameter(names={"--maxColQ"}, description="maximum column qualifier value to use", converter=ShortConverter.class)
    short maxColQ = Short.MAX_VALUE;
    @Parameter(names={"--addCheckSum"}, description="turn on checksums")
    boolean checksum = false;
    @Parameter(names={"--visibilities"}, description="read the visibilities to ingest with from a file")
    String visFile = null;

    public static class ShortConverter
    implements IStringConverter<Short> {
        public Short convert(String value) {
            return Short.valueOf(value);
        }
    }

    public static class DebugConverter
    implements IStringConverter<String> {
        public String convert(String debugLog) {
            Logger logger = Logger.getLogger((String)"org.apache.accumulo.core");
            logger.setLevel(Level.TRACE);
            logger.setAdditivity(false);
            try {
                logger.addAppender((Appender)new FileAppender((Layout)new PatternLayout("%d{dd HH:mm:ss,SSS} [%-8c{2}] %-5p: %m%n"), debugLog, true));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return debugLog;
        }
    }
}

