/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.minicluster.MemoryUnit;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class TotalQueuedIT
extends ConfigurableMacBase {
    int SMALL_QUEUE_SIZE = 100000;
    int LARGE_QUEUE_SIZE = this.SMALL_QUEUE_SIZE * 10;
    static final long N = 1000000L;

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
        cfg.setDefaultMemory(cfg.getDefaultMemory() * 2L, MemoryUnit.BYTE);
        cfg.useMiniDFS();
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Test
    public void test() throws Exception {
        Random random = new Random();
        Connector c = this.getConnector();
        c.instanceOperations().setProperty(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX.getKey(), "" + this.SMALL_QUEUE_SIZE);
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        c.tableOperations().setProperty(tableName, Property.TABLE_MAJC_RATIO.getKey(), "9999");
        c.tableOperations().setProperty(tableName, Property.TABLE_FILE_MAX.getKey(), "999");
        UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        byte[] row = new byte[250];
        BatchWriterConfig cfg = new BatchWriterConfig();
        cfg.setMaxWriteThreads(10);
        cfg.setMaxLatency(1L, TimeUnit.SECONDS);
        cfg.setMaxMemory(0x100000L);
        long realSyncs = this.getSyncs();
        BatchWriter bw = c.createBatchWriter(tableName, cfg);
        long now = System.currentTimeMillis();
        long bytesSent = 0L;
        int i = 0;
        while ((long)i < 1000000L) {
            random.nextBytes(row);
            Mutation m = new Mutation(row);
            m.put((CharSequence)"", (CharSequence)"", (CharSequence)"");
            bw.addMutation(m);
            bytesSent += m.estimatedMemoryUsed();
            ++i;
        }
        bw.close();
        long diff = System.currentTimeMillis() - now;
        double secs = (double)diff / 1000.0;
        double syncs = bytesSent / (long)this.SMALL_QUEUE_SIZE;
        double syncsPerSec = syncs / secs;
        System.out.println(String.format("Sent %d bytes in %f secs approximately %d syncs (%f syncs per sec)", bytesSent, secs, (long)syncs, syncsPerSec));
        long update = this.getSyncs();
        System.out.println("Syncs " + (update - realSyncs));
        realSyncs = update;
        c.instanceOperations().setProperty(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX.getKey(), "" + this.LARGE_QUEUE_SIZE);
        c.tableOperations().flush(tableName, null, null, true);
        UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        bw = c.createBatchWriter(tableName, cfg);
        now = System.currentTimeMillis();
        bytesSent = 0L;
        int i2 = 0;
        while ((long)i2 < 1000000L) {
            random.nextBytes(row);
            Mutation m = new Mutation(row);
            m.put((CharSequence)"", (CharSequence)"", (CharSequence)"");
            bw.addMutation(m);
            bytesSent += m.estimatedMemoryUsed();
            ++i2;
        }
        bw.close();
        diff = System.currentTimeMillis() - now;
        secs = (double)diff / 1000.0;
        syncs = bytesSent / (long)this.LARGE_QUEUE_SIZE;
        syncsPerSec = syncs / secs;
        System.out.println(String.format("Sent %d bytes in %f secs approximately %d syncs (%f syncs per sec)", bytesSent, secs, (long)syncs, syncsPerSec));
        update = this.getSyncs();
        System.out.println("Syncs " + (update - realSyncs));
        Assert.assertTrue((update - realSyncs < realSyncs ? 1 : 0) != 0);
    }

    private long getSyncs() throws Exception {
        Connector c = this.getConnector();
        ServerConfigurationFactory confFactory = new ServerConfigurationFactory(c.getInstance());
        AccumuloServerContext context = new AccumuloServerContext(confFactory);
        Iterator iterator = c.instanceOperations().getTabletServers().iterator();
        if (iterator.hasNext()) {
            String address = (String)iterator.next();
            TabletClientService.Client client = ThriftUtil.getTServerClient((HostAndPort)HostAndPort.fromString((String)address), (ClientContext)context);
            TabletServerStatus status = client.getTabletServerStatus(null, context.rpcCreds());
            return status.syncs;
        }
        return 0L;
    }
}

