/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import jline.console.ConsoleReader;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.sample.RowSampler;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.format.Formatter;
import org.apache.accumulo.core.util.format.FormatterConfig;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.MiniClusterConfigurationCallback;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.test.TestCompactionStrategy;
import org.apache.accumulo.test.categories.MiniClusterOnlyTests;
import org.apache.accumulo.test.categories.SunnyDayTests;
import org.apache.accumulo.test.functional.SlowIterator;
import org.apache.accumulo.tracer.TraceServer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.tools.DistCp;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiniClusterOnlyTests.class, SunnyDayTests.class})
public class ShellServerIT
extends SharedMiniClusterBase {
    private static final Logger log = LoggerFactory.getLogger(ShellServerIT.class);
    private static final NoOpErrorMessageCallback noop = new NoOpErrorMessageCallback();
    private TestShell ts;
    private static Process traceProcess;
    private static String rootPath;
    @Rule
    public TestName name = new TestName();
    private static final String FAKE_CONTEXT = "FAKE";
    private static final String FAKE_CONTEXT_CLASSPATH;
    private static final String REAL_CONTEXT = "REAL";
    private static final String REAL_CONTEXT_CLASSPATH;
    private static final String VALUE_REVERSING_ITERATOR = "org.apache.accumulo.test.functional.ValueReversingIterator";
    private static final String SUMMING_COMBINER_ITERATOR = "org.apache.accumulo.core.iterators.user.SummingCombiner";
    private static final String COLUMN_FAMILY_COUNTER_ITERATOR = "org.apache.accumulo.core.iterators.ColumnFamilyCounter";

    @BeforeClass
    public static void setupMiniCluster() throws Exception {
        SharedMiniClusterBase.startMiniClusterWithConfig(new ShellServerITConfigCallback());
        rootPath = ShellServerIT.getMiniClusterDir().getAbsolutePath();
        System.setProperty("HOME", rootPath);
        System.setProperty("hadoop.tmp.dir", System.getProperty("user.dir") + "/target/hadoop-tmp");
        traceProcess = ShellServerIT.getCluster().exec(TraceServer.class, new String[0]);
        Connector conn = ShellServerIT.getCluster().getConnector(ShellServerIT.getPrincipal(), ShellServerIT.getToken());
        TableOperations tops = conn.tableOperations();
        while (!tops.exists("trace")) {
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    @Before
    public void setupShell() throws Exception {
        this.ts = new TestShell(ShellServerIT.getPrincipal(), ShellServerIT.getRootPassword(), ShellServerIT.getCluster().getConfig().getInstanceName(), ShellServerIT.getCluster().getConfig().getZooKeepers(), ShellServerIT.getCluster().getConfig().getClientConfFile());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (null != traceProcess) {
            traceProcess.destroy();
        }
        SharedMiniClusterBase.stopMiniCluster();
    }

    @After
    public void deleteTables() throws Exception {
        Connector c = ShellServerIT.getConnector();
        for (String table : c.tableOperations().list()) {
            if (table.startsWith("accumulo.") || table.equals("trace")) continue;
            try {
                c.tableOperations().delete(table);
            }
            catch (TableNotFoundException tableNotFoundException) {}
        }
    }

    @After
    public void tearDownShell() {
        this.ts.shell.shutdown();
    }

    @Override
    public int defaultTimeoutSeconds() {
        return 180;
    }

    @Test
    public void exporttableImporttable() throws Exception {
        String table = this.name.getMethodName();
        String table2 = table + "2";
        this.ts.exec("createtable " + table + " -evc", true);
        this.make10();
        this.ts.exec("addsplits row5", true);
        this.ts.exec("config -t " + table + " -s table.split.threshold=345M", true);
        this.ts.exec("offline " + table, true);
        File exportDir = new File(rootPath, "ShellServerIT.export");
        String exportUri = "file://" + exportDir.toString();
        String localTmp = "file://" + new File(rootPath, "ShellServerIT.tmp").toString();
        this.ts.exec("exporttable -t " + table + " " + exportUri, true);
        DistCp cp = this.newDistCp(new Configuration(false));
        String import_ = "file://" + new File(rootPath, "ShellServerIT.import").toString();
        if (ShellServerIT.getCluster().getClientConfig().hasSasl()) {
            FileSystem fs = ShellServerIT.getCluster().getFileSystem();
            LocalFileSystem localFs = FileSystem.getLocal((Configuration)new Configuration(false));
            Path localTmpPath = new Path(localTmp);
            localFs.mkdirs(localTmpPath);
            Path importDir = new Path(import_);
            fs.mkdirs(importDir);
            try (BufferedReader reader = new BufferedReader(new FileReader(new File(exportDir, "distcp.txt")));){
                String line;
                while ((line = reader.readLine()) != null) {
                    Path exportedFile = new Path(line);
                    log.info("Copying " + line + " to " + localTmpPath);
                    fs.copyToLocalFile(exportedFile, localTmpPath);
                    Path tmpFile = new Path(localTmpPath, exportedFile.getName());
                    log.info("Moving " + tmpFile + " to the import directory " + importDir);
                    fs.moveFromLocalFile(tmpFile, importDir);
                }
            }
        } else {
            Object[] distCpArgs = new String[]{"-f", exportUri + "/distcp.txt", import_};
            Assert.assertEquals((String)("Failed to run distcp: " + Arrays.toString(distCpArgs)), (long)0L, (long)cp.run((String[])distCpArgs));
        }
        this.ts.exec("importtable " + table2 + " " + import_, true);
        this.ts.exec("config -t " + table2 + " -np", true, "345M", true);
        this.ts.exec("getsplits -t " + table2, true, "row5", true);
        this.ts.exec("constraint --list -t " + table2, true, "VisibilityConstraint=2", true);
        this.ts.exec("online " + table, true);
        this.ts.exec("deletetable -f " + table, true);
        this.ts.exec("deletetable -f " + table2, true);
    }

    private DistCp newDistCp(Configuration conf) {
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = DistCp.class.getConstructors()) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length <= 0 || !parameterTypes[0].equals(Configuration.class)) continue;
                if (parameterTypes.length == 1) {
                    return (DistCp)constructor.newInstance(conf);
                }
                if (parameterTypes.length != 2) continue;
                return (DistCp)constructor.newInstance(conf, null);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("Unexpected constructors for DistCp");
    }

    @Test
    public void setscaniterDeletescaniter() throws Exception {
        String table = this.name.getMethodName();
        this.ts.exec("createtable " + table);
        this.ts.exec("insert a cf cq 1");
        this.ts.exec("insert a cf cq 1");
        this.ts.exec("insert a cf cq 1");
        this.ts.input.set("true\n\n\n\nSTRING");
        this.ts.exec("setscaniter -class org.apache.accumulo.core.iterators.user.SummingCombiner -p 10 -n name", true);
        this.ts.exec("scan", true, "3", true);
        this.ts.exec("deletescaniter -n name", true);
        this.ts.exec("scan", true, "1", true);
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void execfile() throws Exception {
        File file = File.createTempFile("ShellServerIT.execfile", ".conf", new File(rootPath));
        PrintWriter writer = new PrintWriter(file.getAbsolutePath());
        writer.println("about");
        writer.close();
        this.ts.exec("execfile " + file.getAbsolutePath(), true, "1.10.3", true);
    }

    @Test
    public void egrep() throws Exception {
        String table = this.name.getMethodName();
        this.ts.exec("createtable " + table);
        this.make10();
        String lines = this.ts.exec("egrep row[123]", true);
        Assert.assertTrue((lines.split("\n").length - 1 == 3 ? 1 : 0) != 0);
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void du() throws Exception {
        String table = this.name.getMethodName();
        this.ts.exec("notable", true);
        this.ts.output.clear();
        this.ts.exec("du", true, "", true);
        this.ts.output.clear();
        this.ts.exec("createtable " + table);
        this.make10();
        this.ts.exec("flush -t " + table + " -w");
        this.ts.exec("du " + table, true, " [" + table + "]", true);
        this.ts.output.clear();
        this.ts.shell.execCommand("du -h", false, false);
        String o = this.ts.output.get();
        Assert.assertTrue((String)("Output did not match regex: '" + o + "'"), (boolean)o.matches(".*[1-9][0-9][0-9]\\s\\[" + table + "\\]\\n"));
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void debug() throws Exception {
        this.ts.exec("debug", true, "off", true);
        this.ts.exec("debug on", true);
        this.ts.exec("debug", true, "on", true);
        this.ts.exec("debug off", true);
        this.ts.exec("debug", true, "off", true);
        this.ts.exec("debug debug", false);
        this.ts.exec("debug debug debug", false);
    }

    @Test
    public void user() throws Exception {
        String table = this.name.getMethodName();
        boolean kerberosEnabled = ShellServerIT.getToken() instanceof KerberosToken;
        if (!kerberosEnabled) {
            this.ts.input.set("secret\nsecret\n");
        }
        this.ts.exec("createuser xyzzy", true);
        this.ts.exec("users", true, "xyzzy", true);
        String perms = this.ts.exec("userpermissions -u xyzzy", true);
        Assert.assertTrue((boolean)perms.contains("Table permissions (accumulo.metadata): Table.READ"));
        this.ts.exec("grant -u xyzzy -s System.CREATE_TABLE", true);
        perms = this.ts.exec("userpermissions -u xyzzy", true);
        Assert.assertTrue((boolean)perms.contains(""));
        this.ts.exec("grant -u " + ShellServerIT.getPrincipal() + " -t " + "accumulo.metadata" + " Table.WRITE", true);
        this.ts.exec("grant -u " + ShellServerIT.getPrincipal() + " -t " + "accumulo.metadata" + " Table.GOOFY", false);
        this.ts.exec("grant -u " + ShellServerIT.getPrincipal() + " -s foo", false);
        this.ts.exec("grant -u xyzzy -t accumulo.metadata foo", false);
        if (!kerberosEnabled) {
            this.ts.input.set("secret\nsecret\n");
            this.ts.exec("user xyzzy", true);
            this.ts.exec("createtable " + table, true, "xyzzy@", true);
            this.ts.exec("insert row1 cf cq 1", true);
            this.ts.exec("scan", true, "row1", true);
            this.ts.exec("droptable -f " + table, true);
            this.ts.input.set(ShellServerIT.getRootPassword() + "\n" + ShellServerIT.getRootPassword() + "\n");
            this.ts.exec("user root", true);
        }
        this.ts.exec("deleteuser " + ShellServerIT.getPrincipal(), false, "delete yourself", true);
        this.ts.exec("revoke -u xyzzy -s System.CREATE_TABLE", true);
        this.ts.exec("revoke -u xyzzy -s System.GOOFY", false);
        this.ts.exec("revoke -u xyzzy -s foo", false);
        this.ts.exec("revoke -u xyzzy -t accumulo.metadata Table.WRITE", true);
        this.ts.exec("revoke -u xyzzy -t accumulo.metadata Table.GOOFY", false);
        this.ts.exec("revoke -u xyzzy -t accumulo.metadata foo", false);
        this.ts.exec("deleteuser xyzzy", true, "deleteuser { xyzzy } (yes|no)?", true);
        this.ts.exec("deleteuser -f xyzzy", true);
        this.ts.exec("users", true, "xyzzy", false);
    }

    @Test
    public void durability() throws Exception {
        String table = this.name.getMethodName();
        this.ts.exec("createtable " + table);
        this.ts.exec("insert -d none a cf cq randomGunkaASDFWEAQRd");
        this.ts.exec("insert -d foo a cf cq2 2", false, "foo", true);
        this.ts.exec("scan -r a", true, "randomGunkaASDFWEAQRd", true);
        this.ts.exec("scan -r a", true, "foo", false);
    }

    @Test
    public void iter() throws Exception {
        String table = this.name.getMethodName();
        this.ts.exec("createtable " + table);
        this.ts.exec("insert a cf cq 1");
        this.ts.exec("insert a cf cq 1");
        this.ts.exec("insert a cf cq 1");
        this.ts.input.set("true\n\n\n\nSTRING\n");
        this.ts.exec("setshelliter -class org.apache.accumulo.core.iterators.user.SummingCombiner -p 10 -pn sum -n name", true);
        this.ts.exec("setshelliter -class org.apache.accumulo.core.iterators.user.SummingCombiner -p 11 -pn sum -n name", false);
        this.ts.exec("setshelliter -class org.apache.accumulo.core.iterators.user.SummingCombiner -p 10 -pn sum -n other", false);
        this.ts.input.set("true\n\n\n\nSTRING\n");
        this.ts.exec("setshelliter -class org.apache.accumulo.core.iterators.user.SummingCombiner -p 11 -pn sum -n xyzzy", true);
        this.ts.exec("scan -pn sum", true, "3", true);
        this.ts.exec("listshelliter", true, "Iterator name", true);
        this.ts.exec("listshelliter", true, "Iterator xyzzy", true);
        this.ts.exec("listshelliter", true, "Profile : sum", true);
        this.ts.exec("deleteshelliter -pn sum -n name", true);
        this.ts.exec("listshelliter", true, "Iterator name", false);
        this.ts.exec("listshelliter", true, "Iterator xyzzy", true);
        this.ts.exec("deleteshelliter -pn sum -a", true);
        this.ts.exec("listshelliter", true, "Iterator xyzzy", false);
        this.ts.exec("listshelliter", true, "Profile : sum", false);
        this.ts.exec("deletetable -f " + table);
        this.ts.exec("createtable " + table);
        this.ts.exec("insert a cf cq 1");
        this.ts.exec("insert a cf cq 1");
        this.ts.exec("insert a cf cq 1");
        this.ts.input.set("true\n\n\n\nSTRING\n");
        this.ts.exec("setiter -scan -class org.apache.accumulo.core.iterators.user.SummingCombiner -p 10 -n name", true);
        this.ts.exec("setiter -scan -class org.apache.accumulo.core.iterators.user.SummingCombiner -p 11 -n name", false);
        this.ts.exec("setiter -scan -class org.apache.accumulo.core.iterators.user.SummingCombiner -p 10 -n other", false);
        this.ts.input.set("true\n\n\n\nSTRING\n");
        this.ts.exec("setiter -scan -class org.apache.accumulo.core.iterators.user.SummingCombiner -p 11 -n xyzzy", true);
        this.ts.exec("scan", true, "3", true);
        this.ts.exec("listiter -scan", true, "Iterator name", true);
        this.ts.exec("listiter -scan", true, "Iterator xyzzy", true);
        this.ts.exec("listiter -minc", true, "Iterator name", false);
        this.ts.exec("listiter -minc", true, "Iterator xyzzy", false);
        this.ts.exec("deleteiter -scan -n name", true);
        this.ts.exec("listiter -scan", true, "Iterator name", false);
        this.ts.exec("listiter -scan", true, "Iterator xyzzy", true);
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void setIterOptionPrompt() throws Exception {
        Connector conn = ShellServerIT.getConnector();
        String tableName = this.name.getMethodName();
        this.ts.exec("createtable " + tableName);
        this.ts.input.set("\n\n");
        this.ts.exec("setiter -scan -class org.apache.accumulo.core.iterators.ColumnFamilyCounter -p 30", false);
        this.ts.exec("setiter -scan -class org.apache.accumulo.core.iterators.ColumnFamilyCounter -p 30 -name cfcounter", true);
        String expectedKey = "table.iterator.scan.cfcounter";
        String expectedValue = "30,org.apache.accumulo.core.iterators.ColumnFamilyCounter";
        TableOperations tops = conn.tableOperations();
        this.checkTableForProperty(tops, tableName, expectedKey, expectedValue);
        this.ts.exec("deletetable " + tableName, true);
        tableName = tableName + "1";
        this.ts.exec("createtable " + tableName, true);
        this.ts.input.set("customcfcounter\n\n");
        this.ts.exec("setiter -scan -class org.apache.accumulo.core.iterators.ColumnFamilyCounter -p 30", true);
        expectedKey = "table.iterator.scan.customcfcounter";
        expectedValue = "30,org.apache.accumulo.core.iterators.ColumnFamilyCounter";
        this.checkTableForProperty(tops, tableName, expectedKey, expectedValue);
        this.ts.exec("deletetable " + tableName, true);
        tableName = tableName + "1";
        this.ts.exec("createtable " + tableName, true);
        this.ts.input.set("customcfcounter\nname1 value1\nname2 value2\n\n");
        this.ts.exec("setiter -scan -class org.apache.accumulo.core.iterators.ColumnFamilyCounter -p 30", true);
        expectedKey = "table.iterator.scan.customcfcounter";
        expectedValue = "30,org.apache.accumulo.core.iterators.ColumnFamilyCounter";
        this.checkTableForProperty(tops, tableName, expectedKey, expectedValue);
        expectedKey = "table.iterator.scan.customcfcounter.opt.name1";
        expectedValue = "value1";
        this.checkTableForProperty(tops, tableName, expectedKey, expectedValue);
        expectedKey = "table.iterator.scan.customcfcounter.opt.name2";
        expectedValue = "value2";
        this.checkTableForProperty(tops, tableName, expectedKey, expectedValue);
        this.ts.exec("deletetable " + tableName, true);
        tableName = tableName + "1";
        this.ts.exec("createtable " + tableName, true);
        this.ts.input.set("\nname1 value1.1,value1.2,value1.3\nname2 value2\n\n");
        this.ts.exec("setiter -scan -class org.apache.accumulo.core.iterators.ColumnFamilyCounter -p 30 -name cfcounter", true);
        expectedKey = "table.iterator.scan.cfcounter";
        expectedValue = "30,org.apache.accumulo.core.iterators.ColumnFamilyCounter";
        this.checkTableForProperty(tops, tableName, expectedKey, expectedValue);
        expectedKey = "table.iterator.scan.cfcounter.opt.name1";
        expectedValue = "value1.1,value1.2,value1.3";
        this.checkTableForProperty(tops, tableName, expectedKey, expectedValue);
        expectedKey = "table.iterator.scan.cfcounter.opt.name2";
        expectedValue = "value2";
        this.checkTableForProperty(tops, tableName, expectedKey, expectedValue);
    }

    protected void checkTableForProperty(TableOperations tops, String tableName, String expectedKey, String expectedValue) throws Exception {
        for (int i = 0; i < 5; ++i) {
            for (Map.Entry entry : tops.getProperties(tableName)) {
                if (!expectedKey.equals(entry.getKey())) continue;
                Assert.assertEquals((Object)expectedValue, entry.getValue());
                return;
            }
            Thread.sleep(500L);
        }
        Assert.fail((String)("Failed to find expected property on " + tableName + ": " + expectedKey + "=" + expectedValue));
    }

    @Test
    public void notable() throws Exception {
        String table = this.name.getMethodName();
        this.ts.exec("createtable " + table, true);
        this.ts.exec("scan", true, " " + table + ">", true);
        Assert.assertTrue((boolean)this.ts.output.get().contains(" " + table + ">"));
        this.ts.exec("notable", true);
        this.ts.exec("scan", false, "Not in a table context.", true);
        Assert.assertFalse((boolean)this.ts.output.get().contains(" " + table + ">"));
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void sleep() throws Exception {
        long now = System.currentTimeMillis();
        this.ts.exec("sleep 0.2", true);
        long diff = System.currentTimeMillis() - now;
        Assert.assertTrue((String)("Diff was actually " + diff), (diff >= 200L ? 1 : 0) != 0);
        Assert.assertTrue((String)("Diff was actually " + diff), (diff < 600L ? 1 : 0) != 0);
    }

    @Test
    public void addauths() throws Exception {
        String table = this.name.getMethodName();
        this.ts.exec("createtable " + table + " -evc");
        boolean success = false;
        while (!success) {
            try {
                this.ts.exec("insert a b c d -l foo", false, "does not have authorization", true, new ErrorMessageCallback(){

                    @Override
                    public String getErrorMessage() {
                        try {
                            Connector c = SharedMiniClusterBase.getConnector();
                            return "Current auths for root are: " + c.securityOperations().getUserAuthorizations("root").toString();
                        }
                        catch (Exception e) {
                            return "Could not check authorizations";
                        }
                    }
                });
                success = true;
            }
            catch (AssertionError e) {
                Thread.sleep(500L);
            }
        }
        this.ts.exec("addauths -s foo,bar", true);
        boolean passed = false;
        while (!passed) {
            try {
                this.ts.exec("getauths", true, "foo", true);
                this.ts.exec("getauths", true, "bar", true);
                passed = true;
            }
            catch (AssertionError | Exception e) {
                UtilWaitThread.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
        Assert.assertTrue((String)"Could not successfully see updated authoriations", (boolean)passed);
        this.ts.exec("insert a b c d -l foo");
        this.ts.exec("scan", true, "[foo]");
        this.ts.exec("scan -s bar", true, "[foo]", false);
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void getAuths() throws Exception {
        Assume.assumeFalse((String)"test skipped for kerberos", (boolean)(ShellServerIT.getToken() instanceof KerberosToken));
        for (int i = 1; i <= 2; ++i) {
            String userName = this.name.getMethodName() + "user" + i;
            String password = "password" + i;
            String auths = "auth" + i + "A,auth" + i + "B";
            this.ts.exec("createuser " + userName, true);
            this.ts.exec(password, true);
            this.ts.exec("addauths -u " + userName + " -s " + auths, true);
        }
        this.ts.exec("getauths -u getAuthsuser1", true, "auth1A", true);
        this.ts.exec("getauths -u getAuthsuser1", true, "auth1B", true);
        this.ts.exec("getauths -u getAuthsuser2", true, "auth2A", true);
        this.ts.exec("getauths -u getAuthsuser2", true, "auth2B", true);
        this.ts.exec("grant -u getAuthsuser1 -s System.ALTER_USER", true);
        this.ts.exec("user getAuthsuser1", true);
        this.ts.exec("password1", true);
        this.ts.exec("getauths -u getAuthsuser1", true, "auth1A", true);
        this.ts.exec("getauths -u getAuthsuser1", true, "auth1B", true);
        this.ts.exec("getauths -u getAuthsuser2", true, "auth2A", true);
        this.ts.exec("getauths -u getAuthsuser2", true, "auth2B", true);
        this.ts.exec("user getAuthsuser2", true);
        this.ts.exec("password2", true);
        this.ts.exec("getauths -u getAuthsuser2", true, "auth2A", true);
        this.ts.exec("getauths -u getAuthsuser2", true, "auth2B", true);
        this.ts.exec("getauths -u getAuthsuser1", false, "PERMISSION_DENIED", true);
        this.ts.exec("getauths -u getAuthsuser1", false, "PERMISSION_DENIED", true);
    }

    @Test
    public void byeQuitExit() throws Exception {
        for (String cmd : "bye quit exit".split(" ")) {
            Assert.assertFalse((boolean)this.ts.shell.getExit());
            this.ts.exec(cmd);
            Assert.assertTrue((boolean)this.ts.shell.getExit());
            this.ts.shell.setExit(false);
        }
    }

    @Test
    public void classpath() throws Exception {
        this.ts.exec("classpath", true, "Level 2: Java Classloader (loads everything defined by java classpath)", true);
    }

    @Test
    public void clearCls() throws Exception {
        if (this.ts.shell.getReader().getTerminal().isAnsiSupported()) {
            this.ts.exec("cls", true, "[1;1H");
            this.ts.exec("clear", true, "[2J");
        } else {
            this.ts.exec("cls", false, "does not support");
            this.ts.exec("clear", false, "does not support");
        }
    }

    @Test
    public void clonetable() throws Exception {
        String table = this.name.getMethodName();
        String clone = table + "_clone";
        this.ts.exec("createtable " + table + " -evc");
        this.ts.exec("config -t " + table + " -s table.split.threshold=123M", true);
        this.ts.exec("addsplits -t " + table + " a b c", true);
        this.ts.exec("insert a b c value");
        this.ts.exec("scan", true, "value", true);
        this.ts.exec("clonetable " + table + " " + clone);
        this.ts.exec("table " + clone);
        this.ts.exec("scan", true, "value", true);
        this.ts.exec("constraint --list -t " + clone, true, "VisibilityConstraint=2", true);
        this.ts.exec("config -t " + clone + " -np", true, "123M", true);
        this.ts.exec("getsplits -t " + clone, true, "a\nb\nc\n");
        this.ts.exec("deletetable -f " + table);
        this.ts.exec("deletetable -f " + clone);
    }

    @Test
    public void clonetableOffline() throws Exception {
        String table = this.name.getMethodName();
        String clone = table + "_clone";
        this.ts.exec("createtable " + table + " -evc");
        this.ts.exec("config -t " + table + " -s table.split.threshold=123M", true);
        this.ts.exec("addsplits -t " + table + " a b c", true);
        this.ts.exec("insert a b c value");
        this.ts.exec("scan", true, "value", true);
        this.ts.exec("clonetable " + table + " " + clone + " -o");
        this.ts.exec("table " + clone);
        this.ts.exec("scan", false, "TableOfflineException", true);
        this.ts.exec("constraint --list -t " + clone, true, "VisibilityConstraint=2", true);
        this.ts.exec("config -t " + clone + " -np", true, "123M", true);
        this.ts.exec("getsplits -t " + clone, true, "a\nb\nc\n");
        this.ts.exec("deletetable -f " + table);
        this.ts.exec("deletetable -f " + clone);
    }

    @Test
    public void createTableWithProperties() throws Exception {
        String table = this.name.getMethodName();
        String testProp = "table.custom.description=description,table.custom.testProp=testProp," + Property.TABLE_SPLIT_THRESHOLD.getKey() + "=10K";
        this.ts.exec("createtable " + table + " -prop " + testProp, true);
        this.ts.exec("insert a b c value", true);
        this.ts.exec("scan", true, "value", true);
        Connector connector = ShellServerIT.getConnector();
        for (Map.Entry entry : connector.tableOperations().getProperties(table)) {
            if (((String)entry.getKey()).equals("table.custom.description")) {
                Assert.assertTrue((String)"Initial property was not set correctly", (boolean)((String)entry.getValue()).equals("description"));
            }
            if (((String)entry.getKey()).equals("table.custom.testProp")) {
                Assert.assertTrue((String)"Initial property was not set correctly", (boolean)((String)entry.getValue()).equals("testProp"));
            }
            if (!((String)entry.getKey()).equals(Property.TABLE_SPLIT_THRESHOLD.getKey())) continue;
            Assert.assertTrue((String)"Initial property was not set correctly", (boolean)((String)entry.getValue()).equals("10K"));
        }
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void testCompactions() throws Exception {
        String table = this.name.getMethodName();
        this.ts.exec("createtable " + table);
        String tableId = this.getTableId(table);
        this.ts.exec("insert a b c d");
        this.ts.exec("flush -w");
        this.ts.exec("insert x y z v");
        this.ts.exec("flush -w");
        int oldCount = this.countFiles(tableId);
        this.ts.exec("compact -t " + table + " -w");
        Assert.assertTrue((this.countFiles(tableId) < oldCount ? 1 : 0) != 0);
        this.ts.exec("addsplits -t " + table + " f");
        this.ts.exec("insert m 1 2 3");
        this.ts.exec("flush -w");
        this.ts.exec("insert n 1 2 v901");
        this.ts.exec("flush -w");
        List<String> oldFiles = this.getFiles(tableId);
        Assert.assertEquals((String)("Files that were found: " + oldFiles), (long)4L, (long)oldFiles.size());
        this.ts.exec("compact -b g -e z -w");
        Assert.assertEquals((long)2L, (long)this.countFiles(tableId));
        this.ts.exec("compact -w");
        Assert.assertEquals((long)2L, (long)this.countFiles(tableId));
        this.ts.exec("merge --all -t " + table);
        this.ts.exec("compact -w");
        Assert.assertEquals((long)1L, (long)this.countFiles(tableId));
        this.ts.exec("insert z 1 2 v900");
        this.ts.exec("compact -w -s " + TestCompactionStrategy.class.getName() + " -sc inputPrefix=F,dropPrefix=A");
        Assert.assertEquals((long)1L, (long)this.countFiles(tableId));
        this.ts.exec("scan", true, "v900", true);
        this.ts.exec("scan", true, "v901", false);
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void testCompactionSelection() throws Exception {
        String table = this.name.getMethodName();
        String clone = table + "_clone";
        this.ts.exec("createtable " + table);
        this.ts.exec("insert a b c d");
        this.ts.exec("flush -w");
        this.ts.exec("insert x y z v");
        this.ts.exec("flush -w");
        this.ts.exec("clonetable -s " + Property.TABLE_MAJC_RATIO.getKey() + "=10 " + table + " " + clone);
        this.ts.exec("table " + clone);
        this.ts.exec("insert m n l o");
        this.ts.exec("flush -w");
        String tableId = this.getTableId(table);
        String cloneId = this.getTableId(clone);
        Assert.assertEquals((long)3L, (long)this.countFiles(cloneId));
        this.ts.exec("compact -t " + clone + " -w --sf-epath .*tables/" + tableId + ".*");
        Assert.assertEquals((long)2L, (long)this.countFiles(cloneId));
        this.ts.exec("insert r s t u");
        this.ts.exec("flush -w");
        Assert.assertEquals((long)3L, (long)this.countFiles(cloneId));
        this.ts.exec("compact -t " + clone + " -w --sf-ename F.*");
        Assert.assertEquals((long)2L, (long)this.countFiles(cloneId));
        Random rand = new Random();
        StringBuilder sb = new StringBuilder("insert b v q ");
        for (int i = 0; i < 10000; ++i) {
            sb.append(97 + rand.nextInt(26));
        }
        this.ts.exec(sb.toString());
        this.ts.exec("flush -w");
        this.ts.exec(sb.toString());
        this.ts.exec("flush -w");
        Assert.assertEquals((long)4L, (long)this.countFiles(cloneId));
        this.ts.exec("compact -t " + clone + " -w --sf-lt-esize 1000");
        Assert.assertEquals((long)3L, (long)this.countFiles(cloneId));
        this.ts.exec("compact -t " + clone + " -w --sf-gt-esize 1K --min-files 3");
        Assert.assertEquals((long)3L, (long)this.countFiles(cloneId));
        this.ts.exec("compact -t " + clone + " -w --sf-gt-esize 1K --min-files 2");
        Assert.assertEquals((long)2L, (long)this.countFiles(cloneId));
        this.ts.exec("compact -t " + clone + " -w --min-files 3");
        Assert.assertEquals((long)2L, (long)this.countFiles(cloneId));
        this.ts.exec("compact -t " + clone + " -w --min-files 2");
        Assert.assertEquals((long)1L, (long)this.countFiles(cloneId));
        this.ts.exec(sb.toString());
        this.ts.exec("flush -w");
        this.ts.exec("insert m n l o");
        this.ts.exec("flush -w");
        this.ts.exec("insert m n l o");
        this.ts.exec("flush -w");
        Assert.assertEquals((long)4L, (long)this.countFiles(cloneId));
        this.ts.exec("compact -t " + clone + " -w --sf-ename F.* --sf-lt-esize 1K");
        Assert.assertEquals((long)3L, (long)this.countFiles(cloneId));
        String clone2 = table + "_clone_2";
        this.ts.exec("clonetable -s table.sampler.opt.hasher=murmur3_32,table.sampler.opt.modulus=7,table.sampler=" + RowSampler.class.getName() + " " + clone + " " + clone2);
        String clone2Id = this.getTableId(clone2);
        Assert.assertEquals((long)3L, (long)this.countFiles(clone2Id));
        this.ts.exec("table " + clone2);
        this.ts.exec("insert v n l o");
        this.ts.exec("flush -w");
        this.ts.exec("insert x n l o");
        this.ts.exec("flush -w");
        Assert.assertEquals((long)5L, (long)this.countFiles(clone2Id));
        this.ts.exec("compact -t " + clone2 + " -w --sf-no-sample");
        Assert.assertEquals((long)3L, (long)this.countFiles(clone2Id));
    }

    @Test
    public void testCompactionSelectionAndStrategy() throws Exception {
        String table = this.name.getMethodName();
        this.ts.exec("createtable " + table);
        this.ts.exec("compact -t " + table + " -w --sf-ename F.* -s " + TestCompactionStrategy.class.getName() + " -sc inputPrefix=F,dropPrefix=A", false);
    }

    @Test
    public void testScanScample() throws Exception {
        String table = this.name.getMethodName();
        this.ts.exec("createtable " + table);
        this.ts.exec("insert 9255 doc content 'abcde'");
        this.ts.exec("insert 9255 doc url file://foo.txt");
        this.ts.exec("insert 8934 doc content 'accumulo scales'");
        this.ts.exec("insert 8934 doc url file://accumulo_notes.txt");
        this.ts.exec("insert 2317 doc content 'milk, eggs, bread, parmigiano-reggiano'");
        this.ts.exec("insert 2317 doc url file://groceries/9.txt");
        this.ts.exec("insert 3900 doc content 'EC2 ate my homework'");
        this.ts.exec("insert 3900 doc uril file://final_project.txt");
        String clone1 = table + "_clone_1";
        this.ts.exec("clonetable -s table.sampler.opt.hasher=murmur3_32,table.sampler.opt.modulus=3,table.sampler=" + RowSampler.class.getName() + " " + table + " " + clone1);
        this.ts.exec("compact -t " + clone1 + " -w --sf-no-sample");
        this.ts.exec("table " + clone1);
        this.ts.exec("scan --sample", true, "parmigiano-reggiano", true);
        this.ts.exec("grep --sample reg", true, "parmigiano-reggiano", true);
        this.ts.exec("scan --sample", true, "accumulo", false);
        this.ts.exec("grep --sample acc", true, "accumulo", false);
        String clone2 = table + "_clone_2";
        this.ts.exec("clonetable -s table.sampler.opt.hasher=murmur3_32,table.sampler.opt.modulus=2,table.sampler=" + RowSampler.class.getName() + " " + clone1 + " " + clone2);
        this.ts.exec("table " + clone2);
        this.ts.exec("scan --sample", false, "SampleNotPresentException", true);
        this.ts.exec("grep --sample reg", false, "SampleNotPresentException", true);
        this.ts.exec("compact -t " + clone2 + " -w --sf-no-sample");
        for (String expected : Arrays.asList("2317", "3900", "9255")) {
            this.ts.exec("scan --sample", true, expected, true);
            this.ts.exec("grep --sample " + expected.substring(0, 2), true, expected, true);
        }
        this.ts.exec("scan --sample", true, "8934", false);
        this.ts.exec("grep --sample 89", true, "8934", false);
    }

    @Test
    public void constraint() throws Exception {
        String table = this.name.getMethodName();
        this.ts.exec("constraint -l -t accumulo.metadata", true, "MetadataConstraints=1", true);
        this.ts.exec("createtable " + table + " -evc");
        this.getTableId(table);
        this.ts.exec("constraint -l -t " + table, true, "VisibilityConstraint=2", true);
        this.ts.exec("constraint -t " + table + " -d 2", true, "Removed constraint 2 from table " + table);
        UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        this.ts.exec("constraint -l -t " + table, true, "VisibilityConstraint=2", false);
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void deletemany() throws Exception {
        String table = this.name.getMethodName();
        this.ts.exec("createtable " + table);
        this.make10();
        Assert.assertEquals((long)10L, (long)this.countkeys(table));
        this.ts.exec("deletemany -f -b row8");
        Assert.assertEquals((long)8L, (long)this.countkeys(table));
        this.ts.exec("scan -t " + table + " -np", true, "row8", false);
        this.make10();
        this.ts.exec("deletemany -f -b row4 -e row5");
        Assert.assertEquals((long)8L, (long)this.countkeys(table));
        this.make10();
        this.ts.exec("deletemany -f -c cf:col4,cf:col5");
        Assert.assertEquals((long)8L, (long)this.countkeys(table));
        this.make10();
        this.ts.exec("deletemany -f -r row3");
        Assert.assertEquals((long)9L, (long)this.countkeys(table));
        this.make10();
        this.ts.exec("deletemany -f -r row3");
        Assert.assertEquals((long)9L, (long)this.countkeys(table));
        this.make10();
        this.ts.exec("deletemany -f -b row3 -be -e row5 -ee");
        Assert.assertEquals((long)9L, (long)this.countkeys(table));
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void deleterows() throws Exception {
        String table = this.name.getMethodName();
        this.ts.exec("createtable " + table);
        String tableId = this.getTableId(table);
        int base = this.countFiles(tableId);
        Assert.assertEquals((long)0L, (long)base);
        log.info("Adding 2 splits");
        this.ts.exec("addsplits row5 row7");
        log.info("Writing 10 records");
        this.make10();
        log.info("Flushing table");
        this.ts.exec("flush -w -t " + table);
        log.info("Table flush completed");
        List<String> files = this.getFiles(tableId);
        if (3 < files.size()) {
            log.info("More than 3 files were found, compacting before proceeding");
            this.ts.exec("compact -w -t " + table);
            files = this.getFiles(tableId);
            Assert.assertEquals((String)("Expected to only find 3 files after compaction: " + files), (long)3L, (long)files.size());
        }
        Assert.assertNotNull(files);
        Assert.assertEquals((String)("Found the following files: " + files), (long)3L, (long)files.size());
        this.ts.exec("deleterows -t " + table + " -b row5 -e row7");
        Assert.assertEquals((long)2L, (long)this.countFiles(tableId));
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void groups() throws Exception {
        String table = this.name.getMethodName();
        this.ts.exec("createtable " + table);
        this.ts.exec("setgroups -t " + table + " alpha=a,b,c num=3,2,1");
        this.ts.exec("getgroups -t " + table, true, "alpha=a,b,c", true);
        this.ts.exec("getgroups -t " + table, true, "num=1,2,3", true);
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void formatter() throws Exception {
        this.ts.exec("createtable formatter_test", true);
        this.ts.exec("table formatter_test", true);
        this.ts.exec("insert row cf cq 1234abcd", true);
        this.ts.exec("insert row cf1 cq1 9876fedc", true);
        this.ts.exec("insert row2 cf cq 13579bdf", true);
        this.ts.exec("insert row2 cf1 cq 2468ace", true);
        ArrayList<String> expectedDefault = new ArrayList<String>(4);
        expectedDefault.add("row cf:cq []    1234abcd");
        expectedDefault.add("row cf1:cq1 []    9876fedc");
        expectedDefault.add("row2 cf:cq []    13579bdf");
        expectedDefault.add("row2 cf1:cq []    2468ace");
        ArrayList<String> actualDefault = new ArrayList<String>(4);
        boolean isFirst = true;
        for (String s : this.ts.exec("scan -np", true).split("[\n\r]+")) {
            if (isFirst) {
                isFirst = false;
                continue;
            }
            actualDefault.add(s);
        }
        ArrayList<String> expectedFormatted = new ArrayList<String>(4);
        expectedFormatted.add("row cf:cq []    0x31 0x32 0x33 0x34 0x61 0x62 0x63 0x64");
        expectedFormatted.add("row cf1:cq1 []    0x39 0x38 0x37 0x36 0x66 0x65 0x64 0x63");
        expectedFormatted.add("row2 cf:cq []    0x31 0x33 0x35 0x37 0x39 0x62 0x64 0x66");
        expectedFormatted.add("row2 cf1:cq []    0x32 0x34 0x36 0x38 0x61 0x63 0x65");
        this.ts.exec("formatter -t formatter_test -f " + HexFormatter.class.getName(), true);
        ArrayList<String> actualFormatted = new ArrayList<String>(4);
        isFirst = true;
        for (String s : this.ts.exec("scan -np", true).split("[\n\r]+")) {
            if (isFirst) {
                isFirst = false;
                continue;
            }
            actualFormatted.add(s);
        }
        this.ts.exec("deletetable -f formatter_test", true);
        Assert.assertTrue((boolean)Iterables.elementsEqual(expectedDefault, new ArrayList(actualDefault)));
        Assert.assertTrue((boolean)Iterables.elementsEqual(expectedFormatted, new ArrayList(actualFormatted)));
    }

    @Test
    public void extensions() throws Exception {
        String extName = "ExampleShellExtension";
        this.ts.exec("help", true, extName, false);
        this.ts.exec("extensions -l", true, extName, false);
        this.ts.exec("extensions -e", true);
        this.ts.exec("extensions -l", true, extName, true);
        this.ts.exec("help", true, extName, true);
        this.ts.exec(extName + "::debug", true, "This is a test", true);
        this.ts.exec("extensions -d", true);
        this.ts.exec("extensions -l", true, extName, false);
        this.ts.exec("help", true, extName, false);
        this.ts.exec(extName + "::debug", true, "Unknown command", true);
    }

    @Test
    public void grep() throws Exception {
        String table = this.name.getMethodName();
        this.ts.exec("createtable " + table, true);
        this.make10();
        this.ts.exec("grep row[123]", true, "row1", false);
        this.ts.exec("grep row5", true, "row5", true);
        this.ts.exec("deletetable -f " + table, true);
    }

    @Test
    public void help() throws Exception {
        this.ts.exec("help -np", true, "Help Commands", true);
        this.ts.exec("?", true, "Help Commands", true);
        for (String c : "bye exit quit about help info ? deleteiter deletescaniter listiter setiter setscaniter grant revoke systempermissions tablepermissions userpermissions execfile history authenticate cls clear notable sleep table user whoami clonetable config createtable deletetable droptable du exporttable importtable offline online renametable tables addsplits compact constraint flush getgropus getsplits merge setgroups addauths createuser deleteuser dropuser getauths passwd setauths users delete deletemany deleterows egrep formatter interpreter grep importdirectory insert maxrow scan".split(" ")) {
            this.ts.exec("help " + c, true);
        }
    }

    @Test
    public void history() throws Exception {
        String table = this.name.getMethodName();
        this.ts.exec("history -c", true);
        this.ts.exec("createtable " + table);
        this.ts.exec("deletetable -f " + table);
        this.ts.exec("history", true, table, true);
        this.ts.exec("history", true, "history", true);
    }

    @Test
    public void importDirectory() throws Exception {
        String table = this.name.getMethodName();
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        File importDir = new File(rootPath, "import");
        Assert.assertTrue((boolean)importDir.mkdir());
        String even = new File(importDir, "even.rf").toString();
        String odd = new File(importDir, "odd.rf").toString();
        File errorsDir = new File(rootPath, "errors");
        Assert.assertTrue((boolean)errorsDir.mkdir());
        fs.mkdirs(new Path(errorsDir.toString()));
        DefaultConfiguration aconf = AccumuloConfiguration.getDefaultConfiguration();
        FileSKVWriter evenWriter = ((FileOperations.OpenWriterOperationBuilder)FileOperations.getInstance().newWriterBuilder().forFile(even, fs, conf).withTableConfiguration((AccumuloConfiguration)aconf)).build();
        evenWriter.startDefaultLocalityGroup();
        FileSKVWriter oddWriter = ((FileOperations.OpenWriterOperationBuilder)FileOperations.getInstance().newWriterBuilder().forFile(odd, fs, conf).withTableConfiguration((AccumuloConfiguration)aconf)).build();
        oddWriter.startDefaultLocalityGroup();
        long timestamp = System.currentTimeMillis();
        Text cf = new Text("cf");
        Text cq = new Text("cq");
        Value value = new Value("value".getBytes());
        for (int i = 0; i < 100; i += 2) {
            Key key = new Key(new Text(String.format("%8d", i)), cf, cq, timestamp);
            evenWriter.append(key, value);
            key = new Key(new Text(String.format("%8d", i + 1)), cf, cq, timestamp);
            oddWriter.append(key, value);
        }
        evenWriter.close();
        oddWriter.close();
        Assert.assertEquals((long)0L, (long)this.ts.shell.getExitCode());
        this.ts.exec("createtable " + table, true);
        this.ts.exec("importdirectory " + importDir + " " + errorsDir + " true", true);
        this.ts.exec("scan -r 00000000", true, "00000000", true);
        this.ts.exec("scan -r 00000099", true, "00000099", true);
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void info() throws Exception {
        this.ts.exec("info", true, "1.10.3", true);
    }

    @Test
    public void interpreter() throws Exception {
        String table = this.name.getMethodName();
        this.ts.exec("createtable " + table, true);
        this.ts.exec("interpreter -l", true, "HexScan", false);
        this.ts.exec("insert \\x02 cf cq value", true);
        this.ts.exec("scan -b 02", true, "value", false);
        this.ts.exec("interpreter -i org.apache.accumulo.core.util.interpret.HexScanInterpreter", true);
        UtilWaitThread.sleepUninterruptibly((long)3L, (TimeUnit)TimeUnit.SECONDS);
        this.ts.exec("interpreter -l", true, "HexScan", true);
        this.ts.exec("scan -b 02", true, "value", true);
        this.ts.exec("deletetable -f " + table, true);
    }

    @Test
    public void listcompactions() throws Exception {
        String table = this.name.getMethodName();
        this.ts.exec("createtable " + table, true);
        this.ts.exec("config -t " + table + " -s table.iterator.minc.slow=30,org.apache.accumulo.test.functional.SlowIterator", true);
        this.ts.exec("config -t " + table + " -s table.iterator.minc.slow.opt.sleepTime=1000", true);
        this.ts.exec("insert a cf cq value", true);
        this.ts.exec("insert b cf cq value", true);
        this.ts.exec("insert c cf cq value", true);
        this.ts.exec("insert d cf cq value", true);
        this.ts.exec("flush -t " + table, true);
        this.ts.exec("sleep 0.2", true);
        this.ts.exec("listcompactions", true, "default_tablet");
        String[] lines = this.ts.output.get().split("\n");
        String last = lines[lines.length - 1];
        String[] parts = last.split("\\|");
        Assert.assertEquals((long)12L, (long)parts.length);
        this.ts.exec("deletetable -f " + table, true);
    }

    @Test
    public void maxrow() throws Exception {
        String table = this.name.getMethodName();
        this.ts.exec("createtable " + table, true);
        this.ts.exec("insert a cf cq value", true);
        this.ts.exec("insert b cf cq value", true);
        this.ts.exec("insert ccc cf cq value", true);
        this.ts.exec("insert zzz cf cq value", true);
        this.ts.exec("maxrow", true, "zzz", true);
        this.ts.exec("delete zzz cf cq", true);
        this.ts.exec("maxrow", true, "ccc", true);
        this.ts.exec("deletetable -f " + table, true);
    }

    @Test
    public void merge() throws Exception {
        String table = this.name.getMethodName();
        this.ts.exec("createtable " + table);
        this.ts.exec("addsplits a m z");
        this.ts.exec("getsplits", true, "z", true);
        this.ts.exec("merge --all", true);
        this.ts.exec("getsplits", true, "z", false);
        this.ts.exec("deletetable -f " + table);
        this.ts.exec("getsplits -t accumulo.metadata", true);
        Assert.assertEquals((long)2L, (long)this.ts.output.get().split("\n").length);
        this.ts.exec("getsplits -t accumulo.root", true);
        Assert.assertEquals((long)1L, (long)this.ts.output.get().split("\n").length);
        this.ts.exec("merge --all -t accumulo.metadata");
        this.ts.exec("getsplits -t accumulo.metadata", true);
        Assert.assertEquals((long)1L, (long)this.ts.output.get().split("\n").length);
    }

    @Test
    public void ping() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.ts.exec("ping", true, "OK", true);
            if (this.ts.output.get().split("\n").length == 3) break;
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        Assert.assertEquals((long)2L, (long)this.ts.output.get().split("\n").length);
    }

    @Test
    public void renametable() throws Exception {
        String table = this.name.getMethodName() + "1";
        String rename = this.name.getMethodName() + "2";
        this.ts.exec("createtable " + table);
        this.ts.exec("insert this is a value");
        this.ts.exec("renametable " + table + " " + rename);
        this.ts.exec("tables", true, rename, true);
        this.ts.exec("tables", true, table, false);
        this.ts.exec("scan -t " + rename, true, "value", true);
        this.ts.exec("deletetable -f " + rename, true);
    }

    @Test
    public void tables() throws Exception {
        String table = this.name.getMethodName();
        String table1 = table + "_z";
        String table2 = table + "_a";
        this.ts.exec("createtable " + table1);
        this.ts.exec("createtable " + table2);
        this.ts.exec("notable");
        String lst = this.ts.exec("tables -l");
        Assert.assertTrue((lst.indexOf(table2) < lst.indexOf(table1) ? 1 : 0) != 0);
        lst = this.ts.exec("tables -l -s");
        Assert.assertTrue((lst.indexOf(table1) < lst.indexOf(table2) ? 1 : 0) != 0);
    }

    @Test
    public void systempermission() throws Exception {
        this.ts.exec("systempermissions");
        Assert.assertEquals((long)12L, (long)(this.ts.output.get().split("\n").length - 1));
        this.ts.exec("tablepermissions", true);
        Assert.assertEquals((long)6L, (long)(this.ts.output.get().split("\n").length - 1));
    }

    @Test
    public void listscans() throws Exception {
        String table = this.name.getMethodName();
        this.ts.exec("createtable " + table, true);
        for (int i = 0; i < 6; ++i) {
            this.ts.exec("insert " + i + " cf cq value", true);
        }
        Connector connector = ShellServerIT.getConnector();
        final Scanner s = connector.createScanner(table, Authorizations.EMPTY);
        IteratorSetting cfg = new IteratorSetting(30, SlowIterator.class);
        SlowIterator.setSleepTime(cfg, 500L);
        s.addScanIterator(cfg);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Iterators.size((Iterator)s.iterator());
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        thread.start();
        ArrayList<String> scans = new ArrayList<String>();
        for (int i = 0; i < 50 && scans.isEmpty(); ++i) {
            String currentScans = this.ts.exec("listscans", true);
            log.info("Got output from listscans:\n" + currentScans);
            String[] lines = currentScans.split("\n");
            for (int scanOffset = 2; scanOffset < lines.length; ++scanOffset) {
                String currentScan = lines[scanOffset];
                if (currentScan.contains(table)) {
                    log.info("Retaining scan: " + currentScan);
                    scans.add(currentScan);
                    continue;
                }
                log.info("Ignoring scan because of wrong table: " + currentScan);
            }
            UtilWaitThread.sleepUninterruptibly((long)300L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        thread.join();
        Assert.assertFalse((String)("Could not find any active scans over table " + table), (boolean)scans.isEmpty());
        for (String scan : scans) {
            if (!scan.contains("RUNNING")) {
                log.info("Ignoring scan because it doesn't contain 'RUNNING': " + scan);
                continue;
            }
            Object[] parts = scan.split("\\|");
            Assert.assertEquals((String)("Expected 14 colums, but found " + parts.length + " instead for '" + Arrays.toString(parts) + "'"), (long)14L, (long)parts.length);
            String tserver = ((String)parts[0]).trim();
            String hostPortPattern = ".+:\\d+";
            Assert.assertTrue((boolean)tserver.matches(hostPortPattern));
            Assert.assertTrue((boolean)ShellServerIT.getConnector().instanceOperations().getTabletServers().contains(tserver));
            String client = ((String)parts[1]).trim();
            Assert.assertTrue((String)(client + " does not match " + hostPortPattern), (boolean)client.matches(hostPortPattern));
            Long.parseLong(((String)parts[11]).trim());
        }
        this.ts.exec("deletetable -f " + table, true);
    }

    @Test
    public void testPertableClasspath() throws Exception {
        String table = this.name.getMethodName();
        File fooFilterJar = File.createTempFile("FooFilter", ".jar", new File(rootPath));
        FileUtils.copyInputStreamToFile((InputStream)this.getClass().getResourceAsStream("/FooFilter.jar"), (File)fooFilterJar);
        fooFilterJar.deleteOnExit();
        File fooConstraintJar = File.createTempFile("FooConstraint", ".jar", new File(rootPath));
        FileUtils.copyInputStreamToFile((InputStream)this.getClass().getResourceAsStream("/FooConstraint.jar"), (File)fooConstraintJar);
        fooConstraintJar.deleteOnExit();
        this.ts.exec("config -s " + Property.VFS_CONTEXT_CLASSPATH_PROPERTY.getKey() + "cx1=" + fooFilterJar.toURI().toString() + "," + fooConstraintJar.toURI().toString(), true);
        this.ts.exec("createtable " + table, true);
        this.ts.exec("config -t " + table + " -s " + Property.TABLE_CLASSPATH.getKey() + "=cx1", true);
        UtilWaitThread.sleepUninterruptibly((long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.ts.exec("config -t " + table + " -s " + Property.TABLE_ITERATOR_PREFIX.getKey() + "scan.foo=10,org.apache.accumulo.test.FooFilter");
        this.ts.exec("insert foo f q v", true);
        UtilWaitThread.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.ts.exec("scan -np", true, "foo", false);
        this.ts.exec("constraint -a FooConstraint", true);
        this.ts.exec("offline -w " + table);
        this.ts.exec("online -w " + table);
        this.ts.exec("table " + table, true);
        this.ts.exec("insert foo f q v", false);
        this.ts.exec("insert ok foo q v", true);
        this.ts.exec("deletetable -f " + table, true);
        this.ts.exec("config -d " + Property.VFS_CONTEXT_CLASSPATH_PROPERTY.getKey() + "cx1");
    }

    @Test
    public void trace() throws Exception {
        String table = this.name.getMethodName() + "Test";
        this.ts.exec("trace on", true);
        this.ts.exec("createtable " + table, true);
        this.ts.exec("insert a b c value", true);
        this.ts.exec("scan -np", true, "value", true);
        this.ts.exec("deletetable -f " + table);
        this.ts.exec("sleep 1");
        String trace = this.ts.exec("trace off");
        System.out.println(trace);
        Assert.assertTrue((boolean)trace.contains("sendMutations"));
        Assert.assertTrue((boolean)trace.contains("startScan"));
        Assert.assertTrue((boolean)trace.contains("DeleteTable"));
    }

    @Test
    public void badLogin() throws Exception {
        Assume.assumeTrue((boolean)(ShellServerIT.getToken() instanceof PasswordToken));
        this.ts.input.set(ShellServerIT.getRootPassword() + "\n");
        String err = this.ts.exec("user NoSuchUser", false);
        Assert.assertTrue((boolean)err.contains("BAD_CREDENTIALS for user NoSuchUser"));
    }

    @Test
    public void namespaces() throws Exception {
        this.ts.exec("namespaces", true, "\"\"", true);
        this.ts.exec("namespaces", true, "accumulo", true);
        this.ts.exec("createnamespace thing1", true);
        String namespaces = this.ts.exec("namespaces");
        Assert.assertTrue((boolean)namespaces.contains("thing1"));
        this.ts.exec("renamenamespace thing1 thing2");
        namespaces = this.ts.exec("namespaces");
        Assert.assertTrue((boolean)namespaces.contains("thing2"));
        Assert.assertTrue((!namespaces.contains("thing1") ? 1 : 0) != 0);
        this.ts.exec("createtable thing2.thingy", true);
        this.ts.exec("deletenamespace thing2");
        this.ts.exec("y");
        this.ts.exec("namespaces", true, "thing2", true);
        this.ts.exec("du -ns thing2", true, "thing2.thingy", true);
        this.ts.exec("offline -ns thing2", true);
        this.ts.exec("online -ns thing2", true);
        this.ts.exec("flush -ns thing2", true);
        this.ts.exec("compact -ns thing2", true);
        this.ts.exec("createnamespace testers3", true);
        this.ts.exec("createtable testers3.1", true);
        this.ts.exec("createtable testers3.2", true);
        this.ts.exec("deletetable -ns testers3 -f", true);
        this.ts.exec("tables", true, "testers3.1", false);
        this.ts.exec("namespaces", true, "testers3", true);
        this.ts.exec("deletenamespace testers3 -f", true);
        this.ts.input.set("true\n\n\n\nSTRING\n");
        this.ts.exec("setiter -ns thing2 -scan -class org.apache.accumulo.core.iterators.user.SummingCombiner -p 10 -n name", true);
        this.ts.exec("listiter -ns thing2 -scan", true, "Summing", true);
        this.ts.exec("deleteiter -ns thing2 -n name -scan", true);
        this.ts.exec("createuser dude");
        this.ts.exec("pass");
        this.ts.exec("pass");
        this.ts.exec("grant Namespace.CREATE_TABLE -ns thing2 -u dude", true);
        this.ts.exec("revoke Namespace.CREATE_TABLE -ns thing2 -u dude", true);
        this.ts.exec("config -ns thing2 -s table.file.max=44444", true);
        this.ts.exec("config -ns thing2", true, "44444", true);
        this.ts.exec("config -t thing2.thingy", true, "44444", true);
        this.ts.exec("config -t thing2.thingy -s table.file.max=55555", true);
        this.ts.exec("config -t thing2.thingy", true, "55555", true);
        this.ts.exec("createnamespace thing3 -cc thing2", true);
        this.ts.exec("config -ns thing3", true, "44444", true);
        this.ts.exec("deletenamespace -f thing2", true);
        this.ts.exec("namespaces", true, "thing2", false);
        this.ts.exec("tables", true, "thing2.thingy", false);
        this.ts.exec("constraint -ns thing3 -a org.apache.accumulo.examples.simple.constraints.NumericValueConstraint", true);
        this.ts.exec("createtable thing3.constrained", true);
        this.ts.exec("table thing3.constrained", true);
        this.ts.exec("constraint -d 1");
        this.ts.exec("constraint -l", true, "NumericValueConstraint", true);
        this.ts.exec("insert r cf cq abc", false);
        this.ts.exec("constraint -ns thing3 -d 1");
        this.ts.exec("sleep 1");
        this.ts.exec("insert r cf cq abc", true);
    }

    private int countkeys(String table) throws IOException {
        this.ts.exec("scan -np -t " + table);
        return this.ts.output.get().split("\n").length - 1;
    }

    @Test
    public void scans() throws Exception {
        this.ts.exec("createtable t");
        this.make10();
        String result = this.ts.exec("scan -np -b row1 -e row1");
        Assert.assertEquals((long)2L, (long)result.split("\n").length);
        result = this.ts.exec("scan -np -b row3 -e row5");
        Assert.assertEquals((long)4L, (long)result.split("\n").length);
        result = this.ts.exec("scan -np -r row3");
        Assert.assertEquals((long)2L, (long)result.split("\n").length);
        result = this.ts.exec("scan -np -b row:");
        Assert.assertEquals((long)1L, (long)result.split("\n").length);
        result = this.ts.exec("scan -np -b row");
        Assert.assertEquals((long)11L, (long)result.split("\n").length);
        result = this.ts.exec("scan -np -e row:");
        Assert.assertEquals((long)11L, (long)result.split("\n").length);
        this.ts.exec("deletetable -f t");
    }

    @Test
    public void scansWithClassLoaderContext() throws IOException {
        try {
            Class.forName(VALUE_REVERSING_ITERATOR);
            Assert.fail((String)"ValueReversingIterator already on the classpath");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.ts.exec("createtable t");
        String result = this.ts.exec("setiter -scan -n reverse -t t -p 21 -class org.apache.accumulo.test.functional.ValueReversingIterator");
        Assert.assertTrue((boolean)result.contains("class not found"));
        this.make10();
        this.setupFakeContextPath();
        result = this.ts.exec("config -s " + Property.VFS_CONTEXT_CLASSPATH_PROPERTY + FAKE_CONTEXT + "=" + FAKE_CONTEXT_CLASSPATH);
        Assert.assertEquals((Object)("root@miniInstance t> config -s " + Property.VFS_CONTEXT_CLASSPATH_PROPERTY + FAKE_CONTEXT + "=" + FAKE_CONTEXT_CLASSPATH + "\n"), (Object)result);
        result = this.ts.exec("config -t t -s table.classpath.context=FAKE");
        Assert.assertEquals((Object)"root@miniInstance t> config -t t -s table.classpath.context=FAKE\n", (Object)result);
        result = this.ts.exec("setshelliter -pn baz -n reverse -p 21 -class org.apache.accumulo.test.functional.ValueReversingIterator");
        Assert.assertTrue((boolean)result.contains("The iterator class does not implement OptionDescriber"));
        result = this.ts.exec("scan -pn baz -np -b row1 -e row1");
        Assert.assertEquals((long)2L, (long)result.split("\n").length);
        Assert.assertTrue((boolean)result.contains("value"));
        result = this.ts.exec("scan -pn baz -np -b row3 -e row5");
        Assert.assertEquals((long)4L, (long)result.split("\n").length);
        Assert.assertTrue((boolean)result.contains("value"));
        result = this.ts.exec("scan -pn baz -np -r row3");
        Assert.assertEquals((long)2L, (long)result.split("\n").length);
        Assert.assertTrue((boolean)result.contains("value"));
        result = this.ts.exec("scan -pn baz -np -b row:");
        Assert.assertEquals((long)1L, (long)result.split("\n").length);
        result = this.ts.exec("scan -pn baz -np -b row");
        Assert.assertEquals((long)11L, (long)result.split("\n").length);
        Assert.assertTrue((boolean)result.contains("value"));
        result = this.ts.exec("scan -pn baz -np -e row:");
        Assert.assertEquals((long)11L, (long)result.split("\n").length);
        Assert.assertTrue((boolean)result.contains("value"));
        this.setupRealContextPath();
        result = this.ts.exec("config -s " + Property.VFS_CONTEXT_CLASSPATH_PROPERTY + REAL_CONTEXT + "=" + REAL_CONTEXT_CLASSPATH);
        Assert.assertEquals((Object)("root@miniInstance t> config -s " + Property.VFS_CONTEXT_CLASSPATH_PROPERTY + REAL_CONTEXT + "=" + REAL_CONTEXT_CLASSPATH + "\n"), (Object)result);
        result = this.ts.exec("scan -pn baz -np -b row1 -e row1 -cc REAL");
        Assert.assertEquals((long)2L, (long)result.split("\n").length);
        Assert.assertTrue((boolean)result.contains("eulav"));
        Assert.assertFalse((boolean)result.contains("value"));
        result = this.ts.exec("scan -pn baz -np -b row3 -e row5 -cc REAL");
        Assert.assertEquals((long)4L, (long)result.split("\n").length);
        Assert.assertTrue((boolean)result.contains("eulav"));
        Assert.assertFalse((boolean)result.contains("value"));
        result = this.ts.exec("scan -pn baz -np -r row3 -cc REAL");
        Assert.assertEquals((long)2L, (long)result.split("\n").length);
        Assert.assertTrue((boolean)result.contains("eulav"));
        Assert.assertFalse((boolean)result.contains("value"));
        result = this.ts.exec("scan -pn baz -np -b row: -cc REAL");
        Assert.assertEquals((long)1L, (long)result.split("\n").length);
        result = this.ts.exec("scan -pn baz -np -b row -cc REAL");
        Assert.assertEquals((long)11L, (long)result.split("\n").length);
        Assert.assertTrue((boolean)result.contains("eulav"));
        Assert.assertFalse((boolean)result.contains("value"));
        result = this.ts.exec("scan -pn baz -np -e row: -cc REAL");
        Assert.assertEquals((long)11L, (long)result.split("\n").length);
        Assert.assertTrue((boolean)result.contains("eulav"));
        Assert.assertFalse((boolean)result.contains("value"));
        this.ts.exec("deletetable -f t");
    }

    @Test
    public void testScanTableWithIterSetWithoutProfile() throws Exception {
        String table = this.name.getMethodName();
        this.ts.exec("createtable " + table, true);
        this.ts.exec("insert foo a b c", true);
        this.ts.exec("scan", true, "foo a:b []    c");
        this.ts.input.set("\n1000\n\n");
        this.ts.exec("setiter -scan -n itname -p 10 -ageoff", true);
        this.ts.exec("sleep 2", true);
        this.ts.exec("scan", true, "", true);
        this.ts.exec("deletetable -f " + table);
        this.ts.exec("createtable " + table, true);
        this.ts.exec("insert foo a b c", true);
        this.ts.exec("notable");
        this.ts.exec("scan -t " + table, true, "foo a:b []    c");
        this.ts.input.set("\n1000\n\n");
        this.ts.exec("setiter -scan -n itname -p 10 -ageoff -t " + table, true);
        this.ts.exec("sleep 2", true);
        this.ts.exec("scan -t " + table, true, "", true);
        this.ts.exec("deletetable -f " + table);
    }

    @Test
    public void importDirectoryCmdFmt() throws Exception {
        String table = this.name.getMethodName();
        File importDir = new File(rootPath, "import_" + table);
        Assert.assertTrue((boolean)importDir.mkdir());
        File errorsDir = new File(rootPath, "errors_" + table);
        Assert.assertTrue((boolean)errorsDir.mkdir());
        this.ts.exec(String.format("importdirectory -t %s %s %s false", table, importDir, errorsDir), false, "TableNotFoundException");
        this.ts.exec(String.format("table %s", table), false, "TableNotFoundException");
        this.ts.exec("createtable " + table, true);
        this.ts.exec(String.format("importdirectory -t %s %s %s false", table, importDir, errorsDir), true);
        this.ts.exec(String.format("table %s", table), true);
        this.ts.exec(String.format("importdirectory %s %s false", importDir, errorsDir), true);
        this.ts.exec("importdirectory false", false, "Expected 3 arguments. There was 1.");
        this.ts.exec("notable", true);
        this.ts.exec(String.format("importdirectory %s %s false", importDir, errorsDir), false, "java.lang.IllegalStateException: Not in a table context.");
    }

    private void setupRealContextPath() throws IOException {
        Path baseDir = new Path(System.getProperty("user.dir"));
        Path targetDir = new Path(baseDir, "target");
        Path jarPath = new Path(targetDir, "TestJar-Iterators.jar");
        Path dstPath = new Path(REAL_CONTEXT_CLASSPATH);
        FileSystem fs = SharedMiniClusterBase.getCluster().getFileSystem();
        fs.copyFromLocalFile(jarPath, dstPath);
    }

    private void setupFakeContextPath() throws IOException {
        Path baseDir = new Path(System.getProperty("user.dir"));
        Path targetDir = new Path(baseDir, "target");
        Path classesDir = new Path(targetDir, "classes");
        Path jarPath = new Path(classesDir, "ShellServerIT-iterators.jar");
        Path dstPath = new Path(FAKE_CONTEXT_CLASSPATH);
        FileSystem fs = SharedMiniClusterBase.getCluster().getFileSystem();
        fs.copyFromLocalFile(jarPath, dstPath);
    }

    @Test
    public void whoami() throws Exception {
        AuthenticationToken token = ShellServerIT.getToken();
        Assert.assertTrue((boolean)this.ts.exec("whoami", true).contains(ShellServerIT.getPrincipal()));
        if (token instanceof PasswordToken) {
            this.ts.input.set("secret\nsecret\n");
        }
        this.ts.exec("createuser test_user");
        this.ts.exec("setauths -u test_user -s 12,3,4");
        String auths = this.ts.exec("getauths -u test_user");
        Assert.assertTrue((auths.contains("3") && auths.contains("12") && auths.contains("4") ? 1 : 0) != 0);
        if (token instanceof PasswordToken) {
            this.ts.input.set("secret\n");
            this.ts.exec("user test_user", true);
            Assert.assertTrue((boolean)this.ts.exec("whoami", true).contains("test_user"));
            this.ts.input.set(ShellServerIT.getRootPassword() + "\n");
            this.ts.exec("user root", true);
        }
    }

    private void make10() throws IOException {
        for (int i = 0; i < 10; ++i) {
            this.ts.exec(String.format("insert row%d cf col%d value", i, i));
        }
    }

    private List<String> getFiles(String tableId) throws IOException {
        this.ts.output.clear();
        this.ts.exec("scan -t accumulo.metadata -np -c file -b " + tableId + " -e " + tableId + "~");
        log.debug("countFiles(): " + this.ts.output.get());
        String[] lines = StringUtils.split((String)this.ts.output.get(), (String)"\n");
        this.ts.output.clear();
        if (0 == lines.length) {
            return Collections.emptyList();
        }
        return Arrays.asList(Arrays.copyOfRange(lines, 1, lines.length));
    }

    private int countFiles(String tableId) throws IOException {
        return this.getFiles(tableId).size();
    }

    private String getTableId(String tableName) throws Exception {
        Connector conn = ShellServerIT.getConnector();
        for (int i = 0; i < 5; ++i) {
            Map nameToId = conn.tableOperations().tableIdMap();
            if (nameToId.containsKey(tableName)) {
                return (String)nameToId.get(tableName);
            }
            Thread.sleep(1000L);
        }
        Assert.fail((String)("Could not find ID for table: " + tableName));
        return null;
    }

    @Test
    public void testGetSplitsScanRange() throws Exception {
        Map idMap;
        Shell.log.debug((Object)"Starting testGetSplitsScanRange test ------------------");
        int idCycleLen = 36;
        int maxLoopcnt = 10;
        int postModifier = 0;
        int loopCnt = 0;
        String[] tables = new String[2];
        Connector conn = ShellServerIT.getCluster().getConnector(ShellServerIT.getPrincipal(), ShellServerIT.getToken());
        while (loopCnt++ < maxLoopcnt && !this.findIds(tables, idMap = conn.tableOperations().tableIdMap())) {
            this.createTables(idCycleLen, postModifier++);
        }
        if (loopCnt >= maxLoopcnt) {
            Shell.log.warn((Object)"Warning: Unable to find needed tables...exiting test without verifying.");
            return;
        }
        this.ts.exec("addsplits -t " + tables[0] + " a c e", true);
        this.ts.exec("addsplits -t " + tables[1] + " g i t", true);
        this.ts.exec("getsplits -v -t " + tables[0], true, "(e, +inf) Default Tablet", true);
        this.ts.exec("getsplits -v -t " + tables[0], true, "(t, +inf) Default Tablet", false);
    }

    private boolean findIds(String[] tables, Map<String, String> idMap) {
        String ids = "0123456789abcdefghijklmnopqrstuvwxyz";
        for (int i = 0; i < ids.length(); ++i) {
            String id = ids.substring(i, i + 1);
            if (!idMap.containsValue(id) || !idMap.containsValue(id + "0")) continue;
            tables[0] = this.getTableNameFromId(idMap, id);
            tables[1] = this.getTableNameFromId(idMap, id + "0");
            Shell.log.debug((Object)("Found tables: " + tables[0] + ":" + id + ", " + tables[1] + ":" + id + "0"));
            return true;
        }
        return false;
    }

    private String getTableNameFromId(Map<String, String> map, String value) {
        return map.entrySet().stream().filter(entry -> value.equals(entry.getValue())).map(Map.Entry::getKey).findFirst().get();
    }

    private void createTables(int limit, int modifier) throws IOException {
        String postfix = Integer.toString(modifier);
        for (int i = 0; i < limit; ++i) {
            this.ts.exec("createtable tabx" + Integer.toString(i) + postfix);
        }
    }

    static {
        FAKE_CONTEXT_CLASSPATH = "file://" + System.getProperty("user.dir") + "/target/" + ShellServerIT.class.getSimpleName() + "-fake-iterators.jar";
        REAL_CONTEXT_CLASSPATH = "file://" + System.getProperty("user.dir") + "/target/" + ShellServerIT.class.getSimpleName() + "-real-iterators.jar";
    }

    public static class HexFormatter
    implements Formatter {
        private Iterator<Map.Entry<Key, Value>> iter = null;
        private FormatterConfig config;
        private static final String tab = "\t";
        private static final String newline = "\n";

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public String next() {
            Map.Entry<Key, Value> entry = this.iter.next();
            String key = this.config.willPrintTimestamps() ? entry.getKey().toString() : entry.getKey().toStringNoTime();
            Value v = entry.getValue();
            StringBuilder sb = new StringBuilder(key.length() + v.getSize() * 5);
            sb.append(key).append(tab);
            for (byte b : v.get()) {
                if ((b < 48 || b > 57) && (b < 97 || b > 102)) continue;
                sb.append(String.format("0x%x ", b));
            }
            return sb.toString().trim() + newline;
        }

        public void remove() {
        }

        public void initialize(Iterable<Map.Entry<Key, Value>> scanner, FormatterConfig config) {
            this.iter = scanner.iterator();
            this.config = new FormatterConfig(config);
        }
    }

    private static class ShellServerITConfigCallback
    implements MiniClusterConfigurationCallback {
        private ShellServerITConfigCallback() {
        }

        @Override
        public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration coreSite) {
            cfg.setNumTservers(1);
            Map siteConf = cfg.getSiteConfig();
            siteConf.put(Property.TRACE_SPAN_RECEIVER_PREFIX.getKey() + "tracer.span.min.ms", "0");
            cfg.setSiteConfig(siteConf);
        }
    }

    public static class TestShell {
        private static final Logger shellLog = LoggerFactory.getLogger(TestShell.class);
        public TestOutputStream output;
        public StringInputStream input;
        public Shell shell;

        TestShell(String user, String rootPass, String instanceName, String zookeepers, File configFile) throws IOException {
            ClientConfiguration clientConf = ClientConfiguration.fromFile((File)configFile);
            this.output = new TestOutputStream();
            this.input = new StringInputStream();
            this.shell = new Shell(new ConsoleReader((InputStream)this.input, (OutputStream)this.output));
            this.shell.setLogErrorsToConsole();
            if (clientConf.hasSasl()) {
                this.shell.config(new String[]{"-u", user, "-z", instanceName, zookeepers, "--config-file", configFile.getAbsolutePath()});
            } else {
                this.shell.config(new String[]{"-u", user, "-p", rootPass, "-z", instanceName, zookeepers, "--config-file", configFile.getAbsolutePath()});
            }
            this.exec("quit", true);
            this.shell.start();
            this.shell.setExit(false);
        }

        String exec(String cmd) throws IOException {
            this.output.clear();
            this.shell.execCommand(cmd, true, true);
            return this.output.get();
        }

        String exec(String cmd, boolean expectGoodExit) throws IOException {
            return this.exec(cmd, expectGoodExit, noop);
        }

        String exec(String cmd, boolean expectGoodExit, ErrorMessageCallback callback) throws IOException {
            String result = this.exec(cmd);
            if (expectGoodExit) {
                this.assertGoodExit("", true, callback);
            } else {
                this.assertBadExit("", true, callback);
            }
            return result;
        }

        String exec(String cmd, boolean expectGoodExit, String expectString) throws IOException {
            return this.exec(cmd, expectGoodExit, expectString, noop);
        }

        String exec(String cmd, boolean expectGoodExit, String expectString, ErrorMessageCallback callback) throws IOException {
            return this.exec(cmd, expectGoodExit, expectString, true, callback);
        }

        String exec(String cmd, boolean expectGoodExit, String expectString, boolean stringPresent) throws IOException {
            return this.exec(cmd, expectGoodExit, expectString, stringPresent, noop);
        }

        String exec(String cmd, boolean expectGoodExit, String expectString, boolean stringPresent, ErrorMessageCallback callback) throws IOException {
            String result = this.exec(cmd);
            if (expectGoodExit) {
                this.assertGoodExit(expectString, stringPresent, callback);
            } else {
                this.assertBadExit(expectString, stringPresent, callback);
            }
            return result;
        }

        void assertGoodExit(String s, boolean stringPresent) {
            this.assertGoodExit(s, stringPresent, noop);
        }

        void assertGoodExit(String s, boolean stringPresent, ErrorMessageCallback callback) {
            shellLog.debug("Shell Output: '{}'", (Object)this.output.get());
            if (0 != this.shell.getExitCode()) {
                String errorMsg = callback.getErrorMessage();
                Assert.assertEquals((String)errorMsg, (long)0L, (long)this.shell.getExitCode());
            }
            if (s.length() > 0) {
                Assert.assertEquals((String)(s + " present in " + this.output.get() + " was not " + stringPresent), (Object)stringPresent, (Object)this.output.get().contains(s));
            }
        }

        void assertBadExit(String s, boolean stringPresent, ErrorMessageCallback callback) {
            shellLog.debug(this.output.get());
            if (0 == this.shell.getExitCode()) {
                String errorMsg = callback.getErrorMessage();
                Assert.assertTrue((String)errorMsg, (this.shell.getExitCode() > 0 ? 1 : 0) != 0);
            }
            if (s.length() > 0) {
                Assert.assertEquals((String)(s + " present in " + this.output.get() + " was not " + stringPresent), (Object)stringPresent, (Object)this.output.get().contains(s));
            }
            this.shell.resetExitCode();
        }
    }

    private static class NoOpErrorMessageCallback
    extends ErrorMessageCallback {
        private static final String empty = "";

        private NoOpErrorMessageCallback() {
        }

        @Override
        public String getErrorMessage() {
            return empty;
        }
    }

    private static abstract class ErrorMessageCallback {
        private ErrorMessageCallback() {
        }

        public abstract String getErrorMessage();
    }

    public static class StringInputStream
    extends InputStream {
        private String source = "";
        private int offset = 0;

        @Override
        public int read() throws IOException {
            if (this.offset == this.source.length()) {
                return 10;
            }
            return this.source.charAt(this.offset++);
        }

        public void set(String other) {
            this.source = other;
            this.offset = 0;
        }
    }

    public static class TestOutputStream
    extends OutputStream {
        StringBuilder sb = new StringBuilder();

        @Override
        public void write(int b) throws IOException {
            this.sb.append((char)(0xFF & b));
        }

        public String get() {
            return this.sb.toString();
        }

        public void clear() {
            this.sb.setLength(0);
        }
    }
}

