/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.OpTimer;
import org.apache.accumulo.tserver.NativeMap;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeMapStressTest {
    private static final Logger log = LoggerFactory.getLogger(NativeMapStressTest.class);

    public static void main(String[] args) {
        NativeMapStressTest.testLotsOfMapDeletes(true);
        NativeMapStressTest.testLotsOfMapDeletes(false);
        NativeMapStressTest.testLotsOfOverwrites();
        NativeMapStressTest.testLotsOfGetsAndScans();
    }

    private static void put(NativeMap nm, String row, String val, int mc) {
        Mutation m = new Mutation(new Text(row));
        m.put(new Text(), new Text(), Long.MAX_VALUE, new Value(val.getBytes(StandardCharsets.UTF_8)));
        nm.mutate(m, mc);
    }

    private static void testLotsOfGetsAndScans() {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        int numThreads = 8;
        int totalGets = 100000000;
        int mapSizePerThread = 500000;
        int getsPerThread = 12500000;
        for (int tCount = 0; tCount < 8; ++tCount) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    String val;
                    String row;
                    int i;
                    NativeMap nm = new NativeMap();
                    Random r = new Random();
                    OpTimer timer = null;
                    AtomicLong nextOpid = new AtomicLong();
                    if (log.isInfoEnabled()) {
                        log.info("tid={} oid={} Creating map of size {}", new Object[]{Thread.currentThread().getId(), nextOpid.get(), 500000});
                        timer = new OpTimer().start();
                    }
                    for (i = 0; i < 500000; ++i) {
                        row = String.format("r%08d", i);
                        val = row + "v";
                        NativeMapStressTest.put(nm, row, val, i);
                    }
                    if (timer != null) {
                        timer.stop();
                        log.info("tid={} oid={} Created map of size {} in {}", new Object[]{Thread.currentThread().getId(), nextOpid.getAndIncrement(), nm.size(), String.format("%.3f secs", timer.scale(TimeUnit.SECONDS))});
                        log.info("tid={} oid={} Doing {} gets()", new Object[]{Thread.currentThread().getId(), nextOpid.get(), 12500000});
                        timer.reset().start();
                    }
                    for (i = 0; i < 12500000; ++i) {
                        row = String.format("r%08d", r.nextInt(500000));
                        val = row + "v";
                        Value value = nm.get(new Key(new Text(row)));
                        if (value != null && value.toString().equals(val)) continue;
                        log.error("nm.get({}) failed", (Object)row);
                    }
                    if (timer != null) {
                        timer.stop();
                        log.info("tid={} oid={} Finished {} gets in {}", new Object[]{Thread.currentThread().getId(), nextOpid.getAndIncrement(), 12500000, String.format("%.3f secs", timer.scale(TimeUnit.SECONDS))});
                        log.info("tid={} oid={} Doing {} random iterations", new Object[]{Thread.currentThread().getId(), nextOpid.get(), 12500000});
                        timer.reset().start();
                    }
                    int scanned = 0;
                    for (int i2 = 0; i2 < 12500000; ++i2) {
                        int count;
                        int startRow = r.nextInt(500000);
                        String row2 = String.format("r%08d", startRow);
                        Iterator iter = nm.iterator(new Key(new Text(row2)));
                        for (count = 0; iter.hasNext() && count < 10; ++count) {
                            String row22 = String.format("r%08d", startRow + count);
                            String val2 = row22 + "v";
                            Map.Entry entry = (Map.Entry)iter.next();
                            if (((Value)entry.getValue()).toString().equals(val2) && ((Key)entry.getKey()).equals((Object)new Key(new Text(row22)))) continue;
                            log.error("nm.iter({}) failed row = {} count = {} row2 = {} val2 = {}", new Object[]{row22, row2, count, row2, val2});
                        }
                        scanned += count;
                    }
                    if (timer != null) {
                        timer.stop();
                        log.info("tid={} oid={} Finished {}  random iterations (scanned = {}) in {}", new Object[]{Thread.currentThread().getId(), nextOpid.getAndIncrement(), 12500000, scanned, String.format("%.3f secs", timer.scale(TimeUnit.SECONDS))});
                    }
                    nm.delete();
                }
            };
            Thread t = new Thread(r);
            t.start();
            threads.add(t);
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                log.error("Could not join thread '{}'.", (Object)thread.getName(), (Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    private static void testLotsOfMapDeletes(final boolean doRemoves) {
        int numThreads = 8;
        int rowRange = 10000;
        int mapsPerThread = 50;
        int totalInserts = 100000000;
        int insertsPerMapPerThread = 250000;
        System.out.println("insertsPerMapPerThread 250000");
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < 8; ++i) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    int inserts = 0;
                    int removes = 0;
                    for (int i = 0; i < 50; ++i) {
                        NativeMap nm = new NativeMap();
                        for (int j = 0; j < 250000; ++j) {
                            String row = String.format("r%08d", j % 10000);
                            String val = row + "v";
                            NativeMapStressTest.put(nm, row, val, j);
                            ++inserts;
                        }
                        if (doRemoves) {
                            Iterator iter = nm.iterator();
                            while (iter.hasNext()) {
                                iter.next();
                                iter.remove();
                                ++removes;
                            }
                        }
                        nm.delete();
                    }
                    System.out.println("inserts " + inserts + " removes " + removes + " " + Thread.currentThread().getName());
                }
            };
            Thread t = new Thread(r);
            t.start();
            threads.add(t);
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                log.error("Could not join thread '{}'.", (Object)thread.getName(), (Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    private static void testLotsOfOverwrites() {
        final HashMap nativeMaps = new HashMap();
        int numThreads = 8;
        final int insertsPerThread = (int)(1.0E8 / (double)numThreads);
        int rowRange = 10000;
        int numMaps = 50;
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < numThreads; ++i) {
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Random r = new Random();
                    int inserts = 0;
                    int i = 0;
                    while ((double)i < (double)insertsPerThread / 100.0) {
                        NativeMap nm;
                        int map = r.nextInt(50);
                        Map map2 = nativeMaps;
                        synchronized (map2) {
                            nm = (NativeMap)nativeMaps.get(map);
                            if (nm == null) {
                                nm = new NativeMap();
                                nativeMaps.put(map, nm);
                            }
                        }
                        map2 = nm;
                        synchronized (map2) {
                            for (int j = 0; j < 100; ++j) {
                                String row = String.format("r%08d", r.nextInt(10000));
                                String val = row + "v";
                                NativeMapStressTest.put(nm, row, val, j);
                                ++inserts;
                            }
                        }
                        ++i;
                    }
                    System.out.println("inserts " + inserts + " " + Thread.currentThread().getName());
                }
            };
            Thread t = new Thread(r);
            t.start();
            threads.add(t);
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                log.error("Could not join thread '{}'.", (Object)thread.getName(), (Object)e);
                throw new RuntimeException(e);
            }
        }
        Set es = nativeMaps.entrySet();
        for (Map.Entry entry : es) {
            ((NativeMap)entry.getValue()).delete();
        }
    }
}

