/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.impl.MultiTableBatchWriterImpl;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiTableBatchWriterIT
extends AccumuloClusterHarness {
    private Connector connector;
    private MultiTableBatchWriter mtbw;

    @Override
    public int defaultTimeoutSeconds() {
        return 300;
    }

    @Before
    public void setUpArgs() throws AccumuloException, AccumuloSecurityException {
        this.connector = this.getConnector();
        this.mtbw = this.getMultiTableBatchWriter();
    }

    public MultiTableBatchWriter getMultiTableBatchWriter() {
        ClientContext context = new ClientContext(this.connector.getInstance(), new Credentials(MultiTableBatchWriterIT.getAdminPrincipal(), MultiTableBatchWriterIT.getAdminToken()), MultiTableBatchWriterIT.getCluster().getClientConfig());
        return new MultiTableBatchWriterImpl(context, new BatchWriterConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableRenameDataValidation() throws Exception {
        try {
            String[] names = this.getUniqueNames(2);
            String table1 = names[0];
            String table2 = names[1];
            TableOperations tops = this.connector.tableOperations();
            tops.create(table1);
            BatchWriter bw1 = this.mtbw.getBatchWriter(table1);
            Mutation m1 = new Mutation((CharSequence)"foo");
            m1.put((CharSequence)"col1", (CharSequence)"", (CharSequence)"val1");
            bw1.addMutation(m1);
            tops.rename(table1, table2);
            tops.create(table1);
            BatchWriter bw2 = this.mtbw.getBatchWriter(table1);
            Mutation m2 = new Mutation((CharSequence)"bar");
            m2.put((CharSequence)"col1", (CharSequence)"", (CharSequence)"val1");
            bw1.addMutation(m2);
            bw2.addMutation(m2);
            this.mtbw.close();
            HashMap<Map.Entry, String> table1Expectations = new HashMap<Map.Entry, String>();
            table1Expectations.put(Maps.immutableEntry((Object)"bar", (Object)"col1"), "val1");
            HashMap<Map.Entry, String> table2Expectations = new HashMap<Map.Entry, String>();
            table2Expectations.put(Maps.immutableEntry((Object)"foo", (Object)"col1"), "val1");
            table2Expectations.put(Maps.immutableEntry((Object)"bar", (Object)"col1"), "val1");
            Scanner s = this.connector.createScanner(table1, new Authorizations());
            s.setRange(new Range());
            HashMap<Map.Entry, String> actual = new HashMap<Map.Entry, String>();
            for (Map.Entry entry : s) {
                actual.put(Maps.immutableEntry((Object)((Key)entry.getKey()).getRow().toString(), (Object)((Key)entry.getKey()).getColumnFamily().toString()), ((Value)entry.getValue()).toString());
            }
            Assert.assertEquals((String)("Differing results for " + table1), table1Expectations, actual);
            s = this.connector.createScanner(table2, new Authorizations());
            s.setRange(new Range());
            actual = new HashMap();
            for (Map.Entry entry : s) {
                actual.put(Maps.immutableEntry((Object)((Key)entry.getKey()).getRow().toString(), (Object)((Key)entry.getKey()).getColumnFamily().toString()), ((Value)entry.getValue()).toString());
            }
            Assert.assertEquals((String)("Differing results for " + table2), table2Expectations, actual);
        }
        finally {
            if (null != this.mtbw) {
                this.mtbw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableRenameSameWriters() throws Exception {
        try {
            String[] names = this.getUniqueNames(4);
            String table1 = names[0];
            String table2 = names[1];
            String newTable1 = names[2];
            String newTable2 = names[3];
            TableOperations tops = this.connector.tableOperations();
            tops.create(table1);
            tops.create(table2);
            BatchWriter bw1 = this.mtbw.getBatchWriter(table1);
            BatchWriter bw2 = this.mtbw.getBatchWriter(table2);
            Mutation m1 = new Mutation((CharSequence)"foo");
            m1.put((CharSequence)"col1", (CharSequence)"", (CharSequence)"val1");
            m1.put((CharSequence)"col2", (CharSequence)"", (CharSequence)"val2");
            bw1.addMutation(m1);
            bw2.addMutation(m1);
            tops.rename(table1, newTable1);
            tops.rename(table2, newTable2);
            Mutation m2 = new Mutation((CharSequence)"bar");
            m2.put((CharSequence)"col1", (CharSequence)"", (CharSequence)"val1");
            m2.put((CharSequence)"col2", (CharSequence)"", (CharSequence)"val2");
            bw1.addMutation(m2);
            bw2.addMutation(m2);
            this.mtbw.close();
            HashMap<Map.Entry, String> expectations = new HashMap<Map.Entry, String>();
            expectations.put(Maps.immutableEntry((Object)"foo", (Object)"col1"), "val1");
            expectations.put(Maps.immutableEntry((Object)"foo", (Object)"col2"), "val2");
            expectations.put(Maps.immutableEntry((Object)"bar", (Object)"col1"), "val1");
            expectations.put(Maps.immutableEntry((Object)"bar", (Object)"col2"), "val2");
            for (String table : Arrays.asList(newTable1, newTable2)) {
                Scanner s = this.connector.createScanner(table, new Authorizations());
                s.setRange(new Range());
                HashMap<Map.Entry, String> actual = new HashMap<Map.Entry, String>();
                for (Map.Entry entry : s) {
                    actual.put(Maps.immutableEntry((Object)((Key)entry.getKey()).getRow().toString(), (Object)((Key)entry.getKey()).getColumnFamily().toString()), ((Value)entry.getValue()).toString());
                }
                Assert.assertEquals((String)("Differing results for " + table), expectations, actual);
            }
        }
        finally {
            if (null != this.mtbw) {
                this.mtbw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableRenameNewWriters() throws Exception {
        try {
            String[] names = this.getUniqueNames(4);
            String table1 = names[0];
            String table2 = names[1];
            String newTable1 = names[2];
            String newTable2 = names[3];
            TableOperations tops = this.connector.tableOperations();
            tops.create(table1);
            tops.create(table2);
            BatchWriter bw1 = this.mtbw.getBatchWriter(table1);
            BatchWriter bw2 = this.mtbw.getBatchWriter(table2);
            Mutation m1 = new Mutation((CharSequence)"foo");
            m1.put((CharSequence)"col1", (CharSequence)"", (CharSequence)"val1");
            m1.put((CharSequence)"col2", (CharSequence)"", (CharSequence)"val2");
            bw1.addMutation(m1);
            bw2.addMutation(m1);
            tops.rename(table1, newTable1);
            try {
                bw1 = this.mtbw.getBatchWriter(table1);
                Assert.fail((String)"Should not be able to find this table");
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            tops.rename(table2, newTable2);
            try {
                bw2 = this.mtbw.getBatchWriter(table2);
                Assert.fail((String)"Should not be able to find this table");
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            bw1 = this.mtbw.getBatchWriter(newTable1);
            bw2 = this.mtbw.getBatchWriter(newTable2);
            Mutation m2 = new Mutation((CharSequence)"bar");
            m2.put((CharSequence)"col1", (CharSequence)"", (CharSequence)"val1");
            m2.put((CharSequence)"col2", (CharSequence)"", (CharSequence)"val2");
            bw1.addMutation(m2);
            bw2.addMutation(m2);
            this.mtbw.close();
            HashMap<Map.Entry, String> expectations = new HashMap<Map.Entry, String>();
            expectations.put(Maps.immutableEntry((Object)"foo", (Object)"col1"), "val1");
            expectations.put(Maps.immutableEntry((Object)"foo", (Object)"col2"), "val2");
            expectations.put(Maps.immutableEntry((Object)"bar", (Object)"col1"), "val1");
            expectations.put(Maps.immutableEntry((Object)"bar", (Object)"col2"), "val2");
            for (String table : Arrays.asList(newTable1, newTable2)) {
                Scanner s = this.connector.createScanner(table, new Authorizations());
                s.setRange(new Range());
                HashMap<Map.Entry, String> actual = new HashMap<Map.Entry, String>();
                for (Map.Entry entry : s) {
                    actual.put(Maps.immutableEntry((Object)((Key)entry.getKey()).getRow().toString(), (Object)((Key)entry.getKey()).getColumnFamily().toString()), ((Value)entry.getValue()).toString());
                }
                Assert.assertEquals((String)("Differing results for " + table), expectations, actual);
            }
        }
        finally {
            if (null != this.mtbw) {
                this.mtbw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableRenameNewWritersNoCaching() throws Exception {
        this.mtbw = this.getMultiTableBatchWriter();
        try {
            String[] names = this.getUniqueNames(4);
            String table1 = names[0];
            String table2 = names[1];
            String newTable1 = names[2];
            String newTable2 = names[3];
            TableOperations tops = this.connector.tableOperations();
            tops.create(table1);
            tops.create(table2);
            BatchWriter bw1 = this.mtbw.getBatchWriter(table1);
            BatchWriter bw2 = this.mtbw.getBatchWriter(table2);
            Mutation m1 = new Mutation((CharSequence)"foo");
            m1.put((CharSequence)"col1", (CharSequence)"", (CharSequence)"val1");
            m1.put((CharSequence)"col2", (CharSequence)"", (CharSequence)"val2");
            bw1.addMutation(m1);
            bw2.addMutation(m1);
            tops.rename(table1, newTable1);
            tops.rename(table2, newTable2);
            try {
                bw1 = this.mtbw.getBatchWriter(table1);
                Assert.fail((String)("Should not have gotten batchwriter for " + table1));
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            try {
                bw2 = this.mtbw.getBatchWriter(table2);
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
        }
        finally {
            if (null != this.mtbw) {
                this.mtbw.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableDelete() throws Exception {
        boolean mutationsRejected = false;
        try {
            String[] names = this.getUniqueNames(2);
            String table1 = names[0];
            String table2 = names[1];
            TableOperations tops = this.connector.tableOperations();
            tops.create(table1);
            tops.create(table2);
            BatchWriter bw1 = this.mtbw.getBatchWriter(table1);
            BatchWriter bw2 = this.mtbw.getBatchWriter(table2);
            Mutation m1 = new Mutation((CharSequence)"foo");
            m1.put((CharSequence)"col1", (CharSequence)"", (CharSequence)"val1");
            m1.put((CharSequence)"col2", (CharSequence)"", (CharSequence)"val2");
            bw1.addMutation(m1);
            bw2.addMutation(m1);
            tops.delete(table1);
            tops.delete(table2);
            Mutation m2 = new Mutation((CharSequence)"bar");
            m2.put((CharSequence)"col1", (CharSequence)"", (CharSequence)"val1");
            m2.put((CharSequence)"col2", (CharSequence)"", (CharSequence)"val2");
            try {
                bw1.addMutation(m2);
                bw2.addMutation(m2);
            }
            catch (MutationsRejectedException e) {
                mutationsRejected = true;
            }
        }
        finally {
            if (null != this.mtbw) {
                try {
                    this.mtbw.close();
                }
                catch (MutationsRejectedException e) {
                    mutationsRejected = true;
                }
            }
        }
        Assert.assertTrue((String)"Expected mutations to be rejected.", (boolean)mutationsRejected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOfflineTable() throws Exception {
        boolean mutationsRejected = false;
        try {
            String[] names = this.getUniqueNames(2);
            String table1 = names[0];
            String table2 = names[1];
            TableOperations tops = this.connector.tableOperations();
            tops.create(table1);
            tops.create(table2);
            BatchWriter bw1 = this.mtbw.getBatchWriter(table1);
            BatchWriter bw2 = this.mtbw.getBatchWriter(table2);
            Mutation m1 = new Mutation((CharSequence)"foo");
            m1.put((CharSequence)"col1", (CharSequence)"", (CharSequence)"val1");
            m1.put((CharSequence)"col2", (CharSequence)"", (CharSequence)"val2");
            bw1.addMutation(m1);
            bw2.addMutation(m1);
            tops.offline(table1, true);
            tops.offline(table2, true);
            Mutation m2 = new Mutation((CharSequence)"bar");
            m2.put((CharSequence)"col1", (CharSequence)"", (CharSequence)"val1");
            m2.put((CharSequence)"col2", (CharSequence)"", (CharSequence)"val2");
            try {
                bw1.addMutation(m2);
                bw2.addMutation(m2);
            }
            catch (MutationsRejectedException e) {
                mutationsRejected = true;
            }
        }
        finally {
            if (null != this.mtbw) {
                try {
                    this.mtbw.close();
                }
                catch (MutationsRejectedException e) {
                    mutationsRejected = true;
                }
            }
        }
        Assert.assertTrue((String)"Expected mutations to be rejected.", (boolean)mutationsRejected);
    }
}

