/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.nio.charset.StandardCharsets;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.minicluster.MemoryUnit;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.categories.MiniClusterOnlyTests;
import org.apache.accumulo.test.categories.PerformanceTests;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.mrit.IntegrationTestMapReduce;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiniClusterOnlyTests.class, PerformanceTests.class})
public class ManySplitIT
extends ConfigurableMacBase {
    final int SPLITS = 10000;

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @BeforeClass
    public static void checkMR() {
        Assume.assumeFalse((boolean)IntegrationTestMapReduce.isMapReduce());
    }

    @Test
    public void test() throws Exception {
        Assume.assumeFalse((boolean)IntegrationTestMapReduce.isMapReduce());
        final String tableName = this.getUniqueNames(1)[0];
        log.info("Creating table");
        final TableOperations tableOperations = this.getConnector().tableOperations();
        log.info("splitting metadata table");
        tableOperations.create(tableName);
        TreeSet<Text> splits = new TreeSet<Text>();
        for (byte b : "123456789abcde".getBytes(StandardCharsets.UTF_8)) {
            splits.add(new Text(new byte[]{49, 59, b}));
        }
        tableOperations.addSplits("accumulo.metadata", splits);
        splits.clear();
        for (int i = 0; i < 10000; ++i) {
            splits.add(new Text(Integer.toHexString(i)));
        }
        log.info("Adding splits");
        final AtomicBoolean stop = new AtomicBoolean(false);
        Thread t = new Thread(){

            @Override
            public void run() {
                while (!stop.get()) {
                    UtilWaitThread.sleep((long)1000L);
                    try {
                        ConfigurableMacBase.log.info("splits: " + tableOperations.listSplits(tableName).size());
                    }
                    catch (AccumuloException | AccumuloSecurityException | TableNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        t.start();
        long now = System.currentTimeMillis();
        tableOperations.addSplits(tableName, splits);
        long diff = System.currentTimeMillis() - now;
        double splitsPerSec = 10000.0 / ((double)diff / 1000.0);
        log.info("Done: {} splits per second", (Object)splitsPerSec);
        Assert.assertTrue((String)"splits created too slowly", (splitsPerSec > 100.0 ? 1 : 0) != 0);
        stop.set(true);
        t.join();
    }

    @Override
    protected void configure(MiniAccumuloConfigImpl cfg, Configuration hdfs) {
        cfg.setNumTservers(1);
        cfg.setMemory(ServerType.TABLET_SERVER, cfg.getMemory(ServerType.TABLET_SERVER) * 2L, MemoryUnit.BYTE);
    }
}

