/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.impl.AccumuloServerException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LargeSplitRowIT
extends ConfigurableMacBase {
    private static final Logger log = LoggerFactory.getLogger(LargeSplitRowIT.class);

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
        HashMap<String, String> siteConfig = new HashMap<String, String>();
        siteConfig.put(Property.TSERV_MAJC_DELAY.getKey(), "50ms");
        cfg.setSiteConfig(siteConfig);
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    @Test
    public void userAddedSplit() throws Exception {
        log.info("User added split");
        String tableName = this.getUniqueNames(1)[0];
        Connector conn = this.getConnector();
        conn.tableOperations().create(tableName);
        conn.tableOperations().setProperty(tableName, Property.TABLE_MAX_END_ROW_SIZE.getKey(), "1000");
        BatchWriter batchWriter = conn.createBatchWriter(tableName, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"Row");
        m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
        batchWriter.addMutation(m);
        batchWriter.close();
        TreeSet<Text> partitionKeys = new TreeSet<Text>();
        byte[] data = new byte[(int)(TableConfiguration.getMemoryInBytes((String)Property.TABLE_MAX_END_ROW_SIZE.getDefaultValue()) + 2L)];
        for (int i = 0; i < data.length; ++i) {
            data[i] = 109;
        }
        partitionKeys.add(new Text(data));
        try {
            conn.tableOperations().addSplits(tableName, partitionKeys);
            Assert.fail();
        }
        catch (AccumuloServerException i) {
            // empty catch block
        }
        int counter = 0;
        Scanner scanner = conn.createScanner(tableName, Authorizations.EMPTY);
        for (Map.Entry entry : scanner) {
            ++counter;
            Key k = (Key)entry.getKey();
            Assert.assertEquals((Object)"Row", (Object)k.getRow().toString());
            Assert.assertEquals((Object)"cf", (Object)k.getColumnFamily().toString());
            Assert.assertEquals((Object)"cq", (Object)k.getColumnQualifier().toString());
            Assert.assertEquals((Object)"value", (Object)((Value)entry.getValue()).toString());
        }
        Assert.assertEquals((long)1L, (long)counter);
    }

    @Test(timeout=60000L)
    public void automaticSplitWith250Same() throws Exception {
        int i;
        log.info("Automatic with 250 with same prefix");
        String tableName = this.getUniqueNames(1)[0];
        Connector conn = this.getConnector();
        conn.tableOperations().create(tableName);
        conn.tableOperations().setProperty(tableName, Property.TABLE_SPLIT_THRESHOLD.getKey(), "10K");
        conn.tableOperations().setProperty(tableName, Property.TABLE_FILE_COMPRESSION_TYPE.getKey(), "none");
        conn.tableOperations().setProperty(tableName, Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE.getKey(), "64");
        conn.tableOperations().setProperty(tableName, Property.TABLE_MAX_END_ROW_SIZE.getKey(), "1000");
        BatchWriter batchWriter = conn.createBatchWriter(tableName, new BatchWriterConfig());
        byte[] data = new byte[(int)(TableConfiguration.getMemoryInBytes((String)Property.TABLE_MAX_END_ROW_SIZE.getDefaultValue()) + 2L)];
        for (i = 0; i < data.length - 1; ++i) {
            data[i] = 109;
        }
        for (i = 0; i < 250; ++i) {
            data[data.length - 1] = (byte)i;
            Mutation m = new Mutation(data);
            m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
            batchWriter.addMutation(m);
        }
        batchWriter.close();
        conn.tableOperations().flush(tableName, new Text(), new Text("z"), true);
        Thread.sleep(500L);
        int count = 0;
        Scanner scanner = conn.createScanner(tableName, Authorizations.EMPTY);
        for (Map.Entry entry : scanner) {
            Key k = (Key)entry.getKey();
            data[data.length - 1] = (byte)count;
            String expected = new String(data, StandardCharsets.UTF_8);
            Assert.assertEquals((Object)expected, (Object)k.getRow().toString());
            Assert.assertEquals((Object)"cf", (Object)k.getColumnFamily().toString());
            Assert.assertEquals((Object)"cq", (Object)k.getColumnQualifier().toString());
            Assert.assertEquals((Object)"value", (Object)((Value)entry.getValue()).toString());
            ++count;
        }
        Assert.assertEquals((long)250L, (long)count);
        Assert.assertEquals((long)0L, (long)conn.tableOperations().listSplits(tableName).size());
    }

    @Test(timeout=60000L)
    public void automaticSplitWithGaps() throws Exception {
        log.info("Automatic Split With Gaps");
        this.automaticSplit(30, 2);
    }

    @Test(timeout=60000L)
    public void automaticSplitWithoutGaps() throws Exception {
        log.info("Automatic Split Without Gaps");
        this.automaticSplit(15, 1);
    }

    @Test(timeout=60000L)
    public void automaticSplitLater() throws Exception {
        log.info("Split later");
        this.automaticSplit(15, 1);
        Connector conn = this.getConnector();
        String tableName = new String();
        for (String curr : conn.tableOperations().list()) {
            if (curr.startsWith("accumulo.")) continue;
            tableName = curr;
        }
        BatchWriter batchWriter = conn.createBatchWriter(tableName, new BatchWriterConfig());
        byte[] data = new byte[10];
        for (int j = 15; j < 150; ++j) {
            int i;
            for (i = 0; i < data.length - 1; ++i) {
                data[i] = (byte)j;
            }
            for (i = 0; i < 25; ++i) {
                data[data.length - 1] = (byte)i;
                Mutation m = new Mutation(data);
                m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
                batchWriter.addMutation(m);
            }
        }
        batchWriter.close();
        conn.tableOperations().flush(tableName, new Text(), new Text("z"), true);
        while (conn.tableOperations().listSplits(tableName).size() == 0) {
            Thread.sleep(250L);
        }
        Assert.assertTrue((0 < conn.tableOperations().listSplits(tableName).size() ? 1 : 0) != 0);
    }

    private void automaticSplit(int max, int spacing) throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        Connector conn = this.getConnector();
        conn.tableOperations().create(tableName);
        conn.tableOperations().setProperty(tableName, Property.TABLE_SPLIT_THRESHOLD.getKey(), "10K");
        conn.tableOperations().setProperty(tableName, Property.TABLE_FILE_COMPRESSION_TYPE.getKey(), "none");
        conn.tableOperations().setProperty(tableName, Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE.getKey(), "64");
        conn.tableOperations().setProperty(tableName, Property.TABLE_MAX_END_ROW_SIZE.getKey(), "1000");
        BatchWriter batchWriter = conn.createBatchWriter(tableName, new BatchWriterConfig());
        byte[] data = new byte[(int)(TableConfiguration.getMemoryInBytes((String)Property.TABLE_MAX_END_ROW_SIZE.getDefaultValue()) + 2L)];
        for (int j = 0; j < max; j += spacing) {
            int i;
            for (i = 0; i < data.length - 1; ++i) {
                data[i] = (byte)j;
            }
            for (i = 0; i < 10; ++i) {
                data[data.length - 1] = (byte)i;
                Mutation m = new Mutation(data);
                m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
                batchWriter.addMutation(m);
            }
        }
        batchWriter.close();
        conn.tableOperations().flush(tableName, new Text(), new Text("z"), true);
        Thread.sleep(500L);
        int count = 0;
        int extra = 10;
        Scanner scanner = conn.createScanner(tableName, Authorizations.EMPTY);
        for (Map.Entry entry : scanner) {
            if (extra == 10) {
                extra = 0;
                for (int i = 0; i < data.length - 1; ++i) {
                    data[i] = (byte)count;
                }
                count += spacing;
            }
            Key k = (Key)entry.getKey();
            data[data.length - 1] = (byte)extra;
            String expected = new String(data, StandardCharsets.UTF_8);
            Assert.assertEquals((Object)expected, (Object)k.getRow().toString());
            Assert.assertEquals((Object)"cf", (Object)k.getColumnFamily().toString());
            Assert.assertEquals((Object)"cq", (Object)k.getColumnQualifier().toString());
            Assert.assertEquals((Object)"value", (Object)((Value)entry.getValue()).toString());
            ++extra;
        }
        Assert.assertEquals((long)10L, (long)extra);
        Assert.assertEquals((long)max, (long)count);
        Assert.assertEquals((long)0L, (long)conn.tableOperations().listSplits(tableName).size());
    }
}

