/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.file.rfile.RFileOperations;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;

public class CreateRandomRFile {
    private static int num;
    private static String file;

    public static byte[] createValue(long rowid, int dataSize) {
        Random r = new Random(rowid);
        byte[] value = new byte[dataSize];
        r.nextBytes(value);
        for (int j = 0; j < value.length; ++j) {
            value[j] = (byte)((0xFF & value[j]) % 92 + 32);
        }
        return value;
    }

    public static void main(String[] args) {
        FileSKVWriter mfw;
        if (args.length != 2) {
            System.err.println("Usage CreateRandomRFile <filename> <size>");
            System.exit(-1);
        }
        file = args[0];
        num = Integer.parseInt(args[1]);
        long[] rands = new long[num];
        Random r = new Random();
        for (int i = 0; i < rands.length; ++i) {
            rands[i] = (r.nextLong() & Long.MAX_VALUE) % 10000000000L;
        }
        Arrays.sort(rands);
        Configuration conf = CachedConfiguration.getInstance();
        try {
            FileSystem fs = FileSystem.get((Configuration)conf);
            mfw = ((FileOperations.OpenWriterOperationBuilder)new RFileOperations().newWriterBuilder().forFile(file, fs, conf).withTableConfiguration((AccumuloConfiguration)AccumuloConfiguration.getDefaultConfiguration())).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < rands.length; ++i) {
            Text row = new Text(String.format("row_%010d", rands[i]));
            Key key = new Key(row);
            Value dv = new Value(CreateRandomRFile.createValue(rands[i], 40));
            try {
                mfw.append(key, dv);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            mfw.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

