/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.util.SimpleThreadPool;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.Test;

public class BalanceWithOfflineTableIT
extends ConfigurableMacBase {
    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Override
    protected void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
    }

    @Test
    public void test() throws Exception {
        String[] tableNames = this.getUniqueNames(2);
        String tableName = tableNames[0];
        final Connector c = this.getConnector();
        log.info("Creating table " + tableName);
        c.tableOperations().create(tableName);
        TreeSet<Text> splits = new TreeSet<Text>();
        for (String split : "a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z".split(",")) {
            splits.add(new Text(split));
        }
        log.info("Splitting table " + tableName);
        c.tableOperations().addSplits(tableName, splits);
        log.info("Balancing");
        c.instanceOperations().waitForBalance();
        log.info("Balanced");
        String table2 = tableNames[1];
        log.info("Creating table " + table2);
        c.tableOperations().create(table2);
        log.info("Creating splits " + table2);
        c.tableOperations().addSplits(table2, splits);
        log.info("Offlining " + table2);
        c.tableOperations().offline(table2, true);
        log.info("Offlined " + table2);
        log.info("Waiting for balance");
        SimpleThreadPool pool = new SimpleThreadPool(1, "waitForBalance");
        Future wait = pool.submit((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                c.instanceOperations().waitForBalance();
                return true;
            }
        });
        wait.get(2 * this.defaultTimeoutSeconds() / 3, TimeUnit.SECONDS);
        log.info("Balance succeeded with an offline table");
    }
}

