/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.Map;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArbitraryTablePropertiesIT
extends SharedMiniClusterBase {
    private static final Logger log = LoggerFactory.getLogger(ArbitraryTablePropertiesIT.class);

    @Override
    protected int defaultTimeoutSeconds() {
        return 30;
    }

    @BeforeClass
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniCluster();
    }

    @AfterClass
    public static void teardown() throws Exception {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @Test
    public void setGetRemoveTablePropertyRoot() throws Exception {
        log.debug("Starting setGetRemoveTablePropertyRoot test ------------------------");
        String tableName = this.getUniqueNames(1)[0];
        Connector conn = ArbitraryTablePropertiesIT.getConnector();
        conn.tableOperations().create(tableName);
        String propertyName = "table.custom.description";
        String description1 = "Description";
        Assert.assertTrue((boolean)Property.isValidPropertyKey((String)propertyName));
        conn.tableOperations().setProperty(tableName, propertyName, description1);
        int count = 0;
        for (Map.Entry property : conn.tableOperations().getProperties(tableName)) {
            if (!((String)property.getKey()).equals(propertyName) || !((String)property.getValue()).equals(description1)) continue;
            ++count;
        }
        Assert.assertEquals((long)count, (long)1L);
        String description2 = "set second";
        conn.tableOperations().setProperty(tableName, propertyName, description2);
        count = 0;
        for (Map.Entry property : conn.tableOperations().getProperties(tableName)) {
            if (!((String)property.getKey()).equals(propertyName) || !((String)property.getValue()).equals(description2)) continue;
            ++count;
        }
        Assert.assertEquals((long)count, (long)1L);
        conn.tableOperations().removeProperty(tableName, propertyName);
        count = 0;
        for (Map.Entry property : conn.tableOperations().getProperties(tableName)) {
            if (!((String)property.getKey()).equals(propertyName)) continue;
            ++count;
        }
        Assert.assertEquals((long)count, (long)0L);
    }

    @Test
    public void userSetGetRemoveTablePropertyWithPermission() throws Exception {
        log.debug("Starting userSetGetRemoveTablePropertyWithPermission test ------------------------");
        ClusterUser user = this.getUser(0);
        String testUser = user.getPrincipal();
        AuthenticationToken testToken = user.getToken();
        String tableName = this.getUniqueNames(1)[0];
        Connector c = ArbitraryTablePropertiesIT.getConnector();
        c.securityOperations().createLocalUser(testUser, testToken instanceof PasswordToken ? (PasswordToken)testToken : null);
        c.tableOperations().create(tableName);
        c.securityOperations().grantTablePermission(testUser, tableName, TablePermission.ALTER_TABLE);
        String propertyName = "table.custom.description";
        String description1 = "Description";
        Assert.assertTrue((boolean)Property.isValidPropertyKey((String)propertyName));
        Connector testConn = c.getInstance().getConnector(testUser, user.getToken());
        testConn.tableOperations().setProperty(tableName, propertyName, description1);
        int count = 0;
        for (Map.Entry property : testConn.tableOperations().getProperties(tableName)) {
            if (!((String)property.getKey()).equals(propertyName) || !((String)property.getValue()).equals(description1)) continue;
            ++count;
        }
        Assert.assertEquals((long)count, (long)1L);
        String description2 = "set second";
        testConn.tableOperations().setProperty(tableName, propertyName, description2);
        count = 0;
        for (Map.Entry property : testConn.tableOperations().getProperties(tableName)) {
            if (!((String)property.getKey()).equals(propertyName) || !((String)property.getValue()).equals(description2)) continue;
            ++count;
        }
        Assert.assertEquals((long)count, (long)1L);
        testConn.tableOperations().removeProperty(tableName, propertyName);
        count = 0;
        for (Map.Entry property : testConn.tableOperations().getProperties(tableName)) {
            if (!((String)property.getKey()).equals(propertyName)) continue;
            ++count;
        }
        Assert.assertEquals((long)count, (long)0L);
    }

    @Test
    public void userSetGetTablePropertyWithoutPermission() throws Exception {
        log.debug("Starting userSetGetTablePropertyWithoutPermission test ------------------------");
        ClusterUser user = this.getUser(1);
        String testUser = user.getPrincipal();
        AuthenticationToken testToken = user.getToken();
        String tableName = this.getUniqueNames(1)[0];
        Connector c = ArbitraryTablePropertiesIT.getConnector();
        c.securityOperations().createLocalUser(testUser, testToken instanceof PasswordToken ? (PasswordToken)testToken : null);
        c.tableOperations().create(tableName);
        String propertyName = "table.custom.description";
        String description1 = "Description";
        Assert.assertTrue((boolean)Property.isValidPropertyKey((String)propertyName));
        Connector testConn = c.getInstance().getConnector(testUser, user.getToken());
        try {
            testConn.tableOperations().setProperty(tableName, propertyName, description1);
            Assert.fail((String)"Was able to set property without permissions");
        }
        catch (AccumuloSecurityException accumuloSecurityException) {
            // empty catch block
        }
        int count = 0;
        for (Map.Entry property : testConn.tableOperations().getProperties(tableName)) {
            if (!((String)property.getKey()).equals(propertyName)) continue;
            ++count;
        }
        Assert.assertEquals((long)count, (long)0L);
    }
}

