/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.util.celltypes;

import org.apache.accumulo.monitor.util.celltypes.NumberType;

public class PreciseNumberType
extends NumberType<Integer> {
    private static final long serialVersionUID = 1L;

    public PreciseNumberType(int warnMin, int warnMax, int errMin, int errMax) {
        super(warnMin, warnMax, errMin, errMax);
    }

    @Override
    public String format(Object obj) {
        if (obj == null) {
            return "-";
        }
        int i = ((Number)obj).intValue();
        String display = String.format("%,d", obj);
        if (this.errMin != null && i < (Integer)this.errMin || this.errMax != null && i > (Integer)this.errMax) {
            return String.format("<span class='error'>%s</span>", display);
        }
        if (this.warnMin != null && i < (Integer)this.warnMin || this.warnMax != null && i > (Integer)this.warnMax) {
            return String.format("<span class='warning'>%s</span>", display);
        }
        return display;
    }

    public PreciseNumberType() {
    }
}

