/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.conf;

import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.hadoop.io.Text;

public class ColumnUtil {
    private static int hash(byte[] bytes, int offset, int len) {
        int hash = 1;
        int end = offset + len;
        for (int i = offset; i < end; ++i) {
            hash = 31 * hash + bytes[i];
        }
        return hash;
    }

    private static int hash(ByteSequence bs) {
        return ColumnUtil.hash(bs.getBackingArray(), bs.offset(), bs.length());
    }

    public static class ColHashKey {
        Text columnFamily;
        Text columnQualifier;
        Key key;
        private int hashValue;

        ColHashKey() {
            this.columnFamily = null;
            this.columnQualifier = null;
        }

        ColHashKey(Text cf, Text cq) {
            this.columnFamily = cf;
            this.columnQualifier = cq;
            this.hashValue = ColumnUtil.hash(this.columnFamily.getBytes(), 0, this.columnFamily.getLength()) + ColumnUtil.hash(this.columnQualifier.getBytes(), 0, this.columnQualifier.getLength());
        }

        void set(Key key) {
            this.key = key;
            this.hashValue = ColumnUtil.hash(key.getColumnFamilyData()) + ColumnUtil.hash(key.getColumnQualifierData());
        }

        public int hashCode() {
            return this.hashValue;
        }

        public boolean equals(Object o) {
            if (o instanceof ColHashKey) {
                return this.equals((ColHashKey)o);
            }
            return false;
        }

        public boolean equals(ColHashKey ohk) {
            if (this.columnFamily == null) {
                return this.key.compareColumnFamily(ohk.columnFamily) == 0 && this.key.compareColumnQualifier(ohk.columnQualifier) == 0;
            }
            return ohk.key.compareColumnFamily(this.columnFamily) == 0 && ohk.key.compareColumnQualifier(this.columnQualifier) == 0;
        }
    }

    public static class ColFamHashKey {
        Text columnFamily;
        Key key;
        private int hashCode;

        ColFamHashKey() {
            this.columnFamily = null;
        }

        ColFamHashKey(Text cf) {
            this.columnFamily = cf;
            this.hashCode = ColumnUtil.hash(this.columnFamily.getBytes(), 0, this.columnFamily.getLength());
        }

        void set(Key key) {
            this.key = key;
            this.hashCode = ColumnUtil.hash(key.getColumnFamilyData());
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o instanceof ColFamHashKey) {
                return this.equals((ColFamHashKey)o);
            }
            return false;
        }

        public boolean equals(ColFamHashKey ohk) {
            if (this.columnFamily == null) {
                return this.key.compareColumnFamily(ohk.columnFamily) == 0;
            }
            return ohk.key.compareColumnFamily(this.columnFamily) == 0;
        }
    }
}

