/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security.handler;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.security.handler.Authenticator;
import org.apache.accumulo.server.security.handler.Authorizor;
import org.apache.accumulo.server.security.handler.PermissionHandler;
import org.apache.accumulo.server.security.handler.ZKSecurityTool;
import org.apache.accumulo.server.zookeeper.ZooCache;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKPermHandler
implements PermissionHandler {
    private static final Logger log = LoggerFactory.getLogger(ZKPermHandler.class);
    private static PermissionHandler zkPermHandlerInstance = null;
    private String ZKUserPath;
    private String ZKTablePath;
    private String ZKNamespacePath;
    private final ZooCache zooCache = new ZooCache();
    private final String ZKUserSysPerms = "/System";
    private final String ZKUserTablePerms = "/Tables";
    private final String ZKUserNamespacePerms = "/Namespaces";

    public static synchronized PermissionHandler getInstance() {
        if (zkPermHandlerInstance == null) {
            zkPermHandlerInstance = new ZKPermHandler();
        }
        return zkPermHandlerInstance;
    }

    @Override
    public void initialize(String instanceId, boolean initialize) {
        this.ZKUserPath = ZKSecurityTool.getInstancePath(instanceId) + "/users";
        this.ZKTablePath = ZKSecurityTool.getInstancePath(instanceId) + "/tables";
        this.ZKNamespacePath = ZKSecurityTool.getInstancePath(instanceId) + "/namespaces";
    }

    @Override
    public boolean hasTablePermission(String user, String table, TablePermission permission) throws TableNotFoundException {
        byte[] serializedPerms;
        ZooReaderWriter zrw = ZooReaderWriter.getInstance();
        try {
            String path = this.ZKUserPath + "/" + user + "/Tables" + "/" + table;
            zrw.sync(path);
            serializedPerms = zrw.getData(path, null);
        }
        catch (KeeperException e) {
            if (e.code() == KeeperException.Code.NONODE) {
                try {
                    zrw.getData(this.ZKTablePath + "/" + table, null);
                    return false;
                }
                catch (InterruptedException ex) {
                    log.warn("Unhandled InterruptedException, failing closed for table permission check", (Throwable)e);
                    return false;
                }
                catch (KeeperException ex) {
                    if (e.code() == KeeperException.Code.NONODE) {
                        throw new TableNotFoundException(null, table, "while checking permissions");
                    }
                    log.warn("Unhandled InterruptedException, failing closed for table permission check", (Throwable)e);
                    return false;
                }
            }
            log.warn("Unhandled KeeperException, failing closed for table permission check", (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            log.warn("Unhandled InterruptedException, failing closed for table permission check", (Throwable)e);
            return false;
        }
        if (serializedPerms != null) {
            return ZKSecurityTool.convertTablePermissions(serializedPerms).contains(permission);
        }
        return false;
    }

    @Override
    public boolean hasCachedTablePermission(String user, String table, TablePermission permission) throws AccumuloSecurityException, TableNotFoundException {
        byte[] serializedPerms = this.zooCache.get(this.ZKUserPath + "/" + user + "/Tables" + "/" + table);
        if (serializedPerms != null) {
            return ZKSecurityTool.convertTablePermissions(serializedPerms).contains(permission);
        }
        return false;
    }

    @Override
    public boolean hasNamespacePermission(String user, String namespace, NamespacePermission permission) throws NamespaceNotFoundException {
        byte[] serializedPerms;
        ZooReaderWriter zrw = ZooReaderWriter.getInstance();
        try {
            String path = this.ZKUserPath + "/" + user + "/Namespaces" + "/" + namespace;
            zrw.sync(path);
            serializedPerms = zrw.getData(path, null);
        }
        catch (KeeperException e) {
            if (e.code() == KeeperException.Code.NONODE) {
                try {
                    zrw.getData(this.ZKNamespacePath + "/" + namespace, null);
                    return false;
                }
                catch (InterruptedException ex) {
                    log.warn("Unhandled InterruptedException, failing closed for namespace permission check", (Throwable)e);
                    return false;
                }
                catch (KeeperException ex) {
                    if (e.code() == KeeperException.Code.NONODE) {
                        throw new NamespaceNotFoundException(null, namespace, "while checking permissions");
                    }
                    log.warn("Unhandled InterruptedException, failing closed for table permission check", (Throwable)e);
                    return false;
                }
            }
            log.warn("Unhandled KeeperException, failing closed for table permission check", (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            log.warn("Unhandled InterruptedException, failing closed for table permission check", (Throwable)e);
            return false;
        }
        if (serializedPerms != null) {
            return ZKSecurityTool.convertNamespacePermissions(serializedPerms).contains(permission);
        }
        return false;
    }

    @Override
    public boolean hasCachedNamespacePermission(String user, String namespace, NamespacePermission permission) throws AccumuloSecurityException, NamespaceNotFoundException {
        byte[] serializedPerms = this.zooCache.get(this.ZKUserPath + "/" + user + "/Namespaces" + "/" + namespace);
        if (serializedPerms != null) {
            return ZKSecurityTool.convertNamespacePermissions(serializedPerms).contains(permission);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantSystemPermission(String user, SystemPermission permission) throws AccumuloSecurityException {
        block6: {
            try {
                byte[] permBytes = this.zooCache.get(this.ZKUserPath + "/" + user + "/System");
                Set<SystemPermission> perms = permBytes == null ? new TreeSet<SystemPermission>() : ZKSecurityTool.convertSystemPermissions(permBytes);
                if (!perms.add(permission)) break block6;
                ZooCache zooCache = this.zooCache;
                synchronized (zooCache) {
                    this.zooCache.clear();
                    ZooReaderWriter.getInstance().putPersistentData(this.ZKUserPath + "/" + user + "/System", ZKSecurityTool.convertSystemPermissions(perms), ZooUtil.NodeExistsPolicy.OVERWRITE);
                }
            }
            catch (KeeperException e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
                throw new AccumuloSecurityException(user, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
            }
            catch (InterruptedException e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantTablePermission(String user, String table, TablePermission permission) throws AccumuloSecurityException {
        block6: {
            byte[] serializedPerms = this.zooCache.get(this.ZKUserPath + "/" + user + "/Tables" + "/" + table);
            Set<TablePermission> tablePerms = serializedPerms != null ? ZKSecurityTool.convertTablePermissions(serializedPerms) : new TreeSet<TablePermission>();
            try {
                if (!tablePerms.add(permission)) break block6;
                ZooCache zooCache = this.zooCache;
                synchronized (zooCache) {
                    this.zooCache.clear(this.ZKUserPath + "/" + user + "/Tables" + "/" + table);
                    ZooReaderWriter.getInstance().putPersistentData(this.ZKUserPath + "/" + user + "/Tables" + "/" + table, ZKSecurityTool.convertTablePermissions(tablePerms), ZooUtil.NodeExistsPolicy.OVERWRITE);
                }
            }
            catch (KeeperException e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
                throw new AccumuloSecurityException(user, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
            }
            catch (InterruptedException e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantNamespacePermission(String user, String namespace, NamespacePermission permission) throws AccumuloSecurityException {
        block6: {
            byte[] serializedPerms = this.zooCache.get(this.ZKUserPath + "/" + user + "/Namespaces" + "/" + namespace);
            Set<NamespacePermission> namespacePerms = serializedPerms != null ? ZKSecurityTool.convertNamespacePermissions(serializedPerms) : new TreeSet<NamespacePermission>();
            try {
                if (!namespacePerms.add(permission)) break block6;
                ZooCache zooCache = this.zooCache;
                synchronized (zooCache) {
                    this.zooCache.clear(this.ZKUserPath + "/" + user + "/Namespaces" + "/" + namespace);
                    ZooReaderWriter.getInstance().putPersistentData(this.ZKUserPath + "/" + user + "/Namespaces" + "/" + namespace, ZKSecurityTool.convertNamespacePermissions(namespacePerms), ZooUtil.NodeExistsPolicy.OVERWRITE);
                }
            }
            catch (KeeperException e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
                throw new AccumuloSecurityException(user, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
            }
            catch (InterruptedException e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeSystemPermission(String user, SystemPermission permission) throws AccumuloSecurityException {
        block7: {
            byte[] sysPermBytes = this.zooCache.get(this.ZKUserPath + "/" + user + "/System");
            if (sysPermBytes == null) {
                return;
            }
            Set<SystemPermission> sysPerms = ZKSecurityTool.convertSystemPermissions(sysPermBytes);
            try {
                if (!sysPerms.remove(permission)) break block7;
                ZooCache zooCache = this.zooCache;
                synchronized (zooCache) {
                    this.zooCache.clear();
                    ZooReaderWriter.getInstance().putPersistentData(this.ZKUserPath + "/" + user + "/System", ZKSecurityTool.convertSystemPermissions(sysPerms), ZooUtil.NodeExistsPolicy.OVERWRITE);
                }
            }
            catch (KeeperException e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
                throw new AccumuloSecurityException(user, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
            }
            catch (InterruptedException e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void revokeTablePermission(String user, String table, TablePermission permission) throws AccumuloSecurityException {
        byte[] serializedPerms = this.zooCache.get(this.ZKUserPath + "/" + user + "/Tables" + "/" + table);
        if (serializedPerms == null) {
            return;
        }
        Set<TablePermission> tablePerms = ZKSecurityTool.convertTablePermissions(serializedPerms);
        try {
            if (tablePerms.remove(permission)) {
                this.zooCache.clear();
                ZooReaderWriter zoo = ZooReaderWriter.getInstance();
                if (tablePerms.size() == 0) {
                    zoo.recursiveDelete(this.ZKUserPath + "/" + user + "/Tables" + "/" + table, ZooUtil.NodeMissingPolicy.SKIP);
                } else {
                    zoo.putPersistentData(this.ZKUserPath + "/" + user + "/Tables" + "/" + table, ZKSecurityTool.convertTablePermissions(tablePerms), ZooUtil.NodeExistsPolicy.OVERWRITE);
                }
            }
        }
        catch (KeeperException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new AccumuloSecurityException(user, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void revokeNamespacePermission(String user, String namespace, NamespacePermission permission) throws AccumuloSecurityException {
        byte[] serializedPerms = this.zooCache.get(this.ZKUserPath + "/" + user + "/Namespaces" + "/" + namespace);
        if (serializedPerms == null) {
            return;
        }
        Set<NamespacePermission> namespacePerms = ZKSecurityTool.convertNamespacePermissions(serializedPerms);
        try {
            if (namespacePerms.remove(permission)) {
                this.zooCache.clear();
                ZooReaderWriter zoo = ZooReaderWriter.getInstance();
                if (namespacePerms.size() == 0) {
                    zoo.recursiveDelete(this.ZKUserPath + "/" + user + "/Namespaces" + "/" + namespace, ZooUtil.NodeMissingPolicy.SKIP);
                } else {
                    zoo.putPersistentData(this.ZKUserPath + "/" + user + "/Namespaces" + "/" + namespace, ZKSecurityTool.convertNamespacePermissions(namespacePerms), ZooUtil.NodeExistsPolicy.OVERWRITE);
                }
            }
        }
        catch (KeeperException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new AccumuloSecurityException(user, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanTablePermissions(String table) throws AccumuloSecurityException {
        try {
            ZooCache zooCache = this.zooCache;
            synchronized (zooCache) {
                this.zooCache.clear();
                ZooReaderWriter zoo = ZooReaderWriter.getInstance();
                for (String user : this.zooCache.getChildren(this.ZKUserPath)) {
                    zoo.recursiveDelete(this.ZKUserPath + "/" + user + "/Tables" + "/" + table, ZooUtil.NodeMissingPolicy.SKIP);
                }
            }
        }
        catch (KeeperException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new AccumuloSecurityException("unknownUser", SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanNamespacePermissions(String namespace) throws AccumuloSecurityException {
        try {
            ZooCache zooCache = this.zooCache;
            synchronized (zooCache) {
                this.zooCache.clear();
                ZooReaderWriter zoo = ZooReaderWriter.getInstance();
                for (String user : this.zooCache.getChildren(this.ZKUserPath)) {
                    zoo.recursiveDelete(this.ZKUserPath + "/" + user + "/Namespaces" + "/" + namespace, ZooUtil.NodeMissingPolicy.SKIP);
                }
            }
        }
        catch (KeeperException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new AccumuloSecurityException("unknownUser", SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void initializeSecurity(TCredentials itw, String rootuser) throws AccumuloSecurityException {
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        TreeSet<SystemPermission> rootPerms = new TreeSet<SystemPermission>();
        for (SystemPermission p : SystemPermission.values()) {
            rootPerms.add(p);
        }
        HashMap<String, Set<TablePermission>> tablePerms = new HashMap<String, Set<TablePermission>>();
        tablePerms.put("+r", Collections.singleton(TablePermission.ALTER_TABLE));
        tablePerms.put("!0", Collections.singleton(TablePermission.ALTER_TABLE));
        HashMap<String, Set<NamespacePermission>> namespacePerms = new HashMap<String, Set<NamespacePermission>>();
        namespacePerms.put("+accumulo", Collections.singleton(NamespacePermission.ALTER_NAMESPACE));
        namespacePerms.put("+accumulo", Collections.singleton(NamespacePermission.ALTER_TABLE));
        try {
            if (!zoo.exists(this.ZKUserPath)) {
                zoo.putPersistentData(this.ZKUserPath, rootuser.getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.FAIL);
            }
            this.initUser(rootuser);
            zoo.putPersistentData(this.ZKUserPath + "/" + rootuser + "/System", ZKSecurityTool.convertSystemPermissions(rootPerms), ZooUtil.NodeExistsPolicy.FAIL);
            for (Map.Entry entry : tablePerms.entrySet()) {
                this.createTablePerm(rootuser, (String)entry.getKey(), (Set)entry.getValue());
            }
            for (Map.Entry entry : namespacePerms.entrySet()) {
                this.createNamespacePerm(rootuser, (String)entry.getKey(), (Set)entry.getValue());
            }
        }
        catch (KeeperException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void initUser(String user) throws AccumuloSecurityException {
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        try {
            zoo.putPersistentData(this.ZKUserPath + "/" + user, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
            zoo.putPersistentData(this.ZKUserPath + "/" + user + "/Tables", new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
            zoo.putPersistentData(this.ZKUserPath + "/" + user + "/Namespaces", new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
        }
        catch (KeeperException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new AccumuloSecurityException(user, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTablePerm(String user, String table, Set<TablePermission> perms) throws KeeperException, InterruptedException {
        ZooCache zooCache = this.zooCache;
        synchronized (zooCache) {
            this.zooCache.clear();
            ZooReaderWriter.getInstance().putPersistentData(this.ZKUserPath + "/" + user + "/Tables" + "/" + table, ZKSecurityTool.convertTablePermissions(perms), ZooUtil.NodeExistsPolicy.FAIL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNamespacePerm(String user, String namespace, Set<NamespacePermission> perms) throws KeeperException, InterruptedException {
        ZooCache zooCache = this.zooCache;
        synchronized (zooCache) {
            this.zooCache.clear();
            ZooReaderWriter.getInstance().putPersistentData(this.ZKUserPath + "/" + user + "/Namespaces" + "/" + namespace, ZKSecurityTool.convertNamespacePermissions(perms), ZooUtil.NodeExistsPolicy.FAIL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUser(String user) throws AccumuloSecurityException {
        try {
            ZooCache zooCache = this.zooCache;
            synchronized (zooCache) {
                ZooReaderWriter zoo = ZooReaderWriter.getInstance();
                zoo.recursiveDelete(this.ZKUserPath + "/" + user + "/System", ZooUtil.NodeMissingPolicy.SKIP);
                zoo.recursiveDelete(this.ZKUserPath + "/" + user + "/Tables", ZooUtil.NodeMissingPolicy.SKIP);
                zoo.recursiveDelete(this.ZKUserPath + "/" + user + "/Namespaces", ZooUtil.NodeMissingPolicy.SKIP);
                this.zooCache.clear(this.ZKUserPath + "/" + user);
            }
        }
        catch (InterruptedException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
        catch (KeeperException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
            if (e.code().equals((Object)KeeperException.Code.NONODE)) {
                throw new AccumuloSecurityException(user, SecurityErrorCode.USER_DOESNT_EXIST, (Throwable)e);
            }
            throw new AccumuloSecurityException(user, SecurityErrorCode.CONNECTION_ERROR, (Throwable)e);
        }
    }

    @Override
    public boolean hasSystemPermission(String user, SystemPermission permission) throws AccumuloSecurityException {
        byte[] perms;
        try {
            String path = this.ZKUserPath + "/" + user + "/System";
            ZooReaderWriter.getInstance().sync(path);
            perms = ZooReaderWriter.getInstance().getData(path, null);
        }
        catch (KeeperException e) {
            if (e.code() == KeeperException.Code.NONODE) {
                return false;
            }
            log.warn("Unhandled KeeperException, failing closed for table permission check", (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            log.warn("Unhandled InterruptedException, failing closed for table permission check", (Throwable)e);
            return false;
        }
        if (perms == null) {
            return false;
        }
        return ZKSecurityTool.convertSystemPermissions(perms).contains(permission);
    }

    @Override
    public boolean hasCachedSystemPermission(String user, SystemPermission permission) throws AccumuloSecurityException {
        byte[] perms = this.zooCache.get(this.ZKUserPath + "/" + user + "/System");
        if (perms == null) {
            return false;
        }
        return ZKSecurityTool.convertSystemPermissions(perms).contains(permission);
    }

    @Override
    public boolean validSecurityHandlers(Authenticator authent, Authorizor author) {
        return true;
    }

    @Override
    public void initTable(String table) throws AccumuloSecurityException {
    }
}

