/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.init;

import com.beust.jcommander.Parameter;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import jline.console.ConsoleReader;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.iterators.Combiner;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.user.VersioningIterator;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.master.thrift.MasterGoalState;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.ColumnFQ;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.volume.VolumeConfiguration;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.Accumulo;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.constraints.MetadataConstraints;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.iterators.MetadataBulkLoadFilter;
import org.apache.accumulo.server.replication.ReplicationUtil;
import org.apache.accumulo.server.replication.StatusCombiner;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.security.SecurityUtil;
import org.apache.accumulo.server.tables.TableManager;
import org.apache.accumulo.server.util.ChangeSecret;
import org.apache.accumulo.server.util.TablePropUtil;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Initialize
implements KeywordExecutable {
    private static final Logger log = LoggerFactory.getLogger(Initialize.class);
    private static final String DEFAULT_ROOT_USER = "root";
    private static final String TABLE_TABLETS_TABLET_DIR = "/table_info";
    private static ConsoleReader reader = null;
    private static IZooReaderWriter zoo = null;
    private static HashMap<String, String> initialMetadataConf = new HashMap();
    private static HashMap<String, String> initialMetadataCombinerConf = new HashMap();
    private static HashMap<String, String> initialReplicationTableConf = new HashMap();

    private static ConsoleReader getConsoleReader() throws IOException {
        if (reader == null) {
            reader = new ConsoleReader();
        }
        return reader;
    }

    static void setZooReaderWriter(IZooReaderWriter izoo) {
        zoo = izoo;
    }

    static IZooReaderWriter getZooReaderWriter() {
        return zoo;
    }

    static boolean checkInit(Configuration conf, VolumeManager fs, SiteConfiguration sconf) throws IOException {
        String fsUri = sconf.get(Property.INSTANCE_DFS_URI);
        if (fsUri.equals("")) {
            fsUri = FileSystem.getDefaultUri((Configuration)conf).toString();
        }
        log.info("Hadoop Filesystem is " + fsUri);
        log.info("Accumulo data dirs are " + Arrays.asList(VolumeConfiguration.getVolumeUris((AccumuloConfiguration)SiteConfiguration.getInstance())));
        log.info("Zookeeper server is " + sconf.get(Property.INSTANCE_ZK_HOST));
        log.info("Checking if Zookeeper is available. If this hangs, then you need to make sure zookeeper is running");
        if (!Initialize.zookeeperAvailable()) {
            log.error("FATAL Zookeeper needs to be up and running in order to init. Exiting ...");
            return false;
        }
        if (sconf.get(Property.INSTANCE_SECRET).equals(Property.INSTANCE_SECRET.getDefaultValue())) {
            ConsoleReader c = Initialize.getConsoleReader();
            c.beep();
            c.println();
            c.println();
            c.println((CharSequence)"Warning!!! Your instance secret is still set to the default, this is not secure. We highly recommend you change it.");
            c.println();
            c.println();
            c.println((CharSequence)"You can change the instance secret in accumulo by using:");
            c.println((CharSequence)("   bin/accumulo " + ChangeSecret.class.getName() + " oldPassword newPassword."));
            c.println((CharSequence)"You will also need to edit your secret in your configuration file by adding the property instance.secret to your conf/accumulo-site.xml. Without this accumulo will not operate correctly");
        }
        try {
            if (Initialize.isInitialized(fs)) {
                Initialize.printInitializeFailureMessages(sconf);
                return false;
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to check if filesystem already initialized", e);
        }
        return true;
    }

    static void printInitializeFailureMessages(SiteConfiguration sconf) {
        Property INSTANCE_DFS_DIR = Property.INSTANCE_DFS_DIR;
        Property INSTANCE_DFS_URI = Property.INSTANCE_DFS_URI;
        String instanceDfsDir = sconf.get(INSTANCE_DFS_DIR);
        log.error("FATAL It appears the directories " + Arrays.asList(VolumeConfiguration.getVolumeUris((AccumuloConfiguration)SiteConfiguration.getInstance())) + " were previously initialized.");
        String instanceVolumes = sconf.get(Property.INSTANCE_VOLUMES);
        String instanceDfsUri = sconf.get(INSTANCE_DFS_URI);
        if (!instanceVolumes.isEmpty()) {
            log.error("FATAL: Change the property " + Property.INSTANCE_VOLUMES + " to use different filesystems,");
        } else if (!instanceDfsDir.isEmpty()) {
            log.error("FATAL: Change the property " + INSTANCE_DFS_URI + " to use a different filesystem,");
        } else {
            log.error("FATAL: You are using the default URI for the filesystem. Set the property " + Property.INSTANCE_VOLUMES + " to use a different filesystem,");
        }
        log.error("FATAL: or change the property " + INSTANCE_DFS_DIR + " to use a different directory.");
        log.error("FATAL: The current value of " + INSTANCE_DFS_URI + " is |" + instanceDfsUri + "|");
        log.error("FATAL: The current value of " + INSTANCE_DFS_DIR + " is |" + instanceDfsDir + "|");
        log.error("FATAL: The current value of " + Property.INSTANCE_VOLUMES + " is |" + instanceVolumes + "|");
    }

    public boolean doInit(Opts opts, Configuration conf, VolumeManager fs) throws IOException {
        String rootUser;
        String instanceNamePath;
        if (!Initialize.checkInit(conf, fs, SiteConfiguration.getInstance())) {
            return false;
        }
        try {
            instanceNamePath = this.getInstanceNamePath(opts);
        }
        catch (Exception e) {
            log.error("FATAL: Failed to talk to zookeeper", (Throwable)e);
            return false;
        }
        try {
            rootUser = this.getRootUserName(opts);
        }
        catch (Exception e) {
            log.error("FATAL: Failed to obtain user for administrative privileges");
            return false;
        }
        SiteConfiguration siteConf = SiteConfiguration.getInstance();
        opts.rootpass = siteConf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED) ? UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8) : this.getRootPassword(opts, rootUser);
        return this.initialize(opts, instanceNamePath, fs, rootUser);
    }

    @SuppressModernizer
    private boolean initialize(Opts opts, String instanceNamePath, VolumeManager fs, String rootUser) {
        UUID uuid = UUID.randomUUID();
        String[] configuredVolumes = VolumeConfiguration.getVolumeUris((AccumuloConfiguration)SiteConfiguration.getInstance());
        String rootTabletDir = new Path(fs.choose((Optional<String>)Optional.absent(), configuredVolumes) + "/" + "tables" + "/" + "+r" + "/root_tablet").toString();
        try {
            Initialize.initZooKeeper(opts, uuid.toString(), instanceNamePath, rootTabletDir);
        }
        catch (Exception e) {
            log.error("FATAL: Failed to initialize zookeeper", (Throwable)e);
            return false;
        }
        try {
            this.initFileSystem(opts, fs, uuid, rootTabletDir);
        }
        catch (Exception e) {
            log.error("FATAL Failed to initialize filesystem", (Throwable)e);
            if (SiteConfiguration.getInstance().get(Property.INSTANCE_VOLUMES).trim().equals("")) {
                Configuration fsConf = CachedConfiguration.getInstance();
                String defaultFsUri = "file:///";
                String fsDefaultName = fsConf.get("fs.default.name", "file:///");
                String fsDefaultFS = fsConf.get("fs.defaultFS", "file:///");
                if ("file:///".equals(fsDefaultName) && "file:///".equals(fsDefaultFS)) {
                    log.error("FATAL: Default filesystem value ('fs.defaultFS' or 'fs.default.name') of 'file:///' was found in the Hadoop configuration");
                    log.error("FATAL: Please ensure that the Hadoop core-site.xml is on the classpath using 'general.classpaths' in accumulo-site.xml");
                }
            }
            return false;
        }
        ServerConfigurationFactory confFactory = new ServerConfigurationFactory(HdfsZooInstance.getInstance());
        try {
            UserGroupInformation ugi;
            SiteConfiguration siteConf = confFactory.getSiteConfiguration();
            if (siteConf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED) && !(ugi = UserGroupInformation.getCurrentUser()).hasKerberosCredentials()) {
                String accumuloKeytab = siteConf.get(Property.GENERAL_KERBEROS_KEYTAB);
                String accumuloPrincipal = siteConf.get(Property.GENERAL_KERBEROS_PRINCIPAL);
                if (StringUtils.isBlank((String)accumuloKeytab) || StringUtils.isBlank((String)accumuloPrincipal)) {
                    log.error("FATAL: No Kerberos credentials provided, and Accumulo is not properly configured for server login");
                    return false;
                }
                log.info("Logging in as " + accumuloPrincipal + " with " + accumuloKeytab);
                UserGroupInformation.loginUserFromKeytab((String)accumuloPrincipal, (String)accumuloKeytab);
            }
        }
        catch (IOException e) {
            log.error("FATAL: Failed to get the Kerberos user", (Throwable)e);
            return false;
        }
        try {
            AccumuloServerContext context = new AccumuloServerContext(confFactory);
            Initialize.initSecurity(context, opts, uuid.toString(), rootUser);
        }
        catch (Exception e) {
            log.error("FATAL: Failed to initialize security", (Throwable)e);
            return false;
        }
        return true;
    }

    private static boolean zookeeperAvailable() {
        try {
            return zoo.exists("/");
        }
        catch (KeeperException e) {
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private static void initDirs(VolumeManager fs, UUID uuid, String[] baseDirs, boolean print) throws IOException {
        for (String baseDir : baseDirs) {
            fs.mkdirs(new Path(new Path(baseDir, "version"), "8"), new FsPermission("700"));
            Path iidLocation = new Path(baseDir, "instance_id");
            fs.mkdirs(iidLocation);
            fs.createNewFile(new Path(iidLocation, uuid.toString()));
            if (!print) continue;
            log.info("Initialized volume " + baseDir);
        }
    }

    @SuppressModernizer
    private void initFileSystem(Opts opts, VolumeManager fs, UUID uuid, String rootTabletDir) throws IOException {
        Initialize.initDirs(fs, uuid, VolumeConfiguration.getVolumeUris((AccumuloConfiguration)SiteConfiguration.getInstance()), false);
        Initialize.initSystemTablesConfig();
        String tableMetadataTabletDir = fs.choose((Optional<String>)Optional.absent(), ServerConstants.getBaseUris()) + "/tables" + "/" + "!0" + TABLE_TABLETS_TABLET_DIR;
        String replicationTableDefaultTabletDir = fs.choose((Optional<String>)Optional.absent(), ServerConstants.getBaseUris()) + "/tables" + "/" + "+rep" + "/default_tablet";
        String defaultMetadataTabletDir = fs.choose((Optional<String>)Optional.absent(), ServerConstants.getBaseUris()) + "/tables" + "/" + "!0" + "/default_tablet";
        Initialize.createDirectories(fs, rootTabletDir, tableMetadataTabletDir, defaultMetadataTabletDir, replicationTableDefaultTabletDir);
        String ext = FileOperations.getNewFileExtension((AccumuloConfiguration)AccumuloConfiguration.getDefaultConfiguration());
        String metadataFileName = tableMetadataTabletDir + "/" + "0_1." + ext;
        Tablet replicationTablet = new Tablet("+rep", replicationTableDefaultTabletDir, null, null, new String[0]);
        Initialize.createMetadataFile(fs, metadataFileName, replicationTablet);
        String rootTabletFileName = rootTabletDir + "/" + "00000_00000." + ext;
        Text splitPoint = MetadataSchema.TabletsSection.getRange().getEndKey().getRow();
        Tablet tablesTablet = new Tablet("!0", tableMetadataTabletDir, null, splitPoint, metadataFileName);
        Tablet defaultTablet = new Tablet("!0", defaultMetadataTabletDir, splitPoint, null, new String[0]);
        Initialize.createMetadataFile(fs, rootTabletFileName, tablesTablet, defaultTablet);
    }

    private static void createMetadataFile(VolumeManager volmanager, String fileName, Tablet ... tablets) throws IOException {
        TreeMap<Key, Value> sorted = new TreeMap<Key, Value>();
        for (Tablet tablet : tablets) {
            Initialize.createEntriesForTablet(sorted, tablet);
        }
        FileSystem fs = volmanager.getVolumeByPath(new Path(fileName)).getFileSystem();
        FileSKVWriter tabletWriter = ((FileOperations.OpenWriterOperationBuilder)FileOperations.getInstance().newWriterBuilder().forFile(fileName, fs, fs.getConf()).withTableConfiguration((AccumuloConfiguration)AccumuloConfiguration.getDefaultConfiguration())).build();
        tabletWriter.startDefaultLocalityGroup();
        for (Map.Entry<Key, Value> entry : sorted.entrySet()) {
            tabletWriter.append(entry.getKey(), entry.getValue());
        }
        tabletWriter.close();
    }

    private static void createEntriesForTablet(TreeMap<Key, Value> map, Tablet tablet) {
        Value EMPTY_SIZE = new DataFileValue(0L, 0L).encodeAsValue();
        Text extent = new Text(KeyExtent.getMetadataEntry((String)tablet.tableId, (Text)tablet.endRow));
        Initialize.addEntry(map, extent, MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN, new Value(tablet.dir.getBytes(StandardCharsets.UTF_8)));
        Initialize.addEntry(map, extent, MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN, new Value("L0".getBytes(StandardCharsets.UTF_8)));
        Initialize.addEntry(map, extent, MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN, KeyExtent.encodePrevEndRow((Text)tablet.prevEndRow));
        for (String file : tablet.files) {
            Initialize.addEntry(map, extent, new ColumnFQ(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, new Text(file)), EMPTY_SIZE);
        }
    }

    private static void addEntry(TreeMap<Key, Value> map, Text row, ColumnFQ col, Value value) {
        map.put(new Key(row, col.getColumnFamily(), col.getColumnQualifier(), 0L), value);
    }

    private static void createDirectories(VolumeManager fs, String ... dirs) throws IOException {
        for (String s : dirs) {
            Path dir = new Path(s);
            try {
                FileStatus fstat = fs.getFileStatus(dir);
                if (fstat.isDirectory()) continue;
                log.error("FATAL: location " + dir + " exists but is not a directory");
                return;
            }
            catch (FileNotFoundException fnfe) {
                if (fs.mkdirs(dir)) continue;
                log.error("FATAL: unable to create directory " + dir);
                return;
            }
        }
    }

    private static void initZooKeeper(Opts opts, String uuid, String instanceNamePath, String rootTabletDir) throws KeeperException, InterruptedException {
        zoo.putPersistentData("/accumulo", new byte[0], -1, ZooUtil.NodeExistsPolicy.SKIP, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
        zoo.putPersistentData("/accumulo/instances", new byte[0], -1, ZooUtil.NodeExistsPolicy.SKIP, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
        if (opts.clearInstanceName) {
            zoo.recursiveDelete(instanceNamePath, ZooUtil.NodeMissingPolicy.SKIP);
        }
        zoo.putPersistentData(instanceNamePath, uuid.getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.FAIL);
        byte[] EMPTY_BYTE_ARRAY = new byte[]{};
        byte[] ZERO_CHAR_ARRAY = new byte[]{48};
        String zkInstanceRoot = "/accumulo/" + uuid;
        zoo.putPersistentData(zkInstanceRoot, EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/tables", Constants.ZTABLES_INITIAL_ID, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/namespaces", new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
        TableManager.prepareNewNamespaceState(uuid, "+default", "", ZooUtil.NodeExistsPolicy.FAIL);
        TableManager.prepareNewNamespaceState(uuid, "+accumulo", "accumulo", ZooUtil.NodeExistsPolicy.FAIL);
        TableManager.prepareNewTableState(uuid, "+r", "+accumulo", "accumulo.root", TableState.ONLINE, ZooUtil.NodeExistsPolicy.FAIL);
        TableManager.prepareNewTableState(uuid, "!0", "+accumulo", "accumulo.metadata", TableState.ONLINE, ZooUtil.NodeExistsPolicy.FAIL);
        TableManager.prepareNewTableState(uuid, "+rep", "+accumulo", "accumulo.replication", TableState.OFFLINE, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/tservers", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/problems", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/root_tablet", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/root_tablet/walogs", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/root_tablet/current_logs", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/root_tablet/dir", rootTabletDir.getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/masters", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/masters/lock", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/masters/goal_state", MasterGoalState.NORMAL.toString().getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/gc", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/gc/lock", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/config", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/table_locks", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/hdfs_reservations", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/next_file", ZERO_CHAR_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/recovery", ZERO_CHAR_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/monitor", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/monitor/lock", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/replication", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/replication/tservers", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/wals", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
    }

    private String getInstanceNamePath(Opts opts) throws IOException, KeeperException, InterruptedException {
        String instanceNamePath = null;
        boolean exists = true;
        do {
            String instanceName;
            if ((instanceName = opts.cliInstanceName == null ? Initialize.getConsoleReader().readLine("Instance name : ") : opts.cliInstanceName) == null) {
                System.exit(0);
            }
            if ((instanceName = instanceName.trim()).length() == 0) continue;
            instanceNamePath = "/accumulo/instances/" + instanceName;
            if (opts.clearInstanceName) {
                exists = false;
                break;
            }
            exists = zoo.exists(instanceNamePath);
            if (!exists) continue;
            String decision = Initialize.getConsoleReader().readLine("Instance name \"" + instanceName + "\" exists. Delete existing entry from zookeeper? [Y/N] : ");
            if (decision == null) {
                System.exit(0);
            }
            if (decision.length() != 1 || decision.toLowerCase(Locale.ENGLISH).charAt(0) != 'y') continue;
            opts.clearInstanceName = true;
            exists = false;
        } while (exists);
        return instanceNamePath;
    }

    private String getRootUserName(Opts opts) throws IOException {
        String user;
        SiteConfiguration conf = SiteConfiguration.getInstance();
        String keytab = conf.get(Property.GENERAL_KERBEROS_KEYTAB);
        if (keytab.equals(Property.GENERAL_KERBEROS_KEYTAB.getDefaultValue()) || !conf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
            return DEFAULT_ROOT_USER;
        }
        ConsoleReader c = Initialize.getConsoleReader();
        c.println((CharSequence)"Running against secured HDFS");
        if (null != opts.rootUser) {
            return opts.rootUser;
        }
        do {
            if ((user = c.readLine("Principal (user) to grant administrative privileges to : ")) != null) continue;
            System.exit(1);
        } while (user.isEmpty());
        return user;
    }

    private byte[] getRootPassword(Opts opts, String rootUser) throws IOException {
        String confirmpass;
        String rootpass;
        if (opts.cliPassword != null) {
            return opts.cliPassword.getBytes(StandardCharsets.UTF_8);
        }
        do {
            if ((rootpass = Initialize.getConsoleReader().readLine("Enter initial password for " + rootUser + " (this may not be applicable for your security setup): ", Character.valueOf('*'))) == null) {
                System.exit(0);
            }
            if ((confirmpass = Initialize.getConsoleReader().readLine("Confirm initial password for " + rootUser + ": ", Character.valueOf('*'))) == null) {
                System.exit(0);
            }
            if (rootpass.equals(confirmpass)) continue;
            log.error("Passwords do not match");
        } while (!rootpass.equals(confirmpass));
        return rootpass.getBytes(StandardCharsets.UTF_8);
    }

    private static void initSecurity(AccumuloServerContext context, Opts opts, String iid, String rootUser) throws AccumuloSecurityException, ThriftSecurityException, IOException {
        AuditedSecurityOperation.getInstance(context, true).initializeSecurity(context.rpcCreds(), rootUser, opts.rootpass);
    }

    public static void initSystemTablesConfig() throws IOException {
        try {
            Configuration conf = CachedConfiguration.getInstance();
            int max = conf.getInt("dfs.replication.max", 512);
            int min = Math.max(conf.getInt("dfs.replication.min", 1), conf.getInt("dfs.namenode.replication.min", 1));
            if (max < 5) {
                Initialize.setMetadataReplication(max, "max");
            }
            if (min > 5) {
                Initialize.setMetadataReplication(min, "min");
            }
            for (Map.Entry<String, String> entry : initialMetadataConf.entrySet()) {
                if (!TablePropUtil.setTableProperty("+r", entry.getKey(), entry.getValue())) {
                    throw new IOException("Cannot create per-table property " + entry.getKey());
                }
                if (TablePropUtil.setTableProperty("!0", entry.getKey(), entry.getValue())) continue;
                throw new IOException("Cannot create per-table property " + entry.getKey());
            }
            for (Map.Entry<String, String> entry : initialMetadataCombinerConf.entrySet()) {
                if (TablePropUtil.setTableProperty("!0", entry.getKey(), entry.getValue())) continue;
                throw new IOException("Cannot create per-table property " + entry.getKey());
            }
            for (Map.Entry<String, String> entry : initialReplicationTableConf.entrySet()) {
                if (TablePropUtil.setTableProperty("+rep", entry.getKey(), entry.getValue())) continue;
                throw new IOException("Cannot create per-table property " + entry.getKey());
            }
        }
        catch (Exception e) {
            log.error("FATAL: Error talking to ZooKeeper", (Throwable)e);
            throw new IOException(e);
        }
    }

    private static void setMetadataReplication(int replication, String reason) throws IOException {
        String rep = Initialize.getConsoleReader().readLine("Your HDFS replication " + reason + " is not compatible with our default " + "accumulo.metadata" + " replication of 5. What do you want to set your " + "accumulo.metadata" + " replication to? (" + replication + ") ");
        if (rep == null || rep.length() == 0) {
            rep = Integer.toString(replication);
        } else {
            Integer.parseInt(rep);
        }
        initialMetadataConf.put(Property.TABLE_FILE_REPLICATION.getKey(), rep);
    }

    public static boolean isInitialized(VolumeManager fs) throws IOException {
        for (String baseDir : VolumeConfiguration.getVolumeUris((AccumuloConfiguration)SiteConfiguration.getInstance())) {
            if (!fs.exists(new Path(baseDir, "instance_id")) && !fs.exists(new Path(baseDir, "version"))) continue;
            return true;
        }
        return false;
    }

    private static void addVolumes(VolumeManager fs) throws IOException {
        String[] volumeURIs = VolumeConfiguration.getVolumeUris((AccumuloConfiguration)SiteConfiguration.getInstance());
        HashSet<String> initializedDirs = new HashSet<String>();
        initializedDirs.addAll(Arrays.asList(ServerConstants.checkBaseUris(volumeURIs, true)));
        HashSet<String> uinitializedDirs = new HashSet<String>();
        uinitializedDirs.addAll(Arrays.asList(volumeURIs));
        uinitializedDirs.removeAll(initializedDirs);
        Path aBasePath = new Path((String)initializedDirs.iterator().next());
        Path iidPath = new Path(aBasePath, "instance_id");
        Path versionPath = new Path(aBasePath, "version");
        UUID uuid = UUID.fromString(ZooUtil.getInstanceIDFromHdfs((Path)iidPath, (AccumuloConfiguration)SiteConfiguration.getInstance()));
        for (Pair<Path, Path> replacementVolume : ServerConstants.getVolumeReplacements()) {
            if (!aBasePath.equals(replacementVolume.getFirst())) continue;
            log.error(aBasePath + " is set to be replaced in " + Property.INSTANCE_VOLUMES_REPLACEMENTS + " and should not appear in " + Property.INSTANCE_VOLUMES + ". It is highly recommended that this property be removed as data could still be written to this volume.");
        }
        if (8 != Accumulo.getAccumuloPersistentVersion(versionPath.getFileSystem(CachedConfiguration.getInstance()), versionPath)) {
            throw new IOException("Accumulo 1.10.3 cannot initialize data version " + Accumulo.getAccumuloPersistentVersion(fs));
        }
        Initialize.initDirs(fs, uuid, uinitializedDirs.toArray(new String[uinitializedDirs.size()]), true);
    }

    public String keyword() {
        return "init";
    }

    public void execute(String[] args) {
        Opts opts = new Opts();
        opts.parseArgs(Initialize.class.getName(), args, new Object[0]);
        try {
            zoo = ZooReaderWriter.getInstance();
            SiteConfiguration acuConf = SiteConfiguration.getInstance();
            SecurityUtil.serverLogin((AccumuloConfiguration)acuConf);
            Configuration conf = CachedConfiguration.getInstance();
            VolumeManager fs = VolumeManagerImpl.get((AccumuloConfiguration)acuConf);
            if (opts.resetSecurity) {
                AccumuloServerContext context = new AccumuloServerContext(new ServerConfigurationFactory(HdfsZooInstance.getInstance()));
                if (Initialize.isInitialized(fs)) {
                    String rootUser = this.getRootUserName(opts);
                    opts.rootpass = this.getRootPassword(opts, rootUser);
                    Initialize.initSecurity(context, opts, HdfsZooInstance.getInstance().getInstanceID(), rootUser);
                } else {
                    log.error("FATAL: Attempted to reset security on accumulo before it was initialized");
                }
            }
            if (opts.addVolumes) {
                Initialize.addVolumes(fs);
            }
            if (!(opts.resetSecurity || opts.addVolumes || this.doInit(opts, conf, fs))) {
                System.exit(-1);
            }
        }
        catch (Exception e) {
            log.error("Fatal exception", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        new Initialize().execute(args);
    }

    static {
        initialMetadataConf.put(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE.getKey(), "32K");
        initialMetadataConf.put(Property.TABLE_FILE_REPLICATION.getKey(), "5");
        initialMetadataConf.put(Property.TABLE_DURABILITY.getKey(), "sync");
        initialMetadataConf.put(Property.TABLE_MAJC_RATIO.getKey(), "1");
        initialMetadataConf.put(Property.TABLE_SPLIT_THRESHOLD.getKey(), "64M");
        initialMetadataConf.put(Property.TABLE_CONSTRAINT_PREFIX.getKey() + "1", MetadataConstraints.class.getName());
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "scan.vers", "10," + VersioningIterator.class.getName());
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "scan.vers.opt.maxVersions", "1");
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "minc.vers", "10," + VersioningIterator.class.getName());
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "minc.vers.opt.maxVersions", "1");
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "majc.vers", "10," + VersioningIterator.class.getName());
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "majc.vers.opt.maxVersions", "1");
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "majc.bulkLoadFilter", "20," + MetadataBulkLoadFilter.class.getName());
        initialMetadataConf.put(Property.TABLE_FAILURES_IGNORE.getKey(), "false");
        initialMetadataConf.put(Property.TABLE_LOCALITY_GROUP_PREFIX.getKey() + "tablet", String.format("%s,%s", MetadataSchema.TabletsSection.TabletColumnFamily.NAME, MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME));
        initialMetadataConf.put(Property.TABLE_LOCALITY_GROUP_PREFIX.getKey() + "server", String.format("%s,%s,%s,%s", MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, MetadataSchema.TabletsSection.LogColumnFamily.NAME, MetadataSchema.TabletsSection.ServerColumnFamily.NAME, MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME));
        initialMetadataConf.put(Property.TABLE_LOCALITY_GROUPS.getKey(), "tablet,server");
        initialMetadataConf.put(Property.TABLE_DEFAULT_SCANTIME_VISIBILITY.getKey(), "");
        initialMetadataConf.put(Property.TABLE_INDEXCACHE_ENABLED.getKey(), "true");
        initialMetadataConf.put(Property.TABLE_BLOCKCACHE_ENABLED.getKey(), "true");
        IteratorSetting setting = new IteratorSetting(9, "replcombiner", StatusCombiner.class);
        Combiner.setColumns((IteratorSetting)setting, Collections.singletonList(new IteratorSetting.Column(MetadataSchema.ReplicationSection.COLF)));
        for (IteratorUtil.IteratorScope scope : IteratorUtil.IteratorScope.values()) {
            String root = String.format("%s%s.%s", Property.TABLE_ITERATOR_PREFIX, scope.name().toLowerCase(), setting.getName());
            for (Map.Entry prop : setting.getOptions().entrySet()) {
                initialMetadataCombinerConf.put(root + ".opt." + (String)prop.getKey(), (String)prop.getValue());
            }
            initialMetadataCombinerConf.put(root, setting.getPriority() + "," + setting.getIteratorClass());
        }
        setting = new IteratorSetting(30, "statuscombiner", StatusCombiner.class);
        setting.setPriority(30);
        Combiner.setColumns((IteratorSetting)setting, Arrays.asList(new IteratorSetting.Column(ReplicationSchema.StatusSection.NAME), new IteratorSetting.Column(ReplicationSchema.WorkSection.NAME)));
        for (IteratorUtil.IteratorScope iteratorScope : EnumSet.allOf(IteratorUtil.IteratorScope.class)) {
            String root = String.format("%s%s.%s", Property.TABLE_ITERATOR_PREFIX, iteratorScope.name().toLowerCase(), setting.getName());
            for (Map.Entry prop : setting.getOptions().entrySet()) {
                initialReplicationTableConf.put(root + ".opt." + (String)prop.getKey(), (String)prop.getValue());
            }
            initialReplicationTableConf.put(root, setting.getPriority() + "," + setting.getIteratorClass());
        }
        for (Map.Entry entry : ReplicationTable.LOCALITY_GROUPS.entrySet()) {
            initialReplicationTableConf.put(Property.TABLE_LOCALITY_GROUP_PREFIX + (String)entry.getKey(), LocalityGroupUtil.encodeColumnFamilies((Set)((Set)entry.getValue())));
        }
        initialReplicationTableConf.put(Property.TABLE_LOCALITY_GROUPS.getKey(), Joiner.on((String)",").join(ReplicationTable.LOCALITY_GROUPS.keySet()));
        initialReplicationTableConf.put(Property.TABLE_FORMATTER_CLASS.getKey(), ReplicationUtil.STATUS_FORMATTER_CLASS_NAME);
    }

    static class Opts
    extends Help {
        @Parameter(names={"--add-volumes"}, description="Initialize any uninitialized volumes listed in instance.volumes")
        boolean addVolumes = false;
        @Parameter(names={"--reset-security"}, description="just update the security information")
        boolean resetSecurity = false;
        @Parameter(names={"--clear-instance-name"}, description="delete any existing instance name without prompting")
        boolean clearInstanceName = false;
        @Parameter(names={"--instance-name"}, description="the instance name, if not provided, will prompt")
        String cliInstanceName;
        @Parameter(names={"--password"}, description="set the password on the command line")
        String cliPassword;
        @Parameter(names={"-u", "--user"}, description="the name of the user to grant system permissions to")
        String rootUser = null;
        byte[] rootpass = null;

        Opts() {
        }
    }

    private static class Tablet {
        String tableId;
        String dir;
        Text prevEndRow;
        Text endRow;
        String[] files;

        Tablet(String tableId, String dir, Text prevEndRow, Text endRow, String ... files) {
            this.tableId = tableId;
            this.dir = dir;
            this.prevEndRow = prevEndRow;
            this.endRow = endRow;
            this.files = files;
        }
    }
}

