/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.mapreduce.bulk;

import com.beust.jcommander.Parameter;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Base64;
import java.util.Collection;
import org.apache.accumulo.core.cli.MapReduceClientOnRequiredTable;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.mapreduce.AccumuloFileOutputFormat;
import org.apache.accumulo.core.client.mapreduce.lib.partition.RangePartitioner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class BulkIngestExample
extends Configured
implements Tool {
    public int run(String[] args) {
        Opts opts = new Opts();
        opts.parseArgs(BulkIngestExample.class.getName(), args, new Object[0]);
        Configuration conf = this.getConf();
        try (PrintStream out = null;){
            Job job = Job.getInstance((Configuration)conf);
            job.setJobName("bulk ingest example");
            job.setJarByClass(((Object)((Object)this)).getClass());
            job.setInputFormatClass(TextInputFormat.class);
            job.setMapperClass(MapClass.class);
            job.setMapOutputKeyClass(Text.class);
            job.setMapOutputValueClass(Text.class);
            job.setReducerClass(ReduceClass.class);
            job.setOutputFormatClass(AccumuloFileOutputFormat.class);
            opts.setAccumuloConfigs(job);
            Connector connector = opts.getConnector();
            TextInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(opts.inputDir)});
            AccumuloFileOutputFormat.setOutputPath((Job)job, (Path)new Path(opts.workDir + "/files"));
            FileSystem fs = FileSystem.get((Configuration)conf);
            out = new PrintStream(new BufferedOutputStream((OutputStream)fs.create(new Path(opts.workDir + "/splits.txt"))));
            Collection splits = connector.tableOperations().listSplits(opts.getTableName(), 100);
            for (Text split : splits) {
                out.println(Base64.getEncoder().encodeToString(TextUtil.getBytes((Text)split)));
            }
            job.setNumReduceTasks(splits.size() + 1);
            out.close();
            job.setPartitionerClass(RangePartitioner.class);
            RangePartitioner.setSplitFile((Job)job, (String)(opts.workDir + "/splits.txt"));
            job.waitForCompletion(true);
            Path failures = new Path(opts.workDir, "failures");
            fs.delete(failures, true);
            fs.mkdirs(new Path(opts.workDir, "failures"));
            FsShell fsShell = new FsShell(conf);
            fsShell.run(new String[]{"-chmod", "-R", "777", opts.workDir});
            connector.tableOperations().importDirectory(opts.getTableName(), opts.workDir + "/files", opts.workDir + "/failures", false);
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new BulkIngestExample(), (String[])args);
        System.exit(res);
    }

    static class Opts
    extends MapReduceClientOnRequiredTable {
        @Parameter(names={"--inputDir"}, required=true)
        String inputDir;
        @Parameter(names={"--workDir"}, required=true)
        String workDir;

        Opts() {
        }
    }

    public static class ReduceClass
    extends Reducer<Text, Text, Key, Value> {
        public void reduce(Text key, Iterable<Text> values, Reducer.Context output) throws IOException, InterruptedException {
            long timestamp = System.currentTimeMillis();
            int index = 0;
            for (Text value : values) {
                Key outputKey = new Key(key, new Text("colf"), new Text(String.format("col_%07d", index)), timestamp);
                ++index;
                Value outputValue = new Value(value.getBytes(), 0, value.getLength());
                output.write((Object)outputKey, (Object)outputValue);
            }
        }
    }

    public static class MapClass
    extends Mapper<LongWritable, Text, Text, Text> {
        private Text outputKey = new Text();
        private Text outputValue = new Text();

        public void map(LongWritable key, Text value, Mapper.Context output) throws IOException, InterruptedException {
            int index = -1;
            for (int i = 0; i < value.getLength(); ++i) {
                if (value.getBytes()[i] != 9) continue;
                index = i;
                break;
            }
            if (index > 0) {
                this.outputKey.set(value.getBytes(), 0, index);
                this.outputValue.set(value.getBytes(), index + 1, value.getLength() - (index + 1));
                output.write((Object)this.outputKey, (Object)this.outputValue);
            }
        }
    }
}

