/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tserverOps;

import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.server.master.LiveTServerSet;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownTServer
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ShutdownTServer.class);
    private TServerInstance server;
    private boolean force;

    public ShutdownTServer(TServerInstance server, boolean force) {
        this.server = server;
        this.force = force;
    }

    @Override
    public long isReady(long tid, Master master) throws Exception {
        LiveTServerSet.TServerConnection connection;
        if (this.force) {
            return 0L;
        }
        master.shutdownTServer(this.server);
        if (master.onlineTabletServers().contains(this.server) && (connection = master.getConnection(this.server)) != null) {
            try {
                TabletServerStatus status = connection.getTableMap(false);
                if (status.tableMap != null && status.tableMap.isEmpty()) {
                    log.info("tablet server hosts no tablets " + this.server);
                    connection.halt(master.getMasterLock());
                    log.info("tablet server asked to halt " + this.server);
                    return 0L;
                }
            }
            catch (TTransportException status) {
            }
            catch (Exception ex) {
                log.error("Error talking to tablet server " + this.server + ": " + ex);
            }
            return 1000L;
        }
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        if (this.force) {
            String path = ZooUtil.getRoot((Instance)master.getInstance()) + "/tservers" + "/" + this.server.getLocation();
            ZooLock.deleteLock((String)path);
            path = ZooUtil.getRoot((Instance)master.getInstance()) + "/dead/tservers" + "/" + this.server.getLocation();
            ZooReaderWriter zoo = ZooReaderWriter.getInstance();
            zoo.putPersistentData(path, "forced down".getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.OVERWRITE);
        }
        return null;
    }

    @Override
    public void undo(long tid, Master m) throws Exception {
    }
}

