/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.gc.thrift.GCMonitorService;
import org.apache.accumulo.core.gc.thrift.GCStatus;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.tabletserver.thrift.ActiveScan;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.DistributedTrace;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.util.LoggingRunnable;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.monitor.EmbeddedWebServer;
import org.apache.accumulo.monitor.ZooKeeperStatus;
import org.apache.accumulo.monitor.servlets.BulkImportServlet;
import org.apache.accumulo.monitor.servlets.DefaultServlet;
import org.apache.accumulo.monitor.servlets.GcStatusServlet;
import org.apache.accumulo.monitor.servlets.JSONServlet;
import org.apache.accumulo.monitor.servlets.LogServlet;
import org.apache.accumulo.monitor.servlets.MasterServlet;
import org.apache.accumulo.monitor.servlets.OperationServlet;
import org.apache.accumulo.monitor.servlets.ProblemServlet;
import org.apache.accumulo.monitor.servlets.ReplicationServlet;
import org.apache.accumulo.monitor.servlets.ScanServlet;
import org.apache.accumulo.monitor.servlets.ShellServlet;
import org.apache.accumulo.monitor.servlets.TServersServlet;
import org.apache.accumulo.monitor.servlets.TablesServlet;
import org.apache.accumulo.monitor.servlets.VisServlet;
import org.apache.accumulo.monitor.servlets.XMLServlet;
import org.apache.accumulo.monitor.servlets.trace.ListType;
import org.apache.accumulo.monitor.servlets.trace.ShowTrace;
import org.apache.accumulo.monitor.servlets.trace.Summary;
import org.apache.accumulo.server.Accumulo;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.ServerOpts;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.metrics.MetricsSystemHelper;
import org.apache.accumulo.server.monitor.LogService;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.accumulo.server.security.SecurityUtil;
import org.apache.accumulo.server.util.Halt;
import org.apache.accumulo.server.util.TableInfoUtil;
import org.apache.accumulo.server.util.time.SimpleTimer;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.TServiceClientFactory;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Monitor {
    private static final Logger log = LoggerFactory.getLogger(Monitor.class);
    private static final int REFRESH_TIME = 5;
    private static AtomicLong lastRecalc = new AtomicLong(0L);
    private static double totalIngestRate = 0.0;
    private static double totalQueryRate = 0.0;
    private static double totalScanRate = 0.0;
    private static long totalEntries = 0L;
    private static int totalTabletCount = 0;
    private static long totalHoldTime = 0L;
    private static long totalLookups = 0L;
    private static int totalTables = 0;
    private static final int MAX_TIME_PERIOD = 3600000;
    private static final List<Pair<Long, Double>> loadOverTime = Collections.synchronizedList(new MaxList(3600000L));
    private static final List<Pair<Long, Double>> ingestRateOverTime = Collections.synchronizedList(new MaxList(3600000L));
    private static final List<Pair<Long, Double>> ingestByteRateOverTime = Collections.synchronizedList(new MaxList(3600000L));
    private static final List<Pair<Long, Integer>> minorCompactionsOverTime = Collections.synchronizedList(new MaxList(3600000L));
    private static final List<Pair<Long, Integer>> majorCompactionsOverTime = Collections.synchronizedList(new MaxList(3600000L));
    private static final List<Pair<Long, Double>> lookupsOverTime = Collections.synchronizedList(new MaxList(3600000L));
    private static final List<Pair<Long, Long>> queryRateOverTime = Collections.synchronizedList(new MaxList(3600000L));
    private static final List<Pair<Long, Long>> scanRateOverTime = Collections.synchronizedList(new MaxList(3600000L));
    private static final List<Pair<Long, Double>> queryByteRateOverTime = Collections.synchronizedList(new MaxList(3600000L));
    private static final List<Pair<Long, Double>> indexCacheHitRateOverTime = Collections.synchronizedList(new MaxList(3600000L));
    private static final List<Pair<Long, Double>> dataCacheHitRateOverTime = Collections.synchronizedList(new MaxList(3600000L));
    private static EventCounter lookupRateTracker = new EventCounter();
    private static EventCounter indexCacheHitTracker = new EventCounter();
    private static EventCounter indexCacheRequestTracker = new EventCounter();
    private static EventCounter dataCacheHitTracker = new EventCounter();
    private static EventCounter dataCacheRequestTracker = new EventCounter();
    private static volatile boolean fetching = false;
    private static MasterMonitorInfo mmi;
    private static Map<String, Map<ProblemType, Integer>> problemSummary;
    private static Exception problemException;
    private static GCStatus gcStatus;
    private static Instance instance;
    private static ServerConfigurationFactory config;
    private static AccumuloServerContext context;
    private static EmbeddedWebServer server;
    private ZooLock monitorLock;
    private static final String DEFAULT_INSTANCE_NAME = "(Unavailable)";
    public static final AtomicReference<String> cachedInstanceName;
    private static long START_TIME;
    static final Map<HostAndPort, ScanStats> allScans;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fetchData() {
        double totalIngestRate = 0.0;
        double totalIngestByteRate = 0.0;
        double totalQueryRate = 0.0;
        double totalQueryByteRate = 0.0;
        double totalScanRate = 0.0;
        long totalEntries = 0L;
        int totalTabletCount = 0;
        long totalHoldTime = 0L;
        long totalLookups = 0L;
        boolean retry = true;
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastRecalc.get() < 5000L) {
            return;
        }
        Class<Monitor> clazz = Monitor.class;
        synchronized (Monitor.class) {
            if (cachedInstanceName.get().equals(DEFAULT_INSTANCE_NAME)) {
                SimpleTimer.getInstance((AccumuloConfiguration)config.getConfiguration()).schedule((Runnable)new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Class<Monitor> clazz = Monitor.class;
                        synchronized (Monitor.class) {
                            String instanceName;
                            if (cachedInstanceName.get().equals(Monitor.DEFAULT_INSTANCE_NAME) && null != (instanceName = HdfsZooInstance.getInstance().getInstanceName())) {
                                cachedInstanceName.set(instanceName);
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                }, 0L);
            }
            // ** MonitorExit[var20_11] (shouldn't be in output)
            clazz = Monitor.class;
            synchronized (Monitor.class) {
                if (fetching) {
                    // ** MonitorExit[var20_11] (shouldn't be in output)
                    return;
                }
                fetching = true;
                // ** MonitorExit[var20_11] (shouldn't be in output)
                try {
                    while (retry) {
                        MasterClientService.Client client = null;
                        try {
                            client = MasterClient.getConnection((ClientContext)context);
                            if (client != null) {
                                mmi = client.getMasterStats(Tracer.traceInfo(), context.rpcCreds());
                                retry = false;
                            } else {
                                mmi = null;
                            }
                            gcStatus = Monitor.fetchGcStatus();
                        }
                        catch (Exception e) {
                            mmi = null;
                            log.info("Error fetching stats: " + e);
                        }
                        finally {
                            if (client != null) {
                                MasterClient.close((MasterClientService.Iface)client);
                            }
                        }
                        if (mmi != null) continue;
                        UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                    }
                    if (mmi != null) {
                        int majorCompactions = 0;
                        int minorCompactions = 0;
                        lookupRateTracker.startingUpdates();
                        indexCacheHitTracker.startingUpdates();
                        indexCacheRequestTracker.startingUpdates();
                        dataCacheHitTracker.startingUpdates();
                        dataCacheRequestTracker.startingUpdates();
                        for (Object server : Monitor.mmi.tServerInfo) {
                            TableInfo summary = TableInfoUtil.summarizeTableStats((TabletServerStatus)server);
                            totalIngestRate += summary.ingestRate;
                            totalIngestByteRate += summary.ingestByteRate;
                            totalQueryRate += summary.queryRate;
                            totalScanRate += summary.scanRate;
                            totalQueryByteRate += summary.queryByteRate;
                            totalEntries += summary.recs;
                            totalHoldTime += ((TabletServerStatus)server).holdTime;
                            totalLookups += ((TabletServerStatus)server).lookups;
                            majorCompactions += summary.majors.running;
                            minorCompactions += summary.minors.running;
                            lookupRateTracker.updateTabletServer(((TabletServerStatus)server).name, ((TabletServerStatus)server).lastContact, ((TabletServerStatus)server).lookups);
                            indexCacheHitTracker.updateTabletServer(((TabletServerStatus)server).name, ((TabletServerStatus)server).lastContact, ((TabletServerStatus)server).indexCacheHits);
                            indexCacheRequestTracker.updateTabletServer(((TabletServerStatus)server).name, ((TabletServerStatus)server).lastContact, ((TabletServerStatus)server).indexCacheRequest);
                            dataCacheHitTracker.updateTabletServer(((TabletServerStatus)server).name, ((TabletServerStatus)server).lastContact, ((TabletServerStatus)server).dataCacheHits);
                            dataCacheRequestTracker.updateTabletServer(((TabletServerStatus)server).name, ((TabletServerStatus)server).lastContact, ((TabletServerStatus)server).dataCacheRequest);
                        }
                        lookupRateTracker.finishedUpdating();
                        indexCacheHitTracker.finishedUpdating();
                        indexCacheRequestTracker.finishedUpdating();
                        dataCacheHitTracker.finishedUpdating();
                        dataCacheRequestTracker.finishedUpdating();
                        int totalTables = 0;
                        for (TableInfo tInfo : Monitor.mmi.tableMap.values()) {
                            totalTabletCount += tInfo.tablets;
                            ++totalTables;
                        }
                        Monitor.totalIngestRate = totalIngestRate;
                        Monitor.totalTables = totalTables;
                        totalIngestByteRate /= 1000000.0;
                        Monitor.totalQueryRate = totalQueryRate;
                        Monitor.totalScanRate = totalScanRate;
                        totalQueryByteRate /= 1000000.0;
                        Monitor.totalEntries = totalEntries;
                        Monitor.totalTabletCount = totalTabletCount;
                        Monitor.totalHoldTime = totalHoldTime;
                        Monitor.totalLookups = totalLookups;
                        ingestRateOverTime.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)totalIngestRate));
                        ingestByteRateOverTime.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)totalIngestByteRate));
                        double totalLoad = 0.0;
                        for (TabletServerStatus status : Monitor.mmi.tServerInfo) {
                            if (status == null) continue;
                            totalLoad += status.osLoad;
                        }
                        loadOverTime.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)totalLoad));
                        minorCompactionsOverTime.add((Pair<Long, Integer>)new Pair((Object)currentTime, (Object)minorCompactions));
                        majorCompactionsOverTime.add((Pair<Long, Integer>)new Pair((Object)currentTime, (Object)majorCompactions));
                        lookupsOverTime.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)lookupRateTracker.calculateRate()));
                        queryRateOverTime.add((Pair<Long, Long>)new Pair((Object)currentTime, (Object)((long)totalQueryRate)));
                        queryByteRateOverTime.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)totalQueryByteRate));
                        scanRateOverTime.add((Pair<Long, Long>)new Pair((Object)currentTime, (Object)((long)totalScanRate)));
                        Monitor.calcCacheHitRate(indexCacheHitRateOverTime, currentTime, indexCacheHitTracker, indexCacheRequestTracker);
                        Monitor.calcCacheHitRate(dataCacheHitRateOverTime, currentTime, dataCacheHitTracker, dataCacheRequestTracker);
                    }
                    try {
                        problemSummary = ProblemReports.getInstance((AccumuloServerContext)Monitor.getContext()).summarize();
                        problemException = null;
                    }
                    catch (Exception e) {
                        log.info("Failed to obtain problem reports ", (Throwable)e);
                        problemSummary = Collections.emptyMap();
                        problemException = e;
                    }
                }
                finally {
                    Class<Monitor> clazz2 = Monitor.class;
                    synchronized (Monitor.class) {
                        fetching = false;
                        lastRecalc.set(currentTime);
                        // ** MonitorExit[var20_14] (shouldn't be in output)
                    }
                }
                return;
            }
        }
    }

    private static void calcCacheHitRate(List<Pair<Long, Double>> hitRate, long currentTime, EventCounter cacheHits, EventCounter cacheReq) {
        long req = cacheReq.calculateCount();
        if (req > 0L) {
            hitRate.add((Pair<Long, Double>)new Pair((Object)currentTime, (Object)((double)cacheHits.calculateCount() / (double)cacheReq.calculateCount())));
        } else {
            hitRate.add((Pair<Long, Double>)new Pair((Object)currentTime, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GCStatus fetchGcStatus() {
        GCStatus result;
        block5: {
            result = null;
            HostAndPort address = null;
            try {
                ZooReaderWriter zk = ZooReaderWriter.getInstance();
                String path = ZooUtil.getRoot((Instance)instance) + "/gc/lock";
                List locks = zk.getChildren(path, null);
                if (locks == null || locks.size() <= 0) break block5;
                Collections.sort(locks);
                address = new ServerServices(new String(zk.getData(path + "/" + (String)locks.get(0), null), StandardCharsets.UTF_8)).getAddress(ServerServices.Service.GC_CLIENT);
                GCMonitorService.Client client = (GCMonitorService.Client)ThriftUtil.getClient((TServiceClientFactory)new GCMonitorService.Client.Factory(), (HostAndPort)address, (ClientContext)new AccumuloServerContext(config));
                try {
                    result = client.getStatus(Tracer.traceInfo(), Monitor.getContext().rpcCreds());
                }
                finally {
                    ThriftUtil.returnClient((TServiceClient)client);
                }
            }
            catch (Exception ex) {
                log.warn("Unable to contact the garbage collector at " + address, (Throwable)ex);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String app = "monitor";
        Accumulo.setupLogging((String)"monitor");
        SecurityUtil.serverLogin((AccumuloConfiguration)SiteConfiguration.getInstance());
        ServerOpts opts = new ServerOpts();
        opts.parseArgs("monitor", args, new Object[0]);
        String hostname = opts.getAddress();
        VolumeManager fs = VolumeManagerImpl.get();
        instance = HdfsZooInstance.getInstance();
        config = new ServerConfigurationFactory(instance);
        context = new AccumuloServerContext(config);
        log.info("Version 1.10.2");
        log.info("Instance " + instance.getInstanceID());
        MetricsSystemHelper.configure((String)Monitor.class.getSimpleName());
        Accumulo.init((VolumeManager)fs, (ServerConfigurationFactory)config, (String)"monitor");
        Monitor monitor = new Monitor();
        DistributedTrace.enable((String)hostname, (String)"monitor", (AccumuloConfiguration)config.getConfiguration());
        try {
            monitor.run(hostname);
        }
        finally {
            DistributedTrace.disable();
        }
    }

    public void run(String hostname) {
        int[] ports;
        try {
            this.getMonitorLock();
        }
        catch (Exception e) {
            log.error("Failed to get Monitor ZooKeeper lock");
            throw new RuntimeException(e);
        }
        START_TIME = System.currentTimeMillis();
        for (int port : ports = config.getConfiguration().getPort(Property.MONITOR_PORT)) {
            try {
                log.debug("Creating monitor on port " + port);
                server = new EmbeddedWebServer(hostname, port);
                server.addServlet(DefaultServlet.class, "/");
                server.addServlet(OperationServlet.class, "/op");
                server.addServlet(MasterServlet.class, "/master");
                server.addServlet(TablesServlet.class, "/tables");
                server.addServlet(TServersServlet.class, "/tservers");
                server.addServlet(ProblemServlet.class, "/problems");
                server.addServlet(GcStatusServlet.class, "/gc");
                server.addServlet(LogServlet.class, "/log");
                server.addServlet(XMLServlet.class, "/xml");
                server.addServlet(JSONServlet.class, "/json");
                server.addServlet(VisServlet.class, "/vis");
                server.addServlet(ScanServlet.class, "/scans");
                server.addServlet(BulkImportServlet.class, "/bulkImports");
                server.addServlet(Summary.class, "/trace/summary");
                server.addServlet(ListType.class, "/trace/listType");
                server.addServlet(ShowTrace.class, "/trace/show");
                server.addServlet(ReplicationServlet.class, "/replication");
                if (server.isUsingSsl()) {
                    server.addServlet(ShellServlet.class, "/shell");
                }
                server.start();
                break;
            }
            catch (Throwable ex) {
                log.error("Unable to start embedded web server", ex);
            }
        }
        if (!server.isRunning()) {
            throw new RuntimeException("Unable to start embedded web server on ports: " + Arrays.toString(ports));
        }
        String advertiseHost = hostname;
        if (advertiseHost.equals("0.0.0.0")) {
            try {
                advertiseHost = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                log.error("Unable to get hostname", (Throwable)e);
            }
        }
        log.debug("Using {} to advertise monitor location in ZooKeeper", (Object)advertiseHost);
        try {
            String monitorAddress = HostAndPort.fromParts((String)advertiseHost, (int)server.getPort()).toString();
            ZooReaderWriter.getInstance().putPersistentData(ZooUtil.getRoot((Instance)instance) + "/monitor/http_addr", monitorAddress.getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.OVERWRITE);
            log.info("Set monitor address in zookeeper to {}", (Object)monitorAddress);
        }
        catch (Exception ex) {
            log.error("Unable to set monitor HTTP address in zookeeper", (Throwable)ex);
        }
        if (null != advertiseHost) {
            LogService.startLogListener((AccumuloConfiguration)Monitor.getContext().getConfiguration(), (String)instance.getInstanceID(), (String)advertiseHost);
        } else {
            log.warn("Not starting log4j listener as we could not determine address to use");
        }
        new Daemon((Runnable)new LoggingRunnable(log, (Runnable)new ZooKeeperStatus()), "ZooKeeperStatus").start();
        new Daemon((Runnable)new LoggingRunnable(log, new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Monitor.fetchData();
                    }
                    catch (Exception e) {
                        log.warn("{}", (Object)e.getMessage(), (Object)e);
                    }
                    UtilWaitThread.sleepUninterruptibly((long)333L, (TimeUnit)TimeUnit.MILLISECONDS);
                }
            }
        }), "Data fetcher").start();
        new Daemon((Runnable)new LoggingRunnable(log, new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Monitor.fetchScans();
                    }
                    catch (Exception e) {
                        log.warn("{}", (Object)e.getMessage(), (Object)e);
                    }
                    UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
                }
            }
        }), "Scan scanner").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<HostAndPort, ScanStats> getScans() {
        Map<HostAndPort, ScanStats> map = allScans;
        synchronized (map) {
            return new HashMap<HostAndPort, ScanStats>(allScans);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void fetchScans() throws Exception {
        if (instance == null) {
            return;
        }
        Connector c = context.getConnector();
        for (String server : c.instanceOperations().getTabletServers()) {
            HostAndPort parsedServer = HostAndPort.fromString((String)server);
            TabletClientService.Client tserver = ThriftUtil.getTServerClient((HostAndPort)parsedServer, (ClientContext)context);
            try {
                List scans = tserver.getActiveScans(null, context.rpcCreds());
                Map<HostAndPort, ScanStats> map = allScans;
                synchronized (map) {
                    allScans.put(parsedServer, new ScanStats(scans));
                }
            }
            catch (Exception ex) {
                log.debug("Failed to get active scans from {}", (Object)server, (Object)ex);
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)tserver);
            }
        }
        Iterator<Map.Entry<HostAndPort, ScanStats>> entryIter = allScans.entrySet().iterator();
        long now = System.currentTimeMillis();
        while (entryIter.hasNext()) {
            Map.Entry<HostAndPort, ScanStats> entry = entryIter.next();
            if (now - entry.getValue().fetched <= 300000L) continue;
            entryIter.remove();
        }
    }

    private void getMonitorLock() throws KeeperException, InterruptedException {
        String zRoot = ZooUtil.getRoot((Instance)instance);
        String monitorPath = zRoot + "/monitor";
        String monitorLockPath = zRoot + "/monitor/lock";
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        if (zoo.exists(monitorPath)) {
            byte[] data = zoo.getData(monitorPath, null);
            if (0 != data.length) {
                zoo.recursiveDelete(monitorPath, ZooUtil.NodeMissingPolicy.SKIP);
                zoo.putPersistentData(monitorPath, new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
                zoo.putPersistentData(monitorLockPath, new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
            } else if (!zoo.exists(monitorLockPath)) {
                zoo.putPersistentData(monitorLockPath, new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
            }
        } else {
            zoo.putPersistentData(zRoot + "/monitor", new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
            if (!zoo.exists(monitorLockPath)) {
                zoo.putPersistentData(monitorLockPath, new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
            }
        }
        while (true) {
            MoniterLockWatcher monitorLockWatcher = new MoniterLockWatcher();
            this.monitorLock = new ZooLock(monitorLockPath);
            this.monitorLock.lockAsync((ZooLock.AsyncLockWatcher)monitorLockWatcher, new byte[0]);
            monitorLockWatcher.waitForChange();
            if (monitorLockWatcher.acquiredLock) break;
            if (!monitorLockWatcher.failedToAcquireLock) {
                throw new IllegalStateException("monitor lock in unknown state");
            }
            this.monitorLock.tryToCancelAsyncLockOrUnlock();
            UtilWaitThread.sleepUninterruptibly((long)Monitor.getContext().getConfiguration().getTimeInMillis(Property.MONITOR_LOCK_CHECK_INTERVAL), (TimeUnit)TimeUnit.MILLISECONDS);
        }
        log.info("Got Monitor lock.");
    }

    public static MasterMonitorInfo getMmi() {
        return mmi;
    }

    public static int getTotalTables() {
        return totalTables;
    }

    public static int getTotalTabletCount() {
        return totalTabletCount;
    }

    public static long getTotalEntries() {
        return totalEntries;
    }

    public static double getTotalIngestRate() {
        return totalIngestRate;
    }

    public static double getTotalQueryRate() {
        return totalQueryRate;
    }

    public static double getTotalScanRate() {
        return totalScanRate;
    }

    public static long getTotalHoldTime() {
        return totalHoldTime;
    }

    public static Exception getProblemException() {
        return problemException;
    }

    public static Map<String, Map<ProblemType, Integer>> getProblemSummary() {
        return problemSummary;
    }

    public static GCStatus getGcStatus() {
        return gcStatus;
    }

    public static long getTotalLookups() {
        return totalLookups;
    }

    public static long getStartTime() {
        return START_TIME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Long, Double>> getLoadOverTime() {
        List<Pair<Long, Double>> list = loadOverTime;
        synchronized (list) {
            return new ArrayList<Pair<Long, Double>>(loadOverTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Long, Double>> getIngestRateOverTime() {
        List<Pair<Long, Double>> list = ingestRateOverTime;
        synchronized (list) {
            return new ArrayList<Pair<Long, Double>>(ingestRateOverTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Long, Double>> getIngestByteRateOverTime() {
        List<Pair<Long, Double>> list = ingestByteRateOverTime;
        synchronized (list) {
            return new ArrayList<Pair<Long, Double>>(ingestByteRateOverTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Long, Integer>> getMinorCompactionsOverTime() {
        List<Pair<Long, Integer>> list = minorCompactionsOverTime;
        synchronized (list) {
            return new ArrayList<Pair<Long, Integer>>(minorCompactionsOverTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Long, Integer>> getMajorCompactionsOverTime() {
        List<Pair<Long, Integer>> list = majorCompactionsOverTime;
        synchronized (list) {
            return new ArrayList<Pair<Long, Integer>>(majorCompactionsOverTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Long, Double>> getLookupsOverTime() {
        List<Pair<Long, Double>> list = lookupsOverTime;
        synchronized (list) {
            return new ArrayList<Pair<Long, Double>>(lookupsOverTime);
        }
    }

    public static double getLookupRate() {
        return lookupRateTracker.calculateRate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Long, Long>> getQueryRateOverTime() {
        List<Pair<Long, Long>> list = queryRateOverTime;
        synchronized (list) {
            return new ArrayList<Pair<Long, Long>>(queryRateOverTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Long, Long>> getScanRateOverTime() {
        List<Pair<Long, Long>> list = scanRateOverTime;
        synchronized (list) {
            return new ArrayList<Pair<Long, Long>>(scanRateOverTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Long, Double>> getQueryByteRateOverTime() {
        List<Pair<Long, Double>> list = queryByteRateOverTime;
        synchronized (list) {
            return new ArrayList<Pair<Long, Double>>(queryByteRateOverTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Long, Double>> getIndexCacheHitRateOverTime() {
        List<Pair<Long, Double>> list = indexCacheHitRateOverTime;
        synchronized (list) {
            return new ArrayList<Pair<Long, Double>>(indexCacheHitRateOverTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Pair<Long, Double>> getDataCacheHitRateOverTime() {
        List<Pair<Long, Double>> list = dataCacheHitRateOverTime;
        synchronized (list) {
            return new ArrayList<Pair<Long, Double>>(dataCacheHitRateOverTime);
        }
    }

    public static boolean isUsingSsl() {
        return server.isUsingSsl();
    }

    public static AccumuloServerContext getContext() {
        return context;
    }

    static {
        problemSummary = Collections.emptyMap();
        cachedInstanceName = new AtomicReference<String>(DEFAULT_INSTANCE_NAME);
        allScans = new HashMap<HostAndPort, ScanStats>();
    }

    private static class MoniterLockWatcher
    implements ZooLock.AsyncLockWatcher {
        boolean acquiredLock = false;
        boolean failedToAcquireLock = false;

        private MoniterLockWatcher() {
        }

        public void lostLock(ZooLock.LockLossReason reason) {
            Halt.halt((String)("Monitor lock in zookeeper lost (reason = " + reason + "), exiting!"), (int)-1);
        }

        public void unableToMonitorLockNode(final Throwable e) {
            Halt.halt((int)-1, (Runnable)new Runnable(){

                @Override
                public void run() {
                    log.error("No longer able to monitor Monitor lock node", e);
                }
            });
        }

        public synchronized void acquiredLock() {
            if (this.acquiredLock || this.failedToAcquireLock) {
                Halt.halt((String)("Zoolock in unexpected state AL " + this.acquiredLock + " " + this.failedToAcquireLock), (int)-1);
            }
            this.acquiredLock = true;
            this.notifyAll();
        }

        public synchronized void failedToAcquireLock(Exception e) {
            log.warn("Failed to get monitor lock " + e);
            if (this.acquiredLock) {
                Halt.halt((String)("Zoolock in unexpected state FAL " + this.acquiredLock + " " + this.failedToAcquireLock), (int)-1);
            }
            this.failedToAcquireLock = true;
            this.notifyAll();
        }

        public synchronized void waitForChange() {
            while (!this.acquiredLock && !this.failedToAcquireLock) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static class ScanStats {
        public final long scanCount;
        public final Long oldestScan;
        public final long fetched;

        ScanStats(List<ActiveScan> active) {
            this.scanCount = active.size();
            long oldest = -1L;
            for (ActiveScan scan : active) {
                oldest = Math.max(oldest, scan.age);
            }
            this.oldestScan = oldest < 0L ? null : Long.valueOf(oldest);
            this.fetched = System.currentTimeMillis();
        }
    }

    private static class EventCounter {
        Map<String, Pair<Long, Long>> prevSamples = new HashMap<String, Pair<Long, Long>>();
        Map<String, Pair<Long, Long>> samples = new HashMap<String, Pair<Long, Long>>();
        Set<String> serversUpdated = new HashSet<String>();

        private EventCounter() {
        }

        void startingUpdates() {
            this.serversUpdated.clear();
        }

        void updateTabletServer(String name, long sampleTime, long numEvents) {
            Pair newSample = new Pair((Object)sampleTime, (Object)numEvents);
            Pair<Long, Long> lastSample = this.samples.get(name);
            if (lastSample == null || !lastSample.equals((Object)newSample)) {
                this.samples.put(name, (Pair<Long, Long>)newSample);
                if (lastSample != null) {
                    this.prevSamples.put(name, lastSample);
                }
            }
            this.serversUpdated.add(name);
        }

        void finishedUpdating() {
            this.samples.keySet().retainAll(this.serversUpdated);
            this.prevSamples.keySet().retainAll(this.serversUpdated);
        }

        double calculateRate() {
            double totalRate = 0.0;
            for (Map.Entry<String, Pair<Long, Long>> entry : this.prevSamples.entrySet()) {
                Pair<Long, Long> prevSample = entry.getValue();
                Pair<Long, Long> sample = this.samples.get(entry.getKey());
                totalRate += (double)((Long)sample.getSecond() - (Long)prevSample.getSecond()) / ((double)((Long)sample.getFirst() - (Long)prevSample.getFirst()) / 1000.0);
            }
            return totalRate;
        }

        long calculateCount() {
            long count = 0L;
            for (Map.Entry<String, Pair<Long, Long>> entry : this.prevSamples.entrySet()) {
                Pair<Long, Long> prevSample = entry.getValue();
                Pair<Long, Long> sample = this.samples.get(entry.getKey());
                count += (Long)sample.getSecond() - (Long)prevSample.getSecond();
            }
            return count;
        }
    }

    private static class MaxList<T>
    extends LinkedList<Pair<Long, T>> {
        private static final long serialVersionUID = 1L;
        private long maxDelta;

        public MaxList(long maxDelta) {
            this.maxDelta = maxDelta;
        }

        @Override
        public boolean add(Pair<Long, T> obj) {
            boolean result = super.add(obj);
            if ((Long)obj.getFirst() - (Long)((Pair)this.get(0)).getFirst() > this.maxDelta) {
                this.remove(0);
            }
            return result;
        }
    }
}

