/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.shard;

import java.util.Collection;
import org.apache.accumulo.core.client.mapreduce.AccumuloFileOutputFormat;
import org.apache.accumulo.core.client.mapreduce.lib.partition.KeyRangePartitioner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.util.Tool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortTool
extends Configured
implements Tool {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String outputDir;
    private String seqFile;
    private String splitFile;
    private Collection<Text> splits;

    public SortTool(String seqFile, String outputDir, String splitFile, Collection<Text> splits) {
        this.outputDir = outputDir;
        this.seqFile = seqFile;
        this.splitFile = splitFile;
        this.splits = splits;
    }

    public int run(String[] args) throws Exception {
        Job job = Job.getInstance((Configuration)this.getConf(), (String)((Object)((Object)this)).getClass().getSimpleName());
        job.setJarByClass(((Object)((Object)this)).getClass());
        if (job.getJar() == null) {
            this.log.error("M/R requires a jar file!  Run mvn package.");
            return 1;
        }
        job.setInputFormatClass(SequenceFileInputFormat.class);
        SequenceFileInputFormat.setInputPaths((Job)job, (String)this.seqFile);
        job.setPartitionerClass(KeyRangePartitioner.class);
        KeyRangePartitioner.setSplitFile((Job)job, (String)this.splitFile);
        job.setMapOutputKeyClass(Key.class);
        job.setMapOutputValueClass(Value.class);
        job.setNumReduceTasks(this.splits.size() + 1);
        job.setOutputFormatClass(AccumuloFileOutputFormat.class);
        AccumuloFileOutputFormat.setOutputPath((Job)job, (Path)new Path(this.outputDir));
        job.waitForCompletion(true);
        return job.isSuccessful() ? 0 : 1;
    }
}

