/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ClientSideIteratorScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.impl.OfflineScanner;
import org.apache.accumulo.core.client.sample.RowSampler;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.WrappingIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.junit.Assert;
import org.junit.Test;

public class SampleIT
extends AccumuloClusterHarness {
    private static final Map<String, String> OPTIONS_1 = ImmutableMap.of((Object)"hasher", (Object)"murmur3_32", (Object)"modulus", (Object)"1009");
    private static final Map<String, String> OPTIONS_2 = ImmutableMap.of((Object)"hasher", (Object)"murmur3_32", (Object)"modulus", (Object)"997");
    private static final SamplerConfiguration SC1 = new SamplerConfiguration(RowSampler.class.getName()).setOptions(OPTIONS_1);
    private static final SamplerConfiguration SC2 = new SamplerConfiguration(RowSampler.class.getName()).setOptions(OPTIONS_2);

    @Test
    public void testBasic() throws Exception {
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        String clone = tableName + "_clone";
        conn.tableOperations().create(tableName, new NewTableConfiguration().enableSampling(SC1));
        BatchWriter bw = conn.createBatchWriter(tableName, new BatchWriterConfig());
        TreeMap<Key, Value> expected = new TreeMap<Key, Value>();
        String someRow = this.writeData(bw, SC1, expected);
        Assert.assertEquals((long)20L, (long)expected.size());
        Scanner scanner = conn.createScanner(tableName, Authorizations.EMPTY);
        IsolatedScanner isoScanner = new IsolatedScanner(conn.createScanner(tableName, Authorizations.EMPTY));
        ClientSideIteratorScanner csiScanner = new ClientSideIteratorScanner(conn.createScanner(tableName, Authorizations.EMPTY));
        scanner.setSamplerConfiguration(SC1);
        csiScanner.setSamplerConfiguration(SC1);
        isoScanner.setSamplerConfiguration(SC1);
        isoScanner.setBatchSize(10);
        BatchScanner bScanner = conn.createBatchScanner(tableName, Authorizations.EMPTY, 2);
        bScanner.setSamplerConfiguration(SC1);
        bScanner.setRanges(Arrays.asList(new Range()));
        this.check(expected, new ScannerBase[]{scanner, bScanner, isoScanner, csiScanner});
        conn.tableOperations().flush(tableName, null, null, true);
        Scanner oScanner = this.newOfflineScanner(conn, tableName, clone, SC1);
        this.check(expected, new ScannerBase[]{scanner, bScanner, isoScanner, csiScanner, oScanner});
        for (ScannerBase sb : Arrays.asList(scanner, bScanner, isoScanner, csiScanner, oScanner)) {
            sb.clearSamplerConfiguration();
            Assert.assertEquals((long)20000L, (long)Iterables.size((Iterable)sb));
            sb.setSamplerConfiguration(SC1);
        }
        Iterator<Key> it = expected.keySet().iterator();
        while (it.hasNext()) {
            Key k = it.next();
            if (!k.getRow().toString().equals(someRow)) continue;
            it.remove();
        }
        expected.put(new Key((CharSequence)someRow, (CharSequence)"cf1", (CharSequence)"cq1", 8L), new Value("42".getBytes()));
        expected.put(new Key((CharSequence)someRow, (CharSequence)"cf1", (CharSequence)"cq3", 8L), new Value("suprise".getBytes()));
        Mutation m = new Mutation((CharSequence)someRow);
        m.put((CharSequence)"cf1", (CharSequence)"cq1", 8L, (CharSequence)"42");
        m.putDelete((CharSequence)"cf1", (CharSequence)"cq2", 8L);
        m.put((CharSequence)"cf1", (CharSequence)"cq3", 8L, (CharSequence)"suprise");
        bw.addMutation(m);
        bw.close();
        this.check(expected, new ScannerBase[]{scanner, bScanner, isoScanner, csiScanner});
        conn.tableOperations().flush(tableName, null, null, true);
        oScanner = this.newOfflineScanner(conn, tableName, clone, SC1);
        this.check(expected, new ScannerBase[]{scanner, bScanner, isoScanner, csiScanner, oScanner});
        scanner.setRange(new Range((CharSequence)someRow));
        isoScanner.setRange(new Range((CharSequence)someRow));
        csiScanner.setRange(new Range((CharSequence)someRow));
        oScanner.setRange(new Range((CharSequence)someRow));
        bScanner.setRanges(Arrays.asList(new Range((CharSequence)someRow)));
        expected.clear();
        expected.put(new Key((CharSequence)someRow, (CharSequence)"cf1", (CharSequence)"cq1", 8L), new Value("42".getBytes()));
        expected.put(new Key((CharSequence)someRow, (CharSequence)"cf1", (CharSequence)"cq3", 8L), new Value("suprise".getBytes()));
        this.check(expected, new ScannerBase[]{scanner, bScanner, isoScanner, csiScanner, oScanner});
        bScanner.close();
    }

    private Scanner newOfflineScanner(Connector conn, String tableName, String clone, SamplerConfiguration sc) throws Exception {
        if (conn.tableOperations().exists(clone)) {
            conn.tableOperations().delete(clone);
        }
        Map em = Collections.emptyMap();
        Set es = Collections.emptySet();
        conn.tableOperations().clone(tableName, clone, false, em, es);
        conn.tableOperations().offline(clone, true);
        String cloneID = (String)conn.tableOperations().tableIdMap().get(clone);
        OfflineScanner oScanner = new OfflineScanner(conn.getInstance(), new Credentials(SampleIT.getAdminPrincipal(), SampleIT.getAdminToken()), cloneID, Authorizations.EMPTY);
        if (sc != null) {
            oScanner.setSamplerConfiguration(sc);
        }
        return oScanner;
    }

    private void updateExpected(SamplerConfiguration sc, TreeMap<Key, Value> expected) {
        expected.clear();
        RowSampler sampler = new RowSampler();
        sampler.init(sc);
        for (int i = 0; i < 10000; ++i) {
            Key k2;
            String row = String.format("r_%06d", i);
            Key k1 = new Key((CharSequence)row, (CharSequence)"cf1", (CharSequence)"cq1", 7L);
            if (sampler.accept(k1)) {
                expected.put(k1, new Value(("" + i).getBytes()));
            }
            if (!sampler.accept(k2 = new Key((CharSequence)row, (CharSequence)"cf1", (CharSequence)"cq2", 7L))) continue;
            expected.put(k2, new Value(("" + (100000000 - i)).getBytes()));
        }
    }

    private String writeData(BatchWriter bw, SamplerConfiguration sc, TreeMap<Key, Value> expected) throws MutationsRejectedException {
        int count = 0;
        String someRow = null;
        RowSampler sampler = new RowSampler();
        sampler.init(sc);
        for (int i = 0; i < 10000; ++i) {
            Key k2;
            String row = String.format("r_%06d", i);
            Mutation m = new Mutation((CharSequence)row);
            m.put((CharSequence)"cf1", (CharSequence)"cq1", 7L, (CharSequence)("" + i));
            m.put((CharSequence)"cf1", (CharSequence)"cq2", 7L, (CharSequence)("" + (100000000 - i)));
            bw.addMutation(m);
            Key k1 = new Key((CharSequence)row, (CharSequence)"cf1", (CharSequence)"cq1", 7L);
            if (sampler.accept(k1)) {
                expected.put(k1, new Value(("" + i).getBytes()));
                if (++count == 5) {
                    someRow = row;
                }
            }
            if (!sampler.accept(k2 = new Key((CharSequence)row, (CharSequence)"cf1", (CharSequence)"cq2", 7L))) continue;
            expected.put(k2, new Value(("" + (100000000 - i)).getBytes()));
        }
        bw.flush();
        return someRow;
    }

    private int countEntries(Iterable<Map.Entry<Key, Value>> scanner) {
        int count = 0;
        Iterator<Map.Entry<Key, Value>> iter = scanner.iterator();
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        return count;
    }

    private void setRange(Range range, List<? extends ScannerBase> scanners) {
        for (ScannerBase scannerBase : scanners) {
            if (scannerBase instanceof Scanner) {
                ((Scanner)scannerBase).setRange(range);
                continue;
            }
            ((BatchScanner)scannerBase).setRanges(Collections.singleton(range));
        }
    }

    @Test
    public void testIterator() throws Exception {
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        String clone = tableName + "_clone";
        conn.tableOperations().create(tableName, new NewTableConfiguration().enableSampling(SC1));
        BatchWriter bw = conn.createBatchWriter(tableName, new BatchWriterConfig());
        TreeMap<Key, Value> expected = new TreeMap<Key, Value>();
        this.writeData(bw, SC1, expected);
        ArrayList<Key> keys = new ArrayList<Key>(expected.keySet());
        Range range1 = new Range(keys.get(6), true, keys.get(11), true);
        Scanner scanner = conn.createScanner(tableName, Authorizations.EMPTY);
        IsolatedScanner isoScanner = new IsolatedScanner(conn.createScanner(tableName, Authorizations.EMPTY));
        ClientSideIteratorScanner csiScanner = new ClientSideIteratorScanner(conn.createScanner(tableName, Authorizations.EMPTY));
        BatchScanner bScanner = conn.createBatchScanner(tableName, Authorizations.EMPTY, 2);
        csiScanner.setIteratorSamplerConfiguration(SC1);
        List<ScannerBase> scanners = Arrays.asList(scanner, isoScanner, bScanner, csiScanner);
        for (ScannerBase scannerBase : scanners) {
            scannerBase.addScanIterator(new IteratorSetting(100, IteratorThatUsesSample.class));
        }
        this.setRange(range1, scanners);
        for (ScannerBase scannerBase : scanners) {
            Assert.assertEquals((long)2954L, (long)this.countEntries((Iterable<Map.Entry<Key, Value>>)scannerBase));
        }
        Range range2 = new Range(keys.get(5), true, keys.get(18), true);
        this.setRange(range2, scanners);
        for (ScannerBase s : scanners) {
            Assert.assertEquals((long)0L, (long)this.countEntries((Iterable<Map.Entry<Key, Value>>)s));
        }
        conn.tableOperations().flush(tableName, null, null, true);
        Scanner scanner2 = this.newOfflineScanner(conn, tableName, clone, null);
        scanner2.addScanIterator(new IteratorSetting(100, IteratorThatUsesSample.class));
        scanners = Arrays.asList(scanner, isoScanner, bScanner, csiScanner, scanner2);
        this.setRange(range1, scanners);
        for (ScannerBase s : scanners) {
            Assert.assertEquals((long)2954L, (long)this.countEntries((Iterable<Map.Entry<Key, Value>>)s));
        }
        this.setRange(range2, scanners);
        for (ScannerBase s : scanners) {
            Assert.assertEquals((long)0L, (long)this.countEntries((Iterable<Map.Entry<Key, Value>>)s));
        }
        this.updateSamplingConfig(conn, tableName, SC2);
        csiScanner.setIteratorSamplerConfiguration(SC2);
        Scanner scanner3 = this.newOfflineScanner(conn, tableName, clone, null);
        scanner3.addScanIterator(new IteratorSetting(100, IteratorThatUsesSample.class));
        scanners = Arrays.asList(scanner, isoScanner, bScanner, csiScanner, scanner3);
        for (ScannerBase s : scanners) {
            try {
                this.countEntries((Iterable<Map.Entry<Key, Value>>)s);
                Assert.fail((String)("Expected SampleNotPresentException, but it did not happen : " + s.getClass().getSimpleName()));
            }
            catch (SampleNotPresentException sampleNotPresentException) {}
        }
    }

    private void setSamplerConfig(SamplerConfiguration sc, ScannerBase ... scanners) {
        for (ScannerBase s : scanners) {
            s.setSamplerConfiguration(sc);
        }
    }

    @Test
    public void testSampleNotPresent() throws Exception {
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        String clone = tableName + "_clone";
        conn.tableOperations().create(tableName);
        BatchWriter bw = conn.createBatchWriter(tableName, new BatchWriterConfig());
        TreeMap<Key, Value> expected = new TreeMap<Key, Value>();
        this.writeData(bw, SC1, expected);
        Scanner scanner = conn.createScanner(tableName, Authorizations.EMPTY);
        IsolatedScanner isoScanner = new IsolatedScanner(conn.createScanner(tableName, Authorizations.EMPTY));
        isoScanner.setBatchSize(10);
        ClientSideIteratorScanner csiScanner = new ClientSideIteratorScanner(conn.createScanner(tableName, Authorizations.EMPTY));
        BatchScanner bScanner = conn.createBatchScanner(tableName, Authorizations.EMPTY, 2);
        bScanner.setRanges(Arrays.asList(new Range()));
        this.assertSampleNotPresent(SC1, new ScannerBase[]{scanner, isoScanner, bScanner, csiScanner});
        conn.tableOperations().flush(tableName, null, null, true);
        Scanner oScanner = this.newOfflineScanner(conn, tableName, clone, SC1);
        this.assertSampleNotPresent(SC1, new ScannerBase[]{scanner, isoScanner, bScanner, csiScanner, oScanner});
        this.updateSamplingConfig(conn, tableName, SC1);
        oScanner = this.newOfflineScanner(conn, tableName, clone, SC1);
        this.assertSampleNotPresent(SC1, new ScannerBase[]{scanner, isoScanner, bScanner, csiScanner, oScanner});
        conn.tableOperations().compact(tableName, new CompactionConfig().setWait(true));
        oScanner = this.newOfflineScanner(conn, tableName, clone, SC1);
        this.setSamplerConfig(SC1, new ScannerBase[]{scanner, csiScanner, isoScanner, bScanner, oScanner});
        this.check(expected, new ScannerBase[]{scanner, isoScanner, bScanner, csiScanner, oScanner});
        this.updateSamplingConfig(conn, tableName, SC2);
        oScanner = this.newOfflineScanner(conn, tableName, clone, SC2);
        this.assertSampleNotPresent(SC2, new ScannerBase[]{scanner, isoScanner, bScanner, csiScanner, oScanner});
        conn.tableOperations().compact(tableName, new CompactionConfig().setWait(true));
        this.updateExpected(SC2, expected);
        oScanner = this.newOfflineScanner(conn, tableName, clone, SC2);
        this.setSamplerConfig(SC2, new ScannerBase[]{scanner, csiScanner, isoScanner, bScanner, oScanner});
        this.check(expected, new ScannerBase[]{scanner, isoScanner, bScanner, csiScanner, oScanner});
        bScanner.close();
    }

    private void updateSamplingConfig(Connector conn, String tableName, SamplerConfiguration sc) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        conn.tableOperations().setSamplerConfiguration(tableName, sc);
        conn.tableOperations().offline(tableName, true);
        conn.tableOperations().online(tableName, true);
    }

    private void assertSampleNotPresent(SamplerConfiguration sc, ScannerBase ... scanners) {
        for (ScannerBase scanner : scanners) {
            SamplerConfiguration csc = scanner.getSamplerConfiguration();
            scanner.setSamplerConfiguration(sc);
            try {
                for (Map.Entry entry : scanner) {
                    entry.getKey();
                }
                Assert.fail((String)("Expected SampleNotPresentException, but it did not happen : " + scanner.getClass().getSimpleName()));
            }
            catch (SampleNotPresentException i) {
                // empty catch block
            }
            scanner.clearSamplerConfiguration();
            for (Map.Entry entry : scanner) {
                entry.getKey();
            }
            if (csc == null) {
                scanner.clearSamplerConfiguration();
                continue;
            }
            scanner.setSamplerConfiguration(csc);
        }
    }

    private void check(TreeMap<Key, Value> expected, ScannerBase ... scanners) {
        TreeMap<Key, Value> actual = new TreeMap<Key, Value>();
        for (ScannerBase s : scanners) {
            actual.clear();
            for (Map.Entry entry : s) {
                actual.put((Key)entry.getKey(), (Value)entry.getValue());
            }
            Assert.assertEquals((String)String.format("Saw %d instead of %d entries using %s", actual.size(), expected.size(), s.getClass().getSimpleName()), expected, actual);
        }
    }

    public static class IteratorThatUsesSample
    extends WrappingIterator {
        private SortedKeyValueIterator<Key, Value> sampleDC;
        private boolean hasTop;

        public boolean hasTop() {
            return this.hasTop && super.hasTop();
        }

        public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
            int sampleCount = 0;
            this.sampleDC.seek(range, columnFamilies, inclusive);
            while (this.sampleDC.hasTop()) {
                ++sampleCount;
                this.sampleDC.next();
            }
            if (sampleCount < 10) {
                this.hasTop = true;
                super.seek(range, columnFamilies, inclusive);
            } else {
                this.hasTop = false;
            }
        }

        public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
            super.init(source, options, env);
            IteratorEnvironment sampleEnv = env.cloneWithSamplingEnabled();
            this.sampleDC = source.deepCopy(sampleEnv);
        }
    }
}

