/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.categories.MiniClusterOnlyTests;
import org.apache.accumulo.test.categories.PerformanceTests;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.mrit.IntegrationTestMapReduce;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiniClusterOnlyTests.class, PerformanceTests.class})
public class BalanceFasterIT
extends ConfigurableMacBase {
    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(3);
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 90;
    }

    @BeforeClass
    public static void checkMR() {
        Assume.assumeFalse((boolean)IntegrationTestMapReduce.isMapReduce());
    }

    @Test
    public void test() throws Exception {
        int total;
        String tableName = this.getUniqueNames(1)[0];
        Connector conn = this.getConnector();
        conn.tableOperations().create(tableName);
        TreeSet<Text> splits = new TreeSet<Text>();
        for (int i = 0; i < 1000; ++i) {
            splits.add(new Text("" + i));
        }
        conn.tableOperations().addSplits(tableName, splits);
        UtilWaitThread.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.SECONDS);
        Scanner s = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        s.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
        s.setRange(MetadataSchema.TabletsSection.getRange());
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        do {
            total = 0;
            counts.clear();
            for (Map.Entry kv : s) {
                String host = ((Value)kv.getValue()).toString();
                if (!counts.containsKey(host)) {
                    counts.put(host, 0);
                }
                counts.put(host, (Integer)counts.get(host) + 1);
                ++total;
            }
        } while (total <= 1000);
        Assert.assertTrue((counts.size() == 3 ? 1 : 0) != 0);
        Iterator i = counts.values().iterator();
        int a = (Integer)i.next();
        int b = (Integer)i.next();
        int c = (Integer)i.next();
        Assert.assertTrue((Math.abs(a - b) < 3 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs(a - c) < 3 ? 1 : 0) != 0);
        Assert.assertTrue((a > 330 ? 1 : 0) != 0);
    }
}

