/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.format.Formatter;
import org.apache.accumulo.core.util.format.FormatterConfig;
import org.apache.accumulo.core.util.interpret.DefaultScanInterpreter;
import org.apache.accumulo.core.util.interpret.ScanInterpreter;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.ShellCommandException;
import org.apache.accumulo.shell.commands.EGrepCommand;
import org.apache.accumulo.shell.commands.GrepCommand;
import org.apache.accumulo.shell.commands.InterpreterCommand;
import org.apache.accumulo.shell.commands.OptUtil;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.hadoop.io.Text;

public class ScanCommand
extends Shell.Command {
    private Option scanOptAuths;
    private Option scanOptRow;
    private Option scanOptColumns;
    private Option disablePaginationOpt;
    private Option showFewOpt;
    private Option formatterOpt;
    private Option interpreterOpt;
    private Option formatterInterpeterOpt;
    private Option outputFileOpt;
    protected Option timestampOpt;
    private Option optStartRowExclusive;
    private Option optStartRowInclusive;
    private Option optEndRowExclusive;
    private Option timeoutOption;
    private Option profileOpt;
    private Option sampleOpt;
    private Option contextOpt;

    protected void setupSampling(String tableName, CommandLine cl, Shell shellState, ScannerBase scanner) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        if (this.getUseSample(cl)) {
            SamplerConfiguration samplerConfig = shellState.getConnector().tableOperations().getSamplerConfiguration(tableName);
            if (samplerConfig == null) {
                throw new SampleNotPresentException("Table " + tableName + " does not have sampling configured");
            }
            Shell.log.debug((Object)("Using sampling configuration : " + samplerConfig));
            scanner.setSamplerConfiguration(samplerConfig);
        }
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        try (Shell.PrintFile printFile = this.getOutputFile(cl);){
            String tableName = OptUtil.getTableOpt(cl, shellState);
            Class<? extends Formatter> formatter = this.getFormatter(cl, tableName, shellState);
            ScanInterpreter interpeter = this.getInterpreter(cl, tableName, shellState);
            String classLoaderContext = null;
            if (cl.hasOption(this.contextOpt.getOpt())) {
                classLoaderContext = cl.getOptionValue(this.contextOpt.getOpt());
            }
            Authorizations auths = this.getAuths(cl, shellState);
            Scanner scanner = shellState.getConnector().createScanner(tableName, auths);
            if (null != classLoaderContext) {
                scanner.setClassLoaderContext(classLoaderContext);
            }
            this.addScanIterators(shellState, cl, scanner, tableName);
            scanner.setRange(this.getRange(cl, interpeter));
            this.fetchColumns(cl, (ScannerBase)scanner, interpeter);
            scanner.setTimeout(this.getTimeout(cl), TimeUnit.MILLISECONDS);
            this.setupSampling(tableName, cl, shellState, (ScannerBase)scanner);
            FormatterConfig config = new FormatterConfig();
            config.setPrintTimestamps(cl.hasOption(this.timestampOpt.getOpt()));
            if (cl.hasOption(this.showFewOpt.getOpt())) {
                String showLength = cl.getOptionValue(this.showFewOpt.getOpt());
                try {
                    int length = Integer.parseInt(showLength);
                    config.setShownLength(length);
                }
                catch (NumberFormatException nfe) {
                    shellState.getReader().println((CharSequence)"Arg must be an integer.");
                }
                catch (IllegalArgumentException iae) {
                    shellState.getReader().println((CharSequence)"Arg must be greater than one.");
                }
            }
            this.printRecords(cl, shellState, config, (Iterable<Map.Entry<Key, Value>>)scanner, formatter, printFile);
        }
        return 0;
    }

    protected boolean getUseSample(CommandLine cl) {
        return cl.hasOption(this.sampleOpt.getLongOpt());
    }

    protected long getTimeout(CommandLine cl) {
        if (cl.hasOption(this.timeoutOption.getLongOpt())) {
            return AccumuloConfiguration.getTimeInMillis((String)cl.getOptionValue(this.timeoutOption.getLongOpt()));
        }
        return Long.MAX_VALUE;
    }

    static void ensureTserversCanLoadIterator(Shell shellState, String tableName, String classname) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, ShellCommandException {
        if (!shellState.getConnector().tableOperations().testClassLoad(tableName, classname, SortedKeyValueIterator.class.getName())) {
            throw new ShellCommandException(ShellCommandException.ErrorCode.INITIALIZATION_FAILURE, "Servers are unable to load " + classname + " as type " + SortedKeyValueIterator.class.getName());
        }
    }

    protected void addScanIterators(Shell shellState, CommandLine cl, Scanner scanner, String tableName) throws Exception {
        List<IteratorSetting> tableScanIterators;
        if (cl.hasOption(this.profileOpt.getOpt())) {
            String profile = cl.getOptionValue(this.profileOpt.getOpt());
            tableScanIterators = shellState.iteratorProfiles.get(profile);
            if (tableScanIterators == null) {
                throw new IllegalArgumentException("Profile " + profile + " does not exist");
            }
            for (IteratorSetting iteratorSetting : tableScanIterators) {
                ScanCommand.ensureTserversCanLoadIterator(shellState, tableName, iteratorSetting.getIteratorClass());
            }
        } else {
            tableScanIterators = shellState.scanIteratorOptions.get(tableName);
            if (tableScanIterators == null) {
                Shell.log.debug((Object)"Found no scan iterators to set");
                return;
            }
        }
        Shell.log.debug((Object)("Found " + tableScanIterators.size() + " scan iterators to set"));
        for (IteratorSetting setting : tableScanIterators) {
            Shell.log.debug((Object)("Setting scan iterator " + setting.getName() + " at priority " + setting.getPriority() + " using class name " + setting.getIteratorClass()));
            for (Map.Entry option : setting.getOptions().entrySet()) {
                Shell.log.debug((Object)("Setting option for " + setting.getName() + ": " + (String)option.getKey() + "=" + (String)option.getValue()));
            }
            scanner.addScanIterator(setting);
        }
    }

    protected void printRecords(CommandLine cl, Shell shellState, FormatterConfig config, Iterable<Map.Entry<Key, Value>> scanner, Class<? extends Formatter> formatter, Shell.PrintFile outFile) throws IOException {
        if (outFile == null) {
            shellState.printRecords(scanner, config, !cl.hasOption(this.disablePaginationOpt.getOpt()), formatter);
        } else {
            shellState.printRecords(scanner, config, !cl.hasOption(this.disablePaginationOpt.getOpt()), formatter, outFile);
        }
    }

    protected ScanInterpreter getInterpreter(CommandLine cl, String tableName, Shell shellState) throws Exception {
        Class clazz = null;
        try {
            if (cl.hasOption(this.interpreterOpt.getOpt())) {
                clazz = AccumuloVFSClassLoader.loadClass((String)cl.getOptionValue(this.interpreterOpt.getOpt()), ScanInterpreter.class);
            } else if (cl.hasOption(this.formatterInterpeterOpt.getOpt())) {
                clazz = AccumuloVFSClassLoader.loadClass((String)cl.getOptionValue(this.formatterInterpeterOpt.getOpt()), ScanInterpreter.class);
            }
        }
        catch (ClassNotFoundException e) {
            shellState.getReader().println((CharSequence)("Interpreter class could not be loaded.\n" + e.getMessage()));
        }
        if (clazz == null) {
            clazz = InterpreterCommand.getCurrentInterpreter(tableName, shellState);
        }
        if (clazz == null) {
            clazz = DefaultScanInterpreter.class;
        }
        return clazz.newInstance();
    }

    protected Class<? extends Formatter> getFormatter(CommandLine cl, String tableName, Shell shellState) throws IOException {
        try {
            if (cl.hasOption(this.formatterOpt.getOpt())) {
                return shellState.getClassLoader(cl, shellState).loadClass(cl.getOptionValue(this.formatterOpt.getOpt())).asSubclass(Formatter.class);
            }
            if (cl.hasOption(this.formatterInterpeterOpt.getOpt())) {
                return shellState.getClassLoader(cl, shellState).loadClass(cl.getOptionValue(this.formatterInterpeterOpt.getOpt())).asSubclass(Formatter.class);
            }
        }
        catch (Exception e) {
            shellState.getReader().println((CharSequence)("Formatter class could not be loaded.\n" + e.getMessage()));
        }
        return shellState.getFormatter(tableName);
    }

    protected void fetchColumns(CommandLine cl, ScannerBase scanner, ScanInterpreter formatter) throws UnsupportedEncodingException {
        if (cl.hasOption(this.scanOptColumns.getOpt())) {
            for (String a : cl.getOptionValue(this.scanOptColumns.getOpt()).split(",")) {
                String[] sa = a.split(":", 2);
                if (sa.length == 1) {
                    scanner.fetchColumnFamily(formatter.interpretColumnFamily(new Text(a.getBytes(Shell.CHARSET))));
                    continue;
                }
                scanner.fetchColumn(formatter.interpretColumnFamily(new Text(sa[0].getBytes(Shell.CHARSET))), formatter.interpretColumnQualifier(new Text(sa[1].getBytes(Shell.CHARSET))));
            }
        }
    }

    protected Range getRange(CommandLine cl, ScanInterpreter formatter) throws UnsupportedEncodingException {
        Text endRow;
        if ((cl.hasOption("b") || cl.hasOption("e")) && cl.hasOption(this.scanOptRow.getOpt())) {
            throw new IllegalArgumentException("Options -" + this.scanOptRow.getOpt() + " AND (-" + "b" + " OR -" + "e" + ") are mutally exclusive ");
        }
        if (cl.hasOption(this.scanOptRow.getOpt())) {
            return new Range(formatter.interpretRow(new Text(cl.getOptionValue(this.scanOptRow.getOpt()).getBytes(Shell.CHARSET))));
        }
        Text startRow = OptUtil.getStartRow(cl);
        if (startRow != null) {
            startRow = formatter.interpretBeginRow(startRow);
        }
        if ((endRow = OptUtil.getEndRow(cl)) != null) {
            endRow = formatter.interpretEndRow(endRow);
        }
        boolean startInclusive = !cl.hasOption(this.optStartRowExclusive.getOpt());
        boolean endInclusive = !cl.hasOption(this.optEndRowExclusive.getOpt());
        return new Range(startRow, startInclusive, endRow, endInclusive);
    }

    protected Authorizations getAuths(CommandLine cl, Shell shellState) throws AccumuloSecurityException, AccumuloException {
        String user = shellState.getConnector().whoami();
        Authorizations auths = shellState.getConnector().securityOperations().getUserAuthorizations(user);
        if (cl.hasOption(this.scanOptAuths.getOpt())) {
            auths = ScanCommand.parseAuthorizations(cl.getOptionValue(this.scanOptAuths.getOpt()));
        }
        return auths;
    }

    static Authorizations parseAuthorizations(String field) {
        if (field == null || field.isEmpty()) {
            return Authorizations.EMPTY;
        }
        return new Authorizations(field.split(","));
    }

    @Override
    public String description() {
        return "scans the table, and displays the resulting records";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.scanOptAuths = new Option("s", "scan-authorizations", true, "scan authorizations (all user auths are used if this argument is not specified)");
        this.optStartRowExclusive = new Option("be", "begin-exclusive", false, "make start row exclusive (by default it's inclusive)");
        this.optStartRowExclusive.setArgName("begin-exclusive");
        this.optEndRowExclusive = new Option("ee", "end-exclusive", false, "make end row exclusive (by default it's inclusive)");
        this.optEndRowExclusive.setArgName("end-exclusive");
        this.scanOptRow = new Option("r", "row", true, "row to scan");
        this.scanOptColumns = new Option("c", "columns", true, "comma-separated columns");
        this.timestampOpt = new Option("st", "show-timestamps", false, "display timestamps");
        this.disablePaginationOpt = new Option("np", "no-pagination", false, "disable pagination of output");
        this.showFewOpt = new Option("f", "show-few", true, "show only a specified number of characters");
        this.formatterOpt = new Option("fm", "formatter", true, "fully qualified name of the formatter class to use");
        this.interpreterOpt = new Option("i", "interpreter", true, "fully qualified name of the interpreter class to use");
        this.formatterInterpeterOpt = new Option("fi", "fmt-interpreter", true, "fully qualified name of a class that is a formatter and interpreter");
        this.timeoutOption = new Option(null, "timeout", true, "time before scan should fail if no data is returned. If no unit is given assumes seconds. Units d,h,m,s,and ms are supported. e.g. 30s or 100ms");
        this.outputFileOpt = new Option("o", "output", true, "local file to write the scan output to");
        this.sampleOpt = new Option(null, "sample", false, "Show sample");
        this.contextOpt = new Option("cc", "context", true, "name of the classloader context");
        this.scanOptAuths.setArgName("comma-separated-authorizations");
        this.scanOptRow.setArgName("row");
        this.scanOptColumns.setArgName("<columnfamily>[:<columnqualifier>]{,<columnfamily>[:<columnqualifier>]}");
        this.showFewOpt.setRequired(false);
        this.showFewOpt.setArgName("int");
        this.formatterOpt.setArgName("className");
        this.timeoutOption.setArgName("timeout");
        this.outputFileOpt.setArgName("file");
        this.contextOpt.setArgName("context");
        this.profileOpt = new Option("pn", "profile", true, "iterator profile name");
        this.profileOpt.setArgName("profile");
        o.addOption(this.scanOptAuths);
        o.addOption(this.scanOptRow);
        this.optStartRowInclusive = new Option("b", "begin-row", true, "begin row (inclusive)");
        this.optStartRowInclusive.setArgName("begin-row");
        o.addOption(this.optStartRowInclusive);
        o.addOption(OptUtil.endRowOpt());
        o.addOption(this.optStartRowExclusive);
        o.addOption(this.optEndRowExclusive);
        o.addOption(this.scanOptColumns);
        o.addOption(this.timestampOpt);
        o.addOption(this.disablePaginationOpt);
        o.addOption(OptUtil.tableOpt("table to be scanned"));
        o.addOption(this.showFewOpt);
        o.addOption(this.formatterOpt);
        o.addOption(this.interpreterOpt);
        o.addOption(this.formatterInterpeterOpt);
        o.addOption(this.timeoutOption);
        if (Arrays.asList(ScanCommand.class.getName(), GrepCommand.class.getName(), EGrepCommand.class.getName()).contains(this.getClass().getName())) {
            o.addOption(this.outputFileOpt);
        }
        o.addOption(this.profileOpt);
        o.addOption(this.sampleOpt);
        o.addOption(this.contextOpt);
        return o;
    }

    @Override
    public int numArgs() {
        return 0;
    }

    protected Shell.PrintFile getOutputFile(CommandLine cl) throws FileNotFoundException {
        String outputFile = cl.getOptionValue(this.outputFileOpt.getOpt());
        return outputFile == null ? null : new Shell.PrintFile(outputFile);
    }
}

