/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Durability;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.CompressedIterators;
import org.apache.accumulo.core.client.impl.DurabilityImpl;
import org.apache.accumulo.core.client.impl.ScannerImpl;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.client.impl.TabletType;
import org.apache.accumulo.core.client.impl.Translator;
import org.apache.accumulo.core.client.impl.Translators;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.ConstraintViolationSummary;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.data.thrift.InitialMultiScan;
import org.apache.accumulo.core.data.thrift.InitialScan;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.accumulo.core.data.thrift.MapFileInfo;
import org.apache.accumulo.core.data.thrift.MultiScanResult;
import org.apache.accumulo.core.data.thrift.ScanResult;
import org.apache.accumulo.core.data.thrift.TCMResult;
import org.apache.accumulo.core.data.thrift.TCMStatus;
import org.apache.accumulo.core.data.thrift.TColumn;
import org.apache.accumulo.core.data.thrift.TConditionalMutation;
import org.apache.accumulo.core.data.thrift.TConditionalSession;
import org.apache.accumulo.core.data.thrift.TKeyExtent;
import org.apache.accumulo.core.data.thrift.TMutation;
import org.apache.accumulo.core.data.thrift.TRange;
import org.apache.accumulo.core.data.thrift.UpdateErrors;
import org.apache.accumulo.core.iterators.IterationInterruptedException;
import org.apache.accumulo.core.master.thrift.BulkImportState;
import org.apache.accumulo.core.master.thrift.Compacting;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletLoadState;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.replication.thrift.ReplicationServicer;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.core.tabletserver.thrift.ActiveCompaction;
import org.apache.accumulo.core.tabletserver.thrift.ActiveScan;
import org.apache.accumulo.core.tabletserver.thrift.ConstraintViolationException;
import org.apache.accumulo.core.tabletserver.thrift.NoSuchScanIDException;
import org.apache.accumulo.core.tabletserver.thrift.NotServingTabletException;
import org.apache.accumulo.core.tabletserver.thrift.TDurability;
import org.apache.accumulo.core.tabletserver.thrift.TSampleNotPresentException;
import org.apache.accumulo.core.tabletserver.thrift.TSamplerConfiguration;
import org.apache.accumulo.core.tabletserver.thrift.TUnloadTabletGoal;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.tabletserver.thrift.TabletStats;
import org.apache.accumulo.core.trace.DistributedTrace;
import org.apache.accumulo.core.trace.Span;
import org.apache.accumulo.core.trace.Trace;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.ColumnFQ;
import org.apache.accumulo.core.util.ComparablePair;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.MapCounter;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.ServerServices;
import org.apache.accumulo.core.util.SimpleThreadPool;
import org.apache.accumulo.core.util.ratelimit.RateLimiter;
import org.apache.accumulo.core.util.ratelimit.SharedRateLimiterFactory;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.util.LoggingRunnable;
import org.apache.accumulo.fate.util.Retry;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.Accumulo;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.GarbageCollectionLogger;
import org.apache.accumulo.server.ServerOpts;
import org.apache.accumulo.server.TabletLevel;
import org.apache.accumulo.server.client.ClientServiceHandler;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.data.ServerMutation;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.log.SortedLogState;
import org.apache.accumulo.server.log.WalStateManager;
import org.apache.accumulo.server.master.recovery.RecoveryPath;
import org.apache.accumulo.server.master.state.Assignment;
import org.apache.accumulo.server.master.state.DistributedStoreException;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.master.state.TabletStateStore;
import org.apache.accumulo.server.master.state.ZooTabletStateStore;
import org.apache.accumulo.server.master.tableOps.UserCompactionConfig;
import org.apache.accumulo.server.metrics.Metrics;
import org.apache.accumulo.server.metrics.MetricsSystemHelper;
import org.apache.accumulo.server.problems.ProblemReport;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.accumulo.server.replication.ZooKeeperInitialization;
import org.apache.accumulo.server.rpc.RpcWrapper;
import org.apache.accumulo.server.rpc.ServerAddress;
import org.apache.accumulo.server.rpc.TCredentialsUpdatingWrapper;
import org.apache.accumulo.server.rpc.TServerUtils;
import org.apache.accumulo.server.rpc.ThriftServerType;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.security.SecurityOperation;
import org.apache.accumulo.server.security.SecurityUtil;
import org.apache.accumulo.server.security.delegation.AuthenticationTokenSecretManager;
import org.apache.accumulo.server.security.delegation.ZooAuthenticationKeyWatcher;
import org.apache.accumulo.server.util.FileSystemMonitor;
import org.apache.accumulo.server.util.Halt;
import org.apache.accumulo.server.util.MasterMetadataUtil;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.util.ServerBulkImportStatus;
import org.apache.accumulo.server.util.time.RelativeTime;
import org.apache.accumulo.server.util.time.SimpleTimer;
import org.apache.accumulo.server.zookeeper.DistributedWorkQueue;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.accumulo.server.zookeeper.ZooCache;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.accumulo.start.classloader.vfs.ContextManager;
import org.apache.accumulo.tserver.BulkFailedCopyProcessor;
import org.apache.accumulo.tserver.BusiestTracker;
import org.apache.accumulo.tserver.ConditionCheckerContext;
import org.apache.accumulo.tserver.ConditionalMutationSet;
import org.apache.accumulo.tserver.HoldTimeoutException;
import org.apache.accumulo.tserver.MinorCompactionReason;
import org.apache.accumulo.tserver.Mutations;
import org.apache.accumulo.tserver.RowLocks;
import org.apache.accumulo.tserver.TConstraintViolationException;
import org.apache.accumulo.tserver.TabletServerResourceManager;
import org.apache.accumulo.tserver.TabletStatsKeeper;
import org.apache.accumulo.tserver.TooManyFilesException;
import org.apache.accumulo.tserver.TservConstraintEnv;
import org.apache.accumulo.tserver.WriteTracker;
import org.apache.accumulo.tserver.compaction.MajorCompactionReason;
import org.apache.accumulo.tserver.data.ServerConditionalMutation;
import org.apache.accumulo.tserver.log.DfsLogger;
import org.apache.accumulo.tserver.log.LogSorter;
import org.apache.accumulo.tserver.log.MutationReceiver;
import org.apache.accumulo.tserver.log.TabletServerLogger;
import org.apache.accumulo.tserver.mastermessage.MasterMessage;
import org.apache.accumulo.tserver.mastermessage.SplitReportMessage;
import org.apache.accumulo.tserver.mastermessage.TabletStatusMessage;
import org.apache.accumulo.tserver.metrics.TabletServerMetricsFactory;
import org.apache.accumulo.tserver.replication.ReplicationServicerHandler;
import org.apache.accumulo.tserver.replication.ReplicationWorker;
import org.apache.accumulo.tserver.scan.LookupTask;
import org.apache.accumulo.tserver.scan.NextBatchTask;
import org.apache.accumulo.tserver.scan.ScanRunState;
import org.apache.accumulo.tserver.session.ConditionalSession;
import org.apache.accumulo.tserver.session.MultiScanSession;
import org.apache.accumulo.tserver.session.ScanSession;
import org.apache.accumulo.tserver.session.Session;
import org.apache.accumulo.tserver.session.SessionManager;
import org.apache.accumulo.tserver.session.UpdateSession;
import org.apache.accumulo.tserver.tablet.BulkImportCacheCleaner;
import org.apache.accumulo.tserver.tablet.CommitSession;
import org.apache.accumulo.tserver.tablet.CompactionInfo;
import org.apache.accumulo.tserver.tablet.CompactionWatcher;
import org.apache.accumulo.tserver.tablet.Compactor;
import org.apache.accumulo.tserver.tablet.KVEntry;
import org.apache.accumulo.tserver.tablet.ScanBatch;
import org.apache.accumulo.tserver.tablet.Tablet;
import org.apache.accumulo.tserver.tablet.TabletClosedException;
import org.apache.accumulo.tserver.tablet.TabletData;
import org.apache.commons.collections.map.LRUMap;
import org.apache.hadoop.fs.FSError;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TBaseProcessor;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.TServiceClientFactory;
import org.apache.thrift.server.TServer;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletServer
extends AccumuloServerContext
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(TabletServer.class);
    private static final long MAX_TIME_TO_WAIT_FOR_SCAN_RESULT_MILLIS = 1000L;
    private static final long RECENTLY_SPLIT_MILLIES = 60000L;
    private static final long TIME_BETWEEN_GC_CHECKS = 5000L;
    private static final long TIME_BETWEEN_LOCATOR_CACHE_CLEARS = 3600000L;
    private final GarbageCollectionLogger gcLogger = new GarbageCollectionLogger();
    private final TransactionWatcher watcher = new TransactionWatcher();
    private final ZooCache masterLockCache = new ZooCache();
    private final TabletServerLogger logger;
    private final TabletServerMetricsFactory metricsFactory;
    private final Metrics updateMetrics;
    private final Metrics scanMetrics;
    private final Metrics mincMetrics;
    private final LogSorter logSorter;
    private ReplicationWorker replWorker = null;
    private final TabletStatsKeeper statsKeeper;
    private final AtomicInteger logIdGenerator = new AtomicInteger();
    private final AtomicLong flushCounter = new AtomicLong(0L);
    private final AtomicLong syncCounter = new AtomicLong(0L);
    private final VolumeManager fs;
    private final SortedMap<KeyExtent, Tablet> onlineTablets = Collections.synchronizedSortedMap(new TreeMap());
    private final SortedSet<KeyExtent> unopenedTablets = Collections.synchronizedSortedSet(new TreeSet());
    private final SortedSet<KeyExtent> openingTablets = Collections.synchronizedSortedSet(new TreeSet());
    private final Map<KeyExtent, Long> recentlyUnloadedCache = Collections.synchronizedMap(new LRUMap(1000));
    private final TabletServerResourceManager resourceManager;
    private final SecurityOperation security;
    private final BlockingDeque<MasterMessage> masterMessages = new LinkedBlockingDeque<MasterMessage>();
    private Thread majorCompactorThread;
    private HostAndPort replicationAddress;
    private HostAndPort clientAddress;
    private volatile boolean serverStopRequested = false;
    private volatile boolean shutdownComplete = false;
    private ZooLock tabletServerLock;
    private TServer server;
    private TServer replServer;
    private DistributedWorkQueue bulkFailedCopyQ;
    private String lockID;
    public static final AtomicLong seekCount = new AtomicLong(0L);
    private final AtomicLong totalMinorCompactions = new AtomicLong(0L);
    private final ServerConfigurationFactory confFactory;
    private final ZooAuthenticationKeyWatcher authKeyWatcher;
    private final WalStateManager walMarker;
    private final SessionManager sessionManager;
    private final WriteTracker writeTracker = new WriteTracker();
    private final RowLocks rowLocks = new RowLocks();
    private final AtomicLong totalQueuedMutationSize = new AtomicLong(0L);
    private final ReentrantLock recoveryLock = new ReentrantLock(true);
    private ThriftClientHandler clientHandler;
    private final ServerBulkImportStatus bulkImportStatus = new ServerBulkImportStatus();
    final ConcurrentHashMap<DfsLogger, EnumSet<TabletLevel>> metadataTableLogs = new ConcurrentHashMap();
    final Object[] levelLocks = new Object[TabletLevel.values().length];
    LinkedHashSet<DfsLogger> closedLogs;
    private static final String MAJC_READ_LIMITER_KEY = "tserv_majc_read";
    private static final String MAJC_WRITE_LIMITER_KEY = "tserv_majc_write";
    private final SharedRateLimiterFactory.RateProvider rateProvider;

    public Metrics getScanMetrics() {
        return this.scanMetrics;
    }

    public Metrics getMinCMetrics() {
        return this.mincMetrics;
    }

    public TabletServer(ServerConfigurationFactory confFactory, VolumeManager fs) throws IOException {
        super(confFactory);
        for (int i = 0; i < this.levelLocks.length; ++i) {
            this.levelLocks[i] = new Object();
        }
        this.closedLogs = new LinkedHashSet();
        this.rateProvider = new SharedRateLimiterFactory.RateProvider(){

            public long getDesiredRate() {
                return TabletServer.this.getConfiguration().getMemoryInBytes(Property.TSERV_MAJC_THROUGHPUT);
            }
        };
        this.confFactory = confFactory;
        this.fs = fs;
        AccumuloConfiguration aconf = this.getConfiguration();
        Instance instance = this.getInstance();
        log.info("Version 1.10.2");
        log.info("Instance " + instance.getInstanceID());
        this.sessionManager = new SessionManager(aconf);
        this.logSorter = new LogSorter(instance, fs, aconf);
        this.replWorker = new ReplicationWorker((ClientContext)this, fs);
        this.statsKeeper = new TabletStatsKeeper();
        final int numBusyTabletsToLog = aconf.getCount(Property.TSERV_LOG_BUSY_TABLETS_COUNT);
        long logBusyTabletsDelay = aconf.getTimeInMillis(Property.TSERV_LOG_BUSY_TABLETS_INTERVAL);
        if (numBusyTabletsToLog > 0) {
            SimpleTimer.getInstance((AccumuloConfiguration)aconf).schedule(new Runnable(){
                private BusiestTracker ingestTracker;
                private BusiestTracker queryTracker;
                {
                    this.ingestTracker = BusiestTracker.newBusiestIngestTracker(numBusyTabletsToLog);
                    this.queryTracker = BusiestTracker.newBusiestQueryTracker(numBusyTabletsToLog);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ArrayList<Tablet> tablets;
                    SortedMap sortedMap = TabletServer.this.onlineTablets;
                    synchronized (sortedMap) {
                        tablets = new ArrayList<Tablet>(TabletServer.this.onlineTablets.values());
                    }
                    this.logBusyTablets(this.ingestTracker.computeBusiest(tablets), "ingest count");
                    this.logBusyTablets(this.queryTracker.computeBusiest(tablets), "query count");
                }

                private void logBusyTablets(List<ComparablePair<Long, KeyExtent>> busyTablets, String label) {
                    int i = 1;
                    for (Pair pair : busyTablets) {
                        log.debug("{} busiest tablet by {}: {} -- extent: {} ", new Object[]{i, label.toLowerCase(), pair.getFirst(), pair.getSecond()});
                        ++i;
                    }
                }
            }, logBusyTabletsDelay, logBusyTabletsDelay);
        }
        SimpleTimer.getInstance((AccumuloConfiguration)aconf).schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SortedMap sortedMap = TabletServer.this.onlineTablets;
                synchronized (sortedMap) {
                    long now = System.currentTimeMillis();
                    for (Tablet tablet : TabletServer.this.onlineTablets.values()) {
                        try {
                            tablet.updateRates(now);
                        }
                        catch (Exception ex) {
                            log.error("Error updating rates for {}", (Object)tablet.getExtent(), (Object)ex);
                        }
                    }
                }
            }
        }, 5000L, 5000L);
        long walogMaxSize = aconf.getMemoryInBytes(Property.TSERV_WALOG_MAX_SIZE);
        long walogMaxAge = aconf.getTimeInMillis(Property.TSERV_WALOG_MAX_AGE);
        long minBlockSize = CachedConfiguration.getInstance().getLong("dfs.namenode.fs-limits.min-block-size", 0L);
        if (minBlockSize != 0L && minBlockSize > walogMaxSize) {
            throw new RuntimeException("Unable to start TabletServer. Logger is set to use blocksize " + walogMaxSize + " but hdfs minimum block size is " + minBlockSize + ". Either increase the " + Property.TSERV_WALOG_MAX_SIZE + " or decrease dfs.namenode.fs-limits.min-block-size in hdfs-site.xml.");
        }
        long toleratedWalCreationFailures = aconf.getCount(Property.TSERV_WALOG_TOLERATED_CREATION_FAILURES);
        long walFailureRetryIncrement = aconf.getTimeInMillis(Property.TSERV_WALOG_TOLERATED_WAIT_INCREMENT);
        long walFailureRetryMax = aconf.getTimeInMillis(Property.TSERV_WALOG_TOLERATED_MAXIMUM_WAIT_DURATION);
        Retry.RetryFactory walCreationRetryFactory = Retry.builder().maxRetries(toleratedWalCreationFailures).retryAfter(walFailureRetryIncrement, TimeUnit.MILLISECONDS).incrementBy(walFailureRetryIncrement, TimeUnit.MILLISECONDS).maxWait(walFailureRetryMax, TimeUnit.MILLISECONDS).logInterval(3L, TimeUnit.MINUTES).createFactory();
        Retry.RetryFactory walWritingRetryFactory = Retry.builder().infiniteRetries().retryAfter(walFailureRetryIncrement, TimeUnit.MILLISECONDS).incrementBy(walFailureRetryIncrement, TimeUnit.MILLISECONDS).maxWait(walFailureRetryMax, TimeUnit.MILLISECONDS).logInterval(3L, TimeUnit.MINUTES).createFactory();
        this.logger = new TabletServerLogger(this, walogMaxSize, this.syncCounter, this.flushCounter, walCreationRetryFactory, walWritingRetryFactory, walogMaxAge);
        this.resourceManager = new TabletServerResourceManager(this, fs);
        this.security = AuditedSecurityOperation.getInstance((AccumuloServerContext)this);
        this.metricsFactory = new TabletServerMetricsFactory(aconf);
        this.updateMetrics = this.metricsFactory.createUpdateMetrics();
        this.scanMetrics = this.metricsFactory.createScanMetrics();
        this.mincMetrics = this.metricsFactory.createMincMetrics();
        SimpleTimer.getInstance((AccumuloConfiguration)aconf).schedule(new Runnable(){

            @Override
            public void run() {
                TabletLocator.clearLocators();
            }
        }, TabletServer.jitter(3600000L), TabletServer.jitter(3600000L));
        this.walMarker = new WalStateManager(instance, ZooReaderWriter.getInstance());
        this.setSecretManager(new AuthenticationTokenSecretManager(instance, aconf.getTimeInMillis(Property.GENERAL_DELEGATION_TOKEN_LIFETIME)));
        if (aconf.getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
            log.info("SASL is enabled, creating ZooKeeper watcher for AuthenticationKeys");
            this.authKeyWatcher = new ZooAuthenticationKeyWatcher(this.getSecretManager(), (ZooReader)ZooReaderWriter.getInstance(), ZooUtil.getRoot((Instance)instance) + "/delegation_token_keys");
        } else {
            this.authKeyWatcher = null;
        }
    }

    private static long jitter(long ms) {
        Random r = new Random();
        return (long)((1.0 + r.nextDouble() / 10.0) * (double)ms);
    }

    public long updateTotalQueuedMutationSize(long additionalMutationSize) {
        return this.totalQueuedMutationSize.addAndGet(additionalMutationSize);
    }

    public Tablet getOnlineTablet(KeyExtent extent) {
        return (Tablet)this.onlineTablets.get(extent);
    }

    public Session getSession(long sessionId) {
        return this.sessionManager.getSession(sessionId);
    }

    public void executeSplit(Tablet tablet) {
        this.resourceManager.executeSplit(tablet.getExtent(), (Runnable)new LoggingRunnable(log, (Runnable)new SplitRunner(tablet)));
    }

    private void splitTablet(Tablet tablet) {
        try {
            TreeMap<KeyExtent, TabletData> tabletInfo = this.splitTablet(tablet, null);
            if (tabletInfo == null) {
                tablet.initiateMajorCompaction(MajorCompactionReason.NORMAL);
            }
        }
        catch (IOException e) {
            this.statsKeeper.updateTime(TabletStatsKeeper.Operation.SPLIT, 0L, 0L, true);
            log.error("split failed: {} for tablet {}", new Object[]{e.getMessage(), tablet.getExtent(), e});
        }
        catch (Exception e) {
            this.statsKeeper.updateTime(TabletStatsKeeper.Operation.SPLIT, 0L, 0L, true);
            log.error("Unknown error on split: {}", (Object)e, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeMap<KeyExtent, TabletData> splitTablet(Tablet tablet, byte[] splitPoint) throws IOException {
        long t1 = System.currentTimeMillis();
        TreeMap<KeyExtent, TabletData> tabletInfo = tablet.split(splitPoint);
        if (tabletInfo == null) {
            return null;
        }
        log.info("Starting split: " + tablet.getExtent());
        this.statsKeeper.incrementStatusSplit();
        long start = System.currentTimeMillis();
        Tablet[] newTablets = new Tablet[2];
        Map.Entry<KeyExtent, TabletData> first = tabletInfo.firstEntry();
        TabletServerResourceManager.TabletResourceManager newTrm0 = this.resourceManager.createTabletResourceManager(first.getKey(), (AccumuloConfiguration)this.getTableConfiguration(first.getKey()));
        newTablets[0] = new Tablet(this, first.getKey(), newTrm0, first.getValue());
        Map.Entry<KeyExtent, TabletData> last = tabletInfo.lastEntry();
        TabletServerResourceManager.TabletResourceManager newTrm1 = this.resourceManager.createTabletResourceManager(last.getKey(), (AccumuloConfiguration)this.getTableConfiguration(last.getKey()));
        newTablets[1] = new Tablet(this, last.getKey(), newTrm1, last.getValue());
        this.statsKeeper.saveMajorMinorTimes(tablet.getTabletStats());
        SortedMap<KeyExtent, Tablet> sortedMap = this.onlineTablets;
        synchronized (sortedMap) {
            this.onlineTablets.remove(tablet.getExtent());
            this.onlineTablets.put(newTablets[0].getExtent(), newTablets[0]);
            this.onlineTablets.put(newTablets[1].getExtent(), newTablets[1]);
        }
        this.enqueueMasterMessage(new SplitReportMessage(tablet.getExtent(), newTablets[0].getExtent(), new Text("/" + newTablets[0].getLocation().getName()), newTablets[1].getExtent(), new Text("/" + newTablets[1].getLocation().getName())));
        this.statsKeeper.updateTime(TabletStatsKeeper.Operation.SPLIT, start, 0L, false);
        long t2 = System.currentTimeMillis();
        log.info("Tablet split: " + tablet.getExtent() + " size0 " + newTablets[0].estimateTabletSize() + " size1 " + newTablets[1].estimateTabletSize() + " time " + (t2 - t1) + "ms");
        return tabletInfo;
    }

    public void enqueueMasterMessage(MasterMessage m) {
        this.masterMessages.addLast(m);
    }

    private void acquireRecoveryMemory(KeyExtent extent) throws InterruptedException {
        if (!extent.isMeta()) {
            this.recoveryLock.lock();
        }
    }

    private void releaseRecoveryMemory(KeyExtent extent) {
        if (!extent.isMeta()) {
            this.recoveryLock.unlock();
        }
    }

    private HostAndPort startServer(AccumuloConfiguration conf, String address, Property portHint, TProcessor processor, String threadName) throws UnknownHostException {
        Property maxMessageSizeProperty = conf.get(Property.TSERV_MAX_MESSAGE_SIZE) != null ? Property.TSERV_MAX_MESSAGE_SIZE : Property.GENERAL_MAX_MESSAGE_SIZE;
        ServerAddress sp = TServerUtils.startServer((AccumuloServerContext)this, (String)address, (Property)portHint, (TProcessor)processor, (String)this.getClass().getSimpleName(), (String)threadName, (Property)Property.TSERV_PORTSEARCH, (Property)Property.TSERV_MINTHREADS, (Property)Property.TSERV_THREADCHECK, (Property)maxMessageSizeProperty);
        this.server = sp.server;
        return sp.address;
    }

    private HostAndPort getMasterAddress() {
        try {
            List locations = this.getInstance().getMasterLocations();
            if (locations.size() == 0) {
                return null;
            }
            return HostAndPort.fromString((String)((String)locations.get(0)));
        }
        catch (Exception e) {
            log.warn("Failed to obtain master host " + e);
            return null;
        }
    }

    private MasterClientService.Client masterConnection(HostAndPort address) {
        try {
            if (address == null) {
                return null;
            }
            MasterClientService.Client client = (MasterClientService.Client)ThriftUtil.getClient((TServiceClientFactory)new MasterClientService.Client.Factory(), (HostAndPort)address, (ClientContext)this);
            return client;
        }
        catch (Exception e) {
            log.warn("Issue with masterConnection (" + address + ") " + e, (Throwable)e);
            return null;
        }
    }

    private void returnMasterConnection(MasterClientService.Client client) {
        ThriftUtil.returnClient((TServiceClient)client);
    }

    private HostAndPort startTabletClientService() throws UnknownHostException {
        TabletClientService.Processor processor;
        this.clientHandler = new ThriftClientHandler();
        TabletClientService.Iface rpcProxy = (TabletClientService.Iface)RpcWrapper.service((Object)((Object)this.clientHandler), (TBaseProcessor)new TabletClientService.Processor((TabletClientService.Iface)this.clientHandler));
        if (ThriftServerType.SASL == this.getThriftServerType()) {
            TabletClientService.Iface tcredProxy = (TabletClientService.Iface)TCredentialsUpdatingWrapper.service((Object)rpcProxy, ThriftClientHandler.class, (AccumuloConfiguration)this.getConfiguration());
            processor = new TabletClientService.Processor(tcredProxy);
        } else {
            processor = new TabletClientService.Processor(rpcProxy);
        }
        HostAndPort address = this.startServer(this.getServerConfigurationFactory().getConfiguration(), this.clientAddress.getHost(), Property.TSERV_CLIENTPORT, (TProcessor)processor, "Thrift Client Server");
        log.info("address = " + address);
        return address;
    }

    private HostAndPort startReplicationService() throws UnknownHostException {
        ReplicationServicerHandler handler = new ReplicationServicerHandler(this);
        ReplicationServicer.Iface rpcProxy = (ReplicationServicer.Iface)RpcWrapper.service((Object)handler, (TBaseProcessor)new ReplicationServicer.Processor((ReplicationServicer.Iface)handler));
        ReplicationServicer.Iface repl = (ReplicationServicer.Iface)TCredentialsUpdatingWrapper.service((Object)rpcProxy, handler.getClass(), (AccumuloConfiguration)this.getConfiguration());
        ReplicationServicer.Processor processor = new ReplicationServicer.Processor(repl);
        AccumuloConfiguration conf = this.getServerConfigurationFactory().getConfiguration();
        Property maxMessageSizeProperty = conf.get(Property.TSERV_MAX_MESSAGE_SIZE) != null ? Property.TSERV_MAX_MESSAGE_SIZE : Property.GENERAL_MAX_MESSAGE_SIZE;
        ServerAddress sp = TServerUtils.startServer((AccumuloServerContext)this, (String)this.clientAddress.getHost(), (Property)Property.REPLICATION_RECEIPT_SERVICE_PORT, (TProcessor)processor, (String)"ReplicationServicerHandler", (String)"Replication Servicer", null, (Property)Property.REPLICATION_MIN_THREADS, (Property)Property.REPLICATION_THREADCHECK, (Property)maxMessageSizeProperty);
        this.replServer = sp.server;
        log.info("Started replication service on " + sp.address);
        try {
            ZooReaderWriter.getInstance().putPersistentData(ZooUtil.getRoot((Instance)this.getInstance()) + "/replication/tservers" + "/" + this.clientAddress.toString(), sp.address.toString().getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.OVERWRITE);
        }
        catch (Exception e) {
            log.error("Could not advertise replication service port", (Throwable)e);
            throw new RuntimeException(e);
        }
        return sp.address;
    }

    public ZooLock getLock() {
        return this.tabletServerLock;
    }

    private void announceExistence() {
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        try {
            String zPath = ZooUtil.getRoot((Instance)this.getInstance()) + "/tservers" + "/" + this.getClientAddressString();
            try {
                zoo.putPersistentData(zPath, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
            }
            catch (KeeperException e) {
                if (KeeperException.Code.NOAUTH == e.code()) {
                    log.error("Failed to write to ZooKeeper. Ensure that accumulo-site.xml, specifically instance.secret, is consistent.");
                }
                throw e;
            }
            this.tabletServerLock = new ZooLock(zPath);
            ZooLock.LockWatcher lw = new ZooLock.LockWatcher(){

                public void lostLock(final ZooLock.LockLossReason reason) {
                    Halt.halt((int)(TabletServer.this.serverStopRequested ? 0 : 1), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (!TabletServer.this.serverStopRequested) {
                                log.error("Lost tablet server lock (reason = " + reason + "), exiting.");
                            }
                            TabletServer.this.gcLogger.logGCInfo(TabletServer.this.getConfiguration());
                        }
                    });
                }

                public void unableToMonitorLockNode(final Throwable e) {
                    Halt.halt((int)1, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            log.error("Lost ability to monitor tablet server lock, exiting.", e);
                        }
                    });
                }
            };
            byte[] lockContent = new ServerServices(this.getClientAddressString(), ServerServices.Service.TSERV_CLIENT).toString().getBytes(StandardCharsets.UTF_8);
            for (int i = 0; i < 24; ++i) {
                zoo.putPersistentData(zPath, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
                if (this.tabletServerLock.tryLock(lw, lockContent)) {
                    log.debug("Obtained tablet server lock " + this.tabletServerLock.getLockPath());
                    this.lockID = this.tabletServerLock.getLockID().serialize(ZooUtil.getRoot((Instance)this.getInstance()) + "/tservers" + "/");
                    return;
                }
                log.info("Waiting for tablet server lock");
                UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
            }
            String msg = "Too many retries, exiting.";
            log.info(msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.info("Could not obtain tablet server lock, exiting.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SecurityUtil.serverLogin((AccumuloConfiguration)SiteConfiguration.getInstance());
        try {
            ZooKeeperInitialization.ensureZooKeeperInitialized((ZooReaderWriter)ZooReaderWriter.getInstance(), (String)ZooUtil.getRoot((Instance)this.getInstance()));
        }
        catch (InterruptedException | KeeperException e) {
            log.error("Could not ensure that ZooKeeper is properly initialized", e);
            throw new RuntimeException(e);
        }
        Metrics tserverMetrics = this.metricsFactory.createTabletServerMetrics(this);
        try {
            tserverMetrics.register();
            this.mincMetrics.register();
            this.scanMetrics.register();
            this.updateMetrics.register();
        }
        catch (Exception e) {
            log.error("Error registering with JMX", (Throwable)e);
        }
        if (null != this.authKeyWatcher) {
            log.info("Seeding ZooKeeper watcher for authentication keys");
            try {
                this.authKeyWatcher.updateAuthKeys();
            }
            catch (InterruptedException | KeeperException e) {
                log.error("Failed to perform initial check for authentication tokens in ZooKeeper. Delegation token authentication will be unavailable.", e);
            }
        }
        try {
            this.clientAddress = this.startTabletClientService();
        }
        catch (UnknownHostException e1) {
            throw new RuntimeException("Failed to start the tablet client service", e1);
        }
        this.announceExistence();
        try {
            this.walMarker.initWalMarker(this.getTabletSession());
        }
        catch (Exception e) {
            log.error("Unable to create WAL marker node in zookeeper", (Throwable)e);
            throw new RuntimeException(e);
        }
        SimpleThreadPool distWorkQThreadPool = new SimpleThreadPool(this.getConfiguration().getCount(Property.TSERV_WORKQ_THREADS), "distributed work queue");
        this.bulkFailedCopyQ = new DistributedWorkQueue(ZooUtil.getRoot((Instance)this.getInstance()) + "/bulk_failed_copyq", this.getConfiguration());
        try {
            this.bulkFailedCopyQ.startProcessing((DistributedWorkQueue.Processor)new BulkFailedCopyProcessor(), (ThreadPoolExecutor)distWorkQThreadPool);
        }
        catch (Exception e1) {
            throw new RuntimeException("Failed to start distributed work queue for copying ", e1);
        }
        try {
            this.logSorter.startWatchingForRecoveryLogs((ThreadPoolExecutor)distWorkQThreadPool);
        }
        catch (Exception ex) {
            log.error("Error setting watches for recoveries");
            throw new RuntimeException(ex);
        }
        try {
            this.replicationAddress = this.startReplicationService();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Failed to start replication service", e);
        }
        SimpleThreadPool replicationThreadPool = new SimpleThreadPool(this.getConfiguration().getCount(Property.REPLICATION_WORKER_THREADS), "replication task");
        this.replWorker.setExecutor((ThreadPoolExecutor)replicationThreadPool);
        this.replWorker.run();
        final AccumuloConfiguration aconf = this.getConfiguration();
        Runnable replicationWorkThreadPoolResizer = new Runnable((ThreadPoolExecutor)replicationThreadPool){
            final /* synthetic */ ThreadPoolExecutor val$replicationThreadPool;
            {
                this.val$replicationThreadPool = threadPoolExecutor;
            }

            @Override
            public void run() {
                int maxPoolSize = aconf.getCount(Property.REPLICATION_WORKER_THREADS);
                if (this.val$replicationThreadPool.getMaximumPoolSize() != maxPoolSize) {
                    log.info("Resizing thread pool for sending replication work from " + this.val$replicationThreadPool.getMaximumPoolSize() + " to " + maxPoolSize);
                    this.val$replicationThreadPool.setMaximumPoolSize(maxPoolSize);
                }
            }
        };
        SimpleTimer.getInstance((AccumuloConfiguration)aconf).schedule(replicationWorkThreadPoolResizer, 10000L, 30000L);
        long CLEANUP_BULK_LOADED_CACHE_MILLIS = 900000L;
        SimpleTimer.getInstance((AccumuloConfiguration)aconf).schedule((Runnable)new BulkImportCacheCleaner(this), 900000L, 900000L);
        while (!this.serverStopRequested) {
            try {
                MasterClientService.Client iface;
                block38: {
                    MasterMessage mm = null;
                    iface = null;
                    try {
                        while (mm == null && !this.serverStopRequested) {
                            mm = this.masterMessages.poll(1000L, TimeUnit.MILLISECONDS);
                        }
                        HostAndPort masterHost = this.getMasterAddress();
                        MasterClientService.Client client = iface = this.masterConnection(masterHost);
                        while (!this.serverStopRequested && mm != null && client != null && client.getOutputProtocol() != null && client.getOutputProtocol().getTransport() != null && client.getOutputProtocol().getTransport().isOpen()) {
                            try {
                                mm.send(this.rpcCreds(), this.getClientAddressString(), (MasterClientService.Iface)iface);
                                mm = null;
                            }
                            catch (TException ex) {
                                log.warn("Error sending message: queuing message again");
                                this.masterMessages.putFirst(mm);
                                mm = null;
                                throw ex;
                            }
                            mm = this.masterMessages.poll();
                        }
                        if (mm == null) break block38;
                    }
                    catch (Throwable throwable) {
                        if (mm != null) {
                            this.masterMessages.putFirst(mm);
                        }
                        this.returnMasterConnection(iface);
                        UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                        throw throwable;
                    }
                    this.masterMessages.putFirst(mm);
                }
                this.returnMasterConnection(iface);
                UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.info("Interrupt Exception received, shutting down");
                this.serverStopRequested = true;
            }
            catch (Exception e) {
                log.error(this.getClientAddressString() + ": TServerInfo: Exception. Master down?", (Throwable)e);
            }
        }
        TabletServer e = this;
        synchronized (e) {
            while (!this.shutdownComplete) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e2) {
                    log.error(e2.toString());
                }
            }
        }
        log.debug("Stopping Replication Server");
        TServerUtils.stopTServer((TServer)this.replServer);
        log.debug("Stopping Thrift Servers");
        TServerUtils.stopTServer((TServer)this.server);
        try {
            log.debug("Closing filesystem");
            this.fs.close();
        }
        catch (IOException e2) {
            log.warn("Failed to close filesystem : {}", (Object)e2.getMessage(), (Object)e2);
        }
        this.gcLogger.logGCInfo(this.getConfiguration());
        log.info("TServerInfo: stop requested. exiting ... ");
        try {
            this.tabletServerLock.unlock();
        }
        catch (Exception e3) {
            log.warn("Failed to release tablet server lock", (Throwable)e3);
        }
    }

    private static Pair<Text, KeyExtent> verifyRootTablet(KeyExtent extent, TServerInstance instance) throws DistributedStoreException, AccumuloException {
        ZooTabletStateStore store = new ZooTabletStateStore();
        if (!store.iterator().hasNext()) {
            throw new AccumuloException("Illegal state: location is not set in zookeeper");
        }
        TabletLocationState next = (TabletLocationState)store.iterator().next();
        if (!instance.equals((Object)next.future)) {
            throw new AccumuloException("Future location is not to this server for the root tablet");
        }
        if (next.current != null) {
            throw new AccumuloException("Root tablet already has a location set");
        }
        try {
            return new Pair((Object)new Text(MetadataTableUtil.getRootTabletDir()), null);
        }
        catch (IOException e) {
            throw new AccumuloException((Throwable)e);
        }
    }

    public static Pair<Text, KeyExtent> verifyTabletInformation(AccumuloServerContext context, KeyExtent extent, TServerInstance instance, SortedMap<Key, Value> tabletsKeyValues, String clientAddress, ZooLock lock) throws AccumuloSecurityException, DistributedStoreException, AccumuloException {
        log.debug("verifying extent " + extent);
        if (extent.isRootTablet()) {
            return TabletServer.verifyRootTablet(extent, instance);
        }
        String tableToVerify = "!0";
        if (extent.isMeta()) {
            tableToVerify = "+r";
        }
        List<ColumnFQ> columnsToFetch = Arrays.asList(MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN, MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN, MetadataSchema.TabletsSection.TabletColumnFamily.SPLIT_RATIO_COLUMN, MetadataSchema.TabletsSection.TabletColumnFamily.OLD_PREV_ROW_COLUMN, MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN);
        TreeMap<Key, Value> tkv = new TreeMap<Key, Value>();
        try (ScannerImpl scanner = new ScannerImpl((ClientContext)context, tableToVerify, Authorizations.EMPTY);){
            scanner.setRange(extent.toMetadataRange());
            for (Map.Entry entry : scanner) {
                tkv.put((Key)entry.getKey(), (Value)entry.getValue());
            }
        }
        if (tabletsKeyValues == null) {
            tabletsKeyValues = tkv;
        } else {
            tabletsKeyValues.clear();
            tabletsKeyValues.putAll(tkv);
        }
        Text metadataEntry = extent.getMetadataEntry();
        Value dir = TabletServer.checkTabletMetadata(extent, instance, tabletsKeyValues, metadataEntry);
        if (dir == null) {
            return null;
        }
        Value oldPrevEndRow = null;
        for (Map.Entry<Key, Value> entry : tabletsKeyValues.entrySet()) {
            if (!MetadataSchema.TabletsSection.TabletColumnFamily.OLD_PREV_ROW_COLUMN.hasColumns(entry.getKey())) continue;
            oldPrevEndRow = entry.getValue();
        }
        if (oldPrevEndRow != null) {
            KeyExtent fke;
            SortedMap tabletEntries = MetadataTableUtil.getTabletEntries(tabletsKeyValues, columnsToFetch);
            try {
                fke = MasterMetadataUtil.fixSplit((ClientContext)context, (Text)metadataEntry, (SortedMap)((SortedMap)tabletEntries.get(metadataEntry)), (TServerInstance)instance, (ZooLock)lock);
            }
            catch (IOException e) {
                log.error("Error fixing split " + metadataEntry);
                throw new AccumuloException(e.toString());
            }
            if (!fke.equals((Object)extent)) {
                return new Pair(null, (Object)fke);
            }
            tabletsKeyValues.clear();
            return TabletServer.verifyTabletInformation(context, fke, instance, tabletsKeyValues, clientAddress, lock);
        }
        return new Pair((Object)new Text(dir.get()), null);
    }

    static Value checkTabletMetadata(KeyExtent extent, TServerInstance instance, SortedMap<Key, Value> tabletsKeyValues, Text metadataEntry) throws AccumuloException {
        TServerInstance future = null;
        Value prevEndRow = null;
        Value dir = null;
        Value time = null;
        for (Map.Entry<Key, Value> entry : tabletsKeyValues.entrySet()) {
            Key key = entry.getKey();
            if (!metadataEntry.equals((Object)key.getRow())) {
                log.info("Unexpected row in tablet metadata " + metadataEntry + " " + key.getRow());
                return null;
            }
            Text cf = key.getColumnFamily();
            if (cf.equals((Object)MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME)) {
                if (future != null) {
                    throw new AccumuloException("Tablet has multiple future locations " + extent);
                }
                future = new TServerInstance(entry.getValue(), key.getColumnQualifier());
                continue;
            }
            if (cf.equals((Object)MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME)) {
                log.info("Tablet seems to be already assigned to " + new TServerInstance(entry.getValue(), key.getColumnQualifier()));
                return null;
            }
            if (MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.hasColumns(key)) {
                prevEndRow = entry.getValue();
                continue;
            }
            if (MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.hasColumns(key)) {
                dir = entry.getValue();
                continue;
            }
            if (!MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.hasColumns(key)) continue;
            time = entry.getValue();
        }
        if (prevEndRow == null) {
            throw new AccumuloException("Metadata entry does not have prev row (" + metadataEntry + ")");
        }
        KeyExtent ke2 = new KeyExtent(metadataEntry, prevEndRow);
        if (!extent.equals((Object)ke2)) {
            log.info("Tablet prev end row mismatch " + extent + " " + ke2.getPrevEndRow());
            return null;
        }
        if (dir == null) {
            throw new AccumuloException("Metadata entry does not have directory (" + metadataEntry + ")");
        }
        if (time == null && !extent.equals((Object)RootTable.OLD_EXTENT)) {
            throw new AccumuloException("Metadata entry does not have time (" + metadataEntry + ")");
        }
        if (future == null) {
            log.info("The master has not assigned " + extent + " to " + instance);
            return null;
        }
        if (!instance.equals(future)) {
            log.info("Table " + extent + " has been assigned to " + future + " which is not " + instance);
            return null;
        }
        return dir;
    }

    public String getClientAddressString() {
        if (this.clientAddress == null) {
            return null;
        }
        return this.clientAddress.getHost() + ":" + this.clientAddress.getPort();
    }

    public String getReplicationAddressSTring() {
        if (null == this.replicationAddress) {
            return null;
        }
        return this.replicationAddress.getHost() + ":" + this.replicationAddress.getPort();
    }

    public TServerInstance getTabletSession() {
        String address = this.getClientAddressString();
        if (address == null) {
            return null;
        }
        try {
            return new TServerInstance(address, this.tabletServerLock.getSessionId());
        }
        catch (Exception ex) {
            log.warn("Unable to read session from tablet server lock" + ex);
            return null;
        }
    }

    public void config(String hostname) {
        log.info("Tablet server starting on " + hostname);
        this.majorCompactorThread = new Daemon((Runnable)new LoggingRunnable(log, (Runnable)new MajorCompactor(this.getConfiguration())));
        this.majorCompactorThread.setName("Split/MajC initiator");
        this.majorCompactorThread.start();
        this.clientAddress = HostAndPort.fromParts((String)hostname, (int)0);
        try {
            AccumuloVFSClassLoader.getContextManager().setContextConfig((ContextManager.ContextsConfig)new ContextManager.DefaultContextsConfig(){

                public Map<String, String> getVfsContextClasspathProperties() {
                    return TabletServer.this.getConfiguration().getAllPropertiesWithPrefix(Property.VFS_CONTEXT_CLASSPATH_PROPERTY);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Runnable contextCleaner = new Runnable(){

            @Override
            public void run() {
                Set contextProperties = TabletServer.this.getServerConfigurationFactory().getConfiguration().getAllPropertiesWithPrefix(Property.VFS_CONTEXT_CLASSPATH_PROPERTY).keySet();
                HashSet<String> configuredContexts = new HashSet<String>();
                for (String prop : contextProperties) {
                    configuredContexts.add(prop.substring(Property.VFS_CONTEXT_CLASSPATH_PROPERTY.name().length()));
                }
                try {
                    AccumuloVFSClassLoader.getContextManager().removeUnusedContexts(configuredContexts);
                }
                catch (IOException e) {
                    log.warn("{}", (Object)e.getMessage(), (Object)e);
                }
            }
        };
        AccumuloConfiguration aconf = this.getConfiguration();
        SimpleTimer.getInstance((AccumuloConfiguration)aconf).schedule(contextCleaner, 60000L, 60000L);
        FileSystemMonitor.start((AccumuloConfiguration)aconf, (Property)Property.TSERV_MONITOR_FS);
        Runnable gcDebugTask = new Runnable(){

            @Override
            public void run() {
                TabletServer.this.gcLogger.logGCInfo(TabletServer.this.getConfiguration());
            }
        };
        SimpleTimer.getInstance((AccumuloConfiguration)aconf).schedule(gcDebugTask, 0L, 5000L);
        Runnable constraintTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList tablets;
                SortedMap sortedMap = TabletServer.this.onlineTablets;
                synchronized (sortedMap) {
                    tablets = new ArrayList(TabletServer.this.onlineTablets.values());
                }
                for (Tablet tablet : tablets) {
                    tablet.checkConstraints();
                }
            }
        };
        SimpleTimer.getInstance((AccumuloConfiguration)aconf).schedule(constraintTask, 0L, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TabletServerStatus getStats(Map<String, MapCounter<ScanRunState>> scanCounts) {
        Object table;
        HashMap<KeyExtent, Tablet> onlineTabletsCopy;
        long start = System.currentTimeMillis();
        TabletServerStatus result = new TabletServerStatus();
        SortedMap<KeyExtent, Tablet> sortedMap = this.onlineTablets;
        synchronized (sortedMap) {
            onlineTabletsCopy = new HashMap<KeyExtent, Tablet>(this.onlineTablets);
        }
        HashMap<String, TableInfo> tables = new HashMap<String, TableInfo>();
        for (Map.Entry sortedSet : onlineTabletsCopy.entrySet()) {
            String tableId = ((KeyExtent)sortedSet.getKey()).getTableId();
            TableInfo table2 = (TableInfo)tables.get(tableId);
            if (table2 == null) {
                table2 = new TableInfo();
                table2.minors = new Compacting();
                table2.majors = new Compacting();
                tables.put(tableId, table2);
            }
            Tablet tablet = (Tablet)sortedSet.getValue();
            long recs = tablet.getNumEntries();
            ++table2.tablets;
            ++table2.onlineTablets;
            table2.recs += recs;
            table2.queryRate += tablet.queryRate();
            table2.queryByteRate += tablet.queryByteRate();
            table2.ingestRate += tablet.ingestRate();
            table2.ingestByteRate += tablet.ingestByteRate();
            table2.scanRate += tablet.scanRate();
            long recsInMemory = tablet.getNumEntriesInMemory();
            table2.recsInMemory += recsInMemory;
            if (tablet.isMinorCompactionRunning()) {
                ++table2.minors.running;
            }
            if (tablet.isMinorCompactionQueued()) {
                ++table2.minors.queued;
            }
            if (tablet.isMajorCompactionRunning()) {
                ++table2.majors.running;
            }
            if (!tablet.isMajorCompactionQueued()) continue;
            ++table2.majors.queued;
        }
        for (Map.Entry<Object, Object> entry : scanCounts.entrySet()) {
            table = (TableInfo)tables.get(entry.getKey());
            if (table == null) {
                table = new TableInfo();
                tables.put((String)entry.getKey(), (TableInfo)table);
            }
            if (table.scans == null) {
                table.scans = new Compacting();
            }
            table.scans.queued = (int)((long)table.scans.queued + ((MapCounter)entry.getValue()).get((Object)ScanRunState.QUEUED));
            table.scans.running = (int)((long)table.scans.running + ((MapCounter)entry.getValue()).get((Object)ScanRunState.RUNNING));
        }
        ArrayList<KeyExtent> offlineTabletsCopy = new ArrayList<KeyExtent>();
        SortedSet<KeyExtent> sortedSet = this.unopenedTablets;
        synchronized (sortedSet) {
            table = this.openingTablets;
            synchronized (table) {
                offlineTabletsCopy.addAll(this.unopenedTablets);
                offlineTabletsCopy.addAll(this.openingTablets);
            }
        }
        for (KeyExtent extent : offlineTabletsCopy) {
            String tableId = extent.getTableId();
            TableInfo table3 = (TableInfo)tables.get(tableId);
            if (table3 == null) {
                table3 = new TableInfo();
                tables.put(tableId, table3);
            }
            ++table3.tablets;
        }
        result.lastContact = RelativeTime.currentTimeMillis();
        result.tableMap = tables;
        result.osLoad = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
        result.name = this.getClientAddressString();
        result.holdTime = this.resourceManager.holdTime();
        result.lookups = seekCount.get();
        result.indexCacheHits = this.resourceManager.getIndexCache().getStats().getHitCount();
        result.indexCacheRequest = this.resourceManager.getIndexCache().getStats().getRequestCount();
        result.dataCacheHits = this.resourceManager.getDataCache().getStats().getHitCount();
        result.dataCacheRequest = this.resourceManager.getDataCache().getStats().getRequestCount();
        result.logSorts = this.logSorter.getLogSorts();
        result.flushs = this.flushCounter.get();
        result.syncs = this.syncCounter.get();
        result.bulkImports = new ArrayList();
        result.bulkImports.addAll(this.clientHandler.getBulkLoadStatus());
        result.bulkImports.addAll(this.bulkImportStatus.getBulkLoadStatus());
        result.responseTime = System.currentTimeMillis() - start;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        try {
            String app = "tserver";
            Accumulo.setupLogging((String)"tserver");
            SecurityUtil.serverLogin((AccumuloConfiguration)SiteConfiguration.getInstance());
            ServerOpts opts = new ServerOpts();
            opts.parseArgs("tserver", args, new Object[0]);
            String hostname = opts.getAddress();
            ServerConfigurationFactory conf = new ServerConfigurationFactory(HdfsZooInstance.getInstance());
            VolumeManager fs = VolumeManagerImpl.get();
            MetricsSystemHelper.configure((String)TabletServer.class.getSimpleName());
            Accumulo.init((VolumeManager)fs, (ServerConfigurationFactory)conf, (String)"tserver");
            final TabletServer server = new TabletServer(conf, fs);
            server.config(hostname);
            DistributedTrace.enable((String)hostname, (String)"tserver", (AccumuloConfiguration)conf.getConfiguration());
            if (UserGroupInformation.isSecurityEnabled()) {
                UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
                loginUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() {
                        server.run();
                        return null;
                    }
                });
            } else {
                server.run();
            }
        }
        catch (Exception ex) {
            log.error("Uncaught exception in TabletServer.main, exiting", (Throwable)ex);
            System.exit(1);
        }
        finally {
            DistributedTrace.disable();
        }
    }

    private Durability getMincEventDurability(KeyExtent extent) {
        TableConfiguration conf = extent.isMeta() ? this.confFactory.getTableConfiguration("+r") : this.confFactory.getTableConfiguration("!0");
        Durability durability = DurabilityImpl.fromString((String)conf.get(Property.TABLE_DURABILITY));
        return durability;
    }

    public void minorCompactionFinished(CommitSession tablet, String newDatafile, long walogSeq) throws IOException {
        Durability durability = this.getMincEventDurability(tablet.getExtent());
        this.totalMinorCompactions.incrementAndGet();
        this.logger.minorCompactionFinished(tablet, newDatafile, walogSeq, durability);
        this.markUnusedWALs();
    }

    public void minorCompactionStarted(CommitSession tablet, long lastUpdateSequence, String newMapfileLocation) throws IOException {
        Durability durability = this.getMincEventDurability(tablet.getExtent());
        this.logger.minorCompactionStarted(tablet, lastUpdateSequence, newMapfileLocation, durability);
    }

    public void recover(VolumeManager fs, KeyExtent extent, TableConfiguration tconf, List<LogEntry> logEntries, Set<String> tabletFiles, MutationReceiver mutationReceiver) throws IOException {
        ArrayList<Path> recoveryLogs = new ArrayList<Path>();
        ArrayList<LogEntry> sorted = new ArrayList<LogEntry>(logEntries);
        Collections.sort(sorted, new Comparator<LogEntry>(){

            @Override
            public int compare(LogEntry e1, LogEntry e2) {
                return (int)(e1.timestamp - e2.timestamp);
            }
        });
        for (LogEntry entry : sorted) {
            Path recovery = null;
            Path finished = RecoveryPath.getRecoveryPath((VolumeManager)fs, (Path)fs.getFullPath(VolumeManager.FileType.WAL, entry.filename));
            finished = SortedLogState.getFinishedMarkerPath((Path)finished);
            log.debug("Looking for " + finished);
            if (fs.exists(finished)) {
                recovery = finished.getParent();
            }
            if (recovery == null) {
                throw new IOException("Unable to find recovery files for extent " + extent + " logEntry: " + entry);
            }
            recoveryLogs.add(recovery);
        }
        this.logger.recover(fs, extent, tconf, recoveryLogs, tabletFiles, mutationReceiver);
    }

    public int createLogId() {
        int logId = this.logIdGenerator.incrementAndGet();
        if (logId < 0) {
            throw new IllegalStateException("Log Id rolled");
        }
        return logId;
    }

    public TableConfiguration getTableConfiguration(KeyExtent extent) {
        return this.confFactory.getTableConfiguration(extent.getTableId());
    }

    public DfsLogger.ServerResources getServerConfig() {
        return new DfsLogger.ServerResources(){

            @Override
            public VolumeManager getFileSystem() {
                return TabletServer.this.fs;
            }

            @Override
            public AccumuloConfiguration getConfiguration() {
                return TabletServer.this.getConfiguration();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Tablet> getOnlineTablets() {
        SortedMap<KeyExtent, Tablet> sortedMap = this.onlineTablets;
        synchronized (sortedMap) {
            return new ArrayList<Tablet>(this.onlineTablets.values());
        }
    }

    public VolumeManager getFileSystem() {
        return this.fs;
    }

    public int getOpeningCount() {
        return this.openingTablets.size();
    }

    public int getUnopenedCount() {
        return this.unopenedTablets.size();
    }

    public long getTotalMinorCompactions() {
        return this.totalMinorCompactions.get();
    }

    public double getHoldTimeMillis() {
        return this.resourceManager.holdTime();
    }

    public SecurityOperation getSecurityOperation() {
        return this.security;
    }

    @VisibleForTesting
    static Set<DfsLogger> findOldestUnreferencedWals(List<DfsLogger> closedLogs, ReferencedRemover referencedRemover) {
        DfsLogger unref;
        DfsLogger closed;
        LinkedHashSet<DfsLogger> unreferenced = new LinkedHashSet<DfsLogger>(closedLogs);
        referencedRemover.removeInUse(unreferenced);
        Iterator<DfsLogger> closedIter = closedLogs.iterator();
        Iterator unrefIter = unreferenced.iterator();
        HashSet<DfsLogger> eligible = new HashSet<DfsLogger>();
        while (closedIter.hasNext() && unrefIter.hasNext() && (closed = closedIter.next()).equals(unref = (DfsLogger)unrefIter.next())) {
            eligible.add(unref);
        }
        return eligible;
    }

    @VisibleForTesting
    static List<DfsLogger> copyClosedLogs(LinkedHashSet<DfsLogger> closedLogs) {
        ArrayList<DfsLogger> closedCopy = new ArrayList<DfsLogger>(closedLogs.size());
        for (DfsLogger dfsLogger : closedLogs) {
            closedCopy.add(dfsLogger);
        }
        return Collections.unmodifiableList(closedCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markUnusedWALs() {
        List<DfsLogger> closedCopy;
        LinkedHashSet<DfsLogger> linkedHashSet = this.closedLogs;
        synchronized (linkedHashSet) {
            closedCopy = TabletServer.copyClosedLogs(this.closedLogs);
        }
        ReferencedRemover refRemover = new ReferencedRemover(){

            @Override
            public void removeInUse(Set<DfsLogger> candidates) {
                for (Tablet tablet : TabletServer.this.getOnlineTablets()) {
                    tablet.removeInUseLogs(candidates);
                    if (!candidates.isEmpty()) continue;
                    break;
                }
            }
        };
        Set<DfsLogger> eligible = TabletServer.findOldestUnreferencedWals(closedCopy, refRemover);
        try {
            TServerInstance session = this.getTabletSession();
            for (DfsLogger candidate : eligible) {
                log.info("Marking " + candidate.getPath() + " as unreferenced");
                this.walMarker.walUnreferenced(session, candidate.getPath());
            }
            LinkedHashSet<DfsLogger> linkedHashSet2 = this.closedLogs;
            synchronized (linkedHashSet2) {
                this.closedLogs.removeAll(eligible);
            }
        }
        catch (WalStateManager.WalMarkerException ex) {
            log.info(ex.toString(), (Throwable)ex);
        }
    }

    public void addNewLogMarker(DfsLogger copy) throws WalStateManager.WalMarkerException {
        log.info("Writing log marker for " + copy.getPath());
        this.walMarker.addNewWalMarker(this.getTabletSession(), copy.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void walogClosed(DfsLogger currentLog) throws WalStateManager.WalMarkerException {
        this.metadataTableLogs.remove(currentLog);
        if (currentLog.getWrites() > 0L) {
            int clSize;
            LinkedHashSet<DfsLogger> linkedHashSet = this.closedLogs;
            synchronized (linkedHashSet) {
                this.closedLogs.add(currentLog);
                clSize = this.closedLogs.size();
            }
            log.info("Marking " + currentLog.getPath() + " as closed. Total closed logs " + clSize);
            this.walMarker.closeWal(this.getTabletSession(), currentLog.getPath());
        } else {
            log.info("Marking " + currentLog.getPath() + " as unreferenced (skipping closed writes == 0)");
            this.walMarker.walUnreferenced(this.getTabletSession(), currentLog.getPath());
        }
    }

    public void updateBulkImportState(List<String> files, BulkImportState state) {
        this.bulkImportStatus.updateBulkImportStatus(files, state);
    }

    public void removeBulkImportState(List<String> files) {
        this.bulkImportStatus.removeBulkImportStatus(files);
    }

    public final RateLimiter getMajorCompactionReadLimiter() {
        return SharedRateLimiterFactory.getInstance().create(MAJC_READ_LIMITER_KEY, this.rateProvider);
    }

    public final RateLimiter getMajorCompactionWriteLimiter() {
        return SharedRateLimiterFactory.getInstance().create(MAJC_WRITE_LIMITER_KEY, this.rateProvider);
    }

    @VisibleForTesting
    static interface ReferencedRemover {
        public void removeInUse(Set<DfsLogger> var1);
    }

    protected class AssignmentHandler
    implements Runnable {
        private final KeyExtent extent;
        private final int retryAttempt;

        public AssignmentHandler(KeyExtent extent) {
            this(extent, 0);
        }

        public AssignmentHandler(KeyExtent extent, int retryAttempt) {
            this.extent = extent;
            this.retryAttempt = retryAttempt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TreeMap<Key, Value> tabletsKeyValues;
            Text locationToOpen;
            block46: {
                Set unopenedOverlapping;
                log.info(TabletServer.this.clientAddress + ": got assignment from master: " + this.extent);
                SortedSet sortedSet = TabletServer.this.unopenedTablets;
                synchronized (sortedSet) {
                    SortedSet sortedSet2 = TabletServer.this.openingTablets;
                    synchronized (sortedSet2) {
                        SortedMap sortedMap = TabletServer.this.onlineTablets;
                        synchronized (sortedMap) {
                            unopenedOverlapping = KeyExtent.findOverlapping((KeyExtent)this.extent, (SortedSet)TabletServer.this.unopenedTablets);
                            Set openingOverlapping = KeyExtent.findOverlapping((KeyExtent)this.extent, (SortedSet)TabletServer.this.openingTablets);
                            Set onlineOverlapping = KeyExtent.findOverlapping((KeyExtent)this.extent, (SortedMap)TabletServer.this.onlineTablets);
                            if (openingOverlapping.contains(this.extent) || onlineOverlapping.contains(this.extent)) {
                                return;
                            }
                            if (!unopenedOverlapping.contains(this.extent)) {
                                log.info("assignment " + this.extent + " no longer in the unopened set");
                                return;
                            }
                            if (unopenedOverlapping.size() != 1 || openingOverlapping.size() > 0 || onlineOverlapping.size() > 0) {
                                throw new IllegalStateException("overlaps assigned " + this.extent + " " + !TabletServer.this.unopenedTablets.contains(this.extent) + " " + unopenedOverlapping + " " + openingOverlapping + " " + onlineOverlapping);
                            }
                        }
                        TabletServer.this.unopenedTablets.remove(this.extent);
                        TabletServer.this.openingTablets.add(this.extent);
                    }
                }
                log.debug("Loading extent: " + this.extent);
                locationToOpen = null;
                tabletsKeyValues = new TreeMap<Key, Value>();
                try {
                    Pair<Text, KeyExtent> pair = TabletServer.verifyTabletInformation(TabletServer.this, this.extent, TabletServer.this.getTabletSession(), tabletsKeyValues, TabletServer.this.getClientAddressString(), TabletServer.this.getLock());
                    if (pair == null) break block46;
                    locationToOpen = (Text)pair.getFirst();
                    if (pair.getSecond() == null) break block46;
                    unopenedOverlapping = TabletServer.this.openingTablets;
                    synchronized (unopenedOverlapping) {
                        TabletServer.this.openingTablets.remove(this.extent);
                        TabletServer.this.openingTablets.notifyAll();
                        if (!KeyExtent.findOverlapping((KeyExtent)this.extent, new TreeSet<KeyExtent>(Arrays.asList((KeyExtent)pair.getSecond()))).contains(pair.getSecond())) {
                            throw new IllegalStateException("Fixed split does not overlap " + this.extent + " " + pair.getSecond());
                        }
                        TabletServer.this.unopenedTablets.add((KeyExtent)pair.getSecond());
                    }
                    new AssignmentHandler((KeyExtent)pair.getSecond()).run();
                    return;
                }
                catch (Exception e) {
                    unopenedOverlapping = TabletServer.this.openingTablets;
                    synchronized (unopenedOverlapping) {
                        TabletServer.this.openingTablets.remove(this.extent);
                        TabletServer.this.openingTablets.notifyAll();
                    }
                    log.warn("Failed to verify tablet " + this.extent, (Throwable)e);
                    TabletServer.this.enqueueMasterMessage(new TabletStatusMessage(TabletLoadState.LOAD_FAILURE, this.extent));
                    throw new RuntimeException(e);
                }
            }
            if (locationToOpen == null) {
                log.debug("Reporting tablet " + this.extent + " assignment failure: unable to verify Tablet Information");
                SortedSet e = TabletServer.this.openingTablets;
                synchronized (e) {
                    TabletServer.this.openingTablets.remove(this.extent);
                    TabletServer.this.openingTablets.notifyAll();
                }
                TabletServer.this.enqueueMasterMessage(new TabletStatusMessage(TabletLoadState.LOAD_FAILURE, this.extent));
                return;
            }
            Tablet tablet = null;
            boolean successful = false;
            try {
                TabletServer.this.acquireRecoveryMemory(this.extent);
                TabletServerResourceManager.TabletResourceManager trm = TabletServer.this.resourceManager.createTabletResourceManager(this.extent, (AccumuloConfiguration)TabletServer.this.getTableConfiguration(this.extent));
                TabletData data = this.extent.isRootTablet() ? new TabletData(TabletServer.this.fs, (ZooReader)ZooReaderWriter.getInstance(), (AccumuloConfiguration)TabletServer.this.getTableConfiguration(this.extent)) : new TabletData(this.extent, TabletServer.this.fs, tabletsKeyValues.entrySet().iterator());
                tablet = new Tablet(TabletServer.this, this.extent, trm, data);
                if (tablet.getNumEntriesInMemory() > 0L && !tablet.minorCompactNow(MinorCompactionReason.RECOVERY)) {
                    throw new RuntimeException("Minor compaction after recovery fails for " + this.extent);
                }
                Assignment assignment = new Assignment(this.extent, TabletServer.this.getTabletSession());
                TabletStateStore.setLocation((AccumuloServerContext)TabletServer.this, (Assignment)assignment);
                SortedSet sortedSet = TabletServer.this.openingTablets;
                synchronized (sortedSet) {
                    SortedMap sortedMap = TabletServer.this.onlineTablets;
                    synchronized (sortedMap) {
                        TabletServer.this.openingTablets.remove(this.extent);
                        TabletServer.this.onlineTablets.put(this.extent, tablet);
                        TabletServer.this.openingTablets.notifyAll();
                        TabletServer.this.recentlyUnloadedCache.remove(tablet.getExtent());
                    }
                }
                tablet = null;
                successful = true;
            }
            catch (Throwable e) {
                log.warn("exception trying to assign tablet {} {}", new Object[]{this.extent, locationToOpen, e});
                if (e.getMessage() != null) {
                    log.warn("{}", (Object)e.getMessage());
                }
                String tableId = this.extent.getTableId();
                ProblemReports.getInstance((AccumuloServerContext)TabletServer.this).report(new ProblemReport(tableId, ProblemType.TABLET_LOAD, this.extent.getUUID().toString(), TabletServer.this.getClientAddressString(), e));
            }
            finally {
                TabletServer.this.releaseRecoveryMemory(this.extent);
            }
            if (!successful) {
                SortedSet e = TabletServer.this.unopenedTablets;
                synchronized (e) {
                    SortedSet sortedSet = TabletServer.this.openingTablets;
                    synchronized (sortedSet) {
                        TabletServer.this.openingTablets.remove(this.extent);
                        TabletServer.this.unopenedTablets.add(this.extent);
                        TabletServer.this.openingTablets.notifyAll();
                    }
                }
                log.warn("failed to open tablet " + this.extent + " reporting failure to master");
                TabletServer.this.enqueueMasterMessage(new TabletStatusMessage(TabletLoadState.LOAD_FAILURE, this.extent));
                long reschedule = Math.min((1L << Math.min(32, this.retryAttempt)) * 1000L, 600000L);
                log.warn(String.format("rescheduling tablet load in %.2f seconds", (double)reschedule / 1000.0));
                SimpleTimer.getInstance((AccumuloConfiguration)TabletServer.this.getConfiguration()).schedule((Runnable)new TimerTask(){

                    @Override
                    public void run() {
                        log.info("adding tablet " + AssignmentHandler.this.extent + " back to the assignment pool (retry " + AssignmentHandler.this.retryAttempt + ")");
                        AssignmentHandler handler = new AssignmentHandler(AssignmentHandler.this.extent, AssignmentHandler.this.retryAttempt + 1);
                        if (AssignmentHandler.this.extent.isMeta()) {
                            if (AssignmentHandler.this.extent.isRootTablet()) {
                                new Daemon((Runnable)new LoggingRunnable(log, (Runnable)handler), "Root tablet assignment retry").start();
                            } else {
                                TabletServer.this.resourceManager.addMetaDataAssignment(AssignmentHandler.this.extent, log, handler);
                            }
                        } else {
                            TabletServer.this.resourceManager.addAssignment(AssignmentHandler.this.extent, log, handler);
                        }
                    }
                }, reschedule);
            } else {
                TabletServer.this.enqueueMasterMessage(new TabletStatusMessage(TabletLoadState.LOADED, this.extent));
            }
        }
    }

    private class UnloadTabletHandler
    implements Runnable {
        private final KeyExtent extent;
        private final TUnloadTabletGoal goalState;
        private final long requestTimeSkew;

        public UnloadTabletHandler(KeyExtent extent, TUnloadTabletGoal goalState, long requestTime) {
            this.extent = extent;
            this.goalState = goalState;
            this.requestTimeSkew = requestTime - TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Tablet t = null;
            Object object = TabletServer.this.unopenedTablets;
            synchronized (object) {
                if (TabletServer.this.unopenedTablets.contains(this.extent)) {
                    TabletServer.this.unopenedTablets.remove(this.extent);
                    return;
                }
            }
            object = TabletServer.this.openingTablets;
            synchronized (object) {
                while (TabletServer.this.openingTablets.contains(this.extent)) {
                    try {
                        log.info("Waiting for tablet {} to finish opening before unloading.", (Object)this.extent);
                        TabletServer.this.openingTablets.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            object = TabletServer.this.onlineTablets;
            synchronized (object) {
                if (TabletServer.this.onlineTablets.containsKey(this.extent)) {
                    t = (Tablet)TabletServer.this.onlineTablets.get(this.extent);
                }
            }
            if (t == null) {
                if (!TabletServer.this.recentlyUnloadedCache.containsKey(this.extent)) {
                    log.info("told to unload tablet that was not being served " + this.extent);
                    TabletServer.this.enqueueMasterMessage(new TabletStatusMessage(TabletLoadState.UNLOAD_FAILURE_NOT_SERVING, this.extent));
                }
                return;
            }
            try {
                t.close(!this.goalState.equals((Object)TUnloadTabletGoal.DELETED));
            }
            catch (Throwable e) {
                if ((t.isClosing() || t.isClosed()) && e instanceof IllegalStateException) {
                    log.debug("Failed to unload tablet {} ... it was already closing or closed : {}", (Object)this.extent, (Object)e.getMessage());
                } else {
                    log.error("Failed to close tablet {}... Aborting migration", (Object)this.extent, (Object)e);
                    TabletServer.this.enqueueMasterMessage(new TabletStatusMessage(TabletLoadState.UNLOAD_ERROR, this.extent));
                }
                return;
            }
            TabletServer.this.recentlyUnloadedCache.put(this.extent, System.currentTimeMillis());
            TabletServer.this.onlineTablets.remove(this.extent);
            try {
                TServerInstance instance = new TServerInstance(TabletServer.this.clientAddress, TabletServer.this.getLock().getSessionId());
                TabletLocationState tls = null;
                try {
                    tls = new TabletLocationState(this.extent, null, instance, null, null, null, false);
                }
                catch (TabletLocationState.BadLocationStateException e) {
                    log.error("Unexpected error ", (Throwable)e);
                }
                if (!this.goalState.equals((Object)TUnloadTabletGoal.SUSPENDED) || this.extent.isRootTablet() || this.extent.isMeta() && !TabletServer.this.getConfiguration().getBoolean(Property.MASTER_METADATA_SUSPENDABLE)) {
                    log.debug("Unassigning " + tls);
                    TabletStateStore.unassign((AccumuloServerContext)TabletServer.this, (TabletLocationState)tls, null);
                } else {
                    log.debug("Suspending " + tls);
                    TabletStateStore.suspend((AccumuloServerContext)TabletServer.this, (TabletLocationState)tls, null, (long)(this.requestTimeSkew + TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS)));
                }
            }
            catch (DistributedStoreException ex) {
                log.warn("Unable to update storage", (Throwable)ex);
            }
            catch (KeeperException e) {
                log.warn("Unable determine our zookeeper session information", (Throwable)e);
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while getting our zookeeper session information", (Throwable)e);
            }
            TabletServer.this.enqueueMasterMessage(new TabletStatusMessage(TabletLoadState.UNLOADED, this.extent));
            TabletServer.this.statsKeeper.saveMajorMinorTimes(t.getTabletStats());
            log.info("unloaded " + this.extent);
        }
    }

    private class MajorCompactor
    implements Runnable {
        public MajorCompactor(AccumuloConfiguration config) {
            CompactionWatcher.startWatching(config);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            while (true) {
                try {
                    block12: while (true) {
                        UtilWaitThread.sleepUninterruptibly((long)TabletServer.this.getConfiguration().getTimeInMillis(Property.TSERV_MAJC_DELAY), (TimeUnit)TimeUnit.MILLISECONDS);
                        copyOnlineTablets = new TreeMap<K, V>();
                        var2_3 = TabletServer.access$000(TabletServer.this);
                        synchronized (var2_3) {
                            copyOnlineTablets.putAll(TabletServer.access$000(TabletServer.this));
                        }
                        var3_6 = TabletServer.this.closedLogs;
                        synchronized (var3_6) {
                            closedCopy = TabletServer.copyClosedLogs(TabletServer.this.closedLogs);
                        }
                        numMajorCompactionsInProgress = 0;
                        for (Map.Entry<K, V> entry : copyOnlineTablets.entrySet()) {
                            tablet = (Tablet)entry.getValue();
                            if (tablet.needsSplit()) {
                                TabletServer.this.executeSplit(tablet);
                                continue;
                            }
                            tablet.checkIfMinorCompactionNeededForLogs(closedCopy);
                            var7_12 = tablet;
                            synchronized (var7_12) {
                                if (tablet.initiateMajorCompaction(MajorCompactionReason.NORMAL) || tablet.isMajorCompactionQueued() || tablet.isMajorCompactionRunning()) {
                                    ++numMajorCompactionsInProgress;
                                }
                            }
                        }
                        idleCompactionsToStart = Math.max(1, TabletServer.this.getConfiguration().getCount(Property.TSERV_MAJC_MAXCONCURRENT) / 2);
                        if (numMajorCompactionsInProgress >= idleCompactionsToStart) continue;
                        iter = copyOnlineTablets.entrySet().iterator();
                        while (true) {
                            if (iter.hasNext() && numMajorCompactionsInProgress < idleCompactionsToStart) ** break;
                            continue block12;
                            entry = iter.next();
                            tablet = (Tablet)entry.getValue();
                            if (!tablet.initiateMajorCompaction(MajorCompactionReason.IDLE)) continue;
                            ++numMajorCompactionsInProgress;
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    TabletServer.access$100().error("Unexpected exception in " + Thread.currentThread().getName(), t);
                    UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                    continue;
                }
                break;
            }
        }
    }

    private class SplitRunner
    implements Runnable {
        private final Tablet tablet;

        public SplitRunner(Tablet tablet) {
            this.tablet = tablet;
        }

        @Override
        public void run() {
            TabletServer.this.splitTablet(this.tablet);
        }
    }

    private class ThriftClientHandler
    extends ClientServiceHandler
    implements TabletClientService.Iface {
        ThriftClientHandler() {
            super((AccumuloServerContext)TabletServer.this, TabletServer.this.watcher, TabletServer.this.fs);
            log.debug(ThriftClientHandler.class.getName() + " created");
        }

        public List<TKeyExtent> bulkImport(TInfo tinfo, TCredentials credentials, final long tid, final Map<TKeyExtent, Map<String, MapFileInfo>> files, final boolean setTime) throws ThriftSecurityException {
            if (!TabletServer.this.security.canPerformSystemActions(credentials)) {
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
            }
            try {
                return (List)TabletServer.this.watcher.run("bulkTx", tid, (Callable)new Callable<List<TKeyExtent>>(){

                    @Override
                    public List<TKeyExtent> call() throws Exception {
                        ArrayList<TKeyExtent> failures = new ArrayList<TKeyExtent>();
                        for (Map.Entry entry : files.entrySet()) {
                            TKeyExtent tke = (TKeyExtent)entry.getKey();
                            Map fileMap = (Map)entry.getValue();
                            HashMap<FileRef, MapFileInfo> fileRefMap = new HashMap<FileRef, MapFileInfo>();
                            for (Map.Entry mapping : fileMap.entrySet()) {
                                Path path = new Path((String)mapping.getKey());
                                FileSystem ns = TabletServer.this.fs.getVolumeByPath(path).getFileSystem();
                                path = ns.makeQualified(path);
                                fileRefMap.put(new FileRef(path.toString(), path), (MapFileInfo)mapping.getValue());
                            }
                            Tablet importTablet = (Tablet)TabletServer.this.onlineTablets.get(new KeyExtent(tke));
                            if (importTablet == null) {
                                failures.add(tke);
                                continue;
                            }
                            try {
                                importTablet.importMapFiles(tid, fileRefMap, setTime);
                            }
                            catch (IOException ioe) {
                                log.info("files {} not imported to {}: {}", new Object[]{fileMap.keySet(), new KeyExtent(tke), ioe.getMessage()});
                                failures.add(tke);
                            }
                        }
                        return failures;
                    }
                });
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public InitialScan startScan(TInfo tinfo, TCredentials credentials, TKeyExtent textent, TRange range, List<TColumn> columns, int batchSize, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, boolean isolated, long readaheadThreshold, TSamplerConfiguration tSamplerConfig, long batchTimeOut, String context) throws NotServingTabletException, ThriftSecurityException, org.apache.accumulo.core.tabletserver.thrift.TooManyFilesException, TSampleNotPresentException {
            ScanResult scanResult;
            Tablet tablet;
            String namespaceId;
            String tableId = new String(textent.getTable(), StandardCharsets.UTF_8);
            try {
                namespaceId = Tables.getNamespaceId((Instance)TabletServer.this.getInstance(), (String)tableId);
            }
            catch (TableNotFoundException e1) {
                throw new NotServingTabletException(textent);
            }
            if (!TabletServer.this.security.canScan(credentials, tableId, namespaceId, range, columns, ssiList, ssio, authorizations)) {
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
            }
            if (!TabletServer.this.security.authenticatedUserHasAuthorizations(credentials, authorizations)) {
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.BAD_AUTHORIZATIONS);
            }
            KeyExtent extent = new KeyExtent(textent);
            if (waitForWrites) {
                TabletServer.this.writeTracker.waitForWrites(TabletType.type((KeyExtent)extent));
            }
            if ((tablet = (Tablet)TabletServer.this.onlineTablets.get(extent)) == null) {
                throw new NotServingTabletException(textent);
            }
            HashSet<Column> columnSet = new HashSet<Column>();
            for (TColumn tcolumn : columns) {
                columnSet.add(new Column(tcolumn));
            }
            ScanSession scanSession = new ScanSession(credentials, extent, columnSet, ssiList, ssio, new Authorizations(authorizations), readaheadThreshold, batchTimeOut, context);
            scanSession.scanner = tablet.createScanner(new Range(range), batchSize, scanSession.columnSet, scanSession.auths, ssiList, ssio, isolated, scanSession.interruptFlag, SamplerConfigurationImpl.fromThrift((TSamplerConfiguration)tSamplerConfig), scanSession.batchTimeOut, scanSession.context);
            long sid = TabletServer.this.sessionManager.createSession(scanSession, true);
            try {
                scanResult = this.continueScan(tinfo, sid, scanSession);
            }
            catch (NoSuchScanIDException e) {
                log.error("The impossible happened", (Throwable)e);
                throw new RuntimeException();
            }
            finally {
                TabletServer.this.sessionManager.unreserveSession(sid);
            }
            return new InitialScan(sid, scanResult);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ScanResult continueScan(TInfo tinfo, long scanID) throws NoSuchScanIDException, NotServingTabletException, org.apache.accumulo.core.tabletserver.thrift.TooManyFilesException, TSampleNotPresentException {
            ScanSession scanSession = (ScanSession)TabletServer.this.sessionManager.reserveSession(scanID);
            if (scanSession == null) {
                throw new NoSuchScanIDException();
            }
            try {
                ScanResult scanResult = this.continueScan(tinfo, scanID, scanSession);
                return scanResult;
            }
            finally {
                TabletServer.this.sessionManager.unreserveSession(scanSession);
            }
        }

        private ScanResult continueScan(TInfo tinfo, long scanID, ScanSession scanSession) throws NoSuchScanIDException, NotServingTabletException, org.apache.accumulo.core.tabletserver.thrift.TooManyFilesException, TSampleNotPresentException {
            ScanBatch bresult;
            if (scanSession.nextBatchTask == null) {
                scanSession.nextBatchTask = new NextBatchTask(TabletServer.this, scanID, scanSession.interruptFlag);
                TabletServer.this.resourceManager.executeReadAhead(scanSession.extent, scanSession.nextBatchTask);
            }
            try {
                bresult = scanSession.nextBatchTask.get(1000L, TimeUnit.MILLISECONDS);
                scanSession.nextBatchTask = null;
            }
            catch (ExecutionException e) {
                TabletServer.this.sessionManager.removeSession(scanID);
                if (e.getCause() instanceof NotServingTabletException) {
                    throw (NotServingTabletException)e.getCause();
                }
                if (e.getCause() instanceof TooManyFilesException) {
                    throw new org.apache.accumulo.core.tabletserver.thrift.TooManyFilesException(scanSession.extent.toThrift());
                }
                if (e.getCause() instanceof SampleNotPresentException) {
                    throw new TSampleNotPresentException(scanSession.extent.toThrift());
                }
                if (e.getCause() instanceof IOException) {
                    UtilWaitThread.sleepUninterruptibly((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
                    List<KVEntry> empty = Collections.emptyList();
                    bresult = new ScanBatch(empty, true);
                    scanSession.nextBatchTask = null;
                }
                throw new RuntimeException(e);
            }
            catch (CancellationException ce) {
                TabletServer.this.sessionManager.removeSession(scanID);
                Tablet tablet = (Tablet)TabletServer.this.onlineTablets.get(scanSession.extent);
                if (tablet == null || tablet.isClosed()) {
                    throw new NotServingTabletException(scanSession.extent.toThrift());
                }
                throw new NoSuchScanIDException();
            }
            catch (TimeoutException e) {
                List param = Collections.emptyList();
                long timeout = TabletServer.this.getConfiguration().getTimeInMillis(Property.TSERV_CLIENT_TIMEOUT);
                TabletServer.this.sessionManager.removeIfNotAccessed(scanID, timeout);
                return new ScanResult(param, true);
            }
            catch (Throwable t) {
                TabletServer.this.sessionManager.removeSession(scanID);
                log.warn("Failed to get next batch", t);
                throw new RuntimeException(t);
            }
            ScanResult scanResult = new ScanResult(Key.compress(bresult.getResults()), bresult.isMore());
            scanSession.entriesReturned += (long)scanResult.results.size();
            ++scanSession.batchCount;
            if (scanResult.more && scanSession.batchCount > scanSession.readaheadThreshold) {
                scanSession.nextBatchTask = new NextBatchTask(TabletServer.this, scanID, scanSession.interruptFlag);
                TabletServer.this.resourceManager.executeReadAhead(scanSession.extent, scanSession.nextBatchTask);
            }
            if (!scanResult.more) {
                this.closeScan(tinfo, scanID);
            }
            return scanResult;
        }

        public void closeScan(TInfo tinfo, long scanID) {
            ScanSession ss = (ScanSession)TabletServer.this.sessionManager.removeSession(scanID);
            if (ss != null) {
                long t2 = System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    log.debug(String.format("ScanSess tid %s %s %,d entries in %.2f secs, nbTimes = [%s] ", TServerUtils.clientAddress.get(), ss.extent.getTableId(), ss.entriesReturned, (double)(t2 - ss.startTime) / 1000.0, ss.nbTimes.toString()));
                }
                if (TabletServer.this.scanMetrics.isEnabled()) {
                    TabletServer.this.scanMetrics.add("scan", t2 - ss.startTime);
                    TabletServer.this.scanMetrics.add("result", ss.entriesReturned);
                }
            }
        }

        public InitialMultiScan startMultiScan(TInfo tinfo, TCredentials credentials, Map<TKeyExtent, List<TRange>> tbatch, List<TColumn> tcolumns, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, List<ByteBuffer> authorizations, boolean waitForWrites, TSamplerConfiguration tSamplerConfig, long batchTimeOut, String context) throws ThriftSecurityException, TSampleNotPresentException {
            MultiScanResult result;
            HashSet<String> tables = new HashSet<String>();
            for (TKeyExtent keyExtent : tbatch.keySet()) {
                tables.add(new String(keyExtent.getTable(), StandardCharsets.UTF_8));
            }
            if (tables.size() != 1) {
                throw new IllegalArgumentException("Cannot batch scan over multiple tables");
            }
            for (String tableId : tables) {
                String namespaceId;
                try {
                    namespaceId = Tables.getNamespaceId((Instance)TabletServer.this.getInstance(), (String)tableId);
                }
                catch (TableNotFoundException e1) {
                    throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.TABLE_DOESNT_EXIST);
                }
                if (TabletServer.this.security.canScan(credentials, tableId, namespaceId, tbatch, tcolumns, ssiList, ssio, authorizations)) continue;
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
            }
            try {
                if (!TabletServer.this.security.authenticatedUserHasAuthorizations(credentials, authorizations)) {
                    throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.BAD_AUTHORIZATIONS);
                }
            }
            catch (ThriftSecurityException tse) {
                log.error("{} is not authorized", (Object)credentials.getPrincipal(), (Object)tse);
                throw tse;
            }
            Map batch = Translator.translate(tbatch, (Translator)new Translator.TKeyExtentTranslator(), (Translator)new Translator.ListTranslator((Translator)new Translator.TRangeTranslator()));
            KeyExtent threadPoolExtent = (KeyExtent)batch.keySet().iterator().next();
            if (waitForWrites) {
                TabletServer.this.writeTracker.waitForWrites(TabletType.type(batch.keySet()));
            }
            MultiScanSession mss = new MultiScanSession(credentials, threadPoolExtent, batch, ssiList, ssio, new Authorizations(authorizations), SamplerConfigurationImpl.fromThrift((TSamplerConfiguration)tSamplerConfig), batchTimeOut, context);
            mss.numTablets = batch.size();
            for (List ranges : batch.values()) {
                mss.numRanges += ranges.size();
            }
            for (TColumn tcolumn : tcolumns) {
                mss.columnSet.add(new Column(tcolumn));
            }
            long sid = TabletServer.this.sessionManager.createSession(mss, true);
            try {
                result = this.continueMultiScan(tinfo, sid, mss);
            }
            catch (NoSuchScanIDException e) {
                log.error("the impossible happened", (Throwable)e);
                throw new RuntimeException("the impossible happened", e);
            }
            finally {
                TabletServer.this.sessionManager.unreserveSession(sid);
            }
            return new InitialMultiScan(sid, result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MultiScanResult continueMultiScan(TInfo tinfo, long scanID) throws NoSuchScanIDException, TSampleNotPresentException {
            MultiScanSession session = (MultiScanSession)TabletServer.this.sessionManager.reserveSession(scanID);
            if (session == null) {
                throw new NoSuchScanIDException();
            }
            try {
                MultiScanResult multiScanResult = this.continueMultiScan(tinfo, scanID, session);
                return multiScanResult;
            }
            finally {
                TabletServer.this.sessionManager.unreserveSession(session);
            }
        }

        private MultiScanResult continueMultiScan(TInfo tinfo, long scanID, MultiScanSession session) throws NoSuchScanIDException, TSampleNotPresentException {
            if (session.lookupTask == null) {
                session.lookupTask = new LookupTask(TabletServer.this, scanID);
                TabletServer.this.resourceManager.executeReadAhead(session.threadPoolExtent, session.lookupTask);
            }
            try {
                MultiScanResult scanResult = session.lookupTask.get(1000L, TimeUnit.MILLISECONDS);
                session.lookupTask = null;
                return scanResult;
            }
            catch (ExecutionException e) {
                TabletServer.this.sessionManager.removeSession(scanID);
                if (e.getCause() instanceof SampleNotPresentException) {
                    throw new TSampleNotPresentException();
                }
                log.warn("Failed to get multiscan result", (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (TimeoutException e1) {
                long timeout = TabletServer.this.getConfiguration().getTimeInMillis(Property.TSERV_CLIENT_TIMEOUT);
                TabletServer.this.sessionManager.removeIfNotAccessed(scanID, timeout);
                List results = Collections.emptyList();
                Map failures = Collections.emptyMap();
                List fullScans = Collections.emptyList();
                return new MultiScanResult(results, failures, fullScans, null, null, false, true);
            }
            catch (Throwable t) {
                TabletServer.this.sessionManager.removeSession(scanID);
                log.warn("Failed to get multiscan result", t);
                throw new RuntimeException(t);
            }
        }

        public void closeMultiScan(TInfo tinfo, long scanID) throws NoSuchScanIDException {
            MultiScanSession session = (MultiScanSession)TabletServer.this.sessionManager.removeSession(scanID);
            if (session == null) {
                throw new NoSuchScanIDException();
            }
            long t2 = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug(String.format("MultiScanSess %s %,d entries in %.2f secs (lookup_time:%.2f secs tablets:%,d ranges:%,d) ", TServerUtils.clientAddress.get(), session.numEntries, (double)(t2 - session.startTime) / 1000.0, (double)session.totalLookupTime / 1000.0, session.numTablets, session.numRanges));
            }
        }

        public long startUpdate(TInfo tinfo, TCredentials credentials, TDurability tdurabilty) throws ThriftSecurityException {
            Durability durability = DurabilityImpl.fromThrift((TDurability)tdurabilty);
            TabletServer.this.security.authenticateUser(credentials, credentials);
            if (TabletServer.this.updateMetrics.isEnabled()) {
                TabletServer.this.updateMetrics.add("permissionErrors", 0L);
            }
            UpdateSession us = new UpdateSession(new TservConstraintEnv(TabletServer.this.security, credentials), credentials, durability);
            long sid = TabletServer.this.sessionManager.createSession(us, false);
            return sid;
        }

        private void setUpdateTablet(UpdateSession us, KeyExtent keyExtent) {
            block12: {
                long t1 = System.currentTimeMillis();
                if (us.currentTablet != null && us.currentTablet.getExtent().equals((Object)keyExtent)) {
                    return;
                }
                if (us.currentTablet == null && (us.failures.containsKey(keyExtent) || us.authFailures.containsKey(keyExtent))) {
                    return;
                }
                String tableId = "";
                try {
                    boolean sameTable = us.currentTablet != null && us.currentTablet.getExtent().getTableId().equals(keyExtent.getTableId());
                    tableId = keyExtent.getTableId().toString();
                    if (sameTable || TabletServer.this.security.canWrite(us.getCredentials(), tableId, Tables.getNamespaceId((Instance)TabletServer.this.getInstance(), (String)tableId))) {
                        long t2 = System.currentTimeMillis();
                        us.authTimes.addStat(t2 - t1);
                        us.currentTablet = (Tablet)TabletServer.this.onlineTablets.get(keyExtent);
                        if (us.currentTablet != null) {
                            us.queuedMutations.put(us.currentTablet, new ArrayList());
                        } else {
                            us.failures.put(keyExtent, 0L);
                            if (TabletServer.this.updateMetrics.isEnabled()) {
                                TabletServer.this.updateMetrics.add("unknownTabletErrors", 0L);
                            }
                        }
                        break block12;
                    }
                    log.warn("Denying access to table " + keyExtent.getTableId() + " for user " + us.getUser());
                    long t2 = System.currentTimeMillis();
                    us.authTimes.addStat(t2 - t1);
                    us.currentTablet = null;
                    us.authFailures.put(keyExtent, SecurityErrorCode.PERMISSION_DENIED);
                    if (TabletServer.this.updateMetrics.isEnabled()) {
                        TabletServer.this.updateMetrics.add("permissionErrors", 0L);
                    }
                    return;
                }
                catch (TableNotFoundException tnfe) {
                    log.error("Table " + tableId + " not found ", (Throwable)tnfe);
                    long t2 = System.currentTimeMillis();
                    us.authTimes.addStat(t2 - t1);
                    us.currentTablet = null;
                    us.authFailures.put(keyExtent, SecurityErrorCode.TABLE_DOESNT_EXIST);
                    if (TabletServer.this.updateMetrics.isEnabled()) {
                        TabletServer.this.updateMetrics.add("unknownTabletErrors", 0L);
                    }
                    return;
                }
                catch (ThriftSecurityException e) {
                    log.error("Denying permission to check user " + us.getUser() + " with user " + e.getUser(), (Throwable)e);
                    long t2 = System.currentTimeMillis();
                    us.authTimes.addStat(t2 - t1);
                    us.currentTablet = null;
                    us.authFailures.put(keyExtent, e.getCode());
                    if (TabletServer.this.updateMetrics.isEnabled()) {
                        TabletServer.this.updateMetrics.add("permissionErrors", 0L);
                    }
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void applyUpdates(TInfo tinfo, long updateID, TKeyExtent tkeyExtent, List<TMutation> tmutations) {
            UpdateSession us = (UpdateSession)TabletServer.this.sessionManager.reserveSession(updateID);
            if (us == null) {
                return;
            }
            boolean reserved = true;
            try {
                KeyExtent keyExtent = new KeyExtent(tkeyExtent);
                this.setUpdateTablet(us, keyExtent);
                if (us.currentTablet != null) {
                    long total;
                    long additionalMutationSize = 0L;
                    List<Mutation> mutations = us.queuedMutations.get(us.currentTablet);
                    for (TMutation tmutation : tmutations) {
                        ServerMutation mutation = new ServerMutation(tmutation);
                        mutations.add((Mutation)mutation);
                        additionalMutationSize += mutation.numBytes();
                    }
                    us.queuedMutationSize += additionalMutationSize;
                    long totalQueued = TabletServer.this.updateTotalQueuedMutationSize(additionalMutationSize);
                    if (totalQueued > (total = TabletServer.this.getConfiguration().getMemoryInBytes(Property.TSERV_TOTAL_MUTATION_QUEUE_MAX))) {
                        try {
                            this.flush(us);
                        }
                        catch (HoldTimeoutException hte) {
                            log.debug("HoldTimeoutException during applyUpdates, removing session");
                            TabletServer.this.sessionManager.removeSession(updateID, true);
                            reserved = false;
                        }
                    }
                }
            }
            finally {
                if (reserved) {
                    TabletServer.this.sessionManager.unreserveSession(us);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flush(UpdateSession us) {
            int mutationCount = 0;
            HashMap<CommitSession, Mutations> sendables = new HashMap<CommitSession, Mutations>();
            Throwable error = null;
            long pt1 = System.currentTimeMillis();
            boolean containsMetadataTablet = false;
            for (Tablet tablet : us.queuedMutations.keySet()) {
                if (!tablet.getExtent().isMeta()) continue;
                containsMetadataTablet = true;
            }
            if (!containsMetadataTablet && us.queuedMutations.size() > 0) {
                TabletServer.this.resourceManager.waitUntilCommitsAreEnabled();
            }
            Span prep = Trace.start((String)"prep");
            try {
                for (Map.Entry<Tablet, List<Mutation>> entry : us.queuedMutations.entrySet()) {
                    Tablet tablet = entry.getKey();
                    Durability durability = tablet.getDurability();
                    List<Mutation> mutations = entry.getValue();
                    if (mutations.size() <= 0) continue;
                    try {
                        CommitSession commitSession;
                        if (TabletServer.this.updateMetrics.isEnabled()) {
                            TabletServer.this.updateMetrics.add("mutationArraysSize", (long)mutations.size());
                        }
                        if ((commitSession = tablet.prepareMutationsForCommit(us.cenv, mutations)) == null) {
                            if (us.currentTablet == tablet) {
                                us.currentTablet = null;
                            }
                            us.failures.put(tablet.getExtent(), us.successfulCommits.get((Object)tablet));
                            continue;
                        }
                        sendables.put(commitSession, new Mutations(DurabilityImpl.resolveDurabilty((Durability)us.durability, (Durability)durability), mutations));
                        mutationCount += mutations.size();
                    }
                    catch (TConstraintViolationException e) {
                        us.violations.add(e.getViolations());
                        if (TabletServer.this.updateMetrics.isEnabled()) {
                            TabletServer.this.updateMetrics.add("constraintViolations", 0L);
                        }
                        if (e.getNonViolators().size() > 0) {
                            sendables.put(e.getCommitSession(), new Mutations(DurabilityImpl.resolveDurabilty((Durability)us.durability, (Durability)durability), e.getNonViolators()));
                        }
                        mutationCount += mutations.size();
                    }
                    catch (Throwable t) {
                        error = t;
                        log.error("Unexpected error preparing for commit", error);
                        break;
                    }
                }
            }
            finally {
                prep.stop();
            }
            long l = System.currentTimeMillis();
            us.prepareTimes.addStat(l - pt1);
            this.updateAvgPrepTime(l - pt1, us.queuedMutations.size());
            if (error != null) {
                for (Map.Entry entry : sendables.entrySet()) {
                    ((CommitSession)entry.getKey()).abortCommit(((Mutations)entry.getValue()).getMutations());
                }
                throw new RuntimeException(error);
            }
            try {
                Span wal = Trace.start((String)"wal");
                try {
                    while (true) {
                        try {
                            long l2 = System.currentTimeMillis();
                            TabletServer.this.logger.logManyTablets(sendables);
                            long t2 = System.currentTimeMillis();
                            us.walogTimes.addStat(t2 - l2);
                            this.updateWalogWriteTime(t2 - l2);
                        }
                        catch (IOException iOException) {
                            log.warn("logging mutations failed, retrying");
                            continue;
                        }
                        catch (FSError fSError) {
                            log.warn("logging mutations failed, retrying");
                            continue;
                        }
                        catch (Throwable throwable) {
                            log.error("Unknown exception logging mutations, counts for mutations in flight not decremented!", throwable);
                            throw new RuntimeException(throwable);
                        }
                        break;
                    }
                }
                finally {
                    wal.stop();
                }
                Span span = Trace.start((String)"commit");
                try {
                    long t1 = System.currentTimeMillis();
                    for (Map.Entry entry : sendables.entrySet()) {
                        CommitSession commitSession = (CommitSession)entry.getKey();
                        List<Mutation> mutations = ((Mutations)entry.getValue()).getMutations();
                        commitSession.commit(mutations);
                        KeyExtent extent = commitSession.getExtent();
                        if (us.currentTablet == null || extent != us.currentTablet.getExtent()) continue;
                        us.successfulCommits.increment((Object)us.currentTablet, (long)us.queuedMutations.get(us.currentTablet).size());
                    }
                    long t2 = System.currentTimeMillis();
                    us.flushTime += t2 - pt1;
                    us.commitTimes.addStat(t2 - t1);
                    this.updateAvgCommitTime(t2 - t1, sendables.size());
                }
                finally {
                    span.stop();
                }
            }
            finally {
                us.queuedMutations.clear();
                if (us.currentTablet != null) {
                    us.queuedMutations.put(us.currentTablet, new ArrayList());
                }
                TabletServer.this.updateTotalQueuedMutationSize(-us.queuedMutationSize);
                us.queuedMutationSize = 0L;
            }
            us.totalUpdates += (long)mutationCount;
        }

        private void updateWalogWriteTime(long time) {
            if (TabletServer.this.updateMetrics.isEnabled()) {
                TabletServer.this.updateMetrics.add("waLogWriteTime", time);
            }
        }

        private void updateAvgCommitTime(long time, int size) {
            if (TabletServer.this.updateMetrics.isEnabled()) {
                TabletServer.this.updateMetrics.add("commitTime", (long)((double)time / (double)size));
            }
        }

        private void updateAvgPrepTime(long time, int size) {
            if (TabletServer.this.updateMetrics.isEnabled()) {
                TabletServer.this.updateMetrics.add("commitPrep", (long)((double)time / (double)size));
            }
        }

        public UpdateErrors closeUpdate(TInfo tinfo, long updateID) throws NoSuchScanIDException {
            ConstraintViolationSummary first;
            List violations;
            UpdateSession us = (UpdateSession)TabletServer.this.sessionManager.removeSession(updateID);
            if (us == null) {
                throw new NoSuchScanIDException();
            }
            long opid = TabletServer.this.writeTracker.startWrite(us.queuedMutations.keySet());
            try {
                this.flush(us);
            }
            catch (HoldTimeoutException e) {
                log.debug("HoldTimeoutException during closeUpdate, reporting no such session");
                throw new NoSuchScanIDException();
            }
            finally {
                TabletServer.this.writeTracker.finishWrite(opid);
            }
            if (log.isDebugEnabled()) {
                log.debug(String.format("UpSess %s %,d in %.3fs, at=[%s] ft=%.3fs(pt=%.3fs lt=%.3fs ct=%.3fs)", TServerUtils.clientAddress.get(), us.totalUpdates, (double)(System.currentTimeMillis() - us.startTime) / 1000.0, us.authTimes.toString(), (double)us.flushTime / 1000.0, (double)us.prepareTimes.getSum() / 1000.0, (double)us.walogTimes.getSum() / 1000.0, (double)us.commitTimes.getSum() / 1000.0));
            }
            if (us.failures.size() > 0) {
                Map.Entry<KeyExtent, Long> first2 = us.failures.entrySet().iterator().next();
                log.debug(String.format("Failures: %d, first extent %s successful commits: %d", us.failures.size(), first2.getKey().toString(), first2.getValue()));
            }
            if ((violations = us.violations.asList()).size() > 0) {
                first = (ConstraintViolationSummary)us.violations.asList().iterator().next();
                log.debug(String.format("Violations: %d, first %s occurs %d", violations.size(), first.violationDescription, first.numberOfViolatingMutations));
            }
            if (us.authFailures.size() > 0) {
                first = us.authFailures.keySet().iterator().next();
                log.debug(String.format("Authentication Failures: %d, first %s", us.authFailures.size(), first.toString()));
            }
            return new UpdateErrors(Translator.translate(us.failures, (Translator)Translators.KET), Translator.translate((Collection)violations, (Translator)Translators.CVST), Translator.translate(us.authFailures, (Translator)Translators.KET));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(TInfo tinfo, TCredentials credentials, TKeyExtent tkeyExtent, TMutation tmutation, TDurability tdurability) throws NotServingTabletException, ConstraintViolationException, ThriftSecurityException {
            String namespaceId;
            String tableId = new String(tkeyExtent.getTable(), StandardCharsets.UTF_8);
            try {
                namespaceId = Tables.getNamespaceId((Instance)TabletServer.this.getInstance(), (String)tableId);
            }
            catch (TableNotFoundException e1) {
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.TABLE_DOESNT_EXIST);
            }
            if (!TabletServer.this.security.canWrite(credentials, tableId, namespaceId)) {
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
            }
            KeyExtent keyExtent = new KeyExtent(tkeyExtent);
            Tablet tablet = (Tablet)TabletServer.this.onlineTablets.get(new KeyExtent(keyExtent));
            if (tablet == null) {
                throw new NotServingTabletException(tkeyExtent);
            }
            Durability tabletDurability = tablet.getDurability();
            if (!keyExtent.isMeta()) {
                try {
                    TabletServer.this.resourceManager.waitUntilCommitsAreEnabled();
                }
                catch (HoldTimeoutException hte) {
                    throw new NotServingTabletException(tkeyExtent);
                }
            }
            long opid = TabletServer.this.writeTracker.startWrite(TabletType.type((KeyExtent)keyExtent));
            try {
                CommitSession cs;
                ServerMutation mutation = new ServerMutation(tmutation);
                List<ServerMutation> mutations = Collections.singletonList(mutation);
                Span prep = Trace.start((String)"prep");
                try {
                    cs = tablet.prepareMutationsForCommit(new TservConstraintEnv(TabletServer.this.security, credentials), mutations);
                }
                finally {
                    prep.stop();
                }
                if (cs == null) {
                    throw new NotServingTabletException(tkeyExtent);
                }
                while (true) {
                    try {
                        Span wal = Trace.start((String)"wal");
                        try {
                            TabletServer.this.logger.log(cs, cs.getWALogSeq(), (Mutation)mutation, DurabilityImpl.resolveDurabilty((Durability)DurabilityImpl.fromThrift((TDurability)tdurability), (Durability)tabletDurability));
                        }
                        finally {
                            wal.stop();
                        }
                    }
                    catch (IOException ex) {
                        log.warn("Error writing mutations to log", (Throwable)ex);
                        continue;
                    }
                    break;
                }
                Span commit = Trace.start((String)"commit");
                try {
                    cs.commit(mutations);
                }
                finally {
                    commit.stop();
                }
            }
            catch (TConstraintViolationException e) {
                throw new ConstraintViolationException(Translator.translate((Collection)e.getViolations().asList(), (Translator)Translators.CVST));
            }
            finally {
                TabletServer.this.writeTracker.finishWrite(opid);
            }
        }

        private void checkConditions(Map<KeyExtent, List<ServerConditionalMutation>> updates, ArrayList<TCMResult> results, ConditionalSession cs, List<String> symbols) throws IOException {
            Iterator<Map.Entry<KeyExtent, List<ServerConditionalMutation>>> iter = updates.entrySet().iterator();
            CompressedIterators compressedIters = new CompressedIterators(symbols);
            ConditionCheckerContext checkerContext = new ConditionCheckerContext(compressedIters, TabletServer.this.confFactory.getTableConfiguration(cs.tableId));
            while (iter.hasNext()) {
                Map.Entry<KeyExtent, List<ServerConditionalMutation>> entry = iter.next();
                Tablet tablet = (Tablet)TabletServer.this.onlineTablets.get(entry.getKey());
                if (tablet == null || tablet.isClosed()) {
                    for (ServerConditionalMutation scm : entry.getValue()) {
                        results.add(new TCMResult(scm.getID(), TCMStatus.IGNORED));
                    }
                    iter.remove();
                    continue;
                }
                ArrayList<ServerConditionalMutation> okMutations = new ArrayList<ServerConditionalMutation>(entry.getValue().size());
                List<TCMResult> resultsSubList = results.subList(results.size(), results.size());
                ConditionCheckerContext.ConditionChecker checker = checkerContext.newChecker(entry.getValue(), okMutations, resultsSubList);
                try {
                    tablet.checkConditions(checker, cs.auths, cs.interruptFlag);
                    if (okMutations.size() > 0) {
                        entry.setValue(okMutations);
                        continue;
                    }
                    iter.remove();
                }
                catch (IterationInterruptedException | TooManyFilesException | TabletClosedException e) {
                    resultsSubList.clear();
                    for (ServerConditionalMutation scm : entry.getValue()) {
                        results.add(new TCMResult(scm.getID(), TCMStatus.IGNORED));
                    }
                    iter.remove();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void writeConditionalMutations(Map<KeyExtent, List<ServerConditionalMutation>> updates, ArrayList<TCMResult> results, ConditionalSession sess) {
            Set<Map.Entry<KeyExtent, List<ServerConditionalMutation>>> es = updates.entrySet();
            HashMap<CommitSession, Mutations> sendables = new HashMap<CommitSession, Mutations>();
            boolean sessionCanceled = sess.interruptFlag.get();
            Span prepSpan = Trace.start((String)"prep");
            try {
                long t1 = System.currentTimeMillis();
                for (Map.Entry<KeyExtent, List<ServerConditionalMutation>> entry : es) {
                    Tablet tablet = (Tablet)TabletServer.this.onlineTablets.get(entry.getKey());
                    if (tablet == null || tablet.isClosed() || sessionCanceled) {
                        for (ServerConditionalMutation scm : entry.getValue()) {
                            results.add(new TCMResult(scm.getID(), TCMStatus.IGNORED));
                        }
                        continue;
                    }
                    Durability durability = tablet.getDurability();
                    try {
                        List<ServerConditionalMutation> mutations = entry.getValue();
                        if (mutations.size() <= 0) continue;
                        CommitSession cs = tablet.prepareMutationsForCommit(new TservConstraintEnv(TabletServer.this.security, sess.credentials), mutations);
                        if (cs == null) {
                            for (ServerConditionalMutation scm : entry.getValue()) {
                                results.add(new TCMResult(scm.getID(), TCMStatus.IGNORED));
                            }
                            continue;
                        }
                        for (ServerConditionalMutation scm : entry.getValue()) {
                            results.add(new TCMResult(scm.getID(), TCMStatus.ACCEPTED));
                        }
                        sendables.put(cs, new Mutations(DurabilityImpl.resolveDurabilty((Durability)sess.durability, (Durability)durability), mutations));
                    }
                    catch (TConstraintViolationException e) {
                        if (e.getNonViolators().size() > 0) {
                            sendables.put(e.getCommitSession(), new Mutations(DurabilityImpl.resolveDurabilty((Durability)sess.durability, (Durability)durability), e.getNonViolators()));
                            for (Mutation m : e.getNonViolators()) {
                                results.add(new TCMResult(((ServerConditionalMutation)m).getID(), TCMStatus.ACCEPTED));
                            }
                        }
                        for (Mutation m : e.getViolators()) {
                            results.add(new TCMResult(((ServerConditionalMutation)m).getID(), TCMStatus.VIOLATED));
                        }
                    }
                }
                long t2 = System.currentTimeMillis();
                this.updateAvgPrepTime(t2 - t1, es.size());
            }
            finally {
                prepSpan.stop();
            }
            Span walSpan = Trace.start((String)"wal");
            try {
                while (sendables.size() > 0) {
                    try {
                        long t1 = System.currentTimeMillis();
                        TabletServer.this.logger.logManyTablets(sendables);
                        long t2 = System.currentTimeMillis();
                        this.updateWalogWriteTime(t2 - t1);
                        break;
                    }
                    catch (IOException ex) {
                        log.warn("logging mutations failed, retrying");
                    }
                    catch (FSError ex) {
                        log.warn("logging mutations failed, retrying");
                    }
                    catch (Throwable t) {
                        log.error("Unknown exception logging mutations, counts for mutations in flight not decremented!", t);
                        throw new RuntimeException(t);
                    }
                }
            }
            finally {
                walSpan.stop();
            }
            Span commitSpan = Trace.start((String)"commit");
            try {
                long t1 = System.currentTimeMillis();
                for (Map.Entry entry : sendables.entrySet()) {
                    CommitSession commitSession = (CommitSession)entry.getKey();
                    List<Mutation> mutations = ((Mutations)entry.getValue()).getMutations();
                    commitSession.commit(mutations);
                }
                long t2 = System.currentTimeMillis();
                this.updateAvgCommitTime(t2 - t1, sendables.size());
                return;
            }
            finally {
                commitSpan.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<KeyExtent, List<ServerConditionalMutation>> conditionalUpdate(ConditionalSession cs, Map<KeyExtent, List<ServerConditionalMutation>> updates, ArrayList<TCMResult> results, List<String> symbols) throws IOException {
            ConditionalMutationSet.sortConditionalMutations(updates);
            HashMap<KeyExtent, List<ServerConditionalMutation>> deferred = new HashMap<KeyExtent, List<ServerConditionalMutation>>();
            ConditionalMutationSet.deferDuplicatesRows(updates, deferred);
            List<RowLocks.RowLock> locks = TabletServer.this.rowLocks.acquireRowlocks(updates, deferred);
            try {
                Span checkSpan = Trace.start((String)"Check conditions");
                try {
                    this.checkConditions(updates, results, cs, symbols);
                }
                finally {
                    checkSpan.stop();
                }
                Span updateSpan = Trace.start((String)"apply conditional mutations");
                try {
                    this.writeConditionalMutations(updates, results, cs);
                }
                finally {
                    updateSpan.stop();
                }
            }
            finally {
                TabletServer.this.rowLocks.releaseRowLocks(locks);
            }
            return deferred;
        }

        public TConditionalSession startConditionalUpdate(TInfo tinfo, TCredentials credentials, List<ByteBuffer> authorizations, String tableId, TDurability tdurabilty, String classLoaderContext) throws ThriftSecurityException, TException {
            String namespaceId;
            Authorizations userauths = null;
            try {
                namespaceId = Tables.getNamespaceId((Instance)TabletServer.this.getInstance(), (String)tableId);
            }
            catch (TableNotFoundException e) {
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.TABLE_DOESNT_EXIST);
            }
            if (!TabletServer.this.security.canConditionallyUpdate(credentials, tableId, namespaceId, authorizations)) {
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
            }
            userauths = TabletServer.this.security.getUserAuthorizations(credentials);
            for (ByteBuffer auth : authorizations) {
                if (userauths.contains(ByteBufferUtil.toBytes((ByteBuffer)auth))) continue;
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.BAD_AUTHORIZATIONS);
            }
            ConditionalSession cs = new ConditionalSession(credentials, new Authorizations(authorizations), tableId, DurabilityImpl.fromThrift((TDurability)tdurabilty), classLoaderContext);
            long sid = TabletServer.this.sessionManager.createSession(cs, false);
            return new TConditionalSession(sid, TabletServer.this.lockID, TabletServer.this.sessionManager.getMaxIdleTime());
        }

        public List<TCMResult> conditionalUpdate(TInfo tinfo, long sessID, Map<TKeyExtent, List<TConditionalMutation>> mutations, List<String> symbols) throws NoSuchScanIDException, TException {
            ConditionalSession cs = (ConditionalSession)TabletServer.this.sessionManager.reserveSession(sessID);
            if (cs == null || cs.interruptFlag.get()) {
                throw new NoSuchScanIDException();
            }
            if (!cs.tableId.equals("!0") && !cs.tableId.equals("+r")) {
                try {
                    TabletServer.this.resourceManager.waitUntilCommitsAreEnabled();
                }
                catch (HoldTimeoutException hte) {
                    log.debug("HoldTimeoutException during conditionalUpdate, reporting no such session");
                    throw new NoSuchScanIDException();
                }
            }
            String tid = cs.tableId;
            long opid = TabletServer.this.writeTracker.startWrite(TabletType.type((KeyExtent)new KeyExtent(tid, null, null)));
            try {
                Map updates = Translator.translate(mutations, (Translator)Translators.TKET, (Translator)new Translator.ListTranslator((Translator)ServerConditionalMutation.TCMT));
                for (KeyExtent ke : updates.keySet()) {
                    if (ke.getTableId().equals(tid)) continue;
                    throw new IllegalArgumentException("Unexpected table id " + tid + " != " + ke.getTableId());
                }
                ArrayList<TCMResult> results = new ArrayList<TCMResult>();
                Map<KeyExtent, List<ServerConditionalMutation>> deferred = this.conditionalUpdate(cs, updates, results, symbols);
                while (deferred.size() > 0) {
                    deferred = this.conditionalUpdate(cs, deferred, results, symbols);
                }
                ArrayList<TCMResult> arrayList = results;
                return arrayList;
            }
            catch (IOException ioe) {
                throw new TException((Throwable)ioe);
            }
            finally {
                TabletServer.this.writeTracker.finishWrite(opid);
                TabletServer.this.sessionManager.unreserveSession(sessID);
            }
        }

        public void invalidateConditionalUpdate(TInfo tinfo, long sessID) throws TException {
            ConditionalSession cs = (ConditionalSession)TabletServer.this.sessionManager.getSession(sessID);
            if (cs != null) {
                cs.interruptFlag.set(true);
            }
            if ((cs = (ConditionalSession)TabletServer.this.sessionManager.reserveSession(sessID, true)) != null) {
                TabletServer.this.sessionManager.removeSession(sessID, true);
            }
        }

        public void closeConditionalUpdate(TInfo tinfo, long sessID) throws TException {
            TabletServer.this.sessionManager.removeSession(sessID, false);
        }

        public void splitTablet(TInfo tinfo, TCredentials credentials, TKeyExtent tkeyExtent, ByteBuffer splitPoint) throws NotServingTabletException, ThriftSecurityException {
            String namespaceId;
            String tableId = new String(ByteBufferUtil.toBytes((ByteBuffer)tkeyExtent.table));
            try {
                namespaceId = Tables.getNamespaceId((Instance)TabletServer.this.getInstance(), (String)tableId);
            }
            catch (TableNotFoundException ex) {
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.TABLE_DOESNT_EXIST);
            }
            if (!TabletServer.this.security.canSplitTablet(credentials, tableId, namespaceId)) {
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
            }
            KeyExtent keyExtent = new KeyExtent(tkeyExtent);
            Tablet tablet = (Tablet)TabletServer.this.onlineTablets.get(keyExtent);
            if (tablet == null) {
                throw new NotServingTabletException(tkeyExtent);
            }
            if (keyExtent.getEndRow() == null || !keyExtent.getEndRow().equals((Object)ByteBufferUtil.toText((ByteBuffer)splitPoint))) {
                try {
                    if (TabletServer.this.splitTablet(tablet, ByteBufferUtil.toBytes((ByteBuffer)splitPoint)) == null) {
                        throw new NotServingTabletException(tkeyExtent);
                    }
                }
                catch (IOException e) {
                    log.warn("Failed to split " + keyExtent, (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }

        public TabletServerStatus getTabletServerStatus(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
            return TabletServer.this.getStats(TabletServer.this.sessionManager.getActiveScansPerTable());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<TabletStats> getTabletStats(TInfo tinfo, TCredentials credentials, String tableId) throws ThriftSecurityException, TException {
            TreeMap onlineTabletsCopy;
            SortedMap sortedMap = TabletServer.this.onlineTablets;
            synchronized (sortedMap) {
                onlineTabletsCopy = new TreeMap(TabletServer.this.onlineTablets);
            }
            ArrayList<TabletStats> result = new ArrayList<TabletStats>();
            String text = tableId;
            KeyExtent start = new KeyExtent(text, new Text(), null);
            for (Map.Entry entry : onlineTabletsCopy.tailMap(start).entrySet()) {
                KeyExtent ke = entry.getKey();
                if (ke.getTableId().compareTo(text) != 0) continue;
                Tablet tablet = (Tablet)entry.getValue();
                TabletStats stats = tablet.getTabletStats();
                stats.extent = ke.toThrift();
                stats.ingestRate = tablet.ingestRate();
                stats.queryRate = tablet.queryRate();
                stats.splitCreationTime = tablet.getSplitCreationTime();
                stats.numEntries = tablet.getNumEntries();
                result.add(stats);
            }
            return result;
        }

        private void checkPermission(TCredentials credentials, String lock, final String request) throws ThriftSecurityException {
            try {
                log.trace("Got " + request + " message from user: " + credentials.getPrincipal());
                if (!TabletServer.this.security.canPerformSystemActions(credentials)) {
                    log.warn("Got " + request + " message from user: " + credentials.getPrincipal());
                    throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
                }
            }
            catch (ThriftSecurityException e) {
                log.warn("Got " + request + " message from unauthenticatable user: " + e.getUser());
                if (TabletServer.this.getCredentials().getToken().getClass().getName().equals(credentials.getTokenClassName())) {
                    log.error("Got message from a service with a mismatched configuration. Please ensure a compatible configuration.", (Throwable)e);
                }
                throw e;
            }
            if (TabletServer.this.tabletServerLock == null || !TabletServer.this.tabletServerLock.wasLockAcquired()) {
                log.debug("Got " + request + " message before my lock was acquired, ignoring...");
                throw new RuntimeException("Lock not acquired");
            }
            if (TabletServer.this.tabletServerLock != null && TabletServer.this.tabletServerLock.wasLockAcquired() && !TabletServer.this.tabletServerLock.isLocked()) {
                Halt.halt((int)1, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        log.info("Tablet server no longer holds lock during checkPermission() : " + request + ", exiting");
                        TabletServer.this.gcLogger.logGCInfo(TabletServer.this.getConfiguration());
                    }
                });
            }
            if (lock != null) {
                ZooUtil.LockID lid = new ZooUtil.LockID(ZooUtil.getRoot((Instance)TabletServer.this.getInstance()) + "/masters/lock", lock);
                try {
                    if (!ZooLock.isLockHeld((org.apache.accumulo.fate.zookeeper.ZooCache)TabletServer.this.masterLockCache, (ZooUtil.LockID)lid)) {
                        TabletServer.this.masterLockCache.clear();
                        if (!ZooLock.isLockHeld((org.apache.accumulo.fate.zookeeper.ZooCache)TabletServer.this.masterLockCache, (ZooUtil.LockID)lid)) {
                            log.warn("Got " + request + " message from a master that does not hold the current lock " + lock);
                            throw new RuntimeException("bad master lock");
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("bad master lock", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadTablet(TInfo tinfo, TCredentials credentials, String lock, TKeyExtent textent) {
            try {
                this.checkPermission(credentials, lock, "loadTablet");
            }
            catch (ThriftSecurityException e) {
                log.error("Caller doesn't have permission to load a tablet", (Throwable)e);
                throw new RuntimeException(e);
            }
            final KeyExtent extent = new KeyExtent(textent);
            SortedSet sortedSet = TabletServer.this.unopenedTablets;
            synchronized (sortedSet) {
                SortedSet sortedSet2 = TabletServer.this.openingTablets;
                synchronized (sortedSet2) {
                    SortedMap sortedMap = TabletServer.this.onlineTablets;
                    synchronized (sortedMap) {
                        Set unopenedOverlapping = KeyExtent.findOverlapping((KeyExtent)extent, (SortedSet)TabletServer.this.unopenedTablets);
                        Set openingOverlapping = KeyExtent.findOverlapping((KeyExtent)extent, (SortedSet)TabletServer.this.openingTablets);
                        Set onlineOverlapping = KeyExtent.findOverlapping((KeyExtent)extent, (SortedMap)TabletServer.this.onlineTablets);
                        HashSet all = new HashSet();
                        all.addAll(unopenedOverlapping);
                        all.addAll(openingOverlapping);
                        all.addAll(onlineOverlapping);
                        if (!all.isEmpty()) {
                            for (KeyExtent e2 : onlineOverlapping) {
                                Tablet tablet = (Tablet)TabletServer.this.onlineTablets.get(e2);
                                if (System.currentTimeMillis() - tablet.getSplitCreationTime() >= 60000L) continue;
                                all.remove(e2);
                            }
                            all.remove(extent);
                            if (all.size() > 0) {
                                log.error("Tablet " + extent + " overlaps previously assigned " + unopenedOverlapping + " " + openingOverlapping + " " + onlineOverlapping + " " + all);
                            }
                            return;
                        }
                        TabletServer.this.unopenedTablets.add(extent);
                    }
                }
            }
            log.info("Loading tablet " + extent);
            final AssignmentHandler ah = new AssignmentHandler(extent);
            if (extent.isRootTablet()) {
                new Daemon("Root Tablet Assignment"){

                    public void run() {
                        ah.run();
                        if (TabletServer.this.onlineTablets.containsKey(extent)) {
                            log.info("Root tablet loaded: " + extent);
                        } else {
                            log.info("Root tablet failed to load");
                        }
                    }
                }.start();
            } else if (extent.isMeta()) {
                TabletServer.this.resourceManager.addMetaDataAssignment(extent, log, ah);
            } else {
                TabletServer.this.resourceManager.addAssignment(extent, log, ah);
            }
        }

        public void unloadTablet(TInfo tinfo, TCredentials credentials, String lock, TKeyExtent textent, TUnloadTabletGoal goal, long requestTime) {
            try {
                this.checkPermission(credentials, lock, "unloadTablet");
            }
            catch (ThriftSecurityException e) {
                log.error("Caller doesn't have permission to unload a tablet", (Throwable)e);
                throw new RuntimeException(e);
            }
            KeyExtent extent = new KeyExtent(textent);
            TabletServer.this.resourceManager.addMigration(extent, (Runnable)new LoggingRunnable(log, (Runnable)new UnloadTabletHandler(extent, goal, requestTime)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush(TInfo tinfo, TCredentials credentials, String lock, String tableId, ByteBuffer startRow, ByteBuffer endRow) {
            try {
                this.checkPermission(credentials, lock, "flush");
            }
            catch (ThriftSecurityException e) {
                log.error("Caller doesn't have permission to flush a table", (Throwable)e);
                throw new RuntimeException(e);
            }
            ArrayList<Tablet> tabletsToFlush = new ArrayList<Tablet>();
            KeyExtent ke = new KeyExtent(tableId, ByteBufferUtil.toText((ByteBuffer)endRow), ByteBufferUtil.toText((ByteBuffer)startRow));
            SortedMap sortedMap = TabletServer.this.onlineTablets;
            synchronized (sortedMap) {
                for (Tablet tablet : TabletServer.this.onlineTablets.values()) {
                    if (!ke.overlaps(tablet.getExtent())) continue;
                    tabletsToFlush.add(tablet);
                }
            }
            Long flushID = null;
            for (Tablet tablet : tabletsToFlush) {
                if (flushID == null) {
                    try {
                        flushID = tablet.getFlushID();
                    }
                    catch (KeeperException.NoNodeException e) {
                        log.info("Asked to flush table that has no flush id {} {}", (Object)ke, (Object)e.getMessage());
                        return;
                    }
                }
                tablet.flush(flushID);
            }
        }

        public void flushTablet(TInfo tinfo, TCredentials credentials, String lock, TKeyExtent textent) throws TException {
            try {
                this.checkPermission(credentials, lock, "flushTablet");
            }
            catch (ThriftSecurityException e) {
                log.error("Caller doesn't have permission to flush a tablet", (Throwable)e);
                throw new RuntimeException(e);
            }
            Tablet tablet = (Tablet)TabletServer.this.onlineTablets.get(new KeyExtent(textent));
            if (tablet != null) {
                log.info("Flushing " + tablet.getExtent());
                try {
                    tablet.flush(tablet.getFlushID());
                }
                catch (KeeperException.NoNodeException nne) {
                    log.info("Asked to flush tablet that has no flush id {} {}", (Object)new KeyExtent(textent), (Object)nne.getMessage());
                }
            }
        }

        public void halt(TInfo tinfo, TCredentials credentials, String lock) throws ThriftSecurityException {
            this.checkPermission(credentials, lock, "halt");
            Halt.halt((int)0, (Runnable)new Runnable(){

                @Override
                public void run() {
                    log.info("Master requested tablet server halt");
                    TabletServer.this.gcLogger.logGCInfo(TabletServer.this.getConfiguration());
                    TabletServer.this.serverStopRequested = true;
                    try {
                        TabletServer.this.tabletServerLock.unlock();
                    }
                    catch (Exception e) {
                        log.error("Caught exception unlocking TabletServer lock", (Throwable)e);
                    }
                }
            });
        }

        public void fastHalt(TInfo info, TCredentials credentials, String lock) {
            try {
                this.halt(info, credentials, lock);
            }
            catch (Exception e) {
                log.warn("Error halting", (Throwable)e);
            }
        }

        public TabletStats getHistoricalStats(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
            return TabletServer.this.statsKeeper.getTabletStats();
        }

        public List<ActiveScan> getActiveScans(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
            try {
                this.checkPermission(credentials, null, "getScans");
            }
            catch (ThriftSecurityException e) {
                log.error("Caller doesn't have permission to get active scans", (Throwable)e);
                throw e;
            }
            return TabletServer.this.sessionManager.getActiveScans();
        }

        public void chop(TInfo tinfo, TCredentials credentials, String lock, TKeyExtent textent) throws TException {
            try {
                this.checkPermission(credentials, lock, "chop");
            }
            catch (ThriftSecurityException e) {
                log.error("Caller doesn't have permission to chop extent", (Throwable)e);
                throw new RuntimeException(e);
            }
            KeyExtent ke = new KeyExtent(textent);
            Tablet tablet = (Tablet)TabletServer.this.onlineTablets.get(ke);
            if (tablet != null) {
                tablet.chopFiles();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void compact(TInfo tinfo, TCredentials credentials, String lock, String tableId, ByteBuffer startRow, ByteBuffer endRow) throws TException {
            try {
                this.checkPermission(credentials, lock, "compact");
            }
            catch (ThriftSecurityException e) {
                log.error("Caller doesn't have permission to compact a table", (Throwable)e);
                throw new RuntimeException(e);
            }
            KeyExtent ke = new KeyExtent(tableId, ByteBufferUtil.toText((ByteBuffer)endRow), ByteBufferUtil.toText((ByteBuffer)startRow));
            ArrayList<Tablet> tabletsToCompact = new ArrayList<Tablet>();
            SortedMap sortedMap = TabletServer.this.onlineTablets;
            synchronized (sortedMap) {
                for (Tablet tablet : TabletServer.this.onlineTablets.values()) {
                    if (!ke.overlaps(tablet.getExtent())) continue;
                    tabletsToCompact.add(tablet);
                }
            }
            Pair<Long, UserCompactionConfig> compactionInfo = null;
            for (Tablet tablet : tabletsToCompact) {
                if (compactionInfo == null) {
                    try {
                        compactionInfo = tablet.getCompactionID();
                    }
                    catch (KeeperException.NoNodeException e) {
                        log.info("Asked to compact table with no compaction id {} {}", (Object)ke, (Object)e.getMessage());
                        return;
                    }
                }
                tablet.compactAll((Long)compactionInfo.getFirst(), (UserCompactionConfig)compactionInfo.getSecond());
            }
        }

        public List<ActiveCompaction> getActiveCompactions(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException, TException {
            try {
                this.checkPermission(credentials, null, "getActiveCompactions");
            }
            catch (ThriftSecurityException e) {
                log.error("Caller doesn't have permission to get active compactions", (Throwable)e);
                throw e;
            }
            List<CompactionInfo> compactions = Compactor.getRunningCompactions();
            ArrayList<ActiveCompaction> ret = new ArrayList<ActiveCompaction>(compactions.size());
            for (CompactionInfo compactionInfo : compactions) {
                ret.add(compactionInfo.toThrift());
            }
            return ret;
        }

        public List<String> getActiveLogs(TInfo tinfo, TCredentials credentials) throws TException {
            String log = TabletServer.this.logger.getLogFile();
            if (null == log) {
                return Collections.emptyList();
            }
            return Collections.singletonList(log);
        }

        public void removeLogs(TInfo tinfo, TCredentials credentials, List<String> filenames) throws TException {
            log.warn("Garbage collector is attempting to remove logs through the tablet server");
            log.warn("This is probably because your file Garbage Collector is an older version than your tablet servers.\nRestart your file Garbage Collector.");
        }
    }
}

