/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate.util;

import java.util.Date;
import org.slf4j.Logger;

public class LoggingRunnable
implements Runnable {
    private Runnable runnable;
    private Logger log;

    public LoggingRunnable(Logger log, Runnable r) {
        this.runnable = r;
        this.log = log;
    }

    @Override
    public void run() {
        try {
            this.runnable.run();
        }
        catch (Throwable t) {
            block7: {
                boolean errorOnRun = t instanceof Error;
                try {
                    this.log.error("Thread \"{}\" died {}", new Object[]{Thread.currentThread().getName(), t.getMessage(), t});
                }
                catch (Throwable t2) {
                    boolean errorOnLog;
                    block6: {
                        errorOnLog = t2 instanceof Error;
                        try {
                            System.err.println("ERROR " + new Date() + " Failed to log message about thread death " + t2.getMessage());
                            t2.printStackTrace();
                            System.err.println("ERROR " + new Date() + " Exception that failed to log : " + t.getMessage());
                            t.printStackTrace();
                        }
                        catch (Throwable t3) {
                            boolean errorOnPrint = t3 instanceof Error;
                            if (!errorOnPrint || errorOnLog || errorOnRun) break block6;
                            throw t3;
                        }
                    }
                    if (!errorOnLog || errorOnRun) break block7;
                    throw t2;
                }
            }
            throw t;
        }
    }
}

